/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.AddressClassFactory;
import com.kingdee.eas.basedata.assistant.AddressClassInfo;
import com.kingdee.eas.basedata.assistant.AddressCollection;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.IAddress;
import com.kingdee.eas.basedata.assistant.LanguageFactory;
import com.kingdee.eas.basedata.assistant.LanguageInfo;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionFactory;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AddressDataTransimission
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger(AddressDataTransimission.class);
    private static final String RESOURCE_FILE_NAME = "com.kingdee.eas.tools.datatask.DatataskResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AddressFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String fax;
        String availTime;
        String phone;
        String linkMain_l3;
        String linkMain_l2;
        String linkMain_l1;
        String emailAddress;
        String postalCode;
        String languageNum;
        String districtNum;
        String cityNum;
        String provinceNum;
        String countryNum;
        String classNum;
        String detailAddress_l3;
        String detailAddress_l2;
        String detailAddress_l1;
        AddressInfo info = new AddressInfo();
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (number == null) throw new TaskExternalException("number not found!");
        info.setNumber(number);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            try {
                IAddress iAddress = (IAddress)this.getController(ctx);
                AddressCollection AddressCollection2 = iAddress.getAddressCollection();
                if (AddressCollection2 != null) {
                    for (int i = 0; i < AddressCollection2.size(); ++i) {
                        if (!AddressCollection2.get(i).getNumber().equalsIgnoreCase(number)) continue;
                        info.setId(AddressCollection2.get(i).getId());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TaskExternalException("BOSException: getAddressCollection", (Throwable)e);
            }
        }
        if ((detailAddress_l1 = (String)((DataToken)hsData.get((Object)"FDetaillAddress_L1")).data) != null && detailAddress_l1.trim().length() != 0) {
            info.setDetailAddress(detailAddress_l1, new Locale("L1"));
        }
        if ((detailAddress_l2 = (String)((DataToken)hsData.get((Object)"FDetaillAddress_L2")).data) != null && detailAddress_l2.trim().length() != 0) {
            info.setDetailAddress(detailAddress_l2, new Locale("L2"));
        }
        if ((detailAddress_l3 = (String)((DataToken)hsData.get((Object)"FDetaillAddress_L3")).data) != null && detailAddress_l3.trim().length() != 0) {
            info.setDetailAddress(detailAddress_l3, new Locale("L3"));
        }
        if ((classNum = (String)((DataToken)hsData.get((Object)"FClassID")).data) != null && classNum.trim().length() != 0) {
            AddressClassInfo addressClassInfo = null;
            try {
                addressClassInfo = (AddressClassInfo)AddressClassFactory.getLocalInstance(ctx).getValue("select id where number = '" + classNum + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
                Locale currentLocale = ctx.getLocale();
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"classNumber", (Locale)currentLocale));
                message.append(classNum);
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"classImport", (Locale)currentLocale));
                throw new TaskExternalException(message.toString());
            }
            info.setClassId(addressClassInfo);
        }
        if ((countryNum = (String)((DataToken)hsData.get((Object)"FCountryID")).data) != null && countryNum.trim().length() != 0) {
            CountryInfo countryInfo = null;
            try {
                countryInfo = (CountryInfo)CountryFactory.getLocalInstance(ctx).getValue("select id where number = '" + countryNum + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
                Locale currentLocale = ctx.getLocale();
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"countryNumber", (Locale)currentLocale));
                message.append(classNum);
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"countryImport", (Locale)currentLocale));
                throw new TaskExternalException(message.toString());
            }
            info.setCountryId(countryInfo);
        }
        if ((provinceNum = (String)((DataToken)hsData.get((Object)"FProvinceID")).data) != null && provinceNum.trim().length() != 0) {
            ProvinceInfo provinceInfo = null;
            try {
                provinceInfo = (ProvinceInfo)ProvinceFactory.getLocalInstance(ctx).getValue("select id where number = '" + provinceNum + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
                Locale currentLocale = ctx.getLocale();
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"provinceNumber", (Locale)currentLocale));
                message.append(provinceNum);
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"provinceImport", (Locale)currentLocale));
                throw new TaskExternalException(message.toString());
            }
            info.setProvinceId(provinceInfo);
        }
        if ((cityNum = (String)((DataToken)hsData.get((Object)"Fcity")).data) != null && cityNum.trim().length() != 0) {
            CityInfo cityInfo = null;
            try {
                cityInfo = (CityInfo)CityFactory.getLocalInstance(ctx).getValue("select id where number = '" + cityNum + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
                Locale currentLocale = ctx.getLocale();
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"cityNumber", (Locale)currentLocale));
                message.append(classNum);
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"cityImport", (Locale)currentLocale));
                throw new TaskExternalException(message.toString());
            }
            info.setCityId(cityInfo);
        }
        if ((districtNum = (String)((DataToken)hsData.get((Object)"Fdistrict")).data) != null && districtNum.trim().length() != 0) {
            RegionInfo districtInfo = null;
            try {
                districtInfo = (RegionInfo)RegionFactory.getLocalInstance(ctx).getValue("select id where number = '" + districtNum + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
                Locale currentLocale = ctx.getLocale();
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"regionNumber", (Locale)currentLocale));
                message.append(classNum);
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"regionImport", (Locale)currentLocale));
                throw new TaskExternalException(message.toString());
            }
            info.setDistrictId(districtInfo);
        }
        String addressMltName = "";
        try {
            if (info.getCountryId() != null) {
                String countryname = ((CountryInfo)CountryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(info.getCountryId().getId()))).getName();
                addressMltName = addressMltName + countryname;
            }
            if (info.getProvinceId() != null) {
                String proname = ((ProvinceInfo)ProvinceFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(info.getProvinceId().getId()))).getName();
                addressMltName = addressMltName + proname;
            }
            if (info.getCityId() != null) {
                String cityname = ((CityInfo)CityFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(info.getCityId().getId()))).getName();
                addressMltName = addressMltName + cityname;
            }
            if (info.getDistrictId() != null) {
                String regionname = ((RegionInfo)RegionFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(info.getDistrictId().getId()))).getName();
                addressMltName = addressMltName + regionname;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException("BOSException: addressMltName", (Throwable)e);
        }
        if (info.getDetailAddress() != null) {
            addressMltName = addressMltName + info.getDetailAddress();
        }
        if (addressMltName.trim().length() > 0) {
            info.setName(addressMltName);
        }
        if ((languageNum = (String)((DataToken)hsData.get((Object)"FLanguageID")).data) != null && languageNum.trim().length() != 0) {
            LanguageInfo languageInfo = null;
            try {
                languageInfo = (LanguageInfo)LanguageFactory.getLocalInstance(ctx).getValue("select id where number = '" + languageNum + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
                Locale currentLocale = ctx.getLocale();
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"languageNumber", (Locale)currentLocale));
                message.append(classNum);
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"languageImport", (Locale)currentLocale));
                throw new TaskExternalException(message.toString());
            }
            info.setLanguageId(languageInfo);
        }
        if ((postalCode = (String)((DataToken)hsData.get((Object)"FPostalCode")).data) != null && postalCode.trim().length() != 0) {
            info.setPostalCode(postalCode);
        }
        if ((emailAddress = (String)((DataToken)hsData.get((Object)"FWebAddress")).data) != null && emailAddress.trim().length() != 0) {
            info.setEmailAddress(emailAddress);
        }
        if ((linkMain_l1 = (String)((DataToken)hsData.get((Object)"FLinkMan_L1")).data) != null && linkMain_l1.trim().length() != 0) {
            info.setLinkMan(linkMain_l1, new Locale("L1"));
        }
        if ((linkMain_l2 = (String)((DataToken)hsData.get((Object)"FLinkMan_L2")).data) != null && linkMain_l2.trim().length() != 0) {
            info.setLinkMan(linkMain_l2, new Locale("L2"));
        }
        if ((linkMain_l3 = (String)((DataToken)hsData.get((Object)"FLinkMan_L3")).data) != null && linkMain_l3.trim().length() != 0) {
            info.setLinkMan(linkMain_l3, new Locale("L3"));
        }
        if ((phone = (String)((DataToken)hsData.get((Object)"FPhone")).data) != null && phone.trim().length() != 0) {
            info.setPhone(phone);
        }
        if ((availTime = (String)((DataToken)hsData.get((Object)"FAvailTime")).data) != null && availTime.trim().length() != 0) {
            Date parsedTime = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                parsedTime = sdf.parse(availTime);
            }
            catch (ParseException e) {
                Locale currentLocale = ctx.getLocale();
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"availtimeformaterror", (Locale)currentLocale));
                message.append(availTime);
                throw new TaskExternalException(message.toString());
            }
            info.setAvailTime(parsedTime);
        }
        if ((fax = (String)((DataToken)hsData.get((Object)"FFax")).data) == null || fax.trim().length() == 0) return info;
        info.setFax(fax);
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iAddress = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iAddress.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iAddress.addnew(coreBaseInfo);
            } else {
                iAddress.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", rs.getString("number"));
            Locale currentLocale = ctx.getLocale();
            if (rs.getString("name") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("Fname_L1", rs.getString("name"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("Fname_L2", rs.getString("name"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("Fname_L3", rs.getString("name"));
                }
            }
            if (rs.getString("classId.number") != null) {
                result.put("FClassID", rs.getString("classId.number"));
            }
            if (rs.getString("countryId.number") != null) {
                result.put("FCountryID", rs.getString("countryId.number"));
            }
            if (rs.getString("provinceId.number") != null) {
                result.put("FProvinceID", rs.getString("provinceId.number"));
            }
            if (rs.getString("cityId.number") != null) {
                result.put("Fcity", rs.getString("cityId.number"));
            }
            if (rs.getString("districtId.number") != null) {
                result.put("Fdistrict", rs.getString("districtId.number"));
            }
            if (rs.getString("detailAddress") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FDetaillAddress_L1", rs.getString("detailAddress"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FDetaillAddress_L2", rs.getString("detailAddress"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FDetaillAddress_L3", rs.getString("detailAddress"));
                }
            }
            if (rs.getString("languageId.number") != null) {
                result.put("FLanguageID", rs.getString("languageId.number"));
            }
            if (rs.getString("postalCode") != null) {
                result.put("FPostalCode", rs.getString("postalCode"));
            }
            if (rs.getString("emailAddress") != null) {
                result.put("FWebAddress", rs.getString("emailAddress"));
            }
            if (rs.getString("linkMan") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FLinkMan_L1", rs.getString("linkMan"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FLinkMan_L2", rs.getString("linkMan"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FLinkMan_L3", rs.getString("linkMan"));
                }
            }
            if (rs.getString("phone") != null) {
                result.put("FPhone", rs.getString("phone"));
            }
            if (rs.getDate("availTime") != null) {
                result.put("FAvailTime", rs.getDate("availTime").toString());
            }
            if (rs.getString("fax") != null) {
                result.put("FFax", rs.getString("fax"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"accessError", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.AddressQuery";
    }
}

