/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.eas.basedata.assistant.BankAreaTypeEnum;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankException;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LRUMap;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class BankDataTransmission
extends AbstractDataTransmission {
    private LRUMap lruCache = new LRUMap();

    public BankDataTransmission() {
        this.lruCache.setMaxSize(500);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BankFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        BankInfo info;
        block27: {
            String parentNumber;
            String isBank;
            int i;
            String bankAreaType;
            String description_l3;
            String description_l2;
            String description_l1;
            String fax;
            String linkMan;
            String phone;
            String address;
            String name_l3;
            String name_l2;
            String name_l1;
            info = new BankInfo();
            String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
            if (number != null) {
                info.setNumber(number);
                Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
                int mode = datataskMode;
                if (mode == 16) {
                    try {
                        IBank iBank = (IBank)this.getController(ctx);
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                        view.setFilter(filterInfo);
                        BankCollection bankCollection = iBank.getBankCollection(view);
                        if (bankCollection.size() == 1) {
                            info.setId(bankCollection.get(0).getId());
                        }
                        if (bankCollection.size() < 0) {
                            throw new TaskExternalException("bank " + number + " does not exist!");
                        }
                        if (bankCollection.size() > 1) {
                            throw new TaskExternalException("multi bank with number " + number + " !");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new TaskExternalException("BOSException: getSettlementTypeCollection", (Throwable)e);
                    }
                }
            } else {
                throw new TaskExternalException("number not found!");
            }
            if ((name_l1 = (String)((DataToken)hsData.get((Object)"Fname_L1")).data) != null && name_l1.trim().length() != 0) {
                info.setName(name_l1, new Locale("L1"));
            }
            if ((name_l2 = (String)((DataToken)hsData.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
                info.setName(name_l2, new Locale("L2"));
            }
            if ((name_l3 = (String)((DataToken)hsData.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
                info.setName(name_l3, new Locale("L3"));
            }
            if ((address = (String)((DataToken)hsData.get((Object)"FAddress")).data) != null && address.trim().length() != 0) {
                info.setAddress(address);
            }
            if ((phone = (String)((DataToken)hsData.get((Object)"FPhone")).data) != null && phone.trim().length() != 0) {
                info.setPhone(phone);
            }
            if ((linkMan = (String)((DataToken)hsData.get((Object)"FLinkman")).data) != null && linkMan.trim().length() != 0) {
                info.setLinkman(linkMan);
            }
            if ((fax = (String)((DataToken)hsData.get((Object)"FFax")).data) != null && fax.trim().length() != 0) {
                info.setFax(fax);
            }
            if ((description_l1 = (String)((DataToken)hsData.get((Object)"Fdescription_L1")).data) != null && description_l1.trim().length() != 0) {
                info.setDescription(description_l1, new Locale("L1"));
            }
            if ((description_l2 = (String)((DataToken)hsData.get((Object)"Fdescription_L2")).data) != null && description_l2.trim().length() != 0) {
                info.setDescription(description_l2, new Locale("L2"));
            }
            if ((description_l3 = (String)((DataToken)hsData.get((Object)"Fdescription_L3")).data) != null && description_l3.trim().length() != 0) {
                info.setDescription(description_l3, new Locale("L3"));
            }
            if ((bankAreaType = (String)((DataToken)hsData.get((Object)"FBankAreaType")).data) != null && bankAreaType.trim().length() != 0 && (i = this.getIntValueFromAlias(ctx, "com.kingdee.eas.basedata.assistant.BankAreaTypeEnum", bankAreaType)) != -1) {
                info.setBankAreaType(BankAreaTypeEnum.getEnum(i));
            }
            if (!StringUtils.isEmpty((String)(isBank = (String)((DataToken)hsData.get((Object)"FIsBank")).data))) {
                info.setIsBank(this.getBooleanFromAlias(isBank));
            }
            if (!StringUtils.isEmpty((String)(parentNumber = (String)((DataToken)hsData.get((Object)"FParentNumber")).data))) {
                try {
                    if (this.lruCache.get((Object)parentNumber) != null) {
                        info.setParent((BankInfo)this.lruCache.get((Object)parentNumber));
                        break block27;
                    }
                    IBank iBank = (IBank)this.getController(ctx);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)parentNumber, CompareType.EQUALS));
                    view.setFilter(filterInfo);
                    BankCollection bankCollection = iBank.getBankCollection(view);
                    if (bankCollection == null || bankCollection.size() == 0) {
                        throw new TaskExternalException("parent " + parentNumber + " not exist!");
                    }
                    if (bankCollection.size() == 1) {
                        info.setParent(bankCollection.get(0));
                        this.lruCache.put((Object)parentNumber, (Object)bankCollection.get(0));
                        break block27;
                    }
                    throw new TaskExternalException("multi parent " + parentNumber + " !");
                }
                catch (Exception e) {
                    Logger.error((Throwable)e, (String)e.getMessage());
                    BankException ex = new BankException(BankException.PARENTNOTEXIST, new Object[]{parentNumber});
                    throw new TaskExternalException(ex.getMessage(), (Throwable)((Object)ex));
                }
            }
        }
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iBank = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iBank.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iBank.addnew(coreBaseInfo);
            } else {
                iBank.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", rs.getString("number"));
            if (rs.getString("name") != null) {
                result.put("Fname_L1", rs.getString("name"));
            }
            if (rs.getString("name") != null) {
                result.put("Fname_L2", rs.getString("name"));
            }
            if (rs.getString("name") != null) {
                result.put("Fname_L3", rs.getString("name"));
            }
            if (rs.getString("address") != null) {
                result.put("FAddress", rs.getString("address"));
            }
            if (rs.getString("phone") != null) {
                result.put("FPhone", rs.getString("phone"));
            }
            if (rs.getString("linkman") != null) {
                result.put("FLinkman", rs.getString("linkman"));
            }
            if (rs.getString("fax") != null) {
                result.put("FFax", rs.getString("fax"));
            }
            if (rs.getString("description") != null) {
                result.put("Fdescription_L1", rs.getString("description"));
            }
            if (rs.getString("description") != null) {
                result.put("Fdescription_L2", rs.getString("description"));
            }
            if (rs.getString("description") != null) {
                result.put("Fdescription_L3", rs.getString("description"));
            }
            if (rs.getString("parent.number") != null) {
                result.put("FParentNumber", rs.getString("parent.number"));
            }
            result.put("FBankAreaType", this.getAliasFromIntValue(ctx, "com.kingdee.eas.basedata.assistant.BankAreaTypeEnum", rs.getInt("bankAreaType")));
            result.put("FIsBank", this.getAliasFromBooleanValue(rs.getBoolean("isBank")));
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        catch (AccountException e) {
            e.printStackTrace();
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.BankQuery";
    }

    private int getIntValueFromAlias(Context ctx, String enumName, String alias) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BizEnumInfo enumInfo = loader.getEnum((IMetaDataPK)new MetaDataPK(enumName));
        BizEnumValueCollection enumItemCol = enumInfo.getEnumValue();
        for (BizEnumValueInfo enumItem : enumItemCol) {
            if (!alias.equals(enumItem.getAlias(LocaleUtils.getLocale((String)"l1"))) && !alias.equals(enumItem.getAlias(LocaleUtils.getLocale((String)"l2"))) && !alias.equals(enumItem.getAlias(LocaleUtils.getLocale((String)"l3")))) continue;
            if (enumItem.getValue() instanceof Integer) {
                return (Integer)enumItem.getValue();
            }
            if (!(enumItem.getValue() instanceof String)) continue;
            return Integer.parseInt((String)enumItem.getValue());
        }
        return -1;
    }

    private boolean getBooleanFromAlias(String isFreeze) {
        return !isFreeze.equals("N");
    }

    private String getAliasFromBooleanValue(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }

    private String getAliasFromIntValue(Context ctx, String enumName, int value) throws AccountException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BizEnumInfo enumInfo = loader.getEnum((IMetaDataPK)new MetaDataPK(enumName));
        BizEnumValueCollection enumItemCol = enumInfo.getEnumValue();
        for (BizEnumValueInfo enumItem : enumItemCol) {
            if (enumItem.getInt() != value) continue;
            String alias = enumItem.getAlias(ctx.getLocale());
            if (StringUtils.isEmpty((String)alias)) {
                alias = enumItem.getAlias(LocaleUtils.getLocale((String)"l2"));
            }
            return alias;
        }
        throw new AccountException(AccountException.ENUMVALUENOTEXIST, new Object[]{enumName, new Integer(value)});
    }
}

