/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CashDiscountEntryInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountException;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractCashDiscountControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.DataBaseInfo;
import org.apache.log4j.Logger;

public class CashDiscountControllerBean
extends AbstractCashDiscountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.CashDiscountControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkValid(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CashDiscountInfo v = (CashDiscountInfo)model;
        if (v.getNumber() == null || v.getNumber().length() == 0) {
            throw new CashDiscountException(CashDiscountException.EXC_NUMBER_NULL);
        }
        super.checkNumberDup(ctx, (DataBaseInfo)v);
        if (v.getCashDiscType() == null) {
            throw new CashDiscountException(CashDiscountException.EXC_TYPE_NULL);
        }
        if (v.getEntries() == null || v.getEntries().size() == 0) {
            throw new CashDiscountException(CashDiscountException.EXC_ENTRY_NULL);
        }
        CashDiscountEntryInfo entry = null;
        int size = v.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entry = v.getEntries().get(i);
            if (entry.getDays() <= 0) {
                throw new CashDiscountException(CashDiscountException.EXC_ENTRY_DAYS_NULL, new Object[]{new Integer(i + 1)});
            }
            if (entry.getDiscount() != null && !entry.getDiscount().equals(SysConstant.BIGZERO)) continue;
            throw new CashDiscountException(CashDiscountException.EXC_ENTRY_DISCOUNT_NULL, new Object[]{new Integer(i + 1)});
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DataBaseInfo info = (DataBaseInfo)super._getValue(ctx, pk);
        return info.getNumber();
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }
}

