/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemException;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.basedata.assistant.ICashFlowItem;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class CashFlowItemDataTransmission
extends AbstractDataTransmission {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.CashFlowItemDataTransmission.class");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CashFlowItemFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String cAAName;
        String isProfits;
        String direction;
        String isFreezeFCAA;
        String isDealActivity;
        String type;
        String name_l3;
        String name_l2;
        String name_l1;
        CashFlowItemInfo info = new CashFlowItemInfo();
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (number == null) throw new TaskExternalException("number not found!");
        if (number.length() > 80) {
            number = number.substring(0, 80);
        }
        info.setNumber(number);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            try {
                ICashFlowItem iCashFlowItem = (ICashFlowItem)this.getController(ctx);
                CashFlowItemCollection cashFlowItemCollection = iCashFlowItem.getCashFlowItemCollection();
                if (cashFlowItemCollection != null) {
                    for (int i = 0; i < cashFlowItemCollection.size(); ++i) {
                        if (!cashFlowItemCollection.get(i).getNumber().equalsIgnoreCase(number)) continue;
                        info.setId(cashFlowItemCollection.get(i).getId());
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new TaskExternalException("BOSException: getCashFlowItemCollection", (Throwable)e);
            }
        }
        if ((name_l1 = (String)((DataToken)hsData.get((Object)"Fname_L1")).data) != null && name_l1.trim().length() != 0) {
            info.setName(name_l1, LocaleUtils.locale_L1);
        }
        if ((name_l2 = (String)((DataToken)hsData.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
            info.setName(name_l2, LocaleUtils.locale_L2);
        }
        if ((name_l3 = (String)((DataToken)hsData.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
            info.setName(name_l3, LocaleUtils.locale_L3);
        }
        if ((type = (String)((DataToken)hsData.get((Object)"FType")).data) == null || type.trim().length() == 0) {
            String msg = new CashFlowItemException(CashFlowItemException.TYPEISNULL).getMessage();
            throw new TaskExternalException(msg);
        }
        int id = this.getIntValueFromAlias(ctx, "com.kingdee.eas.basedata.assistant.CashFlowItemType", type.toString());
        if (CashFlowItemType.getEnum(id) == null) {
            String msg = new CashFlowItemException(CashFlowItemException.ILLEGAL_CASHFLOWTYPE, new Object[]{type}).getMessage();
            throw new TaskExternalException(msg);
        }
        info.setType(CashFlowItemType.getEnum(id));
        String FParentID = (String)((DataToken)hsData.get((Object)"FParentID")).data;
        if (FParentID != null && !FParentID.trim().equals("")) {
            try {
                String sqlToGetGaa = "SELECT TOP 1 FID FROM t_bd_cashflowitem  WHERE FNUMBER=?";
                IRowSet rsToGetGaa = DbUtil.executeQuery((Context)ctx, (String)sqlToGetGaa, (Object[])new Object[]{FParentID});
                if (rsToGetGaa != null && rsToGetGaa.next()) {
                    CashFlowItemInfo cashinfoprant = new CashFlowItemInfo();
                    cashinfoprant.setId(BOSUuid.read((String)rsToGetGaa.getString("FID")));
                    info.setParent(cashinfoprant);
                }
                info.setParent(null);
            }
            catch (Exception e) {
                throw new TaskExternalException("CashFlowItem", (Throwable)e);
            }
        } else {
            info.setParent(null);
        }
        if (FParentID != null && !FParentID.trim().equals("")) {
            info.setLongNumber(FParentID + "!" + number);
        } else {
            info.setLongNumber(number);
        }
        String isFreeze = (String)((DataToken)hsData.get((Object)"FIsFreeze")).data;
        if (isFreeze != null) {
            info.setIsFreeze(this.getBooleanFromAlias(isFreeze));
        }
        if ((isDealActivity = (String)((DataToken)hsData.get((Object)"FIsDealActivity")).data) != null) {
            info.setIsDealActivity(this.getBooleanFromAlias(isDealActivity));
        }
        if ((isFreezeFCAA = (String)((DataToken)hsData.get((Object)"FIsFreezeFCAA")).data) != null) {
            info.setIsEnable(this.getBooleanFromAlias(isFreezeFCAA));
        }
        if ((direction = (String)((DataToken)hsData.get((Object)"FDrection")).data) != null) {
            info.setDirection(CashFlowDirection.getEnum(this.getIntValueFromAlias(ctx, "com.kingdee.eas.basedata.assistant.CashFlowDirection", direction)));
        }
        if (hsData.get("FIsExChange") != null) {
            String isExChange = (String)((DataToken)hsData.get((Object)"FIsExChange")).data;
            if (isDealActivity != null) {
                info.setIsExChange(this.getBooleanFromAlias(isExChange));
            }
        }
        if ((isProfits = (String)((DataToken)hsData.get((Object)"FIsProfits")).data) != null) {
            if (this.getBooleanFromAlias(isProfits)) {
                info.setIsLeaf(true);
            }
            info.setIsProfit(this.getBooleanFromAlias(isProfits));
        }
        if ((cAAName = (String)((DataToken)hsData.get((Object)"FCAA")).data) != null) {
            try {
                info.setAsstAccount(this.findAsstAccountByName(ctx, cAAName));
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        info.put("IsFromImport", Boolean.TRUE);
        this.verify(info);
        return info;
    }

    private void verify(CashFlowItemInfo info) throws TaskExternalException {
        switch (info.getType().getValue()) {
            case 0: {
                if (info.isIsDealActivity() && info.isIsExChange()) {
                    String msg = new CashFlowItemException(CashFlowItemException.NOT_DEALACTIVITY_EXCHANGE).getMessage();
                    throw new TaskExternalException(msg);
                }
                if (!info.isIsProfit()) break;
                String msg = new CashFlowItemException(CashFlowItemException.NOT_PROFIT).getMessage();
                throw new TaskExternalException(msg);
            }
            case 1: {
                if (info.isIsDealActivity() || info.isIsExChange() || info.getAsstAccount() != null || info.isIsFreeze()) {
                    String msg = new CashFlowItemException(CashFlowItemException.NOT_DEALACTIVITY_EXCHANGE_ASSTACCOUNT).getMessage();
                    throw new TaskExternalException(msg);
                }
                if (info.getDirection().getValue() == 0) break;
                String msg = new CashFlowItemException(CashFlowItemException.NOT_SECONDARY_IN_OR_OUT).getMessage();
                throw new TaskExternalException(msg);
            }
            case 2: {
                if (info.isIsDealActivity() || info.isIsExChange() || info.isIsProfit() || info.getAsstAccount() != null || info.isIsFreeze()) {
                    String msg = new CashFlowItemException(CashFlowItemException.NOT_DEALACTIVITY_EXCHANGE_ASSTACCOUNT_PROFIT).getMessage();
                    throw new TaskExternalException(msg);
                }
                if (info.getDirection().getValue() == 0) break;
                String msg = new CashFlowItemException(CashFlowItemException.NOT_SUPPLEMET_IN_OR_OUT).getMessage();
                throw new TaskExternalException(msg);
            }
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iCashFlowItemData = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iCashFlowItemData.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iCashFlowItemData.addnew(coreBaseInfo);
            } else {
                iCashFlowItemData.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            if (rs.getString("number") != null) {
                result.put("FNumber", rs.getString("number").replaceAll("!", "."));
            }
            if (LocaleUtils.getLocale((String)"l1").equals(ctx.getLocale()) && rs.getString("name") != null) {
                result.put("Fname_L1", rs.getString("name"));
            }
            if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale()) && rs.getString("name") != null) {
                result.put("Fname_L2", rs.getString("name"));
            }
            if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale()) && rs.getString("name") != null) {
                result.put("Fname_L3", rs.getString("name"));
            }
            result.put("FType", this.getAliasFromIntValue(ctx, "com.kingdee.eas.basedata.assistant.CashFlowItemType", rs.getInt("type")));
            if (rs.getString("parent.number") != null) {
                result.put("FParentID", this.getStringValueExceptNull(rs.getString("parent.number")));
            }
            result.put("FIsFreeze", this.getAliasFromBooleanValue(rs.getBoolean("isFreeze")));
            result.put("FIsDealActivity", this.getAliasFromBooleanValue(rs.getBoolean("isDealActivity")));
            result.put("FIsProfits", this.getAliasFromBooleanValue(rs.getBoolean("isProfit")));
            result.put("FDrection", this.getAliasFromIntValue(ctx, "com.kingdee.eas.basedata.assistant.CashFlowDirection", rs.getInt("direction")));
            result.put("FIsExChange", this.getAliasFromBooleanValue(rs.getBoolean("isExChange")));
            result.put("FIsFreezeFCAA", this.getAliasFromBooleanValue(rs.getBoolean("isEnable")));
            if (rs.getString("asstAccount.name") != null) {
                result.put("FCAA", rs.getString("asstAccount.name"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        catch (AccountException e) {
            logger.error((Object)e);
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.CashFlowItemQuery";
    }

    private boolean getBooleanFromAlias(String isTrue) {
        return isTrue.equals("Y");
    }

    private int getIntValueFromAlias(Context ctx, String enumName, String alias) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BizEnumInfo enumInfo = loader.getEnum((IMetaDataPK)new MetaDataPK(enumName));
        BizEnumValueCollection enumItemCol = enumInfo.getEnumValue();
        Iterator iter = enumItemCol.iterator();
        Iterator lans = null;
        LanguageInfo languageInfo2 = null;
        while (iter.hasNext()) {
            BizEnumValueInfo enumItem = (BizEnumValueInfo)iter.next();
            List languages = BOSLocaleUtil.getConfigLanguages();
            if (languages == null || languages.size() <= 0) continue;
            for (LanguageInfo languageInfo2 : languages) {
                if (!alias.equals(enumItem.getAlias(LocaleUtils.getLocale((String)languageInfo2.getLocaleString())))) continue;
                if (enumItem.getValue() instanceof Integer) {
                    return (Integer)enumItem.getValue();
                }
                if (!(enumItem.getValue() instanceof String)) continue;
                return Integer.parseInt((String)enumItem.getValue());
            }
        }
        return -1;
    }

    private String getAliasFromIntValue(Context ctx, String enumName, int value) throws AccountException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BizEnumInfo enumInfo = loader.getEnum((IMetaDataPK)new MetaDataPK(enumName));
        BizEnumValueCollection enumItemCol = enumInfo.getEnumValue();
        for (BizEnumValueInfo enumItem : enumItemCol) {
            if (enumItem.getInt() != value) continue;
            return enumItem.getAlias(ctx.getOriginLocale());
        }
        throw new AccountException(AccountException.ENUMVALUENOTEXIST, new Object[]{enumName, new Integer(value)});
    }

    private String getStringValueExceptNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    private String getAliasFromBooleanValue(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }

    protected AsstAccountInfo findAsstAccountByName(Context ctx, String strAsstAccountName) throws BOSException {
        if (strAsstAccountName == null || strAsstAccountName.trim().equals("")) {
            return null;
        }
        IAsstAccount asstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)(strAsstAccountName.trim() + "%"), CompareType.LIKE));
        AsstAccountInfo asstAccountInfo = null;
        AsstAccountCollection asstAccountCollection = asstAccount.getAsstAccountCollection(view);
        if (asstAccountCollection != null && asstAccountCollection.size() != 0) {
            if (asstAccountCollection.size() > 1) {
                for (int i = 0; i < asstAccountCollection.size(); ++i) {
                    AsstAccountInfo temp = asstAccountCollection.get(i);
                    if (temp == null || temp.getName() == null || !strAsstAccountName.trim().equals(temp.getName().trim())) continue;
                    asstAccountInfo = temp;
                    break;
                }
            } else {
                asstAccountInfo = asstAccountCollection.get(0);
            }
        }
        return asstAccountInfo;
    }
}

