/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.ChannelAttrEnum;
import com.kingdee.eas.basedata.assistant.ChannelTypeCollection;
import com.kingdee.eas.basedata.assistant.ChannelTypeException;
import com.kingdee.eas.basedata.assistant.ChannelTypeFactory;
import com.kingdee.eas.basedata.assistant.ChannelTypeInfo;
import com.kingdee.eas.basedata.assistant.IChannelType;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.Enum;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class ChannelTypeDataTransmission
extends AbstractDataTransmission {
    private static final String RESOURCE_FILE_NAME = "com.kingdee.eas.tools.datatask.DatataskResource";
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.basedata.assistant.client.AssistantDavidResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ChannelTypeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        ChannelAttrEnum channelAttr;
        String description_l3;
        String description_l2;
        String description_l1;
        String name_l3;
        String name_l2;
        String name_l1;
        ChannelTypeInfo info = new ChannelTypeInfo();
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (number == null) throw new TaskExternalException("number not found!");
        info.setNumber(number);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            try {
                IChannelType iChannelType = (IChannelType)this.getController(ctx);
                ChannelTypeCollection countryCollection = iChannelType.getChannelTypeCollection();
                if (countryCollection != null) {
                    for (int i = 0; i < countryCollection.size(); ++i) {
                        if (!countryCollection.get(i).getNumber().equalsIgnoreCase(number)) continue;
                        info.setId(countryCollection.get(i).getId());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TaskExternalException("BOSException: getChannelTypeCollection", (Throwable)e);
            }
        }
        if ((name_l1 = (String)((DataToken)hsData.get((Object)"Fname_L1")).data) != null && name_l1.trim().length() != 0) {
            info.setName(name_l1, new Locale("L1"));
        }
        if ((name_l2 = (String)((DataToken)hsData.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
            info.setName(name_l2, new Locale("L2"));
        }
        if ((name_l3 = (String)((DataToken)hsData.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
            info.setName(name_l3, new Locale("L3"));
        }
        if ((description_l1 = (String)((DataToken)hsData.get((Object)"Fdescription_L1")).data) != null && description_l1.trim().length() != 0) {
            info.setDescription(description_l1, new Locale("L1"));
        }
        if ((description_l2 = (String)((DataToken)hsData.get((Object)"Fdescription_L2")).data) != null && description_l2.trim().length() != 0) {
            info.setDescription(description_l2, new Locale("L2"));
        }
        if ((description_l3 = (String)((DataToken)hsData.get((Object)"Fdescription_L3")).data) != null && description_l3.trim().length() != 0) {
            info.setDescription(description_l3, new Locale("L3"));
        }
        if ((channelAttr = this.getChannelAttrEnum((String)((DataToken)hsData.get((Object)"FChannelAttr")).data, ctx)) == null) {
            throw new TaskExternalException(new ChannelTypeException(ChannelTypeException.CHANNELATTRNOTFOUND).getMessage());
        }
        info.setChannelAttr(channelAttr);
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iChannelType = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iChannelType.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iChannelType.addnew(coreBaseInfo);
            } else {
                iChannelType.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private ChannelAttrEnum getChannelAttrEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (DataImportTools.EnumEqualByAlias((String)value, (Enum)ChannelAttrEnum.CHANNEL)) {
            return ChannelAttrEnum.CHANNEL;
        }
        if (DataImportTools.EnumEqualByAlias((String)value, (Enum)ChannelAttrEnum.CHANNEL_TERMINAL)) {
            return ChannelAttrEnum.CHANNEL_TERMINAL;
        }
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", rs.getString("number"));
            DataImportTools.putValue(result, (Object)"FChannelAttr", (Object)ChannelAttrEnum.getEnum(rs.getString("channelAttr")).getAlias(ctx.getLocale()));
            Locale currentLocale = ctx.getLocale();
            if (rs.getString("name") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("Fname_L1", rs.getString("name"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("Fname_L2", rs.getString("name"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("Fname_L3", rs.getString("name"));
                }
            }
            if (rs.getString("description") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("Fdescription_L1", rs.getString("description"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("Fdescription_L2", rs.getString("description"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("Fdescription_L3", rs.getString("description"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"accessError", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.ChannelTypeQuery";
    }
}

