/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.CommRptRouteConfigException;
import com.kingdee.eas.basedata.assistant.RptRouteConfigInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractCommRptRouteConfigFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class CommRptRouteConfigFacadeControllerBean
extends AbstractCommRptRouteConfigFacadeControllerBean {
    private static CustomCacheService readDbCache = new CustomCacheService("cache.readDbcache");
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.CommRptRouteConfigFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _getConnectionKey(Context ctx, String bosType) throws BOSException, EASBizException {
        String sql = "select FCONKEY from T_BAS_RPTROUTECONFIG where FMODELNUMBER = ? AND FENABLE = 'true'";
        String key = null;
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bosType});
            key = rowSet != null && rowSet.next() ? rowSet.getString("FCONKEY") : ctx.getAIS();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
                catch (BOSException e2) {
                    logger.error((Object)e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowSet);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowSet);
        return key;
    }

    @Override
    protected List _query(Context ctx) throws BOSException, EASBizException {
        String sql = "select FID,FDOMAINNAME,FDOMAINNUMBER,FMODELNAME,FMODELNUMBER,FENABLE,FCONKEY,FBOSTYPE from T_BAS_RPTROUTECONFIG";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<RptRouteConfigInfo> list = new ArrayList<RptRouteConfigInfo>();
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    RptRouteConfigInfo info = new RptRouteConfigInfo();
                    info.setId(rowSet.getString("FID"));
                    info.setBosType(rowSet.getString("FBOSTYPE"));
                    info.setDomainName(rowSet.getString("FDOMAINNAME"));
                    info.setDomainNumber(rowSet.getString("FDOMAINNUMBER"));
                    info.setModelName(rowSet.getString("FMODELNAME"));
                    info.setModelNumber(rowSet.getString("FMODELNUMBER"));
                    info.setConKey(rowSet.getString("FCONKEY"));
                    info.setEnable(Boolean.valueOf(rowSet.getString("FENABLE")));
                    list.add(info);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rowSet);
            }
        }
        return list;
    }

    @Override
    protected void _save(Context ctx, Object obj) throws BOSException, EASBizException {
        this.checkSave(ctx, obj);
        if (obj != null && obj instanceof List) {
            List list = (List)obj;
            Connection con = null;
            Statement stat = null;
            try {
                con = EJBFactory.getConnection((Context)ctx);
                stat = con.createStatement();
                StringBuffer sql = new StringBuffer();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    sql.setLength(0);
                    RptRouteConfigInfo info = (RptRouteConfigInfo)it.next();
                    if (null == info.getConKey() || "".equals(info.getConKey())) continue;
                    if (info.getId() != null) {
                        sql.append("update T_BAS_RPTROUTECONFIG set ");
                        sql.append(" FCONKEY = '").append(info.getConKey()).append("',");
                        sql.append(" FENABLE = '").append(info.isEnable()).append("'");
                        sql.append(" where FDOMAINNUMBER = '").append(info.getDomainNumber()).append("'");
                        sql.append(" AND FMODELNUMBER = '").append(info.getModelNumber()).append("'");
                        stat.addBatch(sql.toString());
                    }
                    this.clearCache(ctx);
                }
                stat.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stat, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stat, (Connection)con);
        }
    }

    private void clearCache(Context ctx) throws BOSException {
        readDbCache.removeAll();
        this.initCache(ctx);
    }

    private void initCache(Context ctx) throws BOSException {
        String sql = "select FMODELNUMBER,FCONKEY,FBOSTYPE from T_BAS_RPTROUTECONFIG WHERE FENABLE = 'true'";
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet != null) {
                while (rowSet.next()) {
                    readDbCache.put(rowSet.getString("FMODELNUMBER"), (Object)rowSet.getString("FCONKEY"));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet);
        }
    }

    private void checkSave(Context ctx, Object obj) throws BOSException, EASBizException {
        if (obj != null && obj instanceof List) {
            List list = (List)obj;
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID FROM T_BAS_RPTROUTECONFIG WHERE ");
            int i = 0;
            ArrayList<String> paramsList = new ArrayList<String>();
            for (RptRouteConfigInfo info : list) {
                if (info.getId() != null || info.getConKey() == null) continue;
                sql.append(i++ > 0 ? " OR " : "");
                sql.append(" (FDOMAINNUMBER = ? AND FMODELNUMBER = ?)");
                paramsList.add(info.getDomainNumber());
                paramsList.add(info.getModelNumber());
            }
            if (i == 0) {
                return;
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramsList.toArray());
            if (rs == null || rs.size() <= 0) {
                throw new CommRptRouteConfigException(CommRptRouteConfigException.MODELNUMBERCANNOTSAME);
            }
        }
    }

    @Override
    protected Hashtable _getQueryDSCache(Context ctx) throws BOSException {
        Hashtable queryDs = EJBFactory.getQueryDSCache();
        Hashtable<String, String> keyTable = new Hashtable<String, String>();
        String key2 = null;
        for (String key2 : queryDs.keySet()) {
            keyTable.put(key2, key2);
        }
        return keyTable;
    }
}

