/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.AssistantCtrlUnitUtils;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.IOtherCountryChange;
import com.kingdee.eas.basedata.assistant.app.AbstractCountryControllerBean;
import com.kingdee.eas.basedata.assistant.util.AssistantUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.DataBaseInfo;
import java.util.Locale;

public class CountryControllerBean
extends AbstractCountryControllerBean {
    public static final String L1_VALUE = "L1";
    public static final String L2_VALUE = "L2";
    public static final String L3_VALUE = "L3";
    public static final Locale l1 = new Locale("L1");
    public static final Locale l2 = new Locale("L2");
    public static final Locale l3 = new Locale("L3");

    protected void addnewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((CountryInfo)model).setCU(AssistantCtrlUnitUtils.getRootCU(ctx));
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        this.addAndUpdateCheck(ctx, (CountryInfo)model);
    }

    private void addAndUpdateCheck(Context ctx, CountryInfo info) throws BOSException, EASBizException {
        CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)info, (String)"ISOCode", (int)80);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        if (!this.checkIsFromSHR(ctx)) {
            this.otherDealCountryChange(ctx, (CountryInfo)model, 1);
        }
        return pk;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this.addAndUpdateCheck(ctx, (CountryInfo)model);
        CountryInfo oldModel = this.getCountryInfo(ctx, pk);
        if (!((DataBaseInfo)model).getNumber().equals(oldModel.getNumber())) {
            this._checkNumberDup(ctx, model);
        }
        if (!((DataBaseInfo)model).getName().equals(oldModel.getName())) {
            this._checkNameDup(ctx, model);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        String[] oldNameStr = AssistantUtil.getOldAddressName(ctx, pk, "T_BD_country");
        CountryInfo oldCountry = this.getCountryInfo(ctx, pk);
        String oldCountryName = oldCountry.getName();
        super._update(ctx, pk, model);
        if (!oldCountryName.equals(((CountryInfo)model).getName())) {
            String name_l1 = ((CountryInfo)model).getName(l1);
            String name_l2 = ((CountryInfo)model).getName(l2);
            String name_l3 = ((CountryInfo)model).getName(l3);
            String[] newNameStr = new String[]{name_l1, name_l2, name_l3};
            AssistantUtil.updateAddress(ctx, pk, oldNameStr, newNameStr, "T_BD_country", "FCountryID");
        }
        if (!this.checkIsFromEnabledOrDisable(ctx) && !this.checkIsFromSHR(ctx)) {
            this.otherDealCountryChange(ctx, (CountryInfo)model, 2);
        }
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!this.checkIsFromSHR(ctx)) {
            this.otherDealCountryChange(ctx, this.getCountryInfo(ctx, pk), 3);
        }
        super.delete(ctx, pk);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._submit(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ctx.put((Object)"isFromEnabledOrDisable", (Object)"true");
        super._cancelCancel(ctx, pk, model);
        if (!this.checkIsFromSHR(ctx)) {
            this.otherDealCountryChange(ctx, (CountryInfo)model, 4);
        }
        ctx.put((Object)"isFromEnabledOrDisable", null);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ctx.put((Object)"isFromEnabledOrDisable", (Object)"true");
        super._cancel(ctx, pk, model);
        if (!this.checkIsFromSHR(ctx)) {
            this.otherDealCountryChange(ctx, (CountryInfo)model, 5);
        }
        ctx.put((Object)"isFromEnabledOrDisable", null);
    }

    private boolean checkIsFromSHR(Context ctx) {
        Object isFromSHR = ctx.get((Object)"isFromSHR");
        if (isFromSHR != null && isFromSHR instanceof Boolean && ((Boolean)isFromSHR).booleanValue()) {
            ctx.put((Object)"isFromSHR", null);
            return true;
        }
        return false;
    }

    private boolean checkIsFromEnabledOrDisable(Context ctx) {
        return ctx != null && "true".equals(ctx.get((Object)"isFromEnabledOrDisable"));
    }

    private void otherDealCountryChange(Context ctx, CountryInfo model, int type) throws EASBizException, BOSException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)this.getBOSType().toString(), IOtherCountryChange.class);
            if (checks != null && checks.length > 0) {
                IOtherCountryChange iOtherCountryChange = null;
                block11: for (int i = 0; i < checks.length; ++i) {
                    iOtherCountryChange = (IOtherCountryChange)Class.forName(checks[i]).newInstance();
                    switch (type) {
                        case 1: {
                            iOtherCountryChange.afterCountryAddNew(ctx, model);
                            continue block11;
                        }
                        case 2: {
                            iOtherCountryChange.afterCountryUpdate(ctx, model);
                            continue block11;
                        }
                        case 3: {
                            iOtherCountryChange.afterCountryDelete(ctx, model);
                            continue block11;
                        }
                        case 4: {
                            iOtherCountryChange.afterCountryCancelCancel(ctx, model);
                            continue block11;
                        }
                        case 5: {
                            iOtherCountryChange.afterCountryCancel(ctx, model);
                            continue block11;
                        }
                    }
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

