/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyException;
import com.kingdee.eas.basedata.assistant.DenominationCollection;
import com.kingdee.eas.basedata.assistant.DenominationFactory;
import com.kingdee.eas.basedata.assistant.DenominationInfo;
import com.kingdee.eas.basedata.assistant.DenominationUtils;
import com.kingdee.eas.basedata.assistant.IDenomination;
import com.kingdee.eas.basedata.assistant.app.AbstractDenominationFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;

public class DenominationFacadeControllerBean
extends AbstractDenominationFacadeControllerBean {
    @Override
    protected void _maintain(Context ctx, IObjectCollection denominations, IObjectPK currencyPk) throws BOSException, EASBizException {
        this.doMaintain(ctx, denominations, currencyPk);
    }

    private void doMaintain(Context ctx, IObjectCollection denominations, IObjectPK currencyPk) throws BOSException, EASBizException {
        int i;
        DenominationCollection addnewVOs = (DenominationCollection)denominations;
        this.checkDenominations(addnewVOs, currencyPk);
        IDenomination iDenomination = DenominationFactory.getLocalInstance(ctx);
        DenominationCollection oldVOs = iDenomination.getDenominationsByCurrency(currencyPk);
        for (i = 0; i < oldVOs.size(); ++i) {
            DenominationInfo oldVO = oldVOs.get(i);
            boolean founded = false;
            for (int j = 0; j < addnewVOs.size(); ++j) {
                DenominationInfo addnewVO = addnewVOs.get(j);
                if (addnewVO.getId() == null || !oldVO.getId().toString().equals(addnewVO.getId().toString())) continue;
                founded = true;
                break;
            }
            if (founded) continue;
            iDenomination.delete((IObjectPK)new ObjectUuidPK(oldVO.getId()));
        }
        for (i = 0; i < addnewVOs.size(); ++i) {
            DenominationInfo addnewVO = addnewVOs.get(i);
            if (addnewVO.getId() == null) {
                iDenomination.addnew((CoreBaseInfo)addnewVO);
                continue;
            }
            iDenomination.update((IObjectPK)new ObjectUuidPK(addnewVO.getId()), (CoreBaseInfo)addnewVO);
        }
        this.checkDenominations(iDenomination.getDenominationsByCurrency(currencyPk), currencyPk);
    }

    private void checkDenominations(DenominationCollection addnewVOs, IObjectPK currencyPk) throws CurrencyException {
        BOSUuid currencyId = BOSUuid.read((String)currencyPk.toString());
        for (int i = 0; i < addnewVOs.size(); ++i) {
            if (DenominationUtils.isIDEquals(addnewVOs.get(i).getCurrency().getId(), currencyId)) continue;
            throw new CurrencyException(CurrencyException.DENOMINATIONS_CURRENCY_MUST_CONSISTANT);
        }
        DenominationUtils.checkValueDuplicate(addnewVOs);
        DenominationUtils.checkCoefficientDuplicate(addnewVOs);
        DenominationUtils.checkStandardDenoMustOnlyUnique(addnewVOs);
    }
}

