/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.basedata.assistant.AssistantException;
import com.kingdee.eas.basedata.assistant.DynamicMltDataCenterConfigInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractDynamicMltDataCenterConfigControllerBean;
import com.kingdee.eas.basedata.common.olap.CommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.DataCenterManager;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DynamicMltDataCenterConfigControllerBean
extends AbstractDynamicMltDataCenterConfigControllerBean {
    private static final long serialVersionUID = 4848875226838809886L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.DynamicMltDataCenterConfigControllerBean");

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int configStatus = 1;
        this.executeSql(ctx, pks, configStatus);
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int configStatus = 0;
        this.executeSql(ctx, pks, configStatus);
    }

    protected void executeSql(Context ctx, IObjectPK[] pks, int configStatus) throws BOSException, EASBizException {
        Connection con = null;
        Statement batchStatement = null;
        try {
            con = this.getConnection(ctx);
            batchStatement = con.createStatement();
            int c = pks.length;
            for (int i = 0; i < c; ++i) {
                String updateSql = "update T_BD_DMltDataCenterConfig set FConfigStatus =" + configStatus + " where fid ='" + pks[i] + "'";
                batchStatement.addBatch(updateSql);
            }
            batchStatement.executeBatch();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            this._delete(ctx, pks[i]);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DynamicMltDataCenterConfigInfo model = (DynamicMltDataCenterConfigInfo)this.getValue(ctx, pk);
        this.checkModify(ctx, model);
        super._delete(ctx, pk);
    }

    private void checkModify(Context ctx, DynamicMltDataCenterConfigInfo model) throws BOSException, EASBizException {
        if (model.getConfigStatus() != null && model.getConfigStatus().getValue() == 0) {
            throw new AssistantException(AssistantException.CONFIG_ISENABLED);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DynamicMltDataCenterConfigInfo info = (DynamicMltDataCenterConfigInfo)model;
        ObjectUuidPK pk = null;
        if (!this.isAddNew(ctx, (IObjectValue)info)) {
            pk = new ObjectUuidPK(info.getId());
            this.checkUpdate(ctx, (IObjectPK)pk, model);
        } else {
            String reportID = CommonUtils.trim((String)info.getReportID());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("reportID", (Object)reportID));
            boolean existRptID = this.exists(ctx, filter);
            if (existRptID) {
                throw new AssistantException(AssistantException.RPTID_ISEXIST);
            }
        }
        pk = super._submit(ctx, model);
        return pk;
    }

    protected boolean isAddNew(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        boolean ret = false;
        DynamicMltDataCenterConfigInfo anInfo = (DynamicMltDataCenterConfigInfo)model;
        ret = anInfo.getId() == null || CommonUtils.trim((String)anInfo.getId().toString()).length() == 0 || !this._exists(ctx, (IObjectPK)new ObjectUuidPK(anInfo.getId()));
        return ret;
    }

    private void checkUpdate(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DynamicMltDataCenterConfigInfo info = (DynamicMltDataCenterConfigInfo)model;
        if (info.getReportID() == null || CommonUtils.trim((String)info.getReportID()).length() == 0) {
            throw new AssistantException(AssistantException.REPORTID_ISNULL);
        }
        if (info.getDataCenterNumber() == null) {
            throw new AssistantException(AssistantException.DATACENTER_ISNULL);
        }
    }

    @Override
    protected String _createView(Context ctx, DynamicMltDataCenterConfigInfo dmdcConfigInfo) throws BOSException, EASBizException {
        this.checkRefTable(dmdcConfigInfo);
        String createViewSqlList = this._getCreateViewSQL(ctx, dmdcConfigInfo);
        return createViewSqlList;
    }

    private void checkRefTable(DynamicMltDataCenterConfigInfo dmdcConfigInfo) throws BOSException, EASBizException {
        String refTable = CommonUtils.trim((String)dmdcConfigInfo.getRptRefTable());
        if (refTable == null || refTable.equals("")) {
            throw new AssistantException(AssistantException.REFTABLE_ISNULL);
        }
    }

    protected String _getCreateViewSQL(Context ctx, DynamicMltDataCenterConfigInfo dmdcConfigInfo) throws BOSException, EASBizException {
        String result = null;
        if ("Oracle".equals(ctx.get((Object)"dbType"))) {
            result = this.getOrclSQL(ctx, dmdcConfigInfo);
        }
        return result;
    }

    private String getOrclSQL(Context ctx, DynamicMltDataCenterConfigInfo dmdcConfigInfo) throws BOSException, EASBizException {
        String[] tableName = CommonUtils.trim((String)dmdcConfigInfo.getRptRefTable()).split(";");
        StringBuffer createView = new StringBuffer();
        StringBuffer createViewLog = new StringBuffer();
        for (int i = 0; i < tableName.length; ++i) {
            createViewLog.append(this.generateMVLogSQL(tableName[i]));
            createView.append(this.generateMVSQL(tableName[i]));
        }
        createViewLog.append("|").append(this.generateDBLinkSQL(ctx, dmdcConfigInfo)).append(createView);
        return createViewLog.toString();
    }

    private String generateDBLinkSQL(Context ctx, DynamicMltDataCenterConfigInfo dmdcConfigInfo) {
        StringBuffer dbLinkSql = new StringBuffer();
        DataCenterManager dcManager = new DataCenterManager(ctx);
        DCInfo dcInfo = dcManager.getDCInfo(ctx.getAIS());
        String dcUser = dcInfo.getUserName();
        String dcPsw = dcInfo.getPassword();
        String[] dataSource = dcInfo.getDataSource().split(":");
        String dcIP = dataSource[0];
        String dcPort = dataSource[1];
        String dcName = dcInfo.getDBName();
        dbLinkSql.append("DECLARE CNT PLS_INTEGER;\r\n").append("BEGIN\r\n").append("SELECT COUNT(DB_LINK) FCOUNT INTO CNT FROM  DBA_DB_LINKS WHERE DB_LINK = 'TFERP'").append(";\r\n").append("IF CNT > 0 THEN\r\n ").append("EXECUTE IMMEDIATE  'drop public database link TFERP';\r\n ").append("END IF;\r\n ").append("END;\r\n ").append("@\r\n").append("create public database link TFERP connect to ").append(dcUser).append(" identified by ").append(dcPsw).append(" using '(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=").append(dcIP).append(")(PORT=").append(dcPort).append(")))(CONNECT_DATA=(SERVER = DEDICATED)(SERVICE_NAME=").append(dcName).append(")))'").append("\r\n").append("@\r\n");
        return dbLinkSql.toString();
    }

    private String generateMVSQL(String tableName) {
        StringBuffer mvSql = new StringBuffer();
        mvSql.append("DECLARE CNT PLS_INTEGER;\r\n").append("BEGIN\r\n").append("SELECT COUNT(MVIEW_NAME) FCOUNT INTO CNT FROM  USER_MVIEWS WHERE MVIEW_NAME = upper('").append(tableName + "')").append(";\r\n").append("IF CNT > 0 THEN\r\n ").append("EXECUTE IMMEDIATE  'drop materialized view  ").append(tableName + "';\r\n ").append("END IF;\r\n ").append("END;\r\n ").append("@\r\n").append("DECLARE CNT PLS_INTEGER;\r\n").append("BEGIN\r\n").append("SELECT COUNT(VIEW_NAME) FCOUNT INTO CNT FROM  USER_VIEWS WHERE VIEW_NAME = upper('").append(tableName + "')").append(";\r\n").append("IF CNT > 0 THEN\r\n ").append("EXECUTE IMMEDIATE  'drop view ").append(tableName + "';\r\n ").append("END IF;\r\n ").append("END;\r\n ").append("@\r\n").append("DECLARE CNT PLS_INTEGER;\r\n").append("BEGIN\r\n").append("SELECT COUNT(TABLE_NAME) FCOUNT INTO CNT FROM  USER_TABLES WHERE TABLE_NAME = upper('").append(tableName + "')").append(";\r\n").append("IF CNT > 0 THEN\r\n ").append("EXECUTE IMMEDIATE  'drop table ").append(tableName + "';\r\n ").append("END IF;\r\n ").append("END;\r\n ").append("@\r\n").append("create materialized view ").append(tableName).append(" refresh force on demand").append(" NEXT SYSDATE+1/24").append(" with primary key ").append("as select a.* from ").append(tableName).append("@TFERP a\r\n").append("@\r\n");
        return mvSql.toString();
    }

    private String generateMVLogSQL(String tableName) {
        StringBuffer mvLogSql = new StringBuffer();
        mvLogSql.append("DECLARE CNT PLS_INTEGER;\r\n").append("BEGIN\r\n").append("SELECT COUNT(MASTER) FCOUNT INTO CNT FROM USER_MVIEW_LOGS WHERE MASTER='").append(tableName.toUpperCase()).append("';\r\n").append("IF CNT = 0 THEN\r\n ").append("EXECUTE IMMEDIATE  'create materialized view log on ").append(tableName).append(" with primary key';\r\n ").append("END IF;\r\n ").append("END;\r\n ").append("@\r\n");
        return mvLogSql.toString();
    }
}

