/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ExchangeRateException;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.app.AbstractExchangeTableControllerBean;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;

public class ExchangeTableControllerBean
extends AbstractExchangeTableControllerBean {
    protected void addnewCheck(Context ctx, ExchangeTableInfo model) throws BOSException, EASBizException {
        model.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this._checkNumberBlank(ctx, (IObjectValue)model);
        this._checkNumberDup(ctx, (IObjectValue)model);
        this._checkNameBlank(ctx, (IObjectValue)model);
        this._checkNameDup(ctx, (IObjectValue)model);
        this.checkBaseCurrency(ctx, model);
    }

    private void checkBaseCurrency(Context ctx, ExchangeTableInfo model) throws ExchangeRateException {
        if (model.getBaseCurrency() == null) {
            throw new ExchangeRateException(ExchangeRateException.NOT_NULL_BASECURRENCY);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (ExchangeTableInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, (ExchangeTableInfo)model);
        super._addnew(ctx, pk, model);
    }

    protected void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        ExchangeTableInfo oldModel = this.getExchangeTableInfo(ctx, pk);
        if (!((DataBaseInfo)model).getNumber().equals(oldModel.getNumber())) {
            this._checkNumberDup(ctx, model);
        }
        if (!((DataBaseInfo)model).getName().equals(oldModel.getName())) {
            this._checkNameDup(ctx, model);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ExchangeTableInfo tableInfo = (ExchangeTableInfo)this.getValue(ctx, pk);
        if (tableInfo.isIsAddNewable()) {
            CtrlUnitInfo cU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (!tableInfo.getCU().getId().toString().equals(cU.getId().toString())) {
                throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
            }
        }
        IExchangeRate exchangeRate = ExchangeRateFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        IObjectPK[] pks = null;
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.exchangeTable", (Object)pk.toString(), CompareType.EQUALS));
        pks = exchangeRate.getPKList(filter, null);
        if (pks != null && pks.length > 0) {
            this.setRollbackOnly();
            throw new ExchangeRateException(ExchangeRateException.EXCHANGE_TABLE_NOT_ALLOW_DELETE);
        }
        super._delete(ctx, pk);
    }
}

