/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.assistant.GlobalRoamingCollection;
import com.kingdee.eas.basedata.assistant.GlobalRoamingException;
import com.kingdee.eas.basedata.assistant.GlobalRoamingInfo;
import com.kingdee.eas.basedata.assistant.IOtherGlobalRoamingChange;
import com.kingdee.eas.basedata.assistant.StateEnum;
import com.kingdee.eas.basedata.assistant.app.AbstractGlobalRoamingControllerBean;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class GlobalRoamingControllerBean
extends AbstractGlobalRoamingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.GlobalRoamingControllerBean");

    public void cancel(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        GlobalRoamingInfo info = this.getGlobalRoamingInfo(ctx, pk);
        info.setState(StateEnum.DISABLE);
        this._update(ctx, pk, (IObjectValue)model);
        if (!this.checkIsFromSHR(ctx)) {
            this.afterGlobalRoamingCancel(ctx, pk);
        }
    }

    public void cancelCancel(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        GlobalRoamingInfo info = this.getGlobalRoamingInfo(ctx, pk);
        info.setState(StateEnum.ENABLE);
        this._update(ctx, pk, (IObjectValue)model);
        if (!this.checkIsFromSHR(ctx)) {
            this.afterGlobalRoamingCancelCancel(ctx, pk);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GlobalRoamingInfo info = this.getGlobalRoamingInfo(ctx, pk);
        if (info.isIsSystem()) {
            throw new GlobalRoamingException(GlobalRoamingException.INNERGLOBALROAMINGNOTBEENREMOVE);
        }
        IUser user = UserFactory.getLocalInstance((Context)ctx);
        IPerson person = PersonFactory.getLocalInstance((Context)ctx);
        boolean isUseByUser = false;
        boolean isUserByPerson = false;
        try {
            isUseByUser = (Boolean)user.getClass().getMethod("checkGlobalRomingIsUse", String.class).invoke((Object)user, info.getAreaCode());
            isUserByPerson = (Boolean)person.getClass().getMethod("checkGlobalRomingIsUse", String.class).invoke((Object)person, info.getAreaCode());
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (isUseByUser) {
            throw new GlobalRoamingException(GlobalRoamingException.GLOBALROAMINGISUSEBYUSER);
        }
        if (isUserByPerson) {
            throw new GlobalRoamingException(GlobalRoamingException.GLOBALROAMINGISUSEBYPERSON);
        }
        if (!this.checkIsFromSHR(ctx)) {
            this.afterGlobalRoamingDelete(ctx, pk);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        GlobalRoamingInfo newInfo = (GlobalRoamingInfo)model;
        String global = newInfo.getAreaCode();
        if (!this.checkGlobalRoaming(global)) {
            throw new GlobalRoamingException(GlobalRoamingException.GLOBALROAMINGERROR);
        }
        if (!global.startsWith("+")) {
            newInfo.setAreaCode("+" + newInfo.getAreaCode());
        }
        GlobalRoamingInfo oldInfo = this.getGlobalRoamingInfo(ctx, pk);
        super._update(ctx, pk, model);
        this.checkRepeat(ctx, newInfo.getAreaCode());
        IUser user = UserFactory.getLocalInstance((Context)ctx);
        IPerson person = PersonFactory.getLocalInstance((Context)ctx);
        try {
            user.getClass().getMethod("updateUserGlobalRomaing", String.class, String.class).invoke((Object)user, oldInfo.getAreaCode(), newInfo.getAreaCode());
            person.getClass().getMethod("updatePersonGlobalRomaing", String.class, String.class).invoke((Object)person, oldInfo.getAreaCode(), newInfo.getAreaCode());
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (!this.checkIsFromSHR(ctx)) {
            this.afterGlobalRoamingUpdate(ctx, pk, newInfo);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GlobalRoamingInfo newInfo = (GlobalRoamingInfo)model;
        String global = newInfo.getAreaCode();
        if (!this.checkGlobalRoaming(global)) {
            throw new GlobalRoamingException(GlobalRoamingException.GLOBALROAMINGERROR);
        }
        if (!global.startsWith("+")) {
            newInfo.setAreaCode("+" + newInfo.getAreaCode());
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)newInfo);
        this.checkRepeat(ctx, newInfo.getAreaCode());
        if (!this.checkIsFromSHR(ctx)) {
            this.afterGlobalRoamingAddNew(ctx, pk, newInfo);
        }
        return pk;
    }

    public void afterGlobalRoamingCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IOtherGlobalRoamingChange[] classInstances;
        for (IOtherGlobalRoamingChange iOtherGlobalRoamingChange : classInstances = this.getOtherGlobalRoamingInstance(ctx)) {
            iOtherGlobalRoamingChange.afterGlobalRoamingCancel(ctx, pk);
        }
    }

    public void afterGlobalRoamingCancelCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IOtherGlobalRoamingChange[] classInstances;
        for (IOtherGlobalRoamingChange iOtherGlobalRoamingChange : classInstances = this.getOtherGlobalRoamingInstance(ctx)) {
            iOtherGlobalRoamingChange.afterGlobalRoamingCancelCancel(ctx, pk);
        }
    }

    public void afterGlobalRoamingDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IOtherGlobalRoamingChange[] classInstances;
        for (IOtherGlobalRoamingChange iOtherGlobalRoamingChange : classInstances = this.getOtherGlobalRoamingInstance(ctx)) {
            iOtherGlobalRoamingChange.afterGlobalRoamingDelete(ctx, pk);
        }
    }

    public void afterGlobalRoamingUpdate(Context ctx, IObjectPK pk, GlobalRoamingInfo model) throws BOSException, EASBizException {
        IOtherGlobalRoamingChange[] classInstances;
        for (IOtherGlobalRoamingChange iOtherGlobalRoamingChange : classInstances = this.getOtherGlobalRoamingInstance(ctx)) {
            iOtherGlobalRoamingChange.afterGlobalRoamingUpdate(ctx, pk, model);
        }
    }

    public void afterGlobalRoamingAddNew(Context ctx, IObjectPK pk, GlobalRoamingInfo model) throws BOSException, EASBizException {
        IOtherGlobalRoamingChange[] classInstances;
        for (IOtherGlobalRoamingChange iOtherGlobalRoamingChange : classInstances = this.getOtherGlobalRoamingInstance(ctx)) {
            iOtherGlobalRoamingChange.afterGlobalRoamingAddNew(ctx, pk, model);
        }
    }

    private IOtherGlobalRoamingChange[] getOtherGlobalRoamingInstance(Context ctx) throws BOSException {
        String[] checks = null;
        IOtherGlobalRoamingChange[] classInstances = new IOtherGlobalRoamingChange[]{};
        try {
            checks = RefCheckersDAO.getCheckers((Context)ctx, (String)this.getBOSType().toString(), IOtherGlobalRoamingChange.class);
            if (checks != null && checks.length > 0) {
                classInstances = new IOtherGlobalRoamingChange[checks.length];
                for (int i = 0; i < checks.length; ++i) {
                    classInstances[i] = (IOtherGlobalRoamingChange)Class.forName(checks[i]).newInstance();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return classInstances;
    }

    private boolean checkIsFromSHR(Context ctx) {
        Object isFromSHR = ctx.get((Object)"isFromSHR");
        if (isFromSHR != null && isFromSHR instanceof Boolean && ((Boolean)isFromSHR).booleanValue()) {
            ctx.put((Object)"isFromSHR", null);
            return true;
        }
        return false;
    }

    private boolean checkGlobalRoaming(String globalRoaming) {
        boolean flag = true;
        if (StringUtils.isEmpty((String)globalRoaming)) {
            flag = false;
        } else if (globalRoaming.startsWith("+")) {
            int index = globalRoaming.indexOf("+");
            globalRoaming = globalRoaming.substring(index + 1);
        }
        try {
            Integer.parseInt(globalRoaming);
        }
        catch (Exception e) {
            flag = !globalRoaming.startsWith("-") && globalRoaming.contains("-");
        }
        return flag;
    }

    private void checkRepeat(Context ctx, String globalRoaming) throws BOSException, EASBizException {
        GlobalRoamingCollection globalRoamingCollection = this.getGlobalRoamingCollection(ctx, "where areaCode='" + globalRoaming + "'");
        if (globalRoamingCollection.size() > 1) {
            throw new GlobalRoamingException(GlobalRoamingException.GLOBALROAMINGREPEAT);
        }
    }
}

