/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AssistantCtrlUnitUtils;
import com.kingdee.eas.basedata.assistant.AssistantException;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractIndustryControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;

public class IndustryControllerBean
extends AbstractIndustryControllerBean {
    IndustryInfo oldInfoIndustry = null;

    protected void addnewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((IndustryInfo)model).setCU(AssistantCtrlUnitUtils.getRootCU(ctx));
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        IndustryInfo industryInfo = (IndustryInfo)model;
        industryInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        return super._addnew(ctx, (IObjectValue)industryInfo);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IndustryInfo industryInfo;
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        IndustryInfo oldModel = this.getIndustryInfo(ctx, pk);
        if (!((DataBaseInfo)model).getNumber().equals(oldModel.getNumber())) {
            this._checkNumberDup(ctx, model);
        }
        if (!((DataBaseInfo)model).getName().equals(oldModel.getName())) {
            this._checkNameDup(ctx, model);
        }
        if ((industryInfo = (IndustryInfo)model).getId() != null) {
            this.oldInfoIndustry = this.getIndustryInfo(ctx, (IObjectPK)new ObjectUuidPK(industryInfo.getId()));
        }
        if (industryInfo.getParent() != null) {
            IndustryInfo parentIndustryInfo = industryInfo.getParent();
            if (industryInfo.getNumber() != null && parentIndustryInfo.getNumber() != null && industryInfo.getNumber().equalsIgnoreCase(parentIndustryInfo.getNumber())) {
                throw new AssistantException(AssistantException.PARENTCANTBESELF);
            }
            if (industryInfo.getLongNumber() != null && parentIndustryInfo.getLongNumber() != null && parentIndustryInfo.getLongNumber().startsWith(industryInfo.getLongNumber())) {
                throw new AssistantException(AssistantException.PARENTCANTBESELF);
            }
        }
    }

    protected void updateIndustryParent(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        IndustryInfo parentIndustryInfo;
        IndustryInfo industryInfo = (IndustryInfo)model;
        if (industryInfo.getParent() != null && (parentIndustryInfo = industryInfo.getParent()) != null && parentIndustryInfo.getId() != null && parentIndustryInfo.getId().toString().trim().length() > 0 && (industryInfo = (IndustryInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(parentIndustryInfo.getId().toString()))) != null && industryInfo.getId() != null) {
            industryInfo.setIsLeaf(false);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(industryInfo.getId()), (IObjectValue)industryInfo);
        }
        if (this.oldInfoIndustry.getParent() != null) {
            IndustryInfo oldIndustryParentInfo = this.oldInfoIndustry.getParent();
            TreeBaseCollection coll = this.getAllChildren(ctx, oldIndustryParentInfo);
            if (coll.size() <= 0) {
                oldIndustryParentInfo.setIsLeaf(true);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(oldIndustryParentInfo.getId()), (IObjectValue)oldIndustryParentInfo);
            } else {
                oldIndustryParentInfo.setIsLeaf(false);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(oldIndustryParentInfo.getId()), (IObjectValue)oldIndustryParentInfo);
            }
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        super._update(ctx, pk, model);
        this.updateIndustryParent(ctx, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        TreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            filter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parent.getId(), CompareType.EQUALS));
        }
        filter.setMaskString("#0 and #1");
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1 and #2");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + " : " + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    private TreeBaseInfo getFullParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        TreeBaseInfo parent = treeBaseInfo.innerGetParent();
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            return null;
        }
        parent = this.lazyLoad(ctx, (IObjectValue)parent);
        treeBaseInfo.innerSetParent(parent);
        return parent;
    }

    private TreeBaseInfo lazyLoad(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("displayName"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        return (TreeBaseInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()), selector);
    }
}

