/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IMeasureUnitGroup;
import com.kingdee.eas.basedata.assistant.MeasureUnitException;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractMeasureUnitControllerBean;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefChkFilter;
import com.kingdee.eas.common.RefChkFilterItemEnum;
import com.kingdee.eas.common.RefChkFilterSet;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MeasureUnitControllerBean
extends AbstractMeasureUnitControllerBean {
    String resClassName = "com.kingdee.eas.basedata.assistant.client.assistantResource";

    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException, MeasureUnitException {
        boolean isReferenced = false;
        MeasureUnitInfo info = (MeasureUnitInfo)model;
        this.addnewAndUpdateCheck(ctx, info);
        super._checkNameBlank(ctx, (IObjectValue)info);
        this.checkNameAddNew(ctx, (IObjectValue)info);
        super._checkNumberBlank(ctx, (IObjectValue)info);
        this._checkNumberDup(ctx, (IObjectValue)info);
        this._checkInValidation(info);
        if (!this._checkNumberValid(ctx, (IObjectValue)info)) {
            throw new MeasureUnitException(MeasureUnitException.VALID_MEASUREUNITCOEFFICIENT);
        }
        IMeasureUnitGroup iGroup = MeasureUnitGroupFactory.getLocalInstance(ctx);
        MeasureUnitGroupInfo group = iGroup.getMeasureUnitGroupInfo((IObjectPK)new ObjectUuidPK(info.getMeasureUnitGroup().getId()));
        if (group.getDisableDate() != null && group.getDisableDate().before(new Date())) {
            throw new MeasureUnitException(MeasureUnitException.INVALID_ADDUNIT);
        }
        String measureUnitGropID = info.getMeasureUnitGroup().getId().toString().toString();
        isReferenced = false;
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        if (info.isIsBaseUnit()) {
            if (group.getDefaultUnit() != null && isReferenced) {
                throw new MeasureUnitException(MeasureUnitException.MSGBOX_MEASUREUNITREFERENCED);
            }
            if (group.getDefaultUnit() == null || group.getDefaultUnit() != null && !isReferenced) {
                if (group.getDefaultUnit() != null) {
                    MeasureUnitInfo oldInfo = this.getMeasureUnitInfo(ctx, (IObjectPK)new ObjectUuidPK(group.getDefaultUnit().getId()));
                    oldInfo.setIsBaseUnit(false);
                    super._update(ctx, (IObjectPK)new ObjectUuidPK(oldInfo.getId()), (IObjectValue)oldInfo);
                }
                group.setDefaultUnit(info);
                iGroup.update((IObjectPK)new ObjectUuidPK(group.getId()), (CoreBaseInfo)group);
            }
        }
        return pk;
    }

    protected void _checkInValidation(MeasureUnitInfo model) throws BOSException, EASBizException, MeasureUnitException {
        if (model.getDisabledDate() != null && model.getDisabledDate().before(new Date())) {
            throw new MeasureUnitException(MeasureUnitException.INVALID_UNIT_DISABLEDATE);
        }
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        boolean isReferenced = false;
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance(ctx);
        MeasureUnitInfo oldInfo = iMeasureUnit.getMeasureUnitInfo(pk, this.getSelectors());
        MeasureUnitInfo info = (MeasureUnitInfo)model;
        this.addnewAndUpdateCheck(ctx, info);
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (!ctrlUnitInfo.getId().equals((Object)oldInfo.getCU().getId())) {
            throw new MeasureUnitException(MeasureUnitException.NOT_CREATE_CU, new Object[]{info.getName(), ctrlUnitInfo.getName()});
        }
        if (info == null || info.getMeasureUnitGroup() == null) {
            return;
        }
        if (oldInfo.isIsBaseUnit() && !info.getMeasureUnitGroup().getId().equals((Object)oldInfo.getMeasureUnitGroup().getId())) {
            String sql = "update T_BD_MeasureUnitGroup set FDefaultUnitID = ? where fid = ? ";
            Connection conn = null;
            try {
                conn = super.getConnection(ctx);
                PreparedStatement ps = conn.prepareStatement(sql);
                ps.setNull(1, 12);
                ps.setString(2, oldInfo.getMeasureUnitGroup().getId().toString());
                ps.execute();
                ORMValueCacheService.getInstance().remove(ctx, oldInfo.getMeasureUnitGroup().getBOSType(), (IObjectPK)new ObjectUuidPK(oldInfo.getMeasureUnitGroup().getId().toString()));
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), e.getCause());
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        IMeasureUnitGroup iGroup = MeasureUnitGroupFactory.getLocalInstance(ctx);
        MeasureUnitGroupInfo group = iGroup.getMeasureUnitGroupInfo((IObjectPK)new ObjectUuidPK(info.getMeasureUnitGroup().getId()));
        super._checkNameBlank(ctx, (IObjectValue)info);
        this.checkNameUpdate(ctx, (IObjectValue)info);
        super._checkNumberBlank(ctx, (IObjectValue)info);
        this._checkNumberDup(ctx, (IObjectValue)info);
        this._checkInValidation(info);
        if (!this._checkNumberValid(ctx, (IObjectValue)info)) {
            throw new MeasureUnitException(MeasureUnitException.VALID_MEASUREUNITCOEFFICIENT);
        }
        this.checkHasReference(ctx, oldInfo, info);
        String measureUnitGropID = info.getMeasureUnitGroup().getId().toString().toString();
        if (info.isIsBaseUnit()) {
            if (group.getDefaultUnit() != null && isReferenced) {
                throw new MeasureUnitException(MeasureUnitException.MSGBOX_MEASUREUNITREFERENCED);
            }
            if (group.getDefaultUnit() == null || group.getDefaultUnit() != null && !isReferenced) {
                if (group.getDefaultUnit() != null) {
                    oldInfo = this.getMeasureUnitInfo(ctx, (IObjectPK)new ObjectUuidPK(group.getDefaultUnit().getId()));
                    oldInfo.setIsBaseUnit(false);
                    super._update(ctx, (IObjectPK)new ObjectUuidPK(oldInfo.getId()), (IObjectValue)oldInfo);
                }
                group.setDefaultUnit(info);
                iGroup.update((IObjectPK)new ObjectUuidPK(group.getId()), (CoreBaseInfo)group);
            }
        } else if (oldInfo.isIsBaseUnit() && !isReferenced) {
            group.setDefaultUnit(null);
            iGroup.update((IObjectPK)new ObjectUuidPK(group.getId()), (CoreBaseInfo)group);
        } else if (oldInfo.isIsBaseUnit() && isReferenced) {
            throw new MeasureUnitException(MeasureUnitException.MSGBOX_MEASUREUNITREFERENCED);
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    private boolean checkMeasureUnitRef(Context ctx, String measureUnitGroupID) throws BOSException {
        boolean isReferenced = false;
        String strSql = "Select FID From T_BD_MeasureUnit Where FGroupID='" + measureUnitGroupID + "'";
        IRowSet measureRowSet = DbUtil.executeQuery((Context)ctx, (String)strSql);
        try {
            String FId;
            while (measureRowSet.next() && !(isReferenced = this.checkReference(ctx, BOSUuid.read((String)(FId = measureRowSet.getString("FID"))), true))) {
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return isReferenced;
    }

    private Throwable checkReference(Context ctx, BOSUuid id) throws BizReferenceException {
        BizReferenceException e = null;
        if (BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)id).isFound()) {
            e = new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
        return e;
    }

    private boolean checkReference(Context ctx, BOSUuid id, boolean isExcludeGroup) {
        RefChkFilterSet filterSet = new RefChkFilterSet();
        HashSet<String> hs = new HashSet<String>();
        hs.add("1C2AC868");
        RefChkFilter filter = new RefChkFilter(RefChkFilterItemEnum.ExcludedRefobjTypeList, hs);
        filterSet.add(filter);
        return ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)id, (RefChkFilterSet)filterSet);
    }

    private void checkHasReference(Context ctx, MeasureUnitInfo oldVO, MeasureUnitInfo updateVO) throws EASBizException {
        boolean isRef = false;
        Throwable e = this.checkReference(ctx, oldVO.getId());
        if (e != null) {
            isRef = true;
        }
        if (!oldVO.getNumber().equals(updateVO.getNumber()) && isRef) {
            throw new MeasureUnitException(MeasureUnitException.REF_NOT_UPDATE_NUMBER);
        }
        if (oldVO.getCoefficient().compareTo(updateVO.getCoefficient()) != 0 && isRef) {
            throw new MeasureUnitException(MeasureUnitException.REF_NOT_UPDATE_COEFFICIENT);
        }
    }

    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Throwable e;
        MeasureUnitInfo info = this.getMeasureUnitInfo(ctx, pk);
        BOSUuid measureUnitUuid = info.getId();
        if (info.isIsBaseUnit()) {
            String sql = "update T_BD_MeasureUnitGroup set FDefaultUnitID = ? where FDefaultUnitID = ? ";
            Connection conn = null;
            try {
                conn = super.getConnection(ctx);
                PreparedStatement ps = conn.prepareStatement(sql);
                ps.setNull(1, 12);
                ps.setString(2, pk.toString());
                ps.execute();
            }
            catch (Exception e2) {
                throw new BOSException(e2.getMessage(), e2.getCause());
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        if ((e = this.checkReference(ctx, measureUnitUuid)) != null) {
            throw new MeasureUnitException(MeasureUnitException.REF_NOT_DELETE_MEASUREUNIT, e);
        }
        BizCheckResult bizCheckResult = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)measureUnitUuid);
        if (bizCheckResult.isFound()) {
            throw bizCheckResult.getException();
        }
        this.recycleNumberFromCodingRule(ctx, info, this.getCurrentOrgId(ctx, (IObjectValue)info));
        String deleteSql = "delete from t_bd_measureunit where fid = ?";
        Object[] params = new Object[]{pk.toString()};
        com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])params);
        ORMValueCacheService.getInstance().remove(ctx, info.getBOSType(), pk);
    }

    public void checkNameAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MeasureUnitInfo muInfo = (MeasureUnitInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)muInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (muInfo.getMeasureUnitGroup() != null) {
            filterItem = new FilterItemInfo("measureUnitGroup.id", (Object)muInfo.getMeasureUnitGroup().getId().toString().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        DataBaseCollection results = this.getDataBaseCollection(ctx, view);
        if (results != null && results.size() > 0) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{muInfo.getName()});
        }
    }

    public void checkNameUpdate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MeasureUnitInfo muInfo = (MeasureUnitInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)muInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("id", (Object)muInfo.getId().toString().toString(), CompareType.NOTEQUALS);
        filter.getFilterItems().add(filterItem);
        if (muInfo.getMeasureUnitGroup() != null) {
            filterItem = new FilterItemInfo("measureUnitGroup.id", (Object)muInfo.getMeasureUnitGroup().getId().toString().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        DataBaseCollection results = this.getDataBaseCollection(ctx, view);
        if (results != null && results.size() > 0) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{muInfo.getName()});
        }
    }

    public boolean _checkNumberValid(Context ctx, IObjectValue model) {
        MeasureUnitInfo info = (MeasureUnitInfo)model;
        Pattern p = Pattern.compile("[0-9]+[.]?[0-9]*+([eE][+-][0-9]*)?");
        Matcher m = p.matcher(info.getCoefficient().toString());
        boolean b = m.matches() && info.getCoefficient().doubleValue() > 0.0;
        return b;
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SQLUtil sb = new SQLUtil();
        sb.appendSql(" update T_BD_MeasureUnit set FisDisabled =1 where FID='").appendSql(pk.toString()).appendSql("'");
        sb.execute(ctx);
    }

    @Override
    protected void _unFreeze(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SQLUtil sb = new SQLUtil();
        sb.appendSql(" update T_BD_MeasureUnit set FisDisabled =0 where FID='").appendSql(pk.toString()).appendSql("'");
        sb.execute(ctx);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("coefficient"));
        sic.add(new SelectorItemInfo("disableDate"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isBaseUnit"));
        sic.add(new SelectorItemInfo("isDisabled"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("measureUnitGroup.id"));
        return sic;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    @Override
    protected void _synMulMeasureUnit(Context ctx, String MeasureUnitGroupID) throws BOSException, EASBizException {
        if (MeasureUnitGroupID == null || MeasureUnitGroupID.length() == 0) {
            return;
        }
        SQLUtil sb = new SQLUtil();
        sb.appendSql(" insert into T_BD_MultiMeasureUnit ");
        sb.appendSql(" ( FID,FSeq ,FMaterialID ,FMeasureUnitID ,FQtyPrecision ,FBaseConvsRate ,  ");
        sb.appendSql(" FConvsPrecision ,FIsUseConvsUnit,FIsBasicUnit,FMeasureUnitType) ");
        sb.appendSql(" select newbosid('C8D5221F'),0,T_BD_MATERIAL.FID, allMeasureUnit.FID, allMeasureUnit.FQtyPrecision, ");
        sb.appendSql("  ROUND(allMeasureUnit.FCoefficient/basicMeasureUnit.FCoefficient,6),0,0,0,0  ");
        sb.appendSql(" from T_BD_MATERIAL,T_BD_MeasureUnit  basicMeasureUnit,T_BD_MeasureUnit  allMeasureUnit  ");
        sb.appendSql(" where T_BD_MATERIAL.FBaseUnit= basicMeasureUnit.FID  ");
        sb.appendSql(" and  basicMeasureUnit.FGroupID= allMeasureUnit.FGroupID   ");
        sb.appendSql(" and basicMeasureUnit.FGroupID= '").appendSql(MeasureUnitGroupID).appendSql("'");
        sb.appendSql(" and allMeasureUnit.FIsDisabled <>1 ");
        sb.appendSql(" and not exists (select 1 from T_BD_MultiMeasureUnit ");
        sb.appendSql("     where  T_BD_MultiMeasureUnit.FMaterialID =T_BD_MATERIAL.FID  ");
        sb.appendSql("     and  T_BD_MultiMeasureUnit.FMeasureUnitID= allMeasureUnit.FID) ");
        sb.execute(ctx);
    }

    public void addnewAndUpdateCheck(Context ctx, MeasureUnitInfo info) throws BOSException, EASBizException {
        if (info.getQtyPrecision() < 0 || info.getQtyPrecision() > 8) {
            throw new MeasureUnitException(MeasureUnitException.PRECISIONILLEGAL);
        }
        if (info.isIsBaseUnit()) {
            info.setCoefficient(new BigDecimal(1));
        }
    }
}

