/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IMeasureUnitGroup;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitException;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractMeasureUnitGroupControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.BizCheckerUtil;
import java.util.Date;

public class MeasureUnitGroupControllerBean
extends AbstractMeasureUnitGroupControllerBean {
    private IMeasureUnit iMeasureUnit;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MeasureUnitGroupInfo info = (MeasureUnitGroupInfo)model;
        super._checkNameBlank(ctx, (IObjectValue)info);
        super._checkNumberBlank(ctx, (IObjectValue)info);
        super._checkNumberDup(ctx, (IObjectValue)info);
        this._checkInValidation(info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _checkInValidation(MeasureUnitGroupInfo model) throws BOSException, EASBizException, MeasureUnitException {
        if (model.getDisableDate() != null && model.getDisableDate().before(new Date())) {
            throw new MeasureUnitException(MeasureUnitException.INVALID_UNITGROUP_DISABLEDATE);
        }
    }

    public MeasureUnitGroupCollection getValidCollection(Context ctx) throws BOSException {
        MeasureUnitGroupCollection c = super.getMeasureUnitGroupCollection(ctx);
        MeasureUnitGroupInfo info = null;
        for (int i = 0; i < c.size(); ++i) {
            info = c.get(i);
            if (this.getUnits(ctx, info.getId().toString()).size() != 0) continue;
            c.remove(info);
        }
        return c;
    }

    private MeasureUnitCollection getUnits(Context ctx, String groupId) throws BOSException {
        if (this.iMeasureUnit == null) {
            this.iMeasureUnit = MeasureUnitFactory.getLocalInstance(ctx);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("MeasureUnitGroup", (Object)groupId.trim(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isBaseUnit", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)new Integer(0), CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return this.iMeasureUnit.getMeasureUnitCollection(evi);
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BOSUuid updateBUUuid = null;
        BOSUuid oldBUUuid = null;
        MeasureUnitGroupInfo info = (MeasureUnitGroupInfo)model;
        IMeasureUnitGroup iMeasureUnitGroup = MeasureUnitGroupFactory.getLocalInstance(ctx);
        MeasureUnitGroupInfo oldInfo = (MeasureUnitGroupInfo)iMeasureUnitGroup.getValue(pk);
        if (info.getDefaultUnit() != null) {
            updateBUUuid = info.getDefaultUnit().getId();
        }
        BOSUuid updateMeaUnitGroUuid = oldInfo.getId();
        if (oldInfo.getDefaultLocale() != null && oldInfo.getDefaultUnit() != null) {
            oldBUUuid = oldInfo.getDefaultUnit().getId();
        }
        super._checkNameBlank(ctx, (IObjectValue)info);
        super._checkNumberBlank(ctx, (IObjectValue)info);
        super._checkNumberDup(ctx, (IObjectValue)info);
        this._checkInValidation(info);
        if (this._checkHasChildren(ctx, pk, model)) {
            throw new MeasureUnitException(MeasureUnitException.MSGBOX_MEASUREUNITGROUPHASCHILDREN);
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    private Throwable checkReference(Context ctx, BOSUuid id) {
        Exception e = null;
        try {
            this._isReferenced(ctx, (IObjectPK)new ObjectUuidPK(id));
            BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)id);
        }
        catch (Exception er) {
            e = er;
        }
        return e;
    }

    private void checkHasReference(Context ctx, MeasureUnitGroupInfo oldVO, MeasureUnitGroupInfo updateVO) throws EASBizException {
        Throwable e = this.checkReference(ctx, oldVO.getId());
        if (e != null && !oldVO.getDefaultUnit().equals(updateVO.getDefaultUnit())) {
            throw new MeasureUnitException(MeasureUnitException.REF_NOT_UPDATE_DEFAULTUNIT, e);
        }
    }

    public boolean _checkHasChildren(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        IMeasureUnitGroup iMeasureUnitGroup = MeasureUnitGroupFactory.getLocalInstance(ctx);
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance(ctx);
        MeasureUnitGroupInfo info = iMeasureUnitGroup.getMeasureUnitGroupInfo(pk);
        String oldNumber = info.getNumber();
        MeasureUnitGroupInfo newInfo = (MeasureUnitGroupInfo)model;
        String newNumber = newInfo.getNumber();
        boolean b = false;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.id", (Object)pk.toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        IObjectPK[] pks = iMeasureUnit.getPKList(filter, null);
        if (!oldNumber.equals(newNumber) && pks.length > 0) {
            b = true;
        }
        return b;
    }
}

