/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnitGroup;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class MeasureUnitGroupImport
extends AbstractDataTransmission {
    public String Locale_en = "l1";
    public String Locale_zh = "l2";
    public String Locale_tw = "l3";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MeasureUnitGroupFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String str = null;
        MeasureUnitGroupInfo info = new MeasureUnitGroupInfo();
        str = (String)((DataToken)hsData.get((Object)"Fnumber")).data;
        if (str == null || "".equals(str)) {
            info.setNumber(null);
        } else {
            info.setNumber(str);
        }
        str = this.getDataString(hsData, "Fname_" + this.Locale_zh.toUpperCase());
        if (!StringUtils.isEmpty((String)str)) {
            info.setName(str, new Locale(this.Locale_zh));
        }
        if (!StringUtils.isEmpty((String)(str = this.getDataString(hsData, "Fname_" + this.Locale_tw.toUpperCase())))) {
            info.setName(str, new Locale(this.Locale_tw));
        }
        if (!StringUtils.isEmpty((String)(str = this.getDataString(hsData, "Fname_" + this.Locale_en.toUpperCase())))) {
            info.setName(str, new Locale(this.Locale_en));
        }
        FilterInfo filter = new FilterInfo();
        this.AddFilterItemInfo(filter, "number", this.getDataString(hsData, "Fnumber"));
        filter.setMaskString("#0");
        if (this.isSltImportUpdate()) {
            try {
                IMeasureUnitGroup iGroup = MeasureUnitGroupFactory.getLocalInstance(ctx);
                MeasureUnitGroupCollection groupCollection = iGroup.getMeasureUnitGroupCollection(this.getViewInfo(filter));
                if (groupCollection != null && groupCollection.size() > 0) {
                    info.setId(groupCollection.get(0).getId());
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException("", (Throwable)e);
            }
        }
        try {
            str = this.getDataString(hsData, "FDisableDate");
            if (str == null || "".equals(str)) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                str = "2199-12-31";
                info.setDisableDate(df.parse(str));
            } else {
                info.setDisableDate(ExcelUtil.formatNationalDate((Context)ctx, (String)str));
            }
        }
        catch (ParseException e) {
            throw new TaskExternalException("Date change error", (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            String multiName = "Fname_" + this.getLoc(ctx);
            this.putTable(result, "Fnumber", rs.getString("number"));
            this.putTable(result, multiName, rs.getString("name"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.MeasureUnitGroupQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    private void AddFilterItemInfo(FilterInfo filter, String fieldName, Object value) {
        filter.getFilterItems().add(new FilterItemInfo(fieldName, value));
    }

    private EntityViewInfo getViewInfo(FilterInfo filter) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return (String)((DataToken)hsData.get((Object)fieldName)).data;
    }

    private String getResString(String resClassName, String resName, Locale locale) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale);
    }

    private String getLoc(Context ctx) {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toUpperCase();
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        this.putToHashtable(htable, key, value);
    }

    private void putToHashtable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }
}

