/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IMeasureUnitGroup;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitException;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class MeasureUnitImport
extends AbstractDataTransmission {
    public String Locale_en = "l1";
    public String Locale_zh = "l2";
    public String Locale_tw = "l3";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MeasureUnitFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private int getDataint(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return 0;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return 0;
        }
        return new Integer(str);
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String str = null;
        MeasureUnitException ep = null;
        MeasureUnitInfo info = new MeasureUnitInfo();
        str = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (str == null || "".equals(str)) {
            info.setNumber(null);
        } else {
            info.setNumber(str);
        }
        str = this.getDataString(hsData, "Fname_" + this.Locale_zh.toUpperCase());
        if (!StringUtils.isEmpty((String)str)) {
            info.setName(str, new Locale(this.Locale_zh));
        }
        if (!StringUtils.isEmpty((String)(str = this.getDataString(hsData, "Fname_" + this.Locale_tw.toUpperCase())))) {
            info.setName(str, new Locale(this.Locale_tw));
        }
        if (!StringUtils.isEmpty((String)(str = this.getDataString(hsData, "Fname_" + this.Locale_en.toUpperCase())))) {
            info.setName(str, new Locale(this.Locale_en));
        }
        FilterInfo filter = new FilterInfo();
        this.AddFilterItemInfo(filter, "number", this.getDataString(hsData, "FNumber"));
        filter.setMaskString("#0");
        int qtyPre = this.getDataint(hsData, "FQtyPrecision");
        info.setQtyPrecision(qtyPre);
        if (this.isSltImportUpdate()) {
            try {
                IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance(ctx);
                MeasureUnitCollection collection = iMeasureUnit.getMeasureUnitCollection(this.getViewInfo(filter));
                if (collection != null && collection.size() > 0) {
                    info.setId(collection.get(0).getId());
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException("", (Throwable)e);
            }
        }
        if ((str = this.getDataString(hsData, "FGroupID")) == null || "".equals(str)) {
            ep = new MeasureUnitException(MeasureUnitException.GROUPNUMBER_NOT_NULL);
            throw new TaskExternalException(ep.getMessage(ctx.getLocale()));
        }
        filter = new FilterInfo();
        this.AddFilterItemInfo(filter, "number", str);
        filter.setMaskString("#0");
        try {
            IMeasureUnitGroup iGroup = MeasureUnitGroupFactory.getLocalInstance(ctx);
            MeasureUnitGroupCollection groupCollection = iGroup.getMeasureUnitGroupCollection(this.getViewInfo(filter));
            if (groupCollection == null || groupCollection.size() <= 0) {
                ep = new MeasureUnitException(MeasureUnitException.GROUPNUMBER_ERROR);
                throw new TaskExternalException(ep.getMessage(ctx.getLocale()));
            }
            info.setMeasureUnitGroup(groupCollection.get(0));
        }
        catch (BOSException e) {
            ep = new MeasureUnitException(MeasureUnitException.GROUPNUMBER_ERROR);
            throw new TaskExternalException(ep.getMessage(ctx.getLocale()), (Throwable)e);
        }
        BigDecimal dec = this.getDataBigDecimal(hsData, "FCoefficient");
        if (dec == null) {
            ep = new MeasureUnitException(MeasureUnitException.COEFF_NOT_NULL);
            throw new TaskExternalException(ep.getMessage(ctx.getLocale()));
        }
        info.setCoefficient(dec);
        info.setIsBaseUnit(this.getDataboolean(hsData, "FIsBaseUnit"));
        info.setIsDisabled(this.getDataboolean(hsData, "FIsDisabled"));
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            String multiName = "Fname_" + this.getLoc(ctx);
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, multiName, rs.getString("name"));
            this.putTable(result, "FQtyPrecision", rs.getString("qtyPrecision"));
            this.putTable(result, "FGroupID", rs.getString("measureUnitGroup.number"));
            this.putTable(result, "FCoefficient", rs.getBigDecimal("coefficent").toString());
            this.putTable(result, "FIsBaseUnit", this.boolToString(rs.getBoolean("isBaseUnit")));
            this.putTable(result, "FIsDisabled", this.boolToString(rs.getBoolean("isDisabled")));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.MeasureUnitQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    private void AddFilterItemInfo(FilterInfo filter, String fieldName, Object value) {
        filter.getFilterItems().add(new FilterItemInfo(fieldName, value));
    }

    private EntityViewInfo getViewInfo(FilterInfo filter) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return (String)((DataToken)hsData.get((Object)fieldName)).data;
    }

    private String getResString(String resClassName, String resName, Locale locale) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale);
    }

    private String getLoc(Context ctx) {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toUpperCase();
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        this.putToHashtable(htable, key, value);
    }

    private void putToHashtable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    private BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return null;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return null;
        }
        return new BigDecimal(str);
    }

    private boolean getDataboolean(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return false;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return false;
        }
        return str.equals("Y") || str.equals("1");
    }

    private String boolToString(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }
}

