/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IMeasureUnitGroupRelation;
import com.kingdee.eas.basedata.assistant.IMeasureUnitRelation;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupRelationCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupRelationFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupRelationInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitRelationCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitRelationFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitRelationInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractO_MeasureUnitControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Vector;

public class O_MeasureUnitControllerBean
extends AbstractO_MeasureUnitControllerBean {
    String resClassName = "com.kingdee.eas.basedata.assistant.client.AssistantResource";

    @Override
    protected BigDecimal _getConvertValue(Context ctx, String sourceUnitId, String targetUnitId, String materialId, BigDecimal sourceValue) throws BOSException {
        BigDecimal value = null;
        if (this.isSameGroup(ctx, sourceUnitId, targetUnitId)) {
            // empty if block
        }
        return value;
    }

    private BigDecimal getMaterialMeasureUnitCoefficient(String materialId, String sourceUnitId, String targetUnitId) {
        return null;
    }

    private BigDecimal getMaterialMeasureUnitGroupCoefficient(String materialId, String sourceUnitId, String targetUnitId) {
        return null;
    }

    @Override
    protected BigDecimal _getConvertValue(Context ctx, String sourceUnitId, String targetUnitId, BigDecimal sourceValue) throws BOSException, EASBizException {
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance(ctx);
        MeasureUnitInfo sourceInfo = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sourceUnitId)));
        MeasureUnitInfo targetInfo = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)targetUnitId)));
        if (sourceInfo.getMeasureUnitGroup().getId().toString().equals(targetInfo.getMeasureUnitGroup().getId().toString())) {
            throw new BOSException(EASResource.getString((String)this.resClassName, (String)"Msg_Not_MeasureUnitExchange"));
        }
        MeasureUnitInfo baseInfo = this.getBaseMeasureUnitInfo(ctx, sourceInfo.getMeasureUnitGroup().getId().toString());
        if (baseInfo == null) {
            throw new BOSException(EASResource.getString((String)this.resClassName, (String)"Msg_NotFound_MeasureUnitExchange"));
        }
        BigDecimal value = sourceInfo.getCoefficient().multiply(baseInfo.getCoefficient());
        value = value.divide(targetInfo.getCoefficient(), 2);
        return value.multiply(sourceValue);
    }

    @Override
    protected IObjectCollection _getEnabledMeasureUnitCollection(Context ctx, String groupId) throws BOSException {
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)new Integer(0), CompareType.EQUALS));
        i.getFilterItems().add(new FilterItemInfo("measureUnitGroup.id", (Object)groupId, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance(ctx);
        MeasureUnitCollection c = iMeasureUnit.getMeasureUnitCollection(evi);
        return c;
    }

    @Override
    protected IRowSet _getMaterialMeasureUnitRelations(Context ctx, String groupId, String materialId) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT b.FID as FRelationID, a.FIsBaseUnit, a.FID, a.FNumber, a.FName");
        sqlBuffer.append(this.getProfix(ctx));
        sqlBuffer.append(" as FName, a.FCoefficient, ");
        sqlBuffer.append("b.FMaterialID, b.FCoefficient AS FSpecialCoefficient ");
        sqlBuffer.append("FROM T_BD_MeasureUnit a LEFT OUTER JOIN ");
        sqlBuffer.append("(SELECT * ");
        sqlBuffer.append("FROM T_BD_MeasureUnitRelation ");
        sqlBuffer.append("WHERE FMaterialId = ? ) b ON a.FID = b.FTargetUnitID ");
        sqlBuffer.append("WHERE (a.FGroupID = ?) and (a.FIsDisabled = 0) ");
        String sql = sqlBuffer.toString();
        Object[] params = new String[]{materialId, groupId};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected IRowSet _getMaterialMeasureUnitGroupRelations(Context ctx, String materialId) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT b.FID as FRelationID, a.*, b.FCoefficient AS FCoefficient ");
        sqlBuffer.append("FROM (SELECT a.FName");
        sqlBuffer.append(this.getProfix(ctx));
        sqlBuffer.append(" AS FGroupName, b.FID as FUnitID, b.FName");
        sqlBuffer.append(this.getProfix(ctx));
        sqlBuffer.append(" AS FName, b.FNumber, a.FID ");
        sqlBuffer.append("FROM T_BD_MeasureUnitGroup a INNER JOIN ");
        sqlBuffer.append("T_BD_MeasureUnit b ON a.FID = b.FGroupID ");
        sqlBuffer.append("WHERE (b.FIsBaseUnit = 1)) a LEFT OUTER JOIN ");
        sqlBuffer.append("(SELECT * FROM T_BD_MeasureUnitGroupRelation WHERE FMaterialID = ?) b ON a.FUnitID = b.FTargetUnitID ");
        return DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{materialId});
    }

    protected void _removeUnitRelation(Context ctx, IObjectPK[] pkList) throws BOSException, EASBizException {
        System.out.println("[method]: _removeUnitRelation");
        IMeasureUnitRelation iUnitRel = MeasureUnitRelationFactory.getLocalInstance(ctx);
        for (int i = 0; i < pkList.length; ++i) {
            System.out.println(pkList[i].toString());
            iUnitRel.delete(pkList[i]);
        }
    }

    protected void _removeGroupRelation(Context ctx, IObjectPK[] pkList) throws BOSException, EASBizException {
        System.out.println("[method]: _removeGroupRelation");
        IMeasureUnitGroupRelation iGroupRel = MeasureUnitGroupRelationFactory.getLocalInstance(ctx);
        for (int i = 0; i < pkList.length; ++i) {
            System.out.println(pkList[i].toString());
            iGroupRel.delete(pkList[i]);
        }
    }

    protected IObjectPK[] _addUnitRelations(Context ctx, MeasureUnitRelationCollection muRelCollection) throws BOSException, EASBizException {
        System.out.println("Begin Add Collection");
        IMeasureUnitRelation iUnitRel = MeasureUnitRelationFactory.getLocalInstance(ctx);
        IObjectPK[] pkList = new IObjectPK[muRelCollection.size()];
        for (int i = 0; i < muRelCollection.size(); ++i) {
            pkList[i] = iUnitRel.addnew((CoreBaseInfo)muRelCollection.get(i));
            System.out.println(pkList[i].toString());
        }
        return pkList;
    }

    protected IObjectPK[] _addGroupRelations(Context ctx, MeasureUnitGroupRelationCollection mugRelCollection) throws BOSException, EASBizException {
        System.out.println("Begin Add Collection");
        IMeasureUnitGroupRelation iGroupRel = MeasureUnitGroupRelationFactory.getLocalInstance(ctx);
        IObjectPK[] pkList = new IObjectPK[mugRelCollection.size()];
        for (int i = 0; i < mugRelCollection.size(); ++i) {
            pkList[i] = iGroupRel.addnew((CoreBaseInfo)mugRelCollection.get(i));
            System.out.println(pkList[i].toString());
        }
        return pkList;
    }

    @Override
    protected IObjectPK[] _updateUnitRelation(Context ctx, IObjectCollection relationCollection1, IObjectPK[] removeList) throws BOSException, EASBizException {
        MeasureUnitRelationCollection relationCollection = (MeasureUnitRelationCollection)relationCollection1;
        IMeasureUnitRelation iUnitRel = MeasureUnitRelationFactory.getLocalInstance(ctx);
        MeasureUnitRelationInfo info = null;
        Vector<Integer> vRemoveIndex = new Vector<Integer>();
        System.out.println("Collection size : " + relationCollection.size());
        System.out.println("removePKList length : " + removeList.length);
        for (int i = 0; i < relationCollection.size(); ++i) {
            info = relationCollection.get(i);
            if (info.getId() == null) continue;
            iUnitRel.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
            vRemoveIndex.add(new Integer(i));
        }
        for (int j = vRemoveIndex.size() - 1; j >= 0; --j) {
            relationCollection.remove(relationCollection.get(j));
        }
        this._removeUnitRelation(ctx, removeList);
        System.out.println("Collection new size : " + relationCollection.size());
        return this._addUnitRelations(ctx, relationCollection);
    }

    @Override
    protected IObjectPK[] _updateGroupRelation(Context ctx, IObjectCollection relationCollection1, IObjectPK[] removeList) throws BOSException, EASBizException {
        MeasureUnitGroupRelationCollection relationCollection = (MeasureUnitGroupRelationCollection)relationCollection1;
        IMeasureUnitGroupRelation iGroupRel = MeasureUnitGroupRelationFactory.getLocalInstance(ctx);
        MeasureUnitGroupRelationInfo info = null;
        Vector<Integer> vRemoveIndex = new Vector<Integer>();
        System.out.println("Collection size : " + relationCollection.size());
        System.out.println("removePKList length : " + removeList.length);
        for (int i = 0; i < relationCollection.size(); ++i) {
            info = relationCollection.get(i);
            if (info.getId() == null) continue;
            iGroupRel.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
            vRemoveIndex.add(new Integer(i));
        }
        for (int j = vRemoveIndex.size() - 1; j >= 0; --j) {
            relationCollection.remove(relationCollection.get(j));
        }
        this._removeGroupRelation(ctx, removeList);
        System.out.println("Collection new size : " + relationCollection.size());
        return this._addGroupRelations(ctx, relationCollection);
    }

    private MeasureUnitInfo getBaseMeasureUnitInfo(Context ctx, String GroupId) throws BOSException {
        MeasureUnitInfo info = null;
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("measureUnitGroup.id", (Object)GroupId, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance(ctx);
        MeasureUnitCollection c = iMeasureUnit.getMeasureUnitCollection(evi);
        if (c.size() > 0) {
            info = c.get(0);
        }
        return info;
    }

    private boolean isSameGroup(Context ctx, String sourceId, String targetId) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT FGroupID ");
        sqlBuffer.append("FROM T_BD_MeasureUnit ");
        sqlBuffer.append("WHERE (FID = ?) OR ");
        sqlBuffer.append("(FID = ?) ");
        String[] params = new String[]{sourceId, targetId};
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        String sourceGroup = null;
        String targetGroup = null;
        try {
            rows.next();
            sourceGroup = rows.getString(0);
            rows.next();
            targetGroup = rows.getString(1);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return sourceGroup == targetGroup && sourceGroup != null && targetGroup != null;
    }

    private String getProfix(Context ctx) {
        return "_L1";
    }
}

