/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.assistant.PayConditionCollection;
import com.kingdee.eas.basedata.assistant.PayConditionException;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractPayConditionControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PayConditionControllerBean
extends AbstractPayConditionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.PayConditionControllerBean");

    protected void addnewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        this.bizCheck(ctx, (PayConditionInfo)model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addnewCheck(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected void updateCheck(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        PayConditionInfo oldModel = this.getPayConditionInfo(ctx, pk);
        if (!((DataBaseInfo)model).getNumber().equals(oldModel.getNumber())) {
            this._checkNumberDup(ctx, model);
        }
        if (!((DataBaseInfo)model).getName().equals(oldModel.getName())) {
            this._checkNameDup(ctx, model);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCheck(ctx, pk, model);
        this.bizCheck(ctx, (PayConditionInfo)model);
        super._update(ctx, pk, model);
    }

    protected void bizCheck(Context ctx, PayConditionInfo info) throws PayConditionException {
        int verifyResult = info.bizVerify();
        if (verifyResult == 0) {
            return;
        }
        if (verifyResult == 1) {
            throw new PayConditionException(PayConditionException.MULPREPAYENTRY);
        }
        if (verifyResult == 2) {
            throw new PayConditionException(PayConditionException.PREPAYRATENOTEQUALSENTRYRATE);
        }
        if (verifyResult == 3) {
            throw new PayConditionException(PayConditionException.FICEDDATENOTNULL);
        }
        if (verifyResult == 5) {
            throw new PayConditionException(PayConditionException.NOPREPAYENTRY);
        }
        if (verifyResult == 4) {
            throw new PayConditionException(PayConditionException.SUMRATEMUST100);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        this.setNullFields(ctx, pk.toString());
        return pk;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayConditionInfo dataBaseInfo = (PayConditionInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayConditionInfo dataBaseInfo = (PayConditionInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    @Override
    protected PayConditionCollection _getSuperiorCollection(Context ctx, String curCompanyLongNumber) throws BOSException {
        if (curCompanyLongNumber == null || curCompanyLongNumber.length() < 1) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID FROM T_ORG_Company  ").append(" WHERE FLongNumber<>'").append(curCompanyLongNumber).append("' ").append(" AND LEN(FLongNumber)<LEN('").append(curCompanyLongNumber).append("') AND LEFT('").append(curCompanyLongNumber).append("' , LEN(FLongNumber))=FLongNumber ");
        filter.getFilterItems().add(new FilterItemInfo("createOrg.id", (Object)sql.toString(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)DeletedStatusEnum.NORMAL, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        viewInfo.setFilter(filter);
        SelectorItemCollection selectors = viewInfo.getSelector();
        selectors.add("*");
        selectors.add("createOrg.id");
        selectors.add("createOrg.name");
        selectors.add("createOrg.longnumber");
        return this.getPayConditionCollection(ctx, viewInfo);
    }

    private void setNullFields(Context ctx, String FParentID) throws BOSException {
        SQLUtil sb = new SQLUtil();
        sb.appendSql(" update T_BD_PayConditionEntry  ");
        sb.appendSql(" set FcreditDays = case when FsettlementType = 'DATE' then null else FcreditDays end, ");
        sb.appendSql(" Fmonths = case when FsettlementType = 'MONTH' then Fmonths else null end, ");
        sb.appendSql(" Fday = case when FsettlementType = 'MONTH' then Fday else null end ");
        sb.appendSql(" where FParentID='").appendSql(FParentID).appendSql("'");
        sb.execute(ctx);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer arApQuery = new StringBuffer();
        arApQuery.append("select fid from T_ar_OtherBill where FpayConditionID = '").append(pk.toString()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)arApQuery.toString());
        try {
            if (rowSet != null && rowSet.next()) {
                throw new PayConditionException(PayConditionException.CANNOTDELETRECEIVINGCONDITION);
            }
            arApQuery.setLength(0);
            arApQuery.append("select fid from T_ap_OtherBill where FpayConditionID = '").append(pk.toString()).append("'");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)arApQuery.toString());
            if (rowSet != null && rowSet.next()) {
                throw new PayConditionException(PayConditionException.CANNOTDELETPAYCONDITION);
            }
        }
        catch (SQLException e) {
            logger.info((Object)("sql is:" + arApQuery.toString()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        super._delete(ctx, pk);
    }
}

