/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ICheck;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.ProjectCollection;
import com.kingdee.eas.basedata.assistant.ProjectException;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.assistant.ProjectStatus;
import com.kingdee.eas.basedata.assistant.ProjectTypeEnum;
import com.kingdee.eas.basedata.assistant.app.AbstractProjectControllerBean;
import com.kingdee.eas.basedata.assistant.app.ICheckMove;
import com.kingdee.eas.basedata.assistant.app.ProjectRef;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ProjectControllerBean
extends AbstractProjectControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.ProjectControllerBean");
    String resClassName = "com.kingdee.eas.basedata.assistant.ProjectException";

    private void checkNumberValidate(String number) throws ProjectException {
        if (number != null && number.indexOf("'") >= 0) {
            throw new ProjectException(ProjectException.NUMBERNOTVALIDATE);
        }
    }

    private void checkLongNumberLength(Context ctx, ProjectInfo projectInfo) throws ProjectException {
        ProjectInfo parent = projectInfo.getParent();
        String longnumber = "";
        longnumber = parent == null || parent.getId().equals((Object)projectInfo.getId()) ? projectInfo.getNumber() : parent.getLongNumber() + "!" + projectInfo.getNumber();
        if (!StringUtil.isEmpty((String)longnumber) && longnumber.length() > 256) {
            throw new ProjectException(ProjectException.LONGNUMBERTOOLONG);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectInfo projectInfo = (ProjectInfo)model;
        this.checkNumberValidate(projectInfo.getNumber());
        this.checkLongNumberLength(ctx, projectInfo);
        this.checkDate(ctx, (IObjectValue)projectInfo);
        super._checkNameBlank(ctx, (IObjectValue)projectInfo);
        this.checkNumberDupl(ctx, (IObjectValue)projectInfo);
        if (StringUtils.isEmpty((String)projectInfo.getDisplayName())) {
            projectInfo.setDisplayName(projectInfo.getName());
        }
        if (model instanceof DataBaseInfo) {
            String orgID = (String)ctx.get((Object)"CurCompanyId");
            this.setAutoNumberByOrg(ctx, (DataBaseInfo)model, orgID);
        }
        IObjectPK pk = this.addNewBussiess(ctx, projectInfo);
        this.statusChange(ctx, (IObjectValue)projectInfo);
        return pk;
    }

    protected void setNumberFromCodingRule(Context ctx, DataBaseInfo model, String orgID) throws BOSException, EASBizException {
    }

    protected void setAutoNumberByOrg(Context ctx, DataBaseInfo model, String orgID) throws BOSException, EASBizException {
        String sysNumber = null;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (model.getCU() == null) {
                model.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            }
            sysNumber = iCodingRuleManager.isExist((IObjectValue)model, orgID) && !iCodingRuleManager.isModifiable((IObjectValue)model, orgID) ? this.getNumber(ctx, orgID, (ObjectBaseInfo)model, iCodingRuleManager) : (iCodingRuleManager.isExist((IObjectValue)model, orgID) && iCodingRuleManager.isAddView((IObjectValue)model, orgID) && iCodingRuleManager.isModifiable((IObjectValue)model, orgID) ? (model.getNumber() != null && model.getNumber().equals(iCodingRuleManager.readNumber((IObjectValue)model, orgID)) ? this.getNumber(ctx, orgID, (ObjectBaseInfo)model, iCodingRuleManager) : model.getNumber()) : model.getNumber());
            if (!StringUtils.isEmpty((String)sysNumber)) {
                model.setString("number", sysNumber);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean IsProRefrenced(Context ctx, IObjectPK pk) {
        try {
            this.isReferenced(ctx, pk);
        }
        catch (ObjectReferedException ex) {
            return true;
        }
        catch (Exception e1) {
            return false;
        }
        return false;
    }

    private void checkIsListItem(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectInfo oldInfo = (ProjectInfo)this.getValue(ctx, pk);
        ProjectInfo newInfo = (ProjectInfo)model;
        if (oldInfo != null && oldInfo.isIsListItem() != newInfo.isIsListItem()) {
            if (this.IsProRefrenced(ctx, pk)) {
                throw new ProjectException(ProjectException.CANUPDATEISLISTITEM_REF);
            }
            if (!oldInfo.isIsLeaf()) {
                throw new ProjectException(ProjectException.CANUPDATEISLISTITEM_LEAF);
            }
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK projectPK = pk;
        ProjectInfo projectInfo = (ProjectInfo)model;
        this.checkNumberValidate(projectInfo.getNumber());
        this.checkLongNumberLength(ctx, projectInfo);
        super._checkNameBlank(ctx, (IObjectValue)projectInfo);
        super._checkNumberBlank(ctx, (IObjectValue)projectInfo);
        this.checkNumberDupl(ctx, (IObjectValue)projectInfo);
        this.checkDate(ctx, (IObjectValue)projectInfo);
        if (this.getProjectIsolateParam(ctx).equals("1") || this.getProjectIsolateParam(ctx).equals("2")) {
            this.CompanyInherit(ctx, (IObjectValue)projectInfo);
        }
        try {
            super._update(ctx, projectPK, (IObjectValue)projectInfo);
        }
        catch (SQLAccessException e) {
            throw new ProjectException(ProjectException.LONG_NUMBER_TOO_LONG, e);
        }
        this.statusChange(ctx, (IObjectValue)projectInfo);
        this.typeInherit(ctx, (IObjectValue)projectInfo);
        try {
            ProjectRef.getInstance().updateSrcObject(ctx, projectInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AssistUtil.updateAssist((Context)ctx, (String)projectInfo.getId().toString(), (BOSObjectType)projectInfo.getBOSType());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProjectIsolateParam(Context ctx) {
        String value = null;
        IParamControl iParam = null;
        try {
            iParam = ParamControlFactory.getLocalInstance((Context)ctx);
            value = iParam.getParamValue(null, "ProjectIsolate");
            if (value == null) {
                value = "0";
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return value;
    }

    private IObjectPK addNewBussiess(Context ctx, ProjectInfo projectInfo) throws BOSException, EASBizException {
        if (projectInfo.getParent() != null) {
            boolean isListItem = projectInfo.getParent().isIsListItem();
            if (!isListItem) {
                String itemSql = "select fislistitem from T_bd_project where fid ='" + projectInfo.getParent().getId() + "'";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)itemSql);
                try {
                    executeQuery.next();
                    int result = executeQuery.getInt(1);
                    if (result == 1) {
                        isListItem = true;
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    e.printStackTrace();
                }
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)projectInfo.getParent().getId().toString()));
            IObjectPK oldPk = super._addnew(ctx, (IObjectValue)projectInfo);
            if (this.IsRefrenced(ctx, (IObjectPK)pk) && isListItem) {
                String pSql = "update T_bd_project set fparentid = '" + oldPk.toString() + "' where fnumber='" + projectInfo.getNumber() + "'";
                String tASql = "update T_bd_project set fid = 'temp" + oldPk.toString() + "' where fnumber='" + projectInfo.getNumber() + "'";
                String IASql = "update T_bd_project set fid = '" + oldPk.toString() + "' where fnumber='" + projectInfo.getParent().getNumber() + "'";
                String LSql = "update T_bd_project set fislistitem = 0 where fnumber='" + projectInfo.getParent().getNumber() + "'";
                String IBSql = "update T_bd_project set fid = '" + pk.toString() + "' where fnumber='" + projectInfo.getNumber() + "'";
                DbUtil.execute((Context)ctx, (String)pSql);
                DbUtil.execute((Context)ctx, (String)tASql);
                DbUtil.execute((Context)ctx, (String)IASql);
                DbUtil.execute((Context)ctx, (String)LSql);
                DbUtil.execute((Context)ctx, (String)IBSql);
                ProjectRef.getInstance().updateSrcObject(ctx, projectInfo);
                AssistUtil.updateAssist((Context)ctx, (String)pk.toString(), (BOSObjectType)projectInfo.getBOSType());
                AssistUtil.updateAssist((Context)ctx, (String)oldPk.toString(), (BOSObjectType)projectInfo.getBOSType());
                return pk;
            }
            return oldPk;
        }
        return super._addnew(ctx, (IObjectValue)projectInfo);
    }

    private boolean IsRefrenced(Context ctx, IObjectPK pk) {
        try {
            this._isReferenced(ctx, pk);
        }
        catch (ObjectReferedException ex) {
            return true;
        }
        catch (Exception e1) {
            return false;
        }
        return false;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._delete(ctx, pk, false);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk, boolean isFromMM) throws BOSException, EASBizException {
        BOSUuid uuid = BOSUuid.read((String)pk.toString());
        this.check(ctx, uuid);
        super._isReferenced(ctx, pk);
        ProjectInfo info = this.getProjectInfo(ctx, pk);
        if (info.isIsLeaf()) {
            if (!isFromMM && ProjectTypeEnum.PROJECT_MM.equals((Object)info.getType())) {
                throw new ProjectException(ProjectException.DELETE_MM_PROJECT_ERROR);
            }
            ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
            if (iCostObject.checkMaterialUsed(pk.toString(), info.getNumber(), 1) || this.IsRefrenced(ctx, pk)) {
                throw new ProjectException(ProjectException.DELETEFAIL);
            }
        } else {
            throw new ProjectException(ProjectException.CANNOTDELETE);
        }
        super._delete(ctx, pk);
    }

    protected void checkNumberDupl(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectInfo projectInfo = (ProjectInfo)model;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)projectInfo.getNumber(), CompareType.EQUALS));
        if (projectInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)projectInfo.getId(), CompareType.NOTEQUALS));
            filterInfo.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filterInfo)) {
            throw new ProjectException(ProjectException.NUMBERNULL, new Object[]{projectInfo.getNumber()});
        }
    }

    public void checkDate(Context ctx, IObjectValue model) throws BOSException, ProjectException {
        ProjectInfo projectInfo = (ProjectInfo)model;
        Date scheduleStartDate = null;
        Date schedulEndDate = null;
        Date factStartDate = null;
        Date factEndDate = null;
        float process = 0.0f;
        try {
            DateFormat df = BOSLocaleUtil.getDateFormat();
            if (projectInfo.getScheduleStartDate() != null && !projectInfo.getScheduleStartDate().toString().equals("")) {
                scheduleStartDate = df.parse(projectInfo.getScheduleStartDate().toString());
            }
            if (projectInfo.getSchedulEndDate() != null && !projectInfo.getSchedulEndDate().toString().equals("")) {
                schedulEndDate = df.parse(projectInfo.getSchedulEndDate().toString());
            }
            if (projectInfo.getFactStartDate() != null && !projectInfo.getFactStartDate().toString().equals("")) {
                factStartDate = df.parse(projectInfo.getFactStartDate().toString());
            }
            if (projectInfo.getFactEndDate() != null && !projectInfo.getFactEndDate().toString().equals("")) {
                factEndDate = df.parse(projectInfo.getFactEndDate().toString());
            }
        }
        catch (ParseException ex) {
            ex.getStackTrace();
        }
        if (projectInfo.getProcess() != null && !projectInfo.getProcess().toString().equals("")) {
            process = projectInfo.getProcess().floatValue();
        }
        if (scheduleStartDate != null && schedulEndDate != null && schedulEndDate.before(scheduleStartDate)) {
            throw new ProjectException(ProjectException.ENDDATELESSTHANSTARTDATE);
        }
        if (factStartDate != null && factEndDate != null && factEndDate.before(factStartDate)) {
            throw new ProjectException(ProjectException.ENDDATELESSTHANSTARTDATE);
        }
        if (process < 0.0f || process > 100.0f) {
            throw new ProjectException(ProjectException.PROCESSOUTOFBOUNDS);
        }
    }

    public void CompanyChange(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectInfo projectInfo = (ProjectInfo)model;
        Object info = null;
    }

    public void CompanyInherit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectInfo projectInfo = (ProjectInfo)model;
        TreeBaseCollection ct = this.getAllChildren(ctx, projectInfo);
        int size = 0;
        if (ct != null) {
            size = ct.size();
        }
        if (ct != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                ProjectInfo childInfo = (ProjectInfo)ct.get(i);
                childInfo.setCompany(projectInfo.getCompany());
                ObjectUuidPK projectPK = new ObjectUuidPK(BOSUuid.read((String)childInfo.getId().toString()));
                super._update(ctx, (IObjectPK)projectPK, (IObjectValue)childInfo);
            }
        }
    }

    public void statusChange(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectInfo projectInfo = (ProjectInfo)model;
        ProjectInfo parnetInfo = null;
        if (projectInfo.getLevel() <= 1) {
            return;
        }
        if (projectInfo.getParent() == null) {
            return;
        }
        String id = projectInfo.getParent().getId().toString();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        parnetInfo = this.getProjectInfo(ctx, (IObjectPK)pk);
        boolean hasExecuteStatus = false;
        String sql = "select fid from t_bd_project where flongnumber like '" + parnetInfo.getLongNumber() + "!%' and fstatus = 1";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (row != null && row.next()) {
                hasExecuteStatus = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (hasExecuteStatus) {
            this.setAllParentStatus(ctx, parnetInfo, 1);
            return;
        }
        boolean isAllStatusSame = true;
        sql = "select fstatus from t_bd_project where flongnumber like '" + parnetInfo.getLongNumber() + "!%' group by fstatus";
        row = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (row != null && row.size() > 1) {
            isAllStatusSame = false;
        }
        if (isAllStatusSame) {
            this.synchronizeParentStatus(ctx, parnetInfo, projectInfo.getStatus().getValue());
        } else {
            this.setAllParentStatus(ctx, parnetInfo, 1);
        }
    }

    private void synchronizeParentStatus(Context ctx, ProjectInfo projectInfo, int status) throws BOSException {
        String longNumber = projectInfo.getLongNumber();
        String updateWithoutCom = "update t_bd_project set FStatus = " + status + " where flongnumber = ?";
        StringBuffer updateSQL = new StringBuffer(updateWithoutCom);
        if (projectInfo.getCompany() != null && projectInfo.getCompany().getId() != null) {
            if (projectInfo.getCompany() != null && projectInfo.getCompany().getId() != null) {
                updateSQL.append("  and fcompanyid = ? ");
                DbUtil.execute((Context)ctx, (String)updateSQL.toString(), (Object[])new Object[]{projectInfo.getCompany().getId().toString(), longNumber});
            }
        } else {
            DbUtil.execute((Context)ctx, (String)updateWithoutCom, (Object[])new Object[]{longNumber});
        }
        while (longNumber.indexOf("!") >= 0) {
            longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            String checkSQL = "select fstatus from t_bd_project where flongnumber like '" + longNumber + "!%' group by fstatus";
            IRowSet checkResult = DbUtil.executeQuery((Context)ctx, (String)checkSQL);
            try {
                if (checkResult == null || !checkResult.next() || checkResult.next()) break;
                if (projectInfo.getCompany() != null && projectInfo.getCompany().getId() != null) {
                    if (projectInfo.getCompany() == null || projectInfo.getCompany().getId() == null) continue;
                    DbUtil.execute((Context)ctx, (String)updateSQL.toString(), (Object[])new Object[]{projectInfo.getCompany().getId().toString(), longNumber});
                    continue;
                }
                DbUtil.execute((Context)ctx, (String)updateWithoutCom, (Object[])new Object[]{longNumber});
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void setAllParentStatus(Context ctx, ProjectInfo projectInfo, int status) throws BOSException {
        String longNumber = projectInfo.getLongNumber();
        StringBuffer longNumberSet = new StringBuffer();
        longNumberSet.append("'").append(longNumber).append("'");
        while (longNumber.indexOf("!") >= 0) {
            longNumberSet.append(",");
            longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            longNumberSet.append("'").append(longNumber).append("'");
        }
        StringBuffer updateParentProjectStatusSQL = new StringBuffer();
        updateParentProjectStatusSQL.append("update t_bd_project set FStatus = ");
        updateParentProjectStatusSQL.append(status + " where ");
        if (projectInfo.getCompany() != null && projectInfo.getCompany().getId() != null) {
            updateParentProjectStatusSQL.append("  fcompanyid = '");
            updateParentProjectStatusSQL.append(projectInfo.getCompany().getId().toString() + "' and ");
        }
        updateParentProjectStatusSQL.append(" flongnumber in(");
        updateParentProjectStatusSQL.append(longNumberSet);
        updateParentProjectStatusSQL.append(")");
        DbUtil.execute((Context)ctx, (String)updateParentProjectStatusSQL.toString());
    }

    public void statusChangeBak(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectInfo projectInfo = (ProjectInfo)model;
        ProjectInfo info = null;
        if (projectInfo.getLevel() > 1) {
            String id = projectInfo.getParent().getId().toString();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            info = this.getProjectInfo(ctx, (IObjectPK)pk);
            TreeBaseCollection ct = this.getAllChildren(ctx, info);
            int size = 0;
            if (ct != null) {
                size = ct.size();
            }
            if (projectInfo.isIsLeaf()) {
                ObjectUuidPK projectPK;
                ProjectInfo childInfo;
                int i;
                if (projectInfo.getStatus() == ProjectStatus.PREPARE) {
                    while (info.getLevel() >= 1) {
                        int count = 0;
                        for (i = 0; i < size; ++i) {
                            childInfo = (ProjectInfo)ct.get(i);
                            if (childInfo.getId().equals((Object)projectInfo.getId())) {
                                if (projectInfo.getStatus() == ProjectStatus.PREPARE) {
                                    ++count;
                                }
                            } else if (childInfo.getStatus() == ProjectStatus.PREPARE) {
                                ++count;
                            }
                            if (count != size) continue;
                            info.setStatus(ProjectStatus.PREPARE);
                            projectPK = new ObjectUuidPK(BOSUuid.read((String)info.getId().toString()));
                            super._update(ctx, (IObjectPK)projectPK, (IObjectValue)info);
                        }
                        if (info.getLevel() <= 1) break;
                        ObjectUuidPK projectfatherPK = new ObjectUuidPK(BOSUuid.read((String)info.getParent().getId().toString()));
                        info = this.getProjectInfo(ctx, (IObjectPK)projectfatherPK);
                    }
                }
                if (projectInfo.getStatus() == ProjectStatus.EXECUTE) {
                    while (info.getLevel() >= 1) {
                        info.setStatus(projectInfo.getStatus());
                        ObjectUuidPK projectPK2 = new ObjectUuidPK(BOSUuid.read((String)info.getId().toString()));
                        super._update(ctx, (IObjectPK)projectPK2, (IObjectValue)info);
                        if (info.getLevel() <= 1) break;
                        ObjectUuidPK projectfatherPK = new ObjectUuidPK(BOSUuid.read((String)info.getParent().getId().toString()));
                        info = this.getProjectInfo(ctx, (IObjectPK)projectfatherPK);
                    }
                }
                if (projectInfo.getStatus() == ProjectStatus.CLOSE) {
                    while (info.getLevel() >= 1) {
                        int count = 0;
                        for (i = 0; i < size; ++i) {
                            childInfo = (ProjectInfo)ct.get(i);
                            if (childInfo.getId().equals((Object)projectInfo.getId())) {
                                if (projectInfo.getStatus() == ProjectStatus.CLOSE) {
                                    ++count;
                                }
                            } else if (childInfo.getStatus() == ProjectStatus.CLOSE) {
                                ++count;
                            }
                            if (count != size) continue;
                            info.setStatus(ProjectStatus.CLOSE);
                            projectPK = new ObjectUuidPK(BOSUuid.read((String)info.getId().toString()));
                            super._update(ctx, (IObjectPK)projectPK, (IObjectValue)info);
                        }
                        if (info.getLevel() <= 1) break;
                        ObjectUuidPK projectfatherPK = new ObjectUuidPK(BOSUuid.read((String)info.getParent().getId().toString()));
                        info = this.getProjectInfo(ctx, (IObjectPK)projectfatherPK);
                    }
                }
            }
        }
    }

    public void typeInherit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectInfo projectInfo = (ProjectInfo)model;
        TreeBaseCollection ct = this.getAllChildren(ctx, projectInfo);
        int size = 0;
        if (ct != null) {
            size = ct.size();
        }
        if (ct != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                ProjectInfo childInfo = (ProjectInfo)ct.get(i);
                if (childInfo.getType() == null || projectInfo.getType() == null || childInfo.getType().equals((Object)projectInfo.getType())) continue;
                childInfo.setType(projectInfo.getType());
                ObjectUuidPK projectPK = new ObjectUuidPK(BOSUuid.read((String)childInfo.getId().toString()));
                super._update(ctx, (IObjectPK)projectPK, (IObjectValue)childInfo);
            }
        }
    }

    public void statusUpdateForRemove(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        ProjectInfo projectInfo = (ProjectInfo)model;
        if (projectInfo.getLevel() < 1) {
            return;
        }
        TreeBaseCollection ct = this.getAllChildren(ctx, projectInfo);
        int size = 0;
        if (ct != null) {
            size = ct.size();
        }
        if (size == 0) {
            return;
        }
        boolean hasExecuteStatus = false;
        Iterator iterator = ct.iterator();
        ProjectInfo temprojectInfo2 = null;
        while (iterator.hasNext()) {
            temprojectInfo2 = (ProjectInfo)iterator.next();
            if (!temprojectInfo2.getStatus().equals((Object)ProjectStatus.EXECUTE)) continue;
            hasExecuteStatus = true;
            break;
        }
        if (hasExecuteStatus) {
            projectInfo.setStatus(ProjectStatus.EXECUTE);
            projectInfo.setIsLeaf(false);
            ObjectUuidPK projectPK = new ObjectUuidPK(BOSUuid.read((String)projectInfo.getId().toString()));
            this._update(ctx, (IObjectPK)projectPK, (IObjectValue)projectInfo);
            return;
        }
        boolean isAllStatusSame = true;
        temprojectInfo2 = (ProjectInfo)ct.get(0);
        ProjectStatus currentStatus = temprojectInfo2.getStatus();
        for (ProjectInfo temprojectInfo2 : ct) {
            if (temprojectInfo2.getStatus().equals((Object)currentStatus)) continue;
            isAllStatusSame = false;
            break;
        }
        if (isAllStatusSame) {
            projectInfo.setStatus(currentStatus);
        } else {
            projectInfo.setStatus(ProjectStatus.EXECUTE);
        }
        projectInfo.setIsLeaf(false);
        ObjectUuidPK projectPK = new ObjectUuidPK(BOSUuid.read((String)projectInfo.getId().toString()));
        this._update(ctx, (IObjectPK)projectPK, (IObjectValue)projectInfo);
    }

    protected void _checkParentDataExist(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, TreeBaseException {
    }

    protected void _checkParentValid(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, TreeBaseException {
    }

    protected void _checkParentBeUsed(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, TreeBaseException {
    }

    protected IObjectValue _getRoot(Context ctx, IObjectValue model) throws BOSException, TreeBaseException {
        return null;
    }

    protected void _isReferenced(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        super._isReferenced(ctx, pk);
        try {
            boolean flag = ProjectRef.getInstance().IsRefrenced(ctx, pk);
            if (flag) {
                throw new ObjectReferedException((Object)"");
            }
        }
        catch (Exception e) {
            throw new ObjectReferedException((Object)"");
        }
    }

    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        this.checkCanModeProject(ctx, (ProjectInfo)sourceNode, (ProjectInfo)targetNode);
        if (targetNode != null) {
            ((ProjectInfo)sourceNode).setLevel(((ProjectInfo)targetNode).getLevel() + 1);
        }
        TreeBaseInfo sourceTree = (TreeBaseInfo)sourceNode;
        TreeBaseInfo targetTree = (TreeBaseInfo)targetNode;
        ObjectUuidPK sourceTreePK = new ObjectUuidPK(((TreeBaseInfo)sourceNode).getId());
        ObjectUuidPK targetTreePK = null;
        sourceTree = (TreeBaseInfo)super._getValue(ctx, (IObjectPK)sourceTreePK);
        if (targetNode == null) {
            targetTree = null;
        } else {
            targetTreePK = new ObjectUuidPK(((TreeBaseInfo)targetNode).getId());
            targetTree = (TreeBaseInfo)super._getValue(ctx, (IObjectPK)targetTreePK);
        }
        this.canMove(sourceTree);
        this.canReceive(targetTree);
        int sourceTreeLevel = sourceTree.getLevel();
        sourceTree.innerSetParent(targetTree);
        this._update(ctx, (IObjectPK)sourceTreePK, (IObjectValue)sourceTree);
        if (targetTree != null) {
            targetTree.setIsLeaf(false);
            super._update(ctx, (IObjectPK)targetTreePK, (IObjectValue)targetTree);
        }
        if (sourceTreeLevel > 1) {
            ObjectUuidPK parentPK = new ObjectUuidPK(((TreeBaseInfo)sourceNode.get("parent")).getId());
            TreeBaseInfo parent = (TreeBaseInfo)super._getValue(ctx, (IObjectPK)parentPK);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parent.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceTree.getId().toString(), CompareType.NOTEQUALS));
            if (!this._exists(ctx, filter)) {
                parent.setIsLeaf(true);
                super._update(ctx, (IObjectPK)parentPK, (IObjectValue)parent);
            } else {
                this.statusUpdateForRemove(ctx, (IObjectValue)parent);
            }
        }
    }

    private void checkCanModeProject(Context ctx, ProjectInfo sourceProject, ProjectInfo targetProject) throws EASBizException, BOSException {
        if (sourceProject.equals(targetProject)) {
            throw new ProjectException(ProjectException.SOURCETARGETPROJECTSAME);
        }
        if ((this.getProjectIsolateParam(ctx).equals("1") || this.getProjectIsolateParam(ctx).equals("2")) && sourceProject != null && targetProject != null && !sourceProject.getCompany().equals((Object)targetProject.getCompany())) {
            throw new ProjectException(ProjectException.SOURCETARGETPROJECTCOMPANYNOTSAME);
        }
        if (targetProject != null && targetProject.isIsListItem()) {
            throw new ProjectException(ProjectException.TARGETPROJECTISLISTITEM);
        }
        if (sourceProject != null && targetProject != null && !sourceProject.getType().equals((Object)targetProject.getType())) {
            throw new ProjectException(ProjectException.SOURCETARGETPROJECTTYPENOTSAME);
        }
        BOSUuid uuid = sourceProject.getId();
        this.check(ctx, uuid);
        this.checkMove(ctx, uuid, targetProject == null ? null : targetProject.getId());
    }

    @Override
    protected void _isolateProject(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
        view.setFilter(filterInfo);
        ProjectCollection projectCollection = this.getProjectCollection(ctx, view);
        if (projectCollection == null || projectCollection.size() <= 0) {
            return;
        }
        Iterator iterator = projectCollection.iterator();
        ProjectInfo firstLevelProjectInfo = null;
        TreeBaseCollection subProjectCollection = null;
        Iterator subProjectIterator = null;
        while (iterator.hasNext()) {
            firstLevelProjectInfo = (ProjectInfo)iterator.next();
            subProjectCollection = this.getAllChildren(ctx, firstLevelProjectInfo);
            if (subProjectCollection == null || subProjectCollection.size() <= 0) continue;
            subProjectIterator = subProjectCollection.iterator();
            ProjectInfo childInfo = null;
            ObjectUuidPK projectPK = null;
            while (subProjectIterator.hasNext()) {
                childInfo = (ProjectInfo)subProjectIterator.next();
                if (firstLevelProjectInfo.getCompany() == null || childInfo.getCompany() != null && childInfo.getCompany().getId().equals((Object)firstLevelProjectInfo.getCompany().getId())) continue;
                childInfo.setCompany(firstLevelProjectInfo.getCompany());
                childInfo.setCU(firstLevelProjectInfo.getCU());
                projectPK = new ObjectUuidPK(BOSUuid.read((String)childInfo.getId().toString()));
                super._update(ctx, (IObjectPK)projectPK, (IObjectValue)childInfo);
            }
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    private void check(Context ctx, BOSUuid uuid) throws BOSException, EASBizException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)"DADE05EE", ICheck.class);
            if (checks != null && checks.length > 0) {
                ICheck checkImpl = null;
                for (int i = 0; i < checks.length; ++i) {
                    checkImpl = (ICheck)Class.forName(checks[i]).newInstance();
                    checkImpl.check(ctx, uuid);
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkMove(Context ctx, BOSUuid src, BOSUuid dst) throws BOSException, EASBizException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)"DADE05EE", ICheckMove.class);
            if (checks != null && checks.length > 0) {
                ICheckMove checkImpl = null;
                for (int i = 0; i < checks.length; ++i) {
                    checkImpl = (ICheckMove)Class.forName(checks[i]).newInstance();
                    checkImpl.check(ctx, src, dst);
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String getNumber(Context ctx, String orgID, ObjectBaseInfo info, ICodingRuleManager iCodingRuleManager) {
        String number = null;
        try {
            if (iCodingRuleManager.isExist((IObjectValue)info, orgID)) {
                number = this._readNewNumber(ctx, orgID, info);
                iCodingRuleManager.getNumber((IObjectValue)info, orgID);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return number;
    }

    protected String _readNewNumber(Context ctx, String orgID, ObjectBaseInfo info) throws BOSException, EASBizException {
        return this.readNewNumber(ctx, orgID, info, 1);
    }

    protected String readNewNumber(Context ctx, String orgID, ObjectBaseInfo info, int count) throws BOSException, EASBizException {
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strBindProp = this.getBindingProperty(ctx);
        number = strBindProp != null && strBindProp.trim().length() > 0 ? iCodingRuleManager.readNumber((IObjectValue)info, orgID, strBindProp) : iCodingRuleManager.readNumber((IObjectValue)info, orgID);
        if (number == null || number.length() == 0) {
            return number;
        }
        if (count > this.loopCount()) {
            return number;
        }
        String oql = "select number where number='" + number + "'";
        if (this._exists(ctx, oql)) {
            iCodingRuleManager.getNumber((IObjectValue)info, orgID, strBindProp);
            number = this.readNewNumber(ctx, orgID, info, count + 1);
        }
        return number;
    }

    protected String getBindingProperty(Context ctx) {
        return null;
    }

    protected String getBindingProperty() {
        return null;
    }

    protected int loopCount() {
        return 10;
    }

    @Override
    protected String _readNewNumber(Context ctx, IObjectValue bizObject, String org) throws BOSException, EASBizException {
        ProjectInfo projectInfo = (ProjectInfo)bizObject;
        return this._readNewNumber(ctx, org, (ObjectBaseInfo)projectInfo);
    }
}

