/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.basedata.assistant.IProject;
import com.kingdee.eas.basedata.assistant.ProjectFactory;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;

public class ProjectDataTransmission
extends AbstractDataTransmission {
    private final String RESOURCE_FILE_NAME = "com.kingdee.eas.tools.datatask.DatataskResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ProjectFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String isListItem;
        String name_l3;
        String name_l2;
        ProjectInfo info = new ProjectInfo();
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (number != null) {
            info.setNumber(number);
            Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
            int mode = datataskMode;
            if (mode == 16) {
                try {
                    IProject iProject = (IProject)this.getController(ctx);
                    CoreBaseInfo result = iProject.getValue("select fid where number='" + number + "'");
                    info.setId(BOSUuid.read((String)result.getString("id")));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new TaskExternalException(number + ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"160_ProjectDataTransmission", (Locale)ctx.getLocale()), (Throwable)e);
                }
            }
        } else {
            throw new TaskExternalException("number  not found!");
        }
        String name_l1 = (String)((DataToken)hsData.get((Object)"Fname_L1")).data;
        if (name_l1 != null && name_l1.trim().length() != 0) {
            info.setName(name_l1, new Locale("L1"));
        }
        if ((name_l2 = (String)((DataToken)hsData.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
            info.setName(name_l2, new Locale("L2"));
        }
        if ((name_l3 = (String)((DataToken)hsData.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
            info.setName(name_l3, new Locale("L3"));
        }
        if ((isListItem = (String)((DataToken)hsData.get((Object)"FIsListItem")).data) != null && isListItem.trim().length() != 0) {
            if (isListItem.equals("N")) {
                info.setIsListItem(false);
            } else if (isListItem.equals("Y")) {
                info.setIsListItem(true);
            }
        }
        String cNumber = (String)((DataToken)hsData.get((Object)"FCompanyID")).data;
        CompanyOrgUnitInfo companyinfo = null;
        try {
            if (!StringUtil.isEmpty((String)cNumber)) {
                companyinfo = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue("select id where number = '" + cNumber + "'");
                info.setCompany(companyinfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"companyImportFirst", (Locale)currentLocale);
            MessageFormat mf = BOSLocaleUtil.getMessageFormat((String)message);
            throw new TaskExternalException(mf.format(new Object[]{cNumber}));
        }
        String parentNum = (String)((DataToken)hsData.get((Object)"FParent")).data;
        if (parentNum != null && parentNum.trim().length() != 0) {
            ProjectInfo projectInfo = null;
            try {
                projectInfo = (ProjectInfo)ProjectFactory.getLocalInstance(ctx).getValue("select id ,longnumber,type,status,scheduleStartDate,schedulEndDate where number = '" + parentNum + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
                Locale currentLocale = ctx.getLocale();
                String message = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"projectImportFirst", (Locale)currentLocale);
                MessageFormat mf = BOSLocaleUtil.getMessageFormat((String)message);
                throw new TaskExternalException(mf.format(new Object[]{parentNum}));
            }
            Calendar tempCal = Calendar.getInstance();
            info.setParent(projectInfo);
            info.setType(projectInfo.getType());
            info.setStatus(projectInfo.getStatus());
            info.setScheduleStartDate(tempCal.getTime());
            info.setSchedulEndDate(tempCal.getTime());
        }
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iProject = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iProject.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iProject.addnew(coreBaseInfo);
            } else {
                iProject.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Timestamp createTime;
            result.put("FNumber", rs.getString("number"));
            Locale currentLocale = ctx.getLocale();
            if (rs.getString("name") != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("Fname_L1", rs.getString("name"));
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("Fname_L2", rs.getString("name"));
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("Fname_L3", rs.getString("name"));
                }
            }
            if (rs.getString("parent.number") != null) {
                result.put("FParent", rs.getString("parent.number"));
            }
            if (rs.getString("company.number") != null) {
                result.put("FCompanyID", rs.getString("company.number"));
            }
            if (rs.getString("isListItem") != null) {
                if (rs.getString("isListItem").equalsIgnoreCase("true")) {
                    result.put("FIsListItem", "Y");
                } else {
                    result.put("FIsListItem", "N");
                }
            }
            if (rs.getString("creator.number") != null) {
                result.put("FCreatorNumber", rs.getString("creator.number"));
            }
            if ((createTime = rs.getTimestamp("createTime")) != null) {
                result.put("FCreateTime", createTime.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"accessError", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.assistant.app.ProjectQuery";
    }
}

