/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.assistant.EntityRefInfo;
import com.kingdee.eas.basedata.assistant.IRefMVEntry;
import com.kingdee.eas.basedata.assistant.RefMVEntryCollection;
import com.kingdee.eas.basedata.assistant.RefMVEntryFactory;
import com.kingdee.eas.basedata.assistant.RefMVEntryInfo;
import com.kingdee.eas.basedata.assistant.RefMVException;
import com.kingdee.eas.basedata.assistant.RefMVInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractRefMVControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class RefMVControllerBean
extends AbstractRefMVControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.RefMVControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RefMVInfo info = (RefMVInfo)model;
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            RefMVEntryInfo entryInfo = info.getEntries().get(i);
            entryInfo.setMVName("M" + info.getViewName() + String.valueOf(i));
            entryInfo.setMVPkIndex("PK" + info.getViewName().substring(1) + String.valueOf(i));
        }
        this.check(info);
        info.setEntryMaxSeq(info.getEntries().size());
        return super._addnew(ctx, model);
    }

    private void check(RefMVInfo info) throws BOSException, EASBizException {
        if (info.getBosType() == null || info.getBosType().trim().length() == 0) {
            throw new RefMVException(RefMVException.BOSTYPENULL);
        }
        if (info.getViewName() == null || info.getViewName().trim().length() == 0) {
            throw new RefMVException(RefMVException.VIEWNAMENULL);
        }
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            RefMVEntryInfo entryInfo = info.getEntries().get(i);
            if (entryInfo.getRefBosType() == null || entryInfo.getRefBosType().trim().length() == 0) {
                throw new RefMVException(RefMVException.ENTRYBOSTYPENULL, new Object[]{new Integer(i + 1)});
            }
            if (entryInfo.getRefName() == null || entryInfo.getRefName().trim().length() == 0) {
                throw new RefMVException(RefMVException.ENTRYREFNAMENULL, new Object[]{new Integer(i + 1)});
            }
            if (entryInfo.getRefTable() == null || entryInfo.getRefTable().trim().length() == 0) {
                throw new RefMVException(RefMVException.ENTRYTABLENULL, new Object[]{new Integer(i + 1)});
            }
            if (entryInfo.getRefColumn() != null && entryInfo.getRefColumn().trim().length() != 0) continue;
            throw new RefMVException(RefMVException.ENTRYCOLUMNNULL, new Object[]{new Integer(i + 1)});
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RefMVInfo info = (RefMVInfo)model;
        this.check(info);
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            RefMVEntryInfo entryInfo = info.getEntries().get(i);
            if (entryInfo.getMVName() != null && entryInfo.getMVName().trim().length() != 0) continue;
            entryInfo.setMVName("M" + info.getViewName() + String.valueOf(info.getEntryMaxSeq()));
            entryInfo.setMVPkIndex("PK" + info.getViewName().substring(1) + String.valueOf(info.getEntryMaxSeq()));
            info.setEntryMaxSeq(info.getEntryMaxSeq() + 1);
        }
        if (info.isIsCreatedView()) {
            ArrayList<String> dropViewSqlList = new ArrayList<String>();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("entries.*"));
            RefMVInfo dbInfo = (RefMVInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), selector);
            RefMVEntryCollection dbEntries = dbInfo.getEntries();
            int size2 = dbEntries.size();
            for (int i = 0; i < size2; ++i) {
                RefMVEntryInfo dbEntryInfo = dbEntries.get(i);
                if (this.isInCollection(dbEntryInfo.getMVName(), info.getEntries())) continue;
                dropViewSqlList.add(this.getDropSQL(dbEntryInfo.getMVName(), " drop materialized view " + dbEntryInfo.getMVName()));
            }
            if (dropViewSqlList.size() > 0) {
                Connection conn = null;
                Statement ps = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    ps = conn.createStatement();
                    for (int i = 0; i < dropViewSqlList.size(); ++i) {
                        ps.addBatch((String)dropViewSqlList.get(i));
                    }
                    ps.executeBatch();
                }
                catch (Exception e) {
                    try {
                        throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(ps, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)ps, (Connection)conn);
            }
        }
        super._update(ctx, pk, model);
    }

    private boolean isInCollection(String mvName, RefMVEntryCollection collection) {
        if (mvName == null || mvName.length() == 0) {
            return true;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            RefMVEntryInfo tempEntryInfo = collection.get(i);
            if (!mvName.equals(tempEntryInfo.getMVName())) continue;
            return true;
        }
        return false;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entries.*"));
        RefMVInfo info = (RefMVInfo)this._getValue(ctx, pk, selector);
        if (info.isIsCreatedView()) {
            this._deleteView(ctx, info);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected List _createView(Context ctx, RefMVInfo refMVInfo) throws BOSException, EASBizException {
        List createViewSqlList = this._getCreateViewSQL(ctx, refMVInfo);
        if (createViewSqlList == null || createViewSqlList.size() == 0) {
            return createViewSqlList;
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.createStatement();
            for (int i = 0; i < createViewSqlList.size(); ++i) {
                ps.addBatch("/*dialect*/" + (String)createViewSqlList.get(i));
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return createViewSqlList;
    }

    private void refreshMview(Context ctx, List refreshMVviewList) throws BOSException {
        if (refreshMVviewList == null || refreshMVviewList.size() == 0) {
            return;
        }
        Connection cn = null;
        CallableStatement proc = null;
        try {
            cn = EJBFactory.getQueryConnection((Context)ctx);
            proc = cn.prepareCall("/*dialect*/ call dbms_mview.refresh(?,?) ");
            for (int i = 0; i < refreshMVviewList.size(); ++i) {
                proc.setString(1, (String)refreshMVviewList.get(i));
                proc.setString(2, "cf");
                proc.addBatch();
            }
            proc.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(proc);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)proc);
    }

    @Override
    protected List[] _deleteView(Context ctx, RefMVInfo refMVInfo) throws BOSException, EASBizException {
        List[] sqlList = this._getSQL(ctx, refMVInfo);
        if (sqlList == null) {
            return null;
        }
        List deleteViewSqlList = sqlList[1];
        List notExecuteDropSqlList = sqlList[2];
        if (deleteViewSqlList == null || deleteViewSqlList.size() == 0) {
            return null;
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.createStatement();
            for (int i = 0; i < deleteViewSqlList.size(); ++i) {
                ps.addBatch("/*dialect*/" + (String)deleteViewSqlList.get(i));
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        List[] result = new ArrayList[]{deleteViewSqlList, notExecuteDropSqlList};
        return result;
    }

    @Override
    protected List _getCreateViewSQL(Context ctx, RefMVInfo refMVInfo) throws BOSException, EASBizException {
        List result = null;
        result = "Oracle".equals(ctx.get((Object)"dbType")) ? this.getOrclSQL(ctx, refMVInfo)[0] : new ArrayList();
        return result;
    }

    @Override
    protected List[] _getDeleteViewSQL(Context ctx, RefMVInfo refMVInfo) throws BOSException, EASBizException {
        ArrayList[] result = null;
        if ("Oracle".equals(ctx.get((Object)"dbType"))) {
            result = new ArrayList[]{this.getOrclSQL(ctx, refMVInfo)[1], this.getOrclSQL(ctx, refMVInfo)[2]};
            if (refMVInfo.getId() != null) {
                SQLUtil sb = new SQLUtil();
                sb.appendSql(" update T_BD_RefMV set FIsCreatedView = 0  where FID='").appendSql(refMVInfo.getId().toString()).appendSql("'");
                sb.execute(ctx);
            }
        }
        return result;
    }

    @Override
    protected List[] _getSQL(Context ctx, RefMVInfo refMVInfo) throws BOSException, EASBizException {
        List[] result = null;
        if ("Oracle".equals(ctx.get((Object)"dbType"))) {
            result = this.getOrclSQL(ctx, refMVInfo);
        }
        return result;
    }

    private List[] getOrclSQL(Context ctx, RefMVInfo refMVInfo) throws BOSException, EASBizException {
        ArrayList<String> createViewSqlList = new ArrayList<String>();
        ArrayList<String> dropViewSqlList = new ArrayList<String>();
        ArrayList<String> notExecuteDropSqlList = new ArrayList<String>();
        String mLogPfix = "MLOG$_";
        StringBuffer createView = new StringBuffer();
        createView.append(" create view ").append(refMVInfo.getViewName()).append(" as ");
        dropViewSqlList.add(this.getDropSQL(refMVInfo.getViewName(), " drop view " + refMVInfo.getViewName()));
        ArrayList<String> createdTableList = new ArrayList<String>();
        RefMVEntryCollection entries = refMVInfo.getEntries();
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < entries.size(); ++i) {
            RefMVEntryInfo entryInfo = entries.get(i);
            hashSet.add(entryInfo.getRefTable());
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("refTable", hashSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)refMVInfo.getId().toString(), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.deletedStatus", (Object)DeletedStatusEnum.NORMAL));
        entityView.setFilter(filterInfo);
        IRefMVEntry iBiz = RefMVEntryFactory.getLocalInstance(ctx);
        RefMVEntryCollection relatTableRefMVEntryCollection = iBiz.getRefMVEntryCollection(entityView);
        relatTableRefMVEntryCollection.addCollection(refMVInfo.getEntries());
        for (int i = 0; i < entries.size(); ++i) {
            RefMVEntryInfo entryInfo = entries.get(i);
            StringBuffer sb = new StringBuffer();
            RefMVEntryCollection sameTableCollection = new RefMVEntryCollection();
            RefMVEntryCollection otherSameTableCollection = new RefMVEntryCollection();
            for (int k = 0; k < relatTableRefMVEntryCollection.size(); ++k) {
                RefMVEntryInfo tempEntryInfo = relatTableRefMVEntryCollection.get(k);
                if (!entryInfo.getRefTable().equals(tempEntryInfo.getRefTable())) continue;
                sameTableCollection.add(tempEntryInfo);
                if (entryInfo.getParent().getId().equals((Object)tempEntryInfo.getParent().getId())) continue;
                otherSameTableCollection.add(tempEntryInfo);
            }
            if (!this.inList(entryInfo.getRefTable(), createdTableList)) {
                RefMVEntryInfo info;
                int j;
                StringBuffer refColumns = new StringBuffer();
                for (j = 0; j < sameTableCollection.size(); ++j) {
                    info = sameTableCollection.get(j);
                    if (j > 0) {
                        refColumns.append(",");
                    }
                    refColumns.append(info.getRefColumn());
                }
                sb.append(" create materialized view log on ").append(entryInfo.getRefTable()).append(" with rowid,");
                sb.append(" sequence ( ").append(refColumns).append(" ) including new values ").append("\n");
                createViewSqlList.add(this.getDropSQL("MLOG$_" + entryInfo.getRefTable(), " drop materialized view log on  " + entryInfo.getRefTable()));
                createViewSqlList.add(sb.toString());
                createdTableList.add(entryInfo.getRefTable());
                notExecuteDropSqlList.add(" drop materialized view log on  " + entryInfo.getRefTable());
                if (otherSameTableCollection.size() > 0) {
                    refColumns = new StringBuffer();
                    for (j = 0; j < otherSameTableCollection.size(); ++j) {
                        info = otherSameTableCollection.get(j);
                        if (j > 0) {
                            refColumns.append(",");
                        }
                        refColumns.append(info.getRefColumn());
                    }
                    sb = new StringBuffer();
                    sb.append(" create materialized view log on ").append(entryInfo.getRefTable()).append(" with rowid,");
                    sb.append(" sequence ( ").append(refColumns).append(" ) including new values ").append("\n");
                    dropViewSqlList.add(sb.toString());
                    for (j = 0; j < otherSameTableCollection.size(); ++j) {
                        RefMVEntryInfo otherSameTableEntryInfo = otherSameTableCollection.get(j);
                        sb = new StringBuffer();
                        sb.append(" create materialized view ").append(otherSameTableEntryInfo.getMVName()).append(" refresh fast on demand next sysdate+1/24 ");
                        sb.append(" as select count(*) FCount, ").append(otherSameTableEntryInfo.getRefColumn()).append(" FID ");
                        sb.append(" from ").append(otherSameTableEntryInfo.getRefTable()).append(" where ").append(otherSameTableEntryInfo.getRefColumn()).append(" is not null group by ").append(otherSameTableEntryInfo.getRefColumn());
                        createViewSqlList.add(this.getDropSQL(otherSameTableEntryInfo.getMVName(), " drop materialized view " + otherSameTableEntryInfo.getMVName()));
                        createViewSqlList.add(this.getTableOrViewSQL(otherSameTableEntryInfo.getMVName(), sb.toString()));
                    }
                }
            }
            sb = new StringBuffer();
            sb.append(" create materialized view ").append(entryInfo.getMVName()).append(" refresh fast on demand next sysdate+1/24 ");
            sb.append(" as select count(*) FCount, ").append(entryInfo.getRefColumn()).append(" FID ");
            sb.append(" from ").append(entryInfo.getRefTable()).append(" where ").append(entryInfo.getRefColumn()).append(" is not null group by ").append(entryInfo.getRefColumn());
            createViewSqlList.add(this.getDropSQL(entryInfo.getMVName(), " drop materialized view " + entryInfo.getMVName()));
            createViewSqlList.add(this.getTableOrViewSQL(entryInfo.getMVName(), sb.toString()));
            dropViewSqlList.add(this.getDropSQL(entryInfo.getMVName(), " drop materialized view " + entryInfo.getMVName()));
            sb = new StringBuffer();
            sb.append(" create index ").append(entryInfo.getMVPkIndex()).append(" on ").append(entryInfo.getMVName()).append(" (FID) ");
            createViewSqlList.add(this.getIndexSQL(entryInfo.getMVPkIndex(), sb.toString()));
            if (i > 0) {
                createView.append(" union all ");
            }
            createView.append(" select FCount, FID, ''").append(entryInfo.getRefName()).append("'' FRefName ");
            createView.append(" from  ").append(entryInfo.getMVName()).append("\n");
        }
        createViewSqlList.add(this.getViewSQL(refMVInfo.getViewName(), createView.toString()));
        List[] result = new List[]{createViewSqlList, dropViewSqlList, notExecuteDropSqlList};
        return result;
    }

    private String getRepeatableExecuteSQL(String queryExsistSql, String executeSql, boolean ifExsistThen) {
        StringBuffer sql = new StringBuffer();
        sql.append("DECLARE CNT PLS_INTEGER;").append("\n");
        sql.append("BEGIN").append("\n");
        sql.append("SELECT COUNT(*) FCOUNT INTO CNT FROM (").append(queryExsistSql).append(");").append("\n");
        if (ifExsistThen) {
            sql.append("IF CNT > 0 THEN").append("\n");
        } else {
            sql.append("IF CNT = 0 THEN").append("\n");
        }
        sql.append("EXECUTE IMMEDIATE '").append(executeSql).append("';").append("\n");
        sql.append("END IF;").append("\n");
        sql.append("END;").append("\n");
        return sql.toString();
    }

    private String getIfNotExsistSQL(String queryExsistSql, String executeSql) {
        return this.getRepeatableExecuteSQL(queryExsistSql, executeSql, false);
    }

    private String getIfExsistSQL(String queryExsistSql, String executeSql) {
        return this.getRepeatableExecuteSQL(queryExsistSql, executeSql, true);
    }

    private String getTableOrViewSQL(String tableName, String sql) {
        String queryExsistSql = " SELECT TABLE_NAME FROM (SELECT TABLE_NAME TABLE_NAME FROM USER_TABLES UNION ALL SELECT VIEW_NAME TABLE_NAME FROM USER_VIEWS) WHERE TABLE_NAME = upper('" + tableName + "')";
        return this.getIfNotExsistSQL(queryExsistSql, sql);
    }

    private String getTableSQL(String tableName, String sql) {
        String queryExsistSql = " SELECT TABLE_NAME TABLE_NAME FROM USER_TABLES) WHERE TABLE_NAME = upper('" + tableName + "')";
        return this.getIfNotExsistSQL(queryExsistSql, sql);
    }

    private String getViewSQL(String viewName, String sql) {
        String queryExsistSql = " SELECT VIEW_NAME FROM USER_VIEWS WHERE VIEW_NAME = upper('" + viewName + "')";
        return this.getIfNotExsistSQL(queryExsistSql, sql);
    }

    private String getIndexSQL(String indexName, String sql) {
        String queryExsistSql = " SELECT INDEX_NAME FROM USER_INDEXES WHERE INDEX_NAME=upper('" + indexName + "')";
        return this.getIfNotExsistSQL(queryExsistSql, sql);
    }

    private String getMVLogSQL(String tableName, String sql) {
        String queryExsistSql = " SELECT MASTER FROM USER_MVIEW_LOGS WHERE MASTER= upper('" + tableName + "')";
        return this.getIfNotExsistSQL(queryExsistSql, sql);
    }

    private String getDropSQL(String tableName, String sql) {
        String queryExsistSql = " SELECT TABLE_NAME FROM (SELECT TABLE_NAME TABLE_NAME FROM USER_TABLES UNION ALL SELECT VIEW_NAME TABLE_NAME FROM USER_VIEWS) WHERE TABLE_NAME = upper('" + tableName + "')";
        return this.getIfExsistSQL(queryExsistSql, sql);
    }

    private String getDropMVLogSQL(String tableName, String sql) {
        String queryExsistSql = " SELECT MASTER FROM USER_MVIEW_LOGS WHERE MASTER= upper('" + tableName + "')";
        return this.getIfExsistSQL(queryExsistSql, sql);
    }

    private boolean inList(String tableName, List tableList) {
        for (int i = 0; i < tableList.size(); ++i) {
            if (!tableName.equals(tableList.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List _getRefTable(Context ctx, String entityName) throws BOSException {
        ArrayList<EntityRefInfo> result = new ArrayList<EntityRefInfo>();
        if (entityName == null) {
            return result;
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.createStatement();
            String sql = "select T_SYS_EntityRef.*,T_PF_BOSObject.FBOSType FRefEntityBosType from T_SYS_EntityRef  left outer join T_PF_BOSObject on T_SYS_EntityRef.FRefEntityName = T_PF_BOSObject.FName where FEntityName='" + entityName + "' order by FREFTABLENAME ";
            ResultSet rs = ps.executeQuery(sql);
            int count = 0;
            StringBuffer sb = new StringBuffer();
            while (rs.next()) {
                String refTable = rs.getString("FREFTABLENAME");
                if (count > 0) {
                    sb.append("union all ");
                }
                sb.append("select ");
                sb.append("'").append(refTable).append("' FRefTable,");
                sb.append("'").append(rs.getString("FREFENTITYALIAS_L2")).append("' FRefTableName,");
                sb.append("'").append(rs.getString("FREFFIELDNAME")).append("' FRefcolumn,");
                sb.append("'").append(rs.getString("FBOSTYPE")).append("' FBosType,");
                sb.append("'").append(rs.getString("FRefEntityBosType")).append("' FRefEntityBosType,");
                sb.append("count(*) FCount from ").append(refTable).append("\n");
                ++count;
            }
            if (sb.length() > 0) {
                String selectSql = sb.toString();
                rs = ps.executeQuery(selectSql);
                while (rs.next()) {
                    EntityRefInfo info = new EntityRefInfo();
                    info.setEntityName(entityName);
                    info.setBosType(rs.getString("FBosType"));
                    info.setRefEntityBosType(rs.getString("FRefEntityBosType"));
                    info.setRefTable(rs.getString("FRefTable"));
                    info.setRefTableName(rs.getString("FRefTableName"));
                    info.setRefColumn(rs.getString("FRefcolumn"));
                    info.setTableRowCount(rs.getInt("FCount"));
                    result.add(info);
                }
            }
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)ex));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return result;
    }
}

