/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.assistant.RefMVFactory;
import com.kingdee.eas.basedata.assistant.RefMVInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.RefChkFilter;
import com.kingdee.eas.common.RefChkFilterItemEnum;
import com.kingdee.eas.common.RefChkFilterSet;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ReferenceMVImpl {
    private static Logger logger = Logger.getLogger(ReferenceMVImpl.class);

    public static void refreshMview(Context ctx, RefMVInfo refMVInfo) throws BOSException {
        if (refMVInfo == null) {
            return;
        }
        Connection cn = null;
        CallableStatement proc = null;
        try {
            cn = EJBFactory.getQueryConnection((Context)ctx);
            proc = cn.prepareCall("/*dialect*/ call dbms_mview.refresh(?) ");
            for (int i = 0; i < refMVInfo.getEntries().size(); ++i) {
                proc.setString(1, refMVInfo.getEntries().get(i).getMVName());
                proc.addBatch();
            }
            proc.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(proc);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)proc);
    }

    public static void checkReferenced(Context ctx, IObjectPK pk, RefChkFilterSet filterSet) throws ObjectReferedException {
        if (pk == null) {
            return;
        }
        BOSUuid uuid = BOSUuid.read((String)pk.toString());
        BOSObjectType BOSObjectType2 = uuid.getType();
        try {
            String oql = " select *,entries.* where bosType='" + BOSObjectType2.toString() + "' and DeletedStatus=" + String.valueOf(1);
            CoreBaseCollection collection = RefMVFactory.getLocalInstance(ctx).getCollection(oql);
            if (collection.size() == 0) {
                ReferenceMVImpl.checkReferencedOld(ctx, pk, filterSet);
                return;
            }
            RefMVInfo refMVInfo = (RefMVInfo)collection.get(0);
            ReferenceMVImpl.refreshMview(ctx, refMVInfo);
            SQLUtil sb = new SQLUtil();
            sb.appendSql(" select * from ").appendSql(refMVInfo.getViewName());
            sb.appendSql(" where FID='").appendSql(pk.toString()).appendSql("' and FCount > 0 ");
            ResultSet rs = sb.exeQuery(ctx);
            if (rs.next()) {
                String refName = rs.getString("FRefName");
                BizReference bizReference = new BizReference();
                bizReference.setRefEntityAlias_L1(refName);
                bizReference.setRefEntityAlias_L2(refName);
                bizReference.setRefEntityAlias_L3(refName);
                throw new ObjectReferedException((Object)bizReference);
            }
            HashSet<String> hs = new HashSet<String>();
            for (int i = 0; i < refMVInfo.getEntries().size(); ++i) {
                hs.add(refMVInfo.getEntries().get(i).getRefBosType());
            }
            RefChkFilter filter = new RefChkFilter(RefChkFilterItemEnum.ExcludedRefobjTypeList, hs);
            if (filterSet == null) {
                filterSet = new RefChkFilterSet();
            }
            filterSet.add(filter);
        }
        catch (ObjectReferedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            throw new RuntimeException(ExceptionUtil.getExcLinkStackTrace((Throwable)e), e);
        }
        ReferenceMVImpl.checkReferencedOld(ctx, pk, filterSet);
    }

    public static void checkReferenced(Context ctx, IObjectPK pk) throws ObjectReferedException {
        ReferenceMVImpl.checkReferenced(ctx, pk, null);
    }

    public static boolean isReferenced(Context ctx, IObjectPK pk, Connection cn) {
        return ReferenceMVImpl.isReferenced(ctx, pk, new RefChkFilterSet());
    }

    public static boolean isReferenced(Context ctx, IObjectPK pk, RefChkFilterSet filterSet) {
        try {
            ReferenceMVImpl.checkReferenced(ctx, pk, filterSet);
        }
        catch (ObjectReferedException e) {
            return true;
        }
        return false;
    }

    public static boolean isReferenced(Context ctx, IObjectPK pk) throws ObjectReferedException {
        return ReferenceMVImpl.isReferenced(ctx, pk, (RefChkFilterSet)null);
    }

    private static void checkReferencedOld(Context ctx, IObjectPK pk, RefChkFilterSet filterSet) throws ObjectReferedException {
        Object ref = null;
        boolean isReferenced = false;
        try {
            BOSUuid uuid = BOSUuid.read((String)pk.toString());
            isReferenced = filterSet == null ? ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)uuid) : ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)uuid, (RefChkFilterSet)filterSet);
        }
        catch (BizReferenceException e) {
            throw new RuntimeException(ExceptionUtil.getExcLinkStackTrace((Throwable)e), e);
        }
        if (isReferenced) {
            throw new ObjectReferedException(ref);
        }
    }
}

