/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.RegistrationTypeFactory;
import com.kingdee.eas.basedata.assistant.RegistrationTypeInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractRegistrationTypeControllerBean;
import com.kingdee.eas.basedata.orgext.OUExtException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class RegistrationTypeControllerBean
extends AbstractRegistrationTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.RegistrationTypeControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDupAndEmpty(ctx, (RegistrationTypeInfo)model);
        this.checkNameDupAndEmpty(ctx, (RegistrationTypeInfo)model);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDupAndEmpty(ctx, (RegistrationTypeInfo)model);
        this.checkNameDupAndEmpty(ctx, (RegistrationTypeInfo)model);
        super._update(ctx, pk, model);
    }

    private void checkNameDupAndEmpty(Context ctx, RegistrationTypeInfo info) throws OUExtException, EASBizException, BOSException {
        if (StringUtils.isEmpty((String)info.getName())) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK, new Object[]{info.getName()});
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (RegistrationTypeFactory.getLocalInstance(ctx).exists(filter)) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{info.getName()});
        }
    }

    private void checkNumberDupAndEmpty(Context ctx, RegistrationTypeInfo info) throws OUExtException, EASBizException, BOSException {
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK, new Object[]{info.getNumber()});
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (RegistrationTypeFactory.getLocalInstance(ctx).exists(filter)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
        }
    }
}

