/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ShareTypeEnum;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctType;
import com.kingdee.eas.basedata.assistant.app.AbstractSharedAcctControllerBean;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SharedAcctControllerBean
extends AbstractSharedAcctControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.SharedAcctControllerBean");
    private String resourcePath = "com.kingdee.eas.basedata.assistant.AccountBankResource";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        this.doAfterAddNew(ctx, model, pk);
        return pk;
    }

    private void doAfterAddNew(Context ctx, IObjectValue model, IObjectPK pk) throws EASBizException, BOSException {
        SharedAcctInfo info = (SharedAcctInfo)model;
        AccountBankInfo sharedAcct = info.getBankAccount();
        sharedAcct.setShareAcct(info);
        sharedAcct.setShareType(SharedAcctType.shared);
        AccountBankFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sharedAcct.getId().toString()), (CoreBaseInfo)sharedAcct);
        SharedAcctEntriesCollection coll = info.getEntries();
        if (coll.size() == 0) {
            String msg = EASResource.getString((String)this.resourcePath, (String)"noShareAcct");
            throw new AccountBankException(AccountBankException.COMMON, new Object[]{msg});
        }
        for (int i = 0; i < coll.size(); ++i) {
            SharedAcctEntriesInfo tmp = coll.get(i);
            if (!ShareTypeEnum.ELECDRAFT.equals((Object)info.getShareType())) {
                this.addSharedBankAcct(ctx, tmp, info);
                continue;
            }
            tmp.setIsLinkAcct(false);
            tmp.setAccountBank(null);
            tmp.setAccountView(null);
            if (EmptyUtil.isEmpty((Object)tmp.getId())) continue;
            SharedAcctEntriesFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(tmp.getId().toString()), tmp);
        }
    }

    private void addSharedBankAcct(Context ctx, SharedAcctEntriesInfo tmp, SharedAcctInfo info) throws BOSException, EASBizException {
        AccountBankInfo sharedAcct = AccountBankFactory.getLocalInstance(ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getBankAccount().getId().toString()));
        if (!tmp.isIsLinkAcct()) {
            AccountBankInfo acctBankInfo = new AccountBankInfo();
            acctBankInfo.copyData(sharedAcct, true);
            acctBankInfo.setCompany(tmp.getSharedCompany());
            acctBankInfo.setAccount(tmp.getAccountView());
            acctBankInfo.setShareAcct(info);
            acctBankInfo.setShareType(SharedAcctType.userd);
            acctBankInfo.setIsMotherAccount(false);
            acctBankInfo.setAccountBankType(sharedAcct.getAccountBankType());
            acctBankInfo.setIsEReceipt(sharedAcct.isIsEReceipt());
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("BD004", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
            if (val) {
                acctBankInfo.setNumber(sharedAcct.getNumber());
            }
            try {
                AccountBankFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)acctBankInfo);
            }
            catch (EASBizException e) {
                String msg = MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"ShareAcctAddAcct"), tmp.getSharedCompany().getName(), e.getMessage());
                AccountBankException ex = new AccountBankException(AccountBankException.COMMON, new Object[]{msg});
                throw ex;
            }
            tmp.setIsLinkAcct(true);
            tmp.setAccountBank(acctBankInfo);
            if (!EmptyUtil.isEmpty((Object)tmp.getId())) {
                SharedAcctEntriesFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(tmp.getId().toString()), tmp);
            }
        } else {
            AccountBankInfo acctBankInfo = tmp.getAccountBank();
            acctBankInfo.setBankAccountNumber(sharedAcct.getBankAccountNumber());
            acctBankInfo.setAcctName(sharedAcct.getAcctName());
            acctBankInfo.setCountry(sharedAcct.getCountry());
            acctBankInfo.setOpenArea(sharedAcct.getOpenArea());
            acctBankInfo.setIsSetBankInterface(sharedAcct.isIsSetBankInterface());
            acctBankInfo.setBankInterFace(sharedAcct.getBankInterFace());
            acctBankInfo.setBankInterFaceID(sharedAcct.getBankInterFaceID());
            acctBankInfo.setMaxPayAmount(sharedAcct.getMaxPayAmount());
            acctBankInfo.setIsMotherAccount(sharedAcct.isIsMotherAccount());
            acctBankInfo.setNotOutPay(sharedAcct.isNotOutPay());
            acctBankInfo.setAccountType(sharedAcct.getAccountType());
            acctBankInfo.setIsVirtualAcct(sharedAcct.isIsVirtualAcct());
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("BD004", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
            if (val) {
                acctBankInfo.setNumber(sharedAcct.getNumber());
            }
            acctBankInfo.setShareAcct(info);
            acctBankInfo.setShareType(SharedAcctType.userd);
            acctBankInfo.setIsMotherAccount(false);
            AccountBankFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(acctBankInfo.getId().toString()), (CoreBaseInfo)acctBankInfo);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSave(ctx, model);
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSave(ctx, model);
        super._update(ctx, pk, model);
        this.doAfterUpdate(ctx, pk, model);
    }

    private void doAfterUpdate(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        SharedAcctInfo info = (SharedAcctInfo)model;
        if (EmptyUtil.isEmpty((Object)info.getId())) {
            return;
        }
        if (ShareTypeEnum.ELECDRAFT.equals((Object)info.getShareType())) {
            SharedAcctEntriesCollection coll = info.getEntries();
            for (int i = 0; i < coll.size(); ++i) {
                SharedAcctEntriesInfo tmp = coll.get(i);
                if (EmptyUtil.isEmpty((Object)tmp.getId())) {
                    this.addSharedBankAcct(ctx, tmp, info);
                }
                tmp.setIsLinkAcct(false);
                tmp.setAccountBank(null);
                tmp.setAccountView(null);
                if (EmptyUtil.isEmpty((Object)tmp.getId())) continue;
                SharedAcctEntriesFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(tmp.getId().toString()), tmp);
            }
        } else {
            SharedAcctEntriesCollection coll = info.getEntries();
            for (int i = 0; i < coll.size(); ++i) {
                SharedAcctEntriesInfo tmp = coll.get(i);
                if (EmptyUtil.isEmpty((Object)tmp.getId()) || tmp.getAccountView() != null && !tmp.isIsLinkAcct()) {
                    this.addSharedBankAcct(ctx, tmp, info);
                }
                tmp.setIsRecDfltComp(false);
                if (EmptyUtil.isEmpty((Object)tmp.getId())) continue;
                SharedAcctEntriesFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(tmp.getId().toString()), tmp);
            }
        }
    }

    private void beforeSave(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SharedAcctEntriesInfo tmp;
        SharedAcctInfo info = (SharedAcctInfo)model;
        if (EmptyUtil.isEmpty((Object)info.getId())) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
        SelectorItemCollection selector = this.getSelector();
        SharedAcctInfo dbInfo = SharedAcctFactory.getLocalInstance(ctx).getSharedAcctInfo((IObjectPK)pk, selector);
        SharedAcctEntriesCollection coll = info.getEntries();
        HashMap<String, SharedAcctEntriesInfo> collMap = new HashMap<String, SharedAcctEntriesInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            SharedAcctEntriesInfo tmp2 = coll.get(i);
            if (EmptyUtil.isEmpty((Object)tmp2.getId())) continue;
            collMap.put(tmp2.getId().toString(), tmp2);
        }
        coll = dbInfo.getEntries();
        HashMap<String, SharedAcctEntriesInfo> dbcollMap = new HashMap<String, SharedAcctEntriesInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            SharedAcctEntriesInfo tmp3 = coll.get(i);
            if (EmptyUtil.isEmpty((Object)tmp3.getId())) continue;
            dbcollMap.put(tmp3.getId().toString(), tmp3);
        }
        for (String key : dbcollMap.keySet()) {
            AccountBankInfo bankInfo;
            if (collMap.containsKey(key) && !ShareTypeEnum.ELECDRAFT.equals((Object)info.getShareType()) || EmptyUtil.isEmpty((CoreBaseInfo)(bankInfo = (tmp = (SharedAcctEntriesInfo)dbcollMap.get(key)).getAccountBank()))) continue;
            bankInfo.setBankAccountNumber("share-" + bankInfo.getCompany().getNumber() + "-" + bankInfo.getBankAccountNumber());
            bankInfo.setShareAcct(null);
            bankInfo.setShareType(SharedAcctType.normal);
            AccountBankFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(bankInfo.getId().toString()), (CoreBaseInfo)bankInfo);
        }
        coll = info.getEntries();
        for (int i = 0; i < coll.size(); ++i) {
            tmp = coll.get(i);
            if (!EmptyUtil.isEmpty((Object)tmp.getId()) || ShareTypeEnum.ELECDRAFT.equals((Object)info.getShareType())) continue;
            this.addSharedBankAcct(ctx, tmp, info);
        }
        if (info.getEntries().size() == 0) {
            AccountBankInfo bankAcct = info.getBankAccount();
            AccountBankInfo bankAcctInfo = AccountBankFactory.getLocalInstance(ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankAcct.getId().toString()), this.getAcctBankSelectors());
            bankAcctInfo.setShareAcct(null);
            bankAcctInfo.setShareType(SharedAcctType.normal);
            AccountBankFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(bankAcct.getId().toString()), (CoreBaseInfo)bankAcctInfo);
        }
    }

    public SelectorItemCollection getAcctBankSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.baseCurrency"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("bank.longNumber"));
        sic.add(new SelectorItemInfo("bank.address"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.isBank"));
        sic.add(new SelectorItemInfo("subAccount.id"));
        sic.add(new SelectorItemInfo("subAccount.number"));
        sic.add(new SelectorItemInfo("subAccount.name"));
        sic.add(new SelectorItemInfo("subAccount.bank.id"));
        sic.add(new SelectorItemInfo("subAccount.bank.number"));
        sic.add(new SelectorItemInfo("subAccount.bank.longNumber"));
        sic.add(new SelectorItemInfo("subAccount.relationalUnit.id"));
        sic.add(new SelectorItemInfo("currency.isoCode"));
        sic.add(new SelectorItemInfo("openArea.number"));
        sic.add(new SelectorItemInfo("openArea.name"));
        sic.add(new SelectorItemInfo("openArea.deptID"));
        sic.add(new SelectorItemInfo("openArea.province"));
        sic.add(new SelectorItemInfo("openArea.unionCode"));
        sic.add(new SelectorItemInfo("country.name"));
        return sic;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("bankAccount.id"));
        selector.add(new SelectorItemInfo("bankAccount.name"));
        selector.add(new SelectorItemInfo("bankAccount.number"));
        selector.add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        selector.add(new SelectorItemInfo("entries.id"));
        selector.add(new SelectorItemInfo("entries.isLinkAcct"));
        selector.add(new SelectorItemInfo("entries.sharedCompany.id"));
        selector.add(new SelectorItemInfo("entries.sharedCompany.name"));
        selector.add(new SelectorItemInfo("entries.sharedCompany.number"));
        selector.add(new SelectorItemInfo("entries.accountView.id"));
        selector.add(new SelectorItemInfo("entries.accountView.name"));
        selector.add(new SelectorItemInfo("entries.accountView.number"));
        selector.add(new SelectorItemInfo("entries.accountBank.*"));
        return selector;
    }

    @Override
    protected void _syncSharedAcct(Context ctx, IObjectValue sharedAcctInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(((SharedAcctInfo)sharedAcctInfo).getId().toString());
        SelectorItemCollection selector = this.getSelector();
        SharedAcctInfo info = SharedAcctFactory.getLocalInstance(ctx).getSharedAcctInfo((IObjectPK)pk, selector);
        AccountBankInfo sharedAcct = this.getSharedAcctInfo(ctx, info.getBankAccount());
        HashSet<String> set = new HashSet<String>();
        SharedAcctEntriesCollection coll = info.getEntries();
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getAccountBank() == null) continue;
            set.add(coll.get(i).getAccountBank().getId().toString());
        }
        List<AccountBankInfo> sharedentriesAcct = this.getSharedEntriesAcctInfo(ctx, set);
        for (int i = 0; i < sharedentriesAcct.size(); ++i) {
            AccountBankInfo entriesAcct = sharedentriesAcct.get(i);
            this.syncData(ctx, entriesAcct, sharedAcct);
        }
    }

    private void syncData(Context ctx, AccountBankInfo entriesAcct, AccountBankInfo sharedAcct) throws EASBizException, BOSException {
        entriesAcct.setBankAccountNumber(sharedAcct.getBankAccountNumber());
        entriesAcct.setAcctName(sharedAcct.getAcctName());
        entriesAcct.setBank(sharedAcct.getBank());
        entriesAcct.setIsByCurrency(sharedAcct.isIsByCurrency());
        entriesAcct.setCurrency(sharedAcct.getCurrency());
        entriesAcct.setCountry(sharedAcct.getCountry());
        entriesAcct.setOpenArea(sharedAcct.getOpenArea());
        entriesAcct.setIsSetBankInterface(sharedAcct.isIsSetBankInterface());
        entriesAcct.setBankInterFace(sharedAcct.getBankInterFace());
        entriesAcct.setBankInterFaceID(sharedAcct.getBankInterFaceID());
        entriesAcct.setMaxPayAmount(sharedAcct.getMaxPayAmount());
        entriesAcct.setNotOutPay(sharedAcct.isNotOutPay());
        entriesAcct.setAccountType(sharedAcct.getAccountType());
        entriesAcct.setIsVirtualAcct(sharedAcct.isIsVirtualAcct());
        entriesAcct.setIsOnlyRead(sharedAcct.isIsOnlyRead());
        entriesAcct.setIsEReceipt(sharedAcct.isIsEReceipt());
        entriesAcct.setBankOpenDate(sharedAcct.getBankOpenDate());
        AccountBankFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(entriesAcct.getId().toString()), (CoreBaseInfo)entriesAcct);
    }

    private List<AccountBankInfo> getSharedEntriesAcctInfo(Context ctx, Set<String> set) throws BOSException {
        ArrayList<AccountBankInfo> list = new ArrayList<AccountBankInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        AccountBankCollection coll = AccountBankFactory.getLocalInstance(ctx).getAccountBankCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            list.add(coll.get(i));
        }
        return list;
    }

    private AccountBankInfo getSharedAcctInfo(Context ctx, AccountBankInfo bankAccount) throws EASBizException, BOSException {
        bankAccount = AccountBankFactory.getLocalInstance(ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankAccount.getId().toString()));
        return bankAccount;
    }
}

