/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fi.cas.CashMgtInitFacadeForBaseFactory;
import com.kingdee.eas.base.core.fi.cas.ICashMgtInitFacadeForBase;
import com.kingdee.eas.base.core.fi.fa.manage.BaseFaBizCheckerFactory;
import com.kingdee.eas.base.core.fi.gl.app.AppHelper;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatus;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrolChecker;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolHelper;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractSystemStatusCtrolControllerBean;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SystemStatusCtrolControllerBean
extends AbstractSystemStatusCtrolControllerBean {
    private static final long serialVersionUID = 7679992223356286473L;
    private static Logger logger = Logger.getLogger(SystemStatusCtrolControllerBean.class);

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ObjectUuidPK companyPK;
        ICashMgtInitFacadeForBase iCashMgtInitFacade;
        SystemStatusCtrolInfo systemStatusCtrolInfo = (SystemStatusCtrolInfo)model;
        SystemStatusCtrolInfo oldInfo = this.getSystemStatusCtrolInfo(ctx, pk, this.getSelectors());
        systemStatusCtrolInfo.setIsStart(oldInfo.isIsStart());
        SystemStatusInfo systemStatusInfo = systemStatusCtrolInfo.getSystemStatus();
        if (systemStatusInfo.getName().equals((Object)SystemEnum.GENERALLEDGER) && !systemStatusCtrolInfo.isIsStart() && (oldInfo.getStartPeriod() == null && systemStatusCtrolInfo.getStartPeriod() != null || oldInfo.getStartPeriod() != null && systemStatusCtrolInfo.getStartPeriod() == null || oldInfo.getStartPeriod() != null && systemStatusCtrolInfo.getStartPeriod() != null && !oldInfo.getStartPeriod().getId().equals((Object)systemStatusCtrolInfo.getStartPeriod().getId()))) {
            AppHelper.checkModifyStartPeriod((Context)ctx, (String)systemStatusCtrolInfo.getCompany().getId().toString());
        }
        if (systemStatusInfo.getName().equals((Object)SystemEnum.FIXEDASSETS) && !systemStatusCtrolInfo.isIsStart() && (oldInfo.getStartPeriod() == null ? systemStatusCtrolInfo.getStartPeriod() != null && BaseFaBizCheckerFactory.createInstance().hasFaInitData(ctx, systemStatusInfo.getId().toString()) : systemStatusCtrolInfo.getStartPeriod() != null && !oldInfo.getStartPeriod().getId().equals((Object)systemStatusCtrolInfo.getStartPeriod().getId()) && BaseFaBizCheckerFactory.createInstance().hasFaInitData(ctx, systemStatusInfo.getId().toString()))) {
            throw new PeriodException(PeriodException.FA_UPDATE_FAIL);
        }
        if (systemStatusInfo.getName().equals((Object)SystemEnum.CASHMANAGEMENT) && !systemStatusCtrolInfo.isIsStart() && (oldInfo.getStartPeriod() == null ? systemStatusCtrolInfo.getStartPeriod() != null && (iCashMgtInitFacade = CashMgtInitFacadeForBaseFactory.createInstance()).hasInitData(ctx, (IObjectPK)(companyPK = new ObjectUuidPK(systemStatusInfo.getId().toString()))) : systemStatusCtrolInfo.getStartPeriod() != null && !oldInfo.getStartPeriod().getId().equals((Object)systemStatusCtrolInfo.getStartPeriod().getId()) && (iCashMgtInitFacade = CashMgtInitFacadeForBaseFactory.createInstance()).hasInitData(ctx, (IObjectPK)(companyPK = new ObjectUuidPK(systemStatusInfo.getId().toString()))))) {
            throw new PeriodException(PeriodException.PERIOD_UPDATE_FAIL);
        }
        if (systemStatusCtrolInfo.isIsClosedAccount() && !systemStatusCtrolInfo.isIsStart()) {
            throw new PeriodException(PeriodException.NOT_START_PERIOD);
        }
        super._update(ctx, pk, model);
        SystemStatusCtrolHelper.updateReference(ctx, BOSUuid.read((String)pk.toString()));
    }

    private void updateForStart(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systemStatusCtrolInfo = this.getSystemStatusCtrolInfo(ctx, pk);
        if (systemStatusCtrolInfo != null && systemStatusCtrolInfo.isIsStart()) {
            throw new PeriodException(PeriodException.NOT_DEL_STARTPERIOD);
        }
        AppHelper.checkModifyStartPeriod((Context)ctx, (String)this.getCurrentFIUnit(ctx));
        super._delete(ctx, pk);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _start(Context ctx, IObjectPK pk, boolean isStart) throws BOSException, EASBizException {
        if (!this._exists(ctx, pk)) throw new PeriodException(PeriodException.NOT_EXIST_SYSCTROL);
        SystemStatusCtrolInfo control = this.getSystemStatusCtrolInfo(ctx, pk);
        control.setIsStart(isStart);
        ISystemStatus iSystemStatus = SystemStatusFactory.getLocalInstance(ctx);
        SystemStatusInfo sysInfo = iSystemStatus.getSystemStatusInfo((IObjectPK)new ObjectUuidPK(control.getSystemStatus().getId()));
        if (sysInfo.isHasPeriod()) {
            if (control.getStartPeriod() == null) throw new PeriodException(PeriodException.NOT_SET_STARTPERIOD);
            control.setCurrentPeriod(control.getStartPeriod());
        }
        this.updateForStart(ctx, pk, (IObjectValue)control);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _start(Context ctx, SystemEnum systemName, IObjectValue company, boolean isStart) throws BOSException, EASBizException {
        SystemStatusCtrolCollection ctrolcollection = null;
        ctrolcollection = this.getCtrolCollection(ctx, systemName, (OrgUnitInfo)company);
        if (ctrolcollection.size() <= 0) throw new PeriodException(PeriodException.NOT_EXIST_SYSCTROL);
        SystemStatusCtrolInfo control = ctrolcollection.get(0);
        control.setIsStart(isStart);
        ISystemStatus iSystemStatus = SystemStatusFactory.getLocalInstance(ctx);
        SystemStatusInfo sysInfo = iSystemStatus.getSystemStatusInfo((IObjectPK)new ObjectUuidPK(control.getSystemStatus().getId()));
        if (sysInfo.isHasPeriod()) {
            if (control.getStartPeriod() == null) throw new PeriodException(PeriodException.NOT_SET_STARTPERIOD);
            control.setCurrentPeriod(control.getStartPeriod());
        }
        ObjectUuidPK pk = new ObjectUuidPK(control.getId());
        this.updateForStart(ctx, (IObjectPK)pk, (IObjectValue)control);
    }

    @Override
    protected void _nextPeriod(Context ctx, SystemEnum systemName, IObjectValue company) throws BOSException, EASBizException {
        SystemStatusCtrolCollection ctrolcollection = null;
        ctrolcollection = this.getCtrolCollection(ctx, systemName, (OrgUnitInfo)company);
        if (ctrolcollection.size() <= 0) {
            throw new PeriodException(PeriodException.NOT_EXIST_SYSCTROL);
        }
        SystemStatusCtrolInfo info = ctrolcollection.get(0);
        PeriodInfo currentPeriod = info.getCurrentPeriod();
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo(ctx, currentPeriod);
        info.setCurrentPeriod(nextPeriod);
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        this.updateForStart(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    @Override
    protected void _prePeriod(Context ctx, SystemEnum systemName, IObjectValue company) throws BOSException, EASBizException {
        PeriodInfo prePeriod;
        SystemStatusCtrolInfo info;
        SystemStatusCtrolCollection ctrolcollection = null;
        ctrolcollection = this.getCtrolCollection(ctx, systemName, (OrgUnitInfo)company);
        if (ctrolcollection.size() > 0) {
            info = ctrolcollection.get(0);
            PeriodInfo currentPeriod = info.getCurrentPeriod();
            prePeriod = PeriodUtils.getPrePeriodInfo(ctx, currentPeriod);
            if (prePeriod == null) {
                throw new PeriodException(PeriodException.PERIODNOTNULL);
            }
        } else {
            throw new PeriodException(PeriodException.NOT_EXIST_SYSCTROL);
        }
        info.setCurrentPeriod(prePeriod);
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        this.updateForStart(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    private SystemStatusCtrolCollection getCtrolCollection(Context ctx, SystemEnum SystemName, OrgUnitInfo company) throws BOSException, EASBizException {
        Object currentPeriod = null;
        ISystemStatus isys = null;
        IPeriod iperiod = null;
        SystemStatusCtrolCollection ctrolCollection = null;
        isys = SystemStatusFactory.getLocalInstance(ctx);
        iperiod = PeriodFactory.getLocalInstance(ctx);
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemName.getValue()), CompareType.EQUALS));
        if (company instanceof ProfitCenterOrgUnitInfo) {
            filter1.getFilterItems().add(new FilterItemInfo("profitCenter", (Object)company.getId().toString(), CompareType.EQUALS));
        } else {
            filter1.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId().toString(), CompareType.EQUALS));
        }
        evi1.setFilter(filter1);
        ctrolCollection = super.getSystemStatusCtrolCollection(ctx, evi1);
        return ctrolCollection;
    }

    private PeriodTypeInfo getPeriodTypeInfo(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodTypeInfo periodType = null;
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = icompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
        periodType = companyInfo.getAccountPeriodType();
        return periodType;
    }

    private void checkIsCurrentPeriodEqual(Context ctx, SystemEnum SystemName, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        SystemStatusCtrolInfo sysCtrolInfo = null;
        SystemStatusCtrolInfo sysGLCtrolInfo = null;
        SystemStatusCtrolCollection sysC = this.getCtrolCollection(ctx, SystemName, (OrgUnitInfo)company);
        SystemStatusCtrolCollection sysGL = this.getCtrolCollection(ctx, SystemEnum.GENERALLEDGER, (OrgUnitInfo)company);
        if (sysC.size() > 0) {
            sysCtrolInfo = sysC.get(0);
        }
        if (sysGL.size() > 0) {
            sysGLCtrolInfo = sysGL.get(0);
        }
        if (sysGLCtrolInfo != null && sysCtrolInfo != null && !sysGLCtrolInfo.getCurrentPeriod().getId().toString().equals(sysCtrolInfo.getCurrentPeriod().getId().toString())) {
            throw new PeriodException(PeriodException.MUST_CURRENTPERIOD_EQUAL);
        }
    }

    private void checkUnRelGL(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        SystemStatusCtrolInfo sysGLCtrolInfo = null;
        boolean hasRelGL = false;
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)new Integer(6), CompareType.NOTEQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId().toString(), CompareType.EQUALS));
        evi1.setFilter(filter1);
        SystemStatusCtrolCollection sysGL = super.getSystemStatusCtrolCollection(ctx, evi1);
        if (sysGL.size() > 0) {
            for (int i = 0; i < sysGL.size(); ++i) {
                sysGLCtrolInfo = sysGL.get(i);
                if (!sysGLCtrolInfo.isIsRelatedAccount()) continue;
                hasRelGL = true;
            }
        }
        if (hasRelGL) {
            throw new PeriodException(PeriodException.MUST_UNRELGL_BEFOREBACK);
        }
    }

    private SystemStatusInfo getSystemStatusInfo(Context ctx, SystemEnum SystemName) throws BOSException, EASBizException {
        SystemStatusInfo info = null;
        ISystemStatus iSystemStatus = SystemStatusFactory.getLocalInstance(ctx);
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("name", (Object)new Integer(SystemName.getValue()), CompareType.EQUALS));
        evi1.setFilter(filter1);
        SystemStatusCollection sysC = iSystemStatus.getSystemStatusCollection(evi1);
        info = sysC.get(0);
        return info;
    }

    @Override
    public boolean _hasStartPeriod(Context ctx, BOSUuid companyID) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        boolean returnEnd;
        block6: {
            String fCompanyID = null;
            returnEnd = false;
            StringBuffer sql = new StringBuffer();
            con = this.getConnection(ctx);
            ps = null;
            rs = null;
            sql.append("select FStartPeriodID from T_BD_SystemStatusCtrol where FCompanyID = ? and FStartPeriodID is not null");
            if (companyID != null) {
                fCompanyID = companyID.toString();
            }
            try {
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, fCompanyID);
                rs = ps.executeQuery();
                if (rs.next()) {
                    returnEnd = true;
                    rs.close();
                    break block6;
                }
                returnEnd = false;
            }
            catch (SQLException e) {
                try {
                    throw new SQLAccessException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return returnEnd;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isStart"));
        sic.add(new SelectorItemInfo("startPeriod.id"));
        sic.add(new SelectorItemInfo("startPeriod.name"));
        sic.add(new SelectorItemInfo("startPeriod.number"));
        sic.add(new SelectorItemInfo("currentPeriod.id"));
        sic.add(new SelectorItemInfo("currentPeriod.name"));
        sic.add(new SelectorItemInfo("currentPeriod.number"));
        sic.add(new SelectorItemInfo("relatedPeriod.number"));
        sic.add(new SelectorItemInfo("relatedPeriod.id"));
        sic.add(new SelectorItemInfo("relatedPeriod.name"));
        return sic;
    }

    @Override
    public boolean _isStartPeriod(Context ctx, BOSUuid periodID) throws BOSException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        boolean returnEnd;
        block6: {
            String fPeriodID = null;
            returnEnd = false;
            StringBuffer sql = new StringBuffer();
            con = this.getConnection(ctx);
            ps = null;
            rs = null;
            sql.append("select FStartPeriodID from T_BD_SystemStatusCtrol where FStartPeriodID = ? ");
            if (periodID != null) {
                fPeriodID = periodID.toString();
            }
            try {
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, fPeriodID);
                rs = ps.executeQuery();
                if (rs.next()) {
                    returnEnd = true;
                    rs.close();
                    break block6;
                }
                returnEnd = false;
            }
            catch (SQLException e) {
                try {
                    throw new SQLAccessException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return returnEnd;
    }

    @Override
    protected boolean _isEqualsCurPeriodAndRelPeriod(Context ctx, String companyID, SystemEnum systemName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getLocalInstance(ctx);
        sql.append(" select sysStaCtr.fid from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FCompanyID='");
        sql.append(companyID);
        sql.append("'");
        sql.append(" and sysSta.FName=");
        sql.append(systemName.getValue());
        sql.append(" and sysStaCtr.FCurrentPeriodID=sysStaCtr.FRelatedPeriodID");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return iRowSet != null && iRowSet.size() > 0;
    }

    @Override
    protected boolean _isRelatedAccount(Context ctx, String companyID, SystemEnum systemName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getLocalInstance(ctx);
        sql.append(" select sysStaCtr.fid from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FCompanyID='");
        sql.append(companyID);
        sql.append("'");
        sql.append(" and sysSta.FName=");
        sql.append(systemName.getValue());
        sql.append(" and sysStaCtr.FIsRelAccount=1");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return iRowSet != null && iRowSet.size() > 0;
    }

    private String getCurrentFIUnit(Context ctx) {
        return ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
    }

    @Override
    protected boolean _isClosed(Context ctx, SystemEnum systemName, IObjectValue company) throws BOSException, EASBizException {
        String companyID = ((CompanyOrgUnitInfo)company).getId().toString();
        StringBuffer sql = new StringBuffer();
        ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getLocalInstance(ctx);
        sql.append(" select sysStaCtr.fid from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FCompanyID='");
        sql.append(companyID);
        sql.append("'");
        sql.append(" and sysSta.FName=");
        sql.append(systemName.getValue());
        sql.append(" and sysStaCtr.FIsClosedAccount=1");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return iRowSet != null && iRowSet.size() > 0;
    }

    @Override
    protected void _close(Context ctx, SystemEnum systemName, IObjectValue company, boolean isClose) throws BOSException, EASBizException {
        SystemStatusCtrolCollection ctrolcollection = null;
        ctrolcollection = this.getCtrolCollection(ctx, systemName, (OrgUnitInfo)((CompanyOrgUnitInfo)company));
        if (ctrolcollection.size() <= 0) {
            throw new PeriodException(PeriodException.NOT_EXIST_SYSCTROL);
        }
        SystemStatusCtrolInfo control = ctrolcollection.get(0);
        control.setIsClosedAccount(isClose);
        ObjectUuidPK pk = new ObjectUuidPK(control.getId());
        this.updateForStart(ctx, (IObjectPK)pk, (IObjectValue)control);
    }

    @Override
    protected void _submitAll(Context ctx, IObjectCollection objCol) throws BOSException, EASBizException {
        if (objCol == null) {
            return;
        }
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)new SystemStatusCtrolInfo().getBOSType().toString(), ISystemStatusCtrolChecker.class);
            if (checkers != null && checkers.length > 0) {
                for (int i = 0; i < checkers.length; ++i) {
                    String checkerName = "";
                    checkerName = checkers[i];
                    try {
                        Class<?> checkerClass = Class.forName(checkers[i]);
                        ISystemStatusCtrolChecker checker = (ISystemStatusCtrolChecker)checkerClass.newInstance();
                        if (checker == null) continue;
                        checker.check(ctx, (SystemStatusCtrolCollection)objCol);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (InstantiationException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (EASDBException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        int count = objCol.size();
        for (int i = 0; i < count; ++i) {
            SystemStatusCtrolInfo oldInfo;
            SystemStatusCtrolInfo info = (SystemStatusCtrolInfo)objCol.getObject(i);
            if (info.getId() != null && (oldInfo = this.getSystemStatusCtrolInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))).isIsStart()) {
                info.setStartPeriod(oldInfo.getStartPeriod());
                info.setCurrentPeriod(oldInfo.getCurrentPeriod());
            }
            this._submit(ctx, (IObjectValue)info);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return EASResource.getString((String)"com.kingdee.eas.basedata.assistant.astResource", (String)"SystemStatus");
    }

    @Override
    protected PeriodInfo _getCacheCurrentPeriod(Context ctx, int systemStatus, String companyID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FCurrentPeriodID from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FCompanyID=? ");
        sql.append(" and sysSta.FName=?");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, systemStatus});
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                String periodid;
                if (iRowSet.next() && (periodid = iRowSet.getString("FCurrentPeriodID")) != null && periodid.length() > 0) {
                    IPeriod iperiod = PeriodFactory.getLocalInstance(ctx);
                    return iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodid));
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
        return null;
    }

    @Override
    protected PeriodInfo _getStartPeriod(Context ctx, int systemStatus, String companyID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FStartPeriodID from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FCompanyID=?");
        sql.append(" and sysSta.FName=?");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, systemStatus});
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                String periodid;
                if (iRowSet.next() && (periodid = iRowSet.getString("FStartPeriodID")) != null && periodid.length() > 0) {
                    IPeriod iperiod = PeriodFactory.getLocalInstance(ctx);
                    return iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodid));
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
        return null;
    }

    @Override
    protected boolean _isClose(Context ctx, int systemStatus, String companyID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getLocalInstance(ctx);
        sql.append(" select sysStaCtr.fid from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FCompanyID='");
        sql.append(companyID);
        sql.append("'");
        sql.append(" and sysSta.FName=");
        sql.append(systemStatus);
        sql.append(" and sysStaCtr.FIsClosedAccount=1");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return iRowSet != null && iRowSet.size() > 0;
    }

    @Override
    protected boolean _isStart(Context ctx, int systemStatus, String companyID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getLocalInstance(ctx);
        sql.append(" select sysStaCtr.fid from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FCompanyID='");
        sql.append(companyID);
        sql.append("'");
        sql.append(" and sysSta.FName=");
        sql.append(systemStatus);
        sql.append(" and sysStaCtr.FIsStart=1");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return iRowSet != null && iRowSet.size() > 0;
    }

    @Override
    protected void _clearSystemStatusCtrolCache(Context ctx) throws BOSException {
    }

    @Override
    protected PeriodInfo _getProfitStartPeriod(Context ctx, int systemStatus, String profitCenterID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FStartPeriodID from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FProfitCenterID='");
        sql.append(profitCenterID);
        sql.append("'");
        sql.append(" and sysSta.FName=");
        sql.append(systemStatus);
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                String periodid;
                if (iRowSet.next() && (periodid = iRowSet.getString("FStartPeriodID")) != null && periodid.length() > 0) {
                    IPeriod iperiod = PeriodFactory.getLocalInstance(ctx);
                    return iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodid));
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
        return null;
    }

    @Override
    protected PeriodInfo _getProfitCurrentPeriod(Context ctx, int systemStatus, String profitCenterID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FCurrentPeriodID from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FProfitCenterID='");
        sql.append(profitCenterID);
        sql.append("'");
        sql.append(" and sysSta.FName=");
        sql.append(systemStatus);
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                String periodid;
                if (iRowSet.next() && (periodid = iRowSet.getString("FCurrentPeriodID")) != null && periodid.length() > 0) {
                    IPeriod iperiod = PeriodFactory.getLocalInstance(ctx);
                    return iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodid));
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
        return null;
    }

    @Override
    protected boolean _isProfitStart(Context ctx, int systemStatus, String profitCenterID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sysStaCtr.fid from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FProfitCenterID='");
        sql.append(profitCenterID);
        sql.append("'");
        sql.append(" and sysSta.FName=");
        sql.append(systemStatus);
        sql.append(" and sysStaCtr.FIsStart=1");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return iRowSet != null && iRowSet.size() > 0;
    }

    @Override
    protected boolean _isProfitClose(Context ctx, int systemStatus, String profitCenterID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sysStaCtr.fid from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FProfitCenterID='");
        sql.append(profitCenterID);
        sql.append("'");
        sql.append(" and sysSta.FName=");
        sql.append(systemStatus);
        sql.append(" and sysStaCtr.FIsClosedAccount=1");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return iRowSet != null && iRowSet.size() > 0;
    }

    @Override
    protected void _startProfit(Context ctx, SystemEnum systemName, IObjectValue profitCenter, boolean isStart) throws BOSException, EASBizException {
        this._start(ctx, systemName, profitCenter, isStart);
    }
}

