/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.OrgUnitInfo;
import com.kingdee.eas.basedata.assistant.WorkCalendarException;
import com.kingdee.eas.basedata.assistant.WorkCalendarInfo;
import com.kingdee.eas.basedata.assistant.app.AbstractWorkCalendarControllerBean;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class WorkCalendarControllerBean
extends AbstractWorkCalendarControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.assistant.app.WorkCalendarControllerBean");
    private Map workCalendarTimeCache = new HashMap();
    private int WORKTIMEPRESICION = 2;

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        WorkCalendarInfo info = (WorkCalendarInfo)model;
        this.checkAll(ctx, info);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WorkCalendarInfo info = (WorkCalendarInfo)model;
        this.checkAll(ctx, info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        WorkCalendarInfo info = (WorkCalendarInfo)model;
        this.checkAll(ctx, info);
        super._update(ctx, pk, model);
    }

    private void checkAll(Context ctx, WorkCalendarInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        this.checkName(ctx, info);
        this.checkNumber(ctx, info);
        this.checkIntegrity(info);
        if (info.getHourOfHalfWorkDate() > info.getHourOfWorkDate()) {
            throw new WorkCalendarException(WorkCalendarException.WORKDAYHOURS_INVALID);
        }
    }

    private void checkName(Context ctx, WorkCalendarInfo info) throws BOSException, EASBizException {
        if (info.getName() == null || info.getName().equals("")) {
            throw new WorkCalendarException(WorkCalendarException.WORKCALENDARNAME_ISNULL);
        }
        this._checkNameDup(ctx, (IObjectValue)info);
    }

    private void checkNumber(Context ctx, WorkCalendarInfo info) throws BOSException, EASBizException {
        if (info.getNumber() == null || info.getNumber().equals("")) {
            throw new WorkCalendarException(WorkCalendarException.WORKCALENDARNUMBER_ISNULL);
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
    }

    private void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WorkCalendarInfo dataBaseInfo = (WorkCalendarInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    private void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WorkCalendarInfo dataBaseInfo = (WorkCalendarInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getFilterForCheckNumber(model) != null && this.getFilterForCheckNumber(model).size() > 0) {
            filter.mergeFilter(this.getFilterForCheckNumber(model), "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    private FilterInfo getFilterForCheckNumber(IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        ObjectBaseInfo info = (ObjectBaseInfo)model;
        if (info.getCU() == null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)super.getCU(ContextUtils.getContextFromSession(), info).getId().toString(), CompareType.EQUALS));
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    private String _getPropertyAlias(Context ctx, ObjectBaseInfo dataBaseInfo, String propertyName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(dataBaseInfo.getBOSType());
        PropertyInfo property = null;
        property = entity.getPropertyByName(propertyName);
        if (property == null) {
            return "";
        }
        return property.getAlias();
    }

    private void checkIntegrity(WorkCalendarInfo info) throws EASBizException {
        if (info.getStartWorkDate() == null || info.getStartWorkDate().toString().equals("")) {
            throw new WorkCalendarException(WorkCalendarException.STARTWORKDATE_ISNULL);
        }
        if (info.getEndWorkDate() == null || info.getEndWorkDate().toString().equals("")) {
            throw new WorkCalendarException(WorkCalendarException.ENDWORKDATE_ISNULL);
        }
        if (info.getHourOfHalfWorkDate() == 0.0) {
            throw new WorkCalendarException(WorkCalendarException.HOURHALFWORKDATE_ISNULL);
        }
        if (info.getHourOfWorkDate() == 0.0) {
            throw new WorkCalendarException(WorkCalendarException.HOURWORKDATE_ISNULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected OrgUnitInfo[] _getOrgUnitCollection(Context ctx) throws BOSException, WorkCalendarException {
        String postfix = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer("SELECT FID as orgUnitID,FName_" + postfix + " as orgUnitName,FParentID as parentID,FIsLeaf as isLeaf,FLevel as orgUnitLevel").append(" FROM T_ORG_Admin AS orga ORDER BY orgUnitLevel");
        IRowSet rs = null;
        ArrayList<OrgUnitInfo> result = new ArrayList<OrgUnitInfo>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            OrgUnitInfo info = null;
            while (rs.next()) {
                info = new OrgUnitInfo();
                info.setOrgUnitID(rs.getString("orgUnitID"));
                info.setOrgUnitName(rs.getString("orgUnitName"));
                info.setParentID(rs.getString("parentID"));
                info.setIsLeaf(rs.getString("isLeaf"));
                info.setOrgUnitLevel(rs.getString("orgUnitLevel"));
                result.add(info);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (SQLException e2) {
            logger.error((Object)e2);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return result.toArray(new OrgUnitInfo[0]);
    }

    protected WorkCalendarInfo _getOrgUnitWorkCalendar(Context ctx, String orgUnitID) throws BOSException, WorkCalendarException {
        String oql = "select * where orgUnit = '" + orgUnitID + "'";
        try {
            return (WorkCalendarInfo)this._getValue(ctx, oql);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _isWorkDay(Context ctx, String orgUnitID, boolean isCastBack, Date d) throws BOSException, WorkCalendarException {
        StringBuffer kSql = new StringBuffer();
        if (!isCastBack) {
            return this._isWorkDayNoCastBack(ctx, orgUnitID, d);
        }
        String orgUnitLongNumber = "";
        kSql.setLength(0);
        kSql.append("select FLongNumber from T_Org_Admin where fid = '").append(orgUnitID).append("'");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
            if (rs.next()) {
                orgUnitLongNumber = rs.getString("FLongNumber");
            }
        }
        catch (BOSException e) {
            try {
                logger.error((Object)e);
                throw new WorkCalendarException(WorkCalendarException.ISWORKDAY_BOSFAIL);
                catch (SQLException e2) {
                    logger.error((Object)e2);
                    throw new WorkCalendarException(WorkCalendarException.ISWORKDAY_SQLFAIL);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return this._isWorkDayCastBack(ctx, orgUnitLongNumber, d);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _isWorkDayCastBack(Context ctx, String orgUnitLongNumber, Date d) throws BOSException, WorkCalendarException {
        IRowSet rs2;
        IRowSet rs;
        block7: {
            boolean bl;
            block8: {
                StringBuffer kSql = new StringBuffer();
                StringTokenizer tokenizer = new StringTokenizer(orgUnitLongNumber, "!", false);
                StringBuffer allOrgNumbers = new StringBuffer("(");
                while (tokenizer.hasMoreElements()) {
                    allOrgNumbers.append("'").append(tokenizer.nextToken()).append("',");
                }
                allOrgNumbers.deleteCharAt(allOrgNumbers.lastIndexOf(","));
                allOrgNumbers.append(")");
                kSql.setLength(0);
                kSql.append("select top 1 a.fid as fid from T_WorkCalendar a, T_Org_Admin b where a.FOrgUnitID = b.fid ").append("and ").append("b.fnumber in ").append(allOrgNumbers);
                rs = null;
                rs2 = null;
                rs = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
                if (!rs.next()) break block7;
                String fid = rs.getString("fid");
                kSql.setLength(0);
                Calendar cl = Calendar.getInstance();
                cl.setTime(d);
                String dStr = cl.get(1) + "-" + (cl.get(2) + 1) + "-" + cl.get(5);
                kSql.append("select distinct b.FDateType as dateType from T_WorkCalendar a, T_WorkCalendarDayEntry b  ").append(" where a.fid = b.FWorkCanlendarID  and a.fid  ='").append(fid).append("' and year(b.FWorkDate)=year(to_date('").append(dStr).append("'))").append("and dayofyear(b.FWorkDate) = dayofyear(to_date('").append(dStr).append("'))");
                rs2 = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
                if (!rs2.next()) break block7;
                int value = rs2.getInt("dateType");
                if (value == 1) break block8;
                boolean bl2 = false;
                SQLUtils.cleanup((ResultSet)rs);
                SQLUtils.cleanup((ResultSet)rs2);
                return bl2;
            }
            try {
                bl = true;
            }
            catch (BOSException e) {
                try {
                    logger.error((Object)e);
                    throw new WorkCalendarException(WorkCalendarException.ISWORKDAY_BOSFAIL);
                    catch (SQLException e2) {
                        logger.error((Object)e2);
                        throw new WorkCalendarException(WorkCalendarException.ISWORKDAY_SQLFAIL);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    SQLUtils.cleanup(rs2);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((ResultSet)rs2);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup(rs2);
        return this.isWorkDayBySysCalendar(d);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _isWorkDayNoCastBack(Context ctx, String orgUnitID, Date d) throws BOSException, WorkCalendarException {
        IRowSet rs;
        block6: {
            boolean bl;
            block7: {
                Calendar cl = Calendar.getInstance();
                cl.setTime(d);
                String dStr = cl.get(1) + "-" + (cl.get(2) + 1) + "-" + cl.get(5);
                StringBuffer kSql = new StringBuffer();
                kSql.append("select distinct b.FDateType as dateType from T_WorkCalendar a, T_WorkCalendarDayEntry b ").append(" where a.fid = b.FWorkCanlendarID  and a.FOrgUnitID ='").append(orgUnitID).append("' and year(b.FWorkDate)=year(to_date('").append(dStr).append("'))").append("and dayofyear(b.FWorkDate) = dayofyear(to_date('").append(dStr).append("'))");
                rs = null;
                rs = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
                if (!rs.next()) break block6;
                int value = rs.getInt("dateType");
                if (value == 1) break block7;
                boolean bl2 = false;
                SQLUtils.cleanup((ResultSet)rs);
                return bl2;
            }
            try {
                bl = true;
            }
            catch (BOSException e) {
                try {
                    logger.error((Object)e);
                    throw new WorkCalendarException(WorkCalendarException.ISWORKDAY_BOSFAIL);
                    catch (SQLException e2) {
                        logger.error((Object)e2);
                        throw new WorkCalendarException(WorkCalendarException.ISWORKDAY_SQLFAIL);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return this.isWorkDayBySysCalendar(d);
    }

    private boolean isWorkDayBySysCalendar(Date d) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        int value = cl.get(7);
        return value != 7 && value != 1;
    }

    @Override
    protected WorkCalendarInfo _getOrgUnitWorkCalendar(Context ctx, String orgUnitLongNumber, boolean isCastBack) throws BOSException, WorkCalendarException {
        return null;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer logBuf = new StringBuffer();
        if (this._exists(ctx, pk)) {
            WorkCalendarInfo vo = (WorkCalendarInfo)this._getValue(ctx, pk);
            if (vo.getNumber() != null && vo.getNumber().trim().length() != 0) {
                logBuf.append(vo.getNumber());
            }
            if (vo.getName() != null && vo.getName().trim().length() != 0) {
                if (logBuf.length() == 0) {
                    logBuf.append(vo.getName());
                } else {
                    logBuf.append(" ").append(vo.getName());
                }
            }
        }
        return logBuf.toString();
    }

    @Override
    protected BigDecimal _getWorkDays(Context ctx, String orgUnitId, Date startDate, Date endDate) throws BOSException, EASBizException {
        if (startDate == null || endDate == null || endDate.compareTo(startDate) <= 0) {
            throw new WorkCalendarException(WorkCalendarException.DATEERROR);
        }
        WorkCalendarInfo calendarInfo = this._getOrgUnitWorkCalendar(ctx, orgUnitId);
        if (calendarInfo == null) {
            throw new WorkCalendarException(WorkCalendarException.NOTFOUND_ORG_CALENDAR);
        }
        BigDecimal workDays = new BigDecimal((endDate.getTime() - startDate.getTime()) / 86400000L + 1L);
        Calendar currentDate = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        currentDate.setTime(startDate);
        end.setTime(endDate);
        while (this.compareTime(currentDate, end) <= 0) {
            workDays = workDays.subtract(this.getDateType(ctx, calendarInfo, currentDate.getTime()));
            currentDate.set(5, currentDate.get(5) + 1);
        }
        return workDays;
    }

    private int compareTime(Calendar current, Calendar end) {
        return current.getTimeInMillis() > end.getTimeInMillis() ? 1 : (current.getTimeInMillis() == end.getTimeInMillis() ? 0 : -1);
    }

    private BigDecimal getDateType(Context ctx, WorkCalendarInfo calendarInfo, Date d) throws BOSException, EASBizException {
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        String dStr = cl.get(1) + "-" + (cl.get(2) + 1) + "-" + cl.get(5);
        String sql = "select FDateType,FID from T_WorkCalendarDayEntry where FWorkCanlendarID ='" + calendarInfo.getId().toString() + "'and year(FWorkDate)=year(to_date('" + dStr + "')) and dayofyear(FWorkDate) = dayofyear(to_date('" + dStr + "'))";
        IRowSet rs = null;
        int value = -1;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                value = rs.getInt("FDateType");
                if (value == 2 || value == 3) {
                    BigDecimal bigDecimal = new BigDecimal(1);
                    return bigDecimal;
                }
                if (value == 4) {
                    BigDecimal bigDecimal = new BigDecimal(0.5);
                    return bigDecimal;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (!this.isWorkDayBySysCalendar(calendarInfo, d) && value == -1) {
            return new BigDecimal(1);
        }
        return new BigDecimal(0);
    }

    private boolean isWorkDayBySysCalendar(WorkCalendarInfo calendarInfo, Date d) {
        String defaultWeekend = calendarInfo.getDefaultWeekend() == null ? "" : calendarInfo.getDefaultWeekend();
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        int value = cl.get(7);
        return defaultWeekend.indexOf(new Integer(value).toString()) < 0;
    }

    @Override
    protected List _distributeBatch(Context ctx, List infoList, IObjectValue workCalendarInfo) throws BOSException, EASBizException {
        ArrayList returnList = new ArrayList();
        ArrayList companyList = new ArrayList();
        ArrayList companyList2 = new ArrayList();
        for (int i = 0; i < infoList.size(); ++i) {
            WorkCalendarInfo dataBaseInfo = (WorkCalendarInfo)((WorkCalendarInfo)workCalendarInfo).clone();
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)infoList.get(i);
            String name = adminOrgUnitInfo.getName();
            String number = adminOrgUnitInfo.getNumber();
            dataBaseInfo.setId(null);
            dataBaseInfo.setOrgUnit(adminOrgUnitInfo.castToFullOrgUnitInfo());
            String newname = this.getName(ctx, name, number);
            String newnumber = this.getNumber(ctx, name, number);
            if (!this.checkNameAndNumberDup(ctx, newname, newnumber)) {
                dataBaseInfo.setName(newname);
                dataBaseInfo.setNumber(newnumber);
                boolean hasWorkCalendar = this.hasWorkCalendar(ctx, adminOrgUnitInfo.getId().toString());
                if (!hasWorkCalendar) {
                    this._addnew(ctx, (IObjectValue)dataBaseInfo);
                    continue;
                }
                companyList.add(infoList.get(i));
                continue;
            }
            companyList2.add(infoList.get(i));
        }
        returnList.add(companyList);
        returnList.add(companyList2);
        return returnList;
    }

    private boolean hasWorkCalendar(Context ctx, String orgUnitID) {
        WorkCalendarInfo info = null;
        try {
            String oql = " where orgUnit = '" + orgUnitID + "'";
            info = this.getWorkCalendarInfo(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            info = null;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return info != null;
    }

    public String getName(Context ctx, String name, String number) {
        WorkCalendarInfo info = null;
        try {
            String oql = " where name = '" + name + "'";
            info = this.getWorkCalendarInfo(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            info = null;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (info == null) {
            return name;
        }
        return number + name;
    }

    public boolean checkNameAndNumberDup(Context ctx, String name, String number) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)name.trim(), CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("number", (Object)number.trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem2);
        filter.setMaskString("#0 or #1");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    public String getNumber(Context ctx, String name, String number) {
        WorkCalendarInfo info = null;
        try {
            String oql = " where number = '" + number + "'";
            info = this.getWorkCalendarInfo(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            info = null;
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace());
        }
        return info == null ? number : number + name;
    }

    @Override
    protected long _getVersion(Context ctx, IObjectPK orgunit) throws BOSException, EASBizException {
        String sql = "select FVersion from t_workcalendar where FOrgUnitID = ?";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgunit.toString()});
        if (rowset != null && rowset.size() > 0) {
            try {
                if (rowset.next()) {
                    long version = rowset.getLong("FVersion");
                    return version;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getStackTrace());
            }
        }
        return 0L;
    }

    @Override
    protected BigDecimal _getWorkTime(Context ctx, String orgUnitId, Date startDate, Date endDate, boolean isNatureDay, int measureType) throws BOSException, EASBizException {
        BigDecimal totalHour;
        WorkCalendarInfo calendarInfo;
        block12: {
            Calendar end;
            Calendar start;
            Calendar currentDate;
            block10: {
                String workType;
                block11: {
                    if (startDate == null || endDate == null || endDate.compareTo(startDate) <= 0) {
                        throw new WorkCalendarException(WorkCalendarException.DATEERROR);
                    }
                    calendarInfo = this._getOrgUnitWorkCalendar(ctx, orgUnitId);
                    if (calendarInfo == null) {
                        throw new WorkCalendarException(WorkCalendarException.NOTFOUND_ORG_CALENDAR);
                    }
                    BigDecimal workDays = new BigDecimal((endDate.getTime() - startDate.getTime()) / 86400000L + 1L);
                    if (isNatureDay) {
                        if (measureType == 0) {
                            return this.getWorkTimePerDay(calendarInfo).multiply(workDays);
                        }
                        return workDays;
                    }
                    currentDate = Calendar.getInstance();
                    start = Calendar.getInstance();
                    end = Calendar.getInstance();
                    currentDate.setTime(startDate);
                    start.setTime(startDate);
                    end.setTime(endDate);
                    totalHour = new BigDecimal(0);
                    if (!this.compareSameDate(start, end)) break block10;
                    workType = this.getWorkTimeType(ctx, calendarInfo, currentDate.getTime());
                    if (!"workday".equals(workType)) break block11;
                    totalHour = totalHour.add(this.getRealWorkTime(start, calendarInfo).add(this.getWorkTimePerDay(calendarInfo).subtract(this.getRealWorkTime(end, calendarInfo))).subtract(this.getWorkTimePerDay(calendarInfo)));
                    break block12;
                }
                if (!"halfworkday".equals(workType)) break block12;
                totalHour = totalHour.add(this.getHalfRealWorkTime(start, calendarInfo).add(this.getWorkTimeHalfDay(calendarInfo).subtract(this.getHalfRealWorkTime(end, calendarInfo))).subtract(this.getWorkTimeHalfDay(calendarInfo)));
                break block12;
            }
            while (this.compareTime(currentDate, end) <= 0) {
                if (this.isWorkDayBySysCalendar(calendarInfo, currentDate.getTime())) {
                    String workType = this.getWorkTimeType(ctx, calendarInfo, currentDate.getTime());
                    if ("workday".equals(workType)) {
                        totalHour = this.compareSameDate(currentDate, start) ? totalHour.add(this.getRealWorkTime(currentDate, calendarInfo)) : (this.compareSameDate(currentDate, end) ? totalHour.add(this.getWorkTimePerDay(calendarInfo).subtract(this.getRealWorkTime(end, calendarInfo))) : totalHour.add(this.getWorkTimePerDay(ctx, calendarInfo, currentDate.getTime())));
                    } else if ("halfworkday".equals(workType)) {
                        totalHour = this.compareSameDate(currentDate, start) ? totalHour.add(this.getHalfRealWorkTime(currentDate, calendarInfo)) : (this.compareSameDate(currentDate, end) ? totalHour.add(this.getWorkTimeHalfDay(calendarInfo).subtract(this.getHalfRealWorkTime(end, calendarInfo))) : totalHour.add(this.getWorkTimeHalfDay(calendarInfo)));
                    }
                }
                currentDate.set(5, currentDate.get(5) + 1);
                if (this.compareTime(currentDate, end) <= 0 || !this.compareSameDate(currentDate, end)) continue;
                currentDate.setTime(endDate);
            }
        }
        if (measureType == 0) {
            return totalHour;
        }
        return totalHour.divide(this.getWorkTimePerDay(calendarInfo), this.WORKTIMEPRESICION, 4);
    }

    private BigDecimal getWorkTimePerDay(Context ctx, WorkCalendarInfo calendarInfo, Date d) throws BOSException, EASBizException {
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        String dStr = cl.get(1) + "-" + (cl.get(2) + 1) + "-" + cl.get(5);
        String sql = "select FDateType,FID from T_WorkCalendarDayEntry where FWorkCanlendarID ='" + calendarInfo.getId().toString() + "'and year(FWorkDate)=year(to_date('" + dStr + "')) and dayofyear(FWorkDate) = dayofyear(to_date('" + dStr + "'))";
        IRowSet rs = null;
        int value = -1;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                value = rs.getInt("FDateType");
                if (value == 2 || value == 3) {
                    BigDecimal bigDecimal = new BigDecimal(0);
                    return bigDecimal;
                }
                if (value == 1) {
                    BigDecimal bigDecimal = this.getWorkTimePerDay(calendarInfo);
                    return bigDecimal;
                }
                if (value == 4) {
                    BigDecimal bigDecimal = new BigDecimal(calendarInfo.getHourOfHalfWorkDate());
                    return bigDecimal;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (this.isWorkDayBySysCalendar(calendarInfo, d) && value == -1) {
            return this.getWorkTimePerDay(calendarInfo);
        }
        return new BigDecimal(0);
    }

    private String getWorkTimeType(Context ctx, WorkCalendarInfo calendarInfo, Date d) throws BOSException, EASBizException {
        String workType = null;
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        String dStr = cl.get(1) + "-" + (cl.get(2) + 1) + "-" + cl.get(5);
        String sql = "select FDateType,FID from T_WorkCalendarDayEntry where FWorkCanlendarID ='" + calendarInfo.getId().toString() + "'and year(FWorkDate)=year(to_date('" + dStr + "')) and dayofyear(FWorkDate) = dayofyear(to_date('" + dStr + "'))";
        IRowSet rs = null;
        int value = -1;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                value = rs.getInt("FDateType");
                if (value == 2 || value == 3) {
                    String string = "holiday";
                    return string;
                }
                if (value == 1) {
                    String string = "workday";
                    return string;
                }
                if (value == 4) {
                    String string = "halfworkday";
                    return string;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (this.isWorkDayBySysCalendar(calendarInfo, d) && value == -1) {
            return "workday";
        }
        return workType;
    }

    protected BigDecimal getWorkTimePerDay(WorkCalendarInfo calendarInfo) throws BOSException, EASBizException {
        if (this.workCalendarTimeCache.get(calendarInfo.getId()) != null) {
            return new BigDecimal(this.workCalendarTimeCache.get(calendarInfo.getId()).toString());
        }
        String beginTimeAM = calendarInfo.getBeginTimeAM();
        String beginTimePM = calendarInfo.getBeginTimePM();
        String endTimeAM = calendarInfo.getEndTimeAM();
        String endTimePM = calendarInfo.getEndTimePM();
        BigDecimal uptime = this.getWorkTime(beginTimeAM, endTimeAM);
        BigDecimal downtime = this.getWorkTime(beginTimePM, endTimePM);
        BigDecimal retVal = uptime.add(downtime);
        this.workCalendarTimeCache.put(calendarInfo.getId(), retVal);
        return retVal;
    }

    protected BigDecimal getWorkTimeHalfDay(WorkCalendarInfo calendarInfo) throws BOSException, EASBizException {
        String beginTimeAM = calendarInfo.getBeginTimeAM();
        String endTimeAM = calendarInfo.getEndTimeAM();
        BigDecimal uptime = this.getWorkTime(beginTimeAM, endTimeAM);
        return uptime;
    }

    protected BigDecimal getWorkTime(String beginTime, String endTime) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)beginTime) && !StringUtils.isEmpty((String)endTime)) {
            try {
                String[] values1 = StringUtil.split((String)beginTime, (String)"-");
                String[] values2 = StringUtil.split((String)endTime, (String)"-");
                int hour = Integer.parseInt(values2[0]) - Integer.parseInt(values1[0]);
                int min = Integer.parseInt(values2[1]) - Integer.parseInt(values1[1]);
                if (min < 0) {
                    --hour;
                    min = 60 + min;
                }
                int total = 60 * hour + min;
                BigDecimal retValue = new BigDecimal(total);
                retValue = retValue.divide(new BigDecimal(60), this.WORKTIMEPRESICION, 4);
                return retValue;
            }
            catch (Exception e) {
                throw new WorkCalendarException(WorkCalendarException.WORKTIMECHECK);
            }
        }
        return new BigDecimal(0);
    }

    private boolean compareSameDate(Calendar currentDate, Calendar compareDate) {
        int curYear = currentDate.get(1);
        int curMonth = currentDate.get(2);
        int curDay = currentDate.get(5);
        int comYear = compareDate.get(1);
        int comMonth = compareDate.get(2);
        int comDay = compareDate.get(5);
        return curYear == comYear && curMonth == comMonth && curDay == comDay;
    }

    private BigDecimal getRealWorkTime(Calendar currentDate, WorkCalendarInfo calendarInfo) {
        BigDecimal realWorkTime;
        block8: {
            realWorkTime = null;
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            int currentHour = currentDate.get(11);
            int currentMinute = currentDate.get(12);
            String beginTimeAM = calendarInfo.getBeginTimeAM();
            String endTimeAM = calendarInfo.getEndTimeAM();
            String beginTimePM = calendarInfo.getBeginTimePM();
            String endTimePM = calendarInfo.getEndTimePM();
            try {
                Date currentTime = sdf.parse(String.valueOf(currentHour + ":" + currentMinute));
                String[] valuesBA = StringUtil.split((String)beginTimeAM, (String)"-");
                Date bTimeAM = sdf.parse(String.valueOf(valuesBA[0] + ":" + valuesBA[1]));
                String[] valuesEA = StringUtil.split((String)endTimeAM, (String)"-");
                Date eTimeAM = sdf.parse(String.valueOf(valuesEA[0] + ":" + valuesEA[1]));
                String[] valuesBP = StringUtil.split((String)beginTimePM, (String)"-");
                Date bTimePM = sdf.parse(String.valueOf(valuesBP[0] + ":" + valuesBP[1]));
                String[] valuesEP = StringUtil.split((String)endTimePM, (String)"-");
                Date eTimePM = sdf.parse(String.valueOf(valuesEP[0] + ":" + valuesEP[1]));
                if (currentTime.before(bTimeAM)) {
                    realWorkTime = this.getWorkTimePerDay(calendarInfo);
                    break block8;
                }
                if (currentTime.before(eTimeAM)) {
                    realWorkTime = this.getWorkTimePerDay(calendarInfo).subtract(this.differ(bTimeAM, currentTime));
                    break block8;
                }
                if (currentTime.before(bTimePM)) {
                    realWorkTime = this.differ(bTimePM, eTimePM);
                    break block8;
                }
                if (currentTime.before(eTimePM)) {
                    realWorkTime = this.differ(currentTime, eTimePM);
                    break block8;
                }
                return new BigDecimal(0);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return realWorkTime;
    }

    private BigDecimal getHalfRealWorkTime(Calendar currentDate, WorkCalendarInfo calendarInfo) {
        BigDecimal realWorkTime;
        block6: {
            realWorkTime = null;
            DateFormat sdf = BOSLocaleUtil.getDateFormat();
            int currentHour = currentDate.get(11);
            int currentMinute = currentDate.get(12);
            String beginTimeAM = calendarInfo.getBeginTimeAM();
            String endTimeAM = calendarInfo.getEndTimeAM();
            try {
                Date currentTime = sdf.parse(String.valueOf(currentHour + ":" + currentMinute));
                String[] valuesBA = StringUtil.split((String)beginTimeAM, (String)"-");
                Date bTimeAM = sdf.parse(String.valueOf(valuesBA[0] + ":" + valuesBA[1]));
                String[] valuesEA = StringUtil.split((String)endTimeAM, (String)"-");
                Date eTimeAM = sdf.parse(String.valueOf(valuesEA[0] + ":" + valuesEA[1]));
                if (currentTime.before(bTimeAM)) {
                    realWorkTime = this.getWorkTimeHalfDay(calendarInfo);
                    break block6;
                }
                if (currentTime.before(eTimeAM)) {
                    realWorkTime = this.getWorkTimeHalfDay(calendarInfo).subtract(this.differ(bTimeAM, currentTime));
                    break block6;
                }
                return new BigDecimal(0);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return realWorkTime;
    }

    public BigDecimal differ(Date frontDate, Date afterDate) {
        long front = frontDate.getTime();
        long after = afterDate.getTime();
        Long fDate = new Long(front);
        Long aDate = new Long(after);
        BigDecimal bigFrontDate = new BigDecimal(fDate.toString());
        BigDecimal bigAfterDate = new BigDecimal(aDate.toString());
        BigDecimal subDate = bigAfterDate.subtract(bigFrontDate).divide(new BigDecimal(3600000), 2, 4);
        return subDate;
    }
}

