/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CommonPrintIntegrationDataProvider
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger(CommonPrintIntegrationDataProvider.class);
    private IMetaDataPK qpk = null;
    private String bosType = "";

    public CommonPrintIntegrationDataProvider(String bosType, IMetaDataPK qpk) {
        this.bosType = bosType;
        this.qpk = qpk;
        logger.info((Object)("current bostype :>>" + bosType));
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        logger.info((Object)"get print info resultset!");
        try {
            ArrayList list = ds.getParams();
            Variant bid = null;
            if (list.size() > 0) {
                DSParam param = (DSParam)list.get(0);
                bid = param.getValue();
            }
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.qpk);
            exec.option().isAutoTranslateEnum = true;
            exec.option().isAutoTranslateBoolean = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("printBosType", (Object)this.bosType, CompareType.EQUALS));
            String billID = bid != null ? bid.getValue().toString() : "";
            logger.info((Object)("par values:>>" + billID));
            filter.getFilterItems().add(new FilterItemInfo("printBillID", (Object)billID, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            ev.setFilter(filter);
            exec.setObjectView(ev);
            rs = exec.executeQuery();
            if (rs.size() > 0) {
                while (rs.next()) {
                    int pnum = rs.getInt("printedNumber");
                    rs.updateInt(4, pnum + 1);
                }
                rs.beforeFirst();
            } else {
                String userName = ConfigMDUtil.isClient() ? SysContext.getSysContext().getCurrentUserInfo().getName() : ConfigMDUtil.getContext().getCaller().toString();
                Timestamp time = new Timestamp(System.currentTimeMillis());
                rs = this.createTempRowSet(1, userName, time);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rs;
    }

    public IRowSet createTempRowSet(int pnum, String username, Timestamp time) {
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(3);
            drs.setColInfo(1, "printedNumber", "printedNumber", 4, null);
            drs.setColInfo(2, "lastPrintUser.name", "lastPrintTime", 12, null);
            drs.setColInfo(3, "lastPrintTime", "lastPrintTime", 93, null);
            drs.moveToInsertRow();
            drs.updateInt("printedNumber", pnum);
            drs.updateString("lastPrintUser.name", username);
            drs.updateTimestamp("lastPrintTime", time);
            drs.insertRow();
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return drs;
    }

    public IMetaDataPK getQpk() {
        return this.qpk;
    }

    public void setQpk(IMetaDataPK qpk) {
        this.qpk = qpk;
    }

    public String getBosType() {
        return this.bosType;
    }

    public void setBosType(String bosType) {
        this.bosType = bosType;
    }
}

