/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.assistant.PrintIntegrationInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PrintIntegrationListener
implements IPrintActionListener {
    private KDNoteHelper appHlp = null;
    private Logger logger = Logger.getLogger(PrintIntegrationListener.class);
    private BOSObjectType bosType = null;
    private String tdPath = "";
    private String resourcePath = "";
    private boolean isEditUI = true;
    private List printList = null;

    public PrintIntegrationListener(KDNoteHelper appHlp, BOSObjectType bosType, List printList, String tdPath, String resourcePath, boolean isEditUI) {
        this.appHlp = appHlp;
        this.bosType = bosType;
        this.tdPath = tdPath;
        this.resourcePath = resourcePath;
        this.isEditUI = isEditUI;
        this.printList = printList;
    }

    public void beforePrint() {
        block14: {
            try {
                String curBosType;
                IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
                if (this.isEditUI) {
                    this.logger.info((Object)"EditUI Printing.....");
                    curBosType = this.getBosType();
                    String billID = this.getBillID();
                    int curNum = this.appHlp.getCopies();
                    PrintIntegrationInfo printInfo = pinfo.getBillPrintInfo(curBosType, billID);
                    if (printInfo != null) {
                        this.logger.info((Object)"Has PrintInfo....");
                        if (!this.isPrintable(printInfo, billID)) {
                            this.appHlp.diposePrint();
                            this.logger.info((Object)"Dispose current Print!");
                            return;
                        }
                        printInfo.setPrintedNumber(curNum + printInfo.getPrintedNumber());
                        printInfo.setLastPrintTime(new Timestamp(System.currentTimeMillis()));
                        printInfo.setLastPrintUser(SysContext.getSysContext().getCurrentUserInfo());
                        pinfo.save((CoreBaseInfo)printInfo);
                        this.logger.info((Object)(billID + " Bill Alreadey Printed Number:>>:" + printInfo.getPrintedNumber()));
                        this.logger.info((Object)"Update current print info..");
                    } else {
                        this.logger.info((Object)"No Print Info ,Will be init the Print Info...");
                        printInfo = new PrintIntegrationInfo();
                        if (!this.isPrintable(printInfo, billID)) {
                            this.appHlp.diposePrint();
                            return;
                        }
                        printInfo.setPrintBosType(curBosType);
                        printInfo.setPrintBillID(billID);
                        printInfo.setPrintedNumber(curNum);
                        printInfo.setLastPrintTime(new Timestamp(System.currentTimeMillis()));
                        printInfo.setLastPrintUser(SysContext.getSysContext().getCurrentUserInfo());
                        pinfo.addnew((CoreBaseInfo)printInfo);
                        this.logger.info((Object)(billID + " Bill Alreadey Printed Number:>>:" + printInfo.getPrintedNumber()));
                        this.logger.info((Object)"Print info inited!");
                    }
                    break block14;
                }
                this.logger.info((Object)"ListUI Printing...");
                curBosType = this.getBosType();
                int curNum = 1;
                ArrayList<PrintIntegrationInfo> updateList = new ArrayList<PrintIntegrationInfo>();
                List infoList = pinfo.getBillsPrintInfoByList(this.printList, curBosType);
                PrintIntegrationInfo tinfo = null;
                boolean ishas = false;
                for (int i = 0; i < this.printList.size(); ++i) {
                    ishas = false;
                    String printID = this.printList.get(i).toString();
                    for (int j = 0; j < infoList.size() && !ishas; ++j) {
                        tinfo = (PrintIntegrationInfo)infoList.get(j);
                        if (!printID.equals(tinfo.getPrintBillID())) continue;
                        this.logger.info((Object)(printID + " Has Print info"));
                        ishas = true;
                        if (!this.isPrintable(tinfo, printID)) {
                            this.appHlp.diposePrint();
                            this.logger.info((Object)"Dispose current print!");
                            return;
                        }
                        curNum = this.appHlp.getCopies();
                        tinfo.setPrintedNumber(tinfo.getPrintedNumber() + curNum);
                        tinfo.setLastPrintTime(new Timestamp(System.currentTimeMillis()));
                        tinfo.setLastPrintUser(SysContext.getSysContext().getCurrentUserInfo());
                        updateList.add(tinfo);
                        this.logger.info((Object)(printID + " bill will be init printed number:>>" + tinfo.getPrintedNumber()));
                    }
                    if (ishas) continue;
                    this.logger.info((Object)"No print Info ,Will be init print info!");
                    tinfo = new PrintIntegrationInfo();
                    tinfo.setPrintBillID(printID);
                    if (!this.isPrintable(tinfo, printID)) {
                        this.appHlp.diposePrint();
                        this.logger.info((Object)"stop current print!");
                        return;
                    }
                    curNum = this.appHlp.getCopies();
                    tinfo.setPrintBosType(curBosType);
                    tinfo.setPrintedNumber(curNum);
                    tinfo.setLastPrintTime(new Timestamp(System.currentTimeMillis()));
                    tinfo.setLastPrintUser(SysContext.getSysContext().getCurrentUserInfo());
                    updateList.add(tinfo);
                    this.logger.info((Object)(printID + " Bill will be init Printed Number:>>" + tinfo.getPrintedNumber()));
                }
                try {
                    boolean isupdate = pinfo.updateBillsPrintInfoByList(updateList);
                    if (isupdate) {
                        this.logger.info((Object)"current batch print success!");
                        break block14;
                    }
                    this.logger.info((Object)"batch update print info error!");
                }
                catch (Exception e) {
                    this.logger.error((Object)"print error,stop print");
                    String msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.error");
                    MsgBox.showWarning((String)msgInfo);
                    this.appHlp.diposePrint();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("printintegration error,error message is:>>" + e.getMessage()));
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.comerr"));
                this.appHlp.diposePrint();
            }
        }
        String operName = EASResource.getString((String)this.resourcePath, (String)"LOG_PRINT");
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)this.bosType, null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public String findControlPath(String path) throws KDRSException {
        this.logger.info((Object)("Current Find Path:>" + path));
        if (KDNoteHelper.isPrintTimesControllable((String)path) || "".equals(path)) {
            this.logger.info((Object)"Find Complent!");
            return path;
        }
        String tph = "";
        try {
            tph = path.substring(0, path.lastIndexOf("/"));
            this.logger.info((Object)("Parent Path:" + tph));
        }
        catch (Exception e) {
            this.logger.info((Object)"Find root path,no control path!!");
            tph = "";
        }
        return this.findControlPath(tph);
    }

    public boolean isPrintable(PrintIntegrationInfo info, String billID) throws KDRSException, BOSException {
        boolean isok = true;
        String tdPath = this.findControlPath(this.getTDFileName());
        this.logger.info((Object)("current print control path:>>" + tdPath));
        if (tdPath != null && tdPath.trim().length() > 0) {
            this.logger.info((Object)"start the print control!");
            KDNoteHelper noteHelper = new KDNoteHelper();
            int maxNum = noteHelper.getMaxPrintTimes2(tdPath);
            int curNum = this.appHlp.getCopies();
            int pnum = info.getPrintedNumber();
            this.logger.info((Object)("Max print number:>>" + maxNum));
            this.logger.info((Object)("Alreadey print number:>>" + pnum));
            this.logger.info((Object)("current print number:>>" + curNum));
            if (pnum >= maxNum) {
                IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
                String billNumber = pinfo.getBillNumberByBosType(this.getBosType(), billID);
                String msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo1");
                Object[] objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                MsgBox.showWarning((String)MessageFormat.format(msgInfo, objs));
                isok = false;
            } else if (curNum + pnum > maxNum) {
                IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
                String billNumber = pinfo.getBillNumberByBosType(this.getBosType(), billID);
                String msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo2");
                Object[] objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                MsgBox.showWarning((String)MessageFormat.format(msgInfo, objs));
                isok = false;
            }
        }
        return isok;
    }

    public String getTDFileName() {
        return this.tdPath;
    }

    public String getBosType() {
        return this.bosType.toString();
    }

    public String getBillID() {
        if (this.printList != null && this.printList.size() > 0) {
            return this.printList.get(0).toString();
        }
        return "";
    }

    public void beforePrintOrPreview() {
    }

    public void beforePreview() {
    }

    public void closePreview() {
    }
}

