/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.assistant.PrintIntegrationInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PrintIntegrationWebListener
implements IPrintActionListener {
    private KDNoteHelper appHlp = null;
    private Logger logger = Logger.getLogger(PrintIntegrationWebListener.class);
    private BOSObjectType bosType = null;
    private String tdPath = "";
    private String resourcePath = "";
    private boolean isEditUI = true;
    private List printList = null;

    public PrintIntegrationWebListener(KDNoteHelper appHlp, BOSObjectType bosType, List printList, String tdPath, String resourcePath, boolean isEditUI) {
        this.appHlp = appHlp;
        this.bosType = bosType;
        this.tdPath = tdPath;
        this.resourcePath = resourcePath;
        this.isEditUI = isEditUI;
        this.printList = printList;
    }

    public void beforePrint() {
        block10: {
            Context ctx = ConfigMDUtil.getContext();
            try {
                IPrintIntegration pinfo = null;
                pinfo = PrintIntegrationFactory.getLocalInstance(ctx);
                IUser user = UserFactory.getLocalInstance((Context)ctx);
                UserInfo currentUserInfo = user.getUserByID(ctx.getCaller());
                if (this.isEditUI) {
                    this.logger.info((Object)"EditUI Printing.....");
                    String curBosType = this.getBosType();
                    String billID = this.getBillID();
                    int curNum = 1;
                    PrintIntegrationInfo printInfo = pinfo.getBillPrintInfo(curBosType, billID);
                    if (printInfo != null) {
                        this.logger.info((Object)"Has PrintInfo....");
                        printInfo.setPrintedNumber(curNum + printInfo.getPrintedNumber());
                        printInfo.setLastPrintTime(new Timestamp(System.currentTimeMillis()));
                        printInfo.setLastPrintUser(currentUserInfo);
                        pinfo.save((CoreBaseInfo)printInfo);
                        this.logger.info((Object)(billID + " Bill Alreadey Printed Number:>>:" + printInfo.getPrintedNumber()));
                        this.logger.info((Object)"Update current print info..");
                    } else {
                        this.logger.info((Object)"No Print Info ,Will be init the Print Info...");
                        printInfo = new PrintIntegrationInfo();
                        printInfo.setPrintBosType(curBosType);
                        printInfo.setPrintBillID(billID);
                        printInfo.setPrintedNumber(curNum);
                        printInfo.setLastPrintTime(new Timestamp(System.currentTimeMillis()));
                        printInfo.setLastPrintUser(currentUserInfo);
                        pinfo.addnew((CoreBaseInfo)printInfo);
                        this.logger.info((Object)(billID + " Bill Alreadey Printed Number:>>:" + printInfo.getPrintedNumber()));
                        this.logger.info((Object)"Print info inited!");
                    }
                    break block10;
                }
                this.logger.info((Object)"ListUI Printing...");
                String curBosType = this.getBosType();
                int curNum = 1;
                ArrayList<PrintIntegrationInfo> updateList = new ArrayList<PrintIntegrationInfo>();
                List infoList = pinfo.getBillsPrintInfoByList(this.printList, curBosType);
                PrintIntegrationInfo tinfo = null;
                boolean ishas = false;
                for (int i = 0; i < this.printList.size(); ++i) {
                    ishas = false;
                    String printID = this.printList.get(i).toString();
                    for (int j = 0; j < infoList.size() && !ishas; ++j) {
                        tinfo = (PrintIntegrationInfo)infoList.get(j);
                        if (!printID.equals(tinfo.getPrintBillID())) continue;
                        this.logger.info((Object)(printID + " Has Print info"));
                        ishas = true;
                        tinfo.setPrintedNumber(tinfo.getPrintedNumber() + curNum);
                        tinfo.setLastPrintTime(new Timestamp(System.currentTimeMillis()));
                        tinfo.setLastPrintUser(currentUserInfo);
                        updateList.add(tinfo);
                        this.logger.info((Object)(printID + " bill will be init printed number:>>" + tinfo.getPrintedNumber()));
                    }
                    if (ishas) continue;
                    this.logger.info((Object)"No print Info ,Will be init print info!");
                    tinfo = new PrintIntegrationInfo();
                    tinfo.setPrintBillID(printID);
                    tinfo.setPrintBosType(curBosType);
                    tinfo.setPrintedNumber(curNum);
                    tinfo.setLastPrintTime(new Timestamp(System.currentTimeMillis()));
                    tinfo.setLastPrintUser(currentUserInfo);
                    updateList.add(tinfo);
                    this.logger.info((Object)(printID + " Bill will be init Printed Number:>>" + tinfo.getPrintedNumber()));
                }
                try {
                    boolean isupdate = pinfo.updateBillsPrintInfoByList(updateList);
                    if (isupdate) {
                        this.logger.info((Object)"current batch print success!");
                        break block10;
                    }
                    this.logger.info((Object)"batch update print info error!");
                }
                catch (Exception e) {
                    this.logger.error((Object)"\u66f4\u65b0\u6253\u5370\u6b21\u6570\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("printintegration error,error message is:>>" + e));
            }
        }
    }

    public String getTDFileName() {
        return this.tdPath;
    }

    public String getBosType() {
        return this.bosType.toString();
    }

    public String getBillID() {
        if (this.printList != null && this.printList.size() > 0) {
            return this.printList.get(0).toString();
        }
        return "";
    }

    public void beforePrintOrPreview() {
    }

    public void beforePreview() {
    }

    public void closePreview() {
    }
}

