/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ITimeZone;
import com.kingdee.eas.basedata.assistant.TimeZoneFactory;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import java.util.Date;

public class TimeZoneUtil {
    public static Date getLocalDate4OtherTimeZone(Context ctx, TimeZoneInfo tzInfo) throws Exception {
        if (tzInfo == null) {
            return new Date();
        }
        Date serverDate = SysUtil.getAppServerTime((Context)ctx);
        long timeDiff = (long)((double)serverDate.getTimezoneOffset() + tzInfo.getTimeDiff().getValue() * 60.0);
        Date ret = new Date(timeDiff * 60L * 1000L + serverDate.getTime());
        return ret;
    }

    private static ITimeZone getTimeZoneInterface(Context ctx) throws Exception {
        if (ctx == null) {
            return TimeZoneFactory.getRemoteInstance();
        }
        return TimeZoneFactory.getLocalInstance(ctx);
    }

    public static final TimeZoneInfo getServerTimeZoneInfo(Context ctx, SelectorItemCollection selector) throws BOSException, Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isdefault", (Object)1, CompareType.EQUALS));
        if (selector == null || selector.size() == 0) {
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
        } else if (selector != null || selector.size() > 0) {
            for (int i = 0; i < selector.size(); ++i) {
                viewInfo.getSelector().add(selector.get(i));
            }
        }
        viewInfo.setFilter(filterInfo);
        TimeZoneInfo tzInfo = null;
        CoreBaseCollection tzColl = TimeZoneUtil.getTimeZoneInterface(ctx).getCollection(viewInfo);
        if (tzColl != null && tzColl.size() > 0) {
            tzInfo = (TimeZoneInfo)tzColl.get(0);
        }
        return tzInfo;
    }

    public static Date getAppServerTime(Context ctx) throws EASBizException {
        return SysUtil.getAppServerTime((Context)ctx);
    }
}

