/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.auxacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.app.AsstActGroupDetail;
import com.kingdee.eas.basedata.master.auxacct.app.GLDatabaseCashe;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AssistUtil {
    private static Logger logger = Logger.getLogger((String)AssistUtil.class.getName());
    public static Locale l1 = new Locale("l1");
    public static Locale l2 = new Locale("l2");
    public static Locale l3 = new Locale("l3");

    public static void updateAssist(Context ctx, String pk, BOSObjectType type) throws BOSException {
        AssistUtil.updateAssist(ctx, pk, type, null);
    }

    public static void updateAssist(Context ctx, String pk, BOSObjectType type, String isGeneral) throws BOSException {
        GLDatabaseCashe.setValue(ctx, "database", pk, null);
        String mappingFilderName = AssistUtil.getAssistantHgField(ctx, type, isGeneral);
        if (mappingFilderName == null) {
            GLDatabaseCashe.clearCashe();
            return;
        }
        StringBuffer asstaccountSql = new StringBuffer();
        asstaccountSql.append(" select fasstaccountid ");
        asstaccountSql.append(" from t_bd_assistanthg ");
        asstaccountSql.append(" where ").append(mappingFilderName).append(" = ? ");
        asstaccountSql.append(" group by fasstaccountid  ");
        IRowSet asstaccountRowSet = DbUtil.executeQuery((Context)ctx, (String)asstaccountSql.toString(), (Object[])new Object[]{pk});
        try {
            while (asstaccountRowSet != null && asstaccountRowSet.next()) {
                String asstaccountid = asstaccountRowSet.getString("fasstaccountid");
                AssistUtil.updateHg(ctx, asstaccountid, mappingFilderName, pk);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SQLAccessException(e);
        }
    }

    public static void updateChildrenHgNumber(Context ctx, String pk, String oldLongnumber, BOSObjectType type, String isGeneral) throws BOSException {
        GLDatabaseCashe.setValue(ctx, "database", pk, null);
        String mappingFilderName = AssistUtil.getAssistantHgField(ctx, type, isGeneral);
        if (mappingFilderName == null) {
            GLDatabaseCashe.clearCashe();
            return;
        }
        BOSUuid id = BOSUuid.read((String)pk);
        IObjectValue value = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), (IObjectPK)new ObjectUuidPK(id));
        String bufferSql = "select fid from t_bd_assistanthg where " + mappingFilderName + "=?";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)bufferSql, (Object[])new Object[]{pk});
        if (set != null) {
            try {
                String asstHgId;
                String newLongnumber = ((TreeBaseInfo)value).getLongNumber().replace("!", ".");
                AssistUtil.replaceChildrenNames(ctx, pk, oldLongnumber, newLongnumber, mappingFilderName, "l2");
                AssistUtil.replaceChildrenNames(ctx, pk, oldLongnumber, newLongnumber, mappingFilderName, "l3");
                if (set.next()) {
                    asstHgId = set.getString("fid");
                    GLDatabaseCashe.setValue(ctx, "assistant", asstHgId, null);
                }
                while (set.next()) {
                    asstHgId = set.getString("fid");
                    GLDatabaseCashe.setValue(ctx, "assistant", asstHgId, null);
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    private static void replaceChildrenNames(Context ctx, String assttypeId, String oldStr, String newStr, String mappingFilderName, String loc) throws BOSException {
        if (!StringUtils.isEmpty((String)oldStr)) {
            oldStr = oldStr.replaceAll(";", "\\\\u003b");
        }
        if (!StringUtils.isEmpty((String)newStr)) {
            newStr = newStr.replaceAll(";", "\\\\u003b");
        }
        String dispalyname = "fDisplayNameGroup_" + loc;
        String longname = "flongNameGroup_" + loc;
        String longnumber = "fnumberGroup_" + loc;
        String sqlUpdate = "update t_bd_assistanthg set " + dispalyname + "= replace(" + dispalyname + ",'" + oldStr + "','" + newStr + "')," + longname + "= replace(" + longname + ",'" + oldStr + "','" + newStr + "')," + longnumber + "= replace(" + longnumber + ",'" + oldStr + "','" + newStr + "') where " + mappingFilderName + " ='" + assttypeId + "'";
        DbUtil.execute((Context)ctx, (String)sqlUpdate);
    }

    public static void updateChildrenHgName(Context ctx, String pk, TreeBaseInfo oldInfo, BOSObjectType type, String isGeneral) throws BOSException {
        GLDatabaseCashe.setValue(ctx, "database", pk, null);
        String mappingFilderName = AssistUtil.getAssistantHgField(ctx, type, isGeneral);
        if (mappingFilderName == null) {
            GLDatabaseCashe.clearCashe();
            return;
        }
        BOSUuid id = BOSUuid.read((String)pk);
        IObjectValue value = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), (IObjectPK)new ObjectUuidPK(id));
        String bufferSql = "select fid,fDisplayNameGroup_l2,fDisplayNameGroup_l3, flongNameGroup_l2,flongNameGroup_l3 from t_bd_assistanthg where " + mappingFilderName + "=?";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)bufferSql, (Object[])new Object[]{pk});
        if (set != null) {
            try {
                String asstHgId;
                AssistUtil.replaceChildrenNames(ctx, pk, oldInfo.getDisplayName(l2), ((TreeBaseInfo)value).getDisplayName(l2), mappingFilderName, "l2");
                AssistUtil.replaceChildrenNames(ctx, pk, oldInfo.getDisplayName(l3), ((TreeBaseInfo)value).getDisplayName(l3), mappingFilderName, "l3");
                if (set.next()) {
                    asstHgId = set.getString("fid");
                    GLDatabaseCashe.setValue(ctx, "assistant", asstHgId, null);
                }
                while (set.next()) {
                    asstHgId = set.getString("fid");
                    GLDatabaseCashe.setValue(ctx, "assistant", asstHgId, null);
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    private static void updateHg(Context ctx, String asstaccountid, String mappingFilderName, String asstacttypeid) throws BOSException {
        if (StringUtils.isEmpty((String)asstaccountid)) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.master.auxacct.AUXACCTAutoGenerateResource", (String)"21_AssistUtil", (Locale)ctx.getLocale()));
            return;
        }
        StringBuffer asstActGroupDetailSql = new StringBuffer();
        asstActGroupDetailSql.append(" select aagd.fseq, aat.fname_l1, aat.fname_l2, aat.fname_l3, aat.fnumber, aat.frealtiondataobject, aat.fmappingfieldname, aat.fgrouptablename, aat.fgroupmappingfieldname, aat.fuselongnumber");
        asstActGroupDetailSql.append(" from T_BD_AsstActGroupDetail aagd ");
        asstActGroupDetailSql.append(" left outer join T_BD_AsstActType aat on aat.fid = aagd.FASSTACTTYPEID ");
        asstActGroupDetailSql.append(" where aagd.FASSTACCOUNTID = ? ");
        asstActGroupDetailSql.append(" order by aagd.fseq");
        logger.info((Object)("asstActGroupDetailSql : " + asstActGroupDetailSql));
        IRowSet asstActGroupDetailRowSet = DbUtil.executeQuery((Context)ctx, (String)asstActGroupDetailSql.toString(), (Object[])new Object[]{asstaccountid});
        try {
            int lang;
            int i;
            AsstActGroupDetail asstActGroupDetail;
            boolean uselongnumber = false;
            ArrayList<AsstActGroupDetail> asstActGroupDetailList = new ArrayList<AsstActGroupDetail>();
            while (asstActGroupDetailRowSet != null && asstActGroupDetailRowSet.next()) {
                int seq = asstActGroupDetailRowSet.getInt("fseq");
                String name_l1 = asstActGroupDetailRowSet.getString("fname_l1");
                String name_l2 = asstActGroupDetailRowSet.getString("fname_l2");
                String name_l3 = asstActGroupDetailRowSet.getString("fname_l3");
                String number = asstActGroupDetailRowSet.getString("fnumber");
                String realtiondataobject = asstActGroupDetailRowSet.getString("frealtiondataobject");
                String mappingfieldname = asstActGroupDetailRowSet.getString("fmappingfieldname");
                String grouptablename = asstActGroupDetailRowSet.getString("fgrouptablename");
                String groupmappingfieldname = asstActGroupDetailRowSet.getString("fgroupmappingfieldname");
                uselongnumber = asstActGroupDetailRowSet.getBoolean("fuselongnumber");
                asstActGroupDetail = new AsstActGroupDetail(seq, name_l1, name_l2, name_l3, number, realtiondataobject, mappingfieldname, grouptablename, groupmappingfieldname, uselongnumber);
                asstActGroupDetailList.add(asstActGroupDetail);
            }
            StringBuffer longNameGroupSql = new StringBuffer();
            StringBuffer displayNameGroupSql = new StringBuffer();
            StringBuffer numberGroupSql = new StringBuffer();
            for (int lang2 = 1; lang2 <= 3; ++lang2) {
                for (i = 0; i < asstActGroupDetailList.size(); ++i) {
                    asstActGroupDetail = (AsstActGroupDetail)asstActGroupDetailList.get(i);
                    longNameGroupSql.append("'").append(asstActGroupDetail.getName()[lang2]).append(":'|| replace (asstAct" + i).append(".fname_l" + lang2 + ",';','\\u003b') ||';'||");
                    displayNameGroupSql.append("'").append(asstActGroupDetail.getName()[lang2]).append(":'|| replace(asstAct" + i).append(asstActGroupDetail.isUselongnumber() ? ".flongnumber" : ".fnumber").append(",'!','.')").append("|| '_!' ||");
                    if (!StringUtils.isEmpty((String)asstActGroupDetail.getGrouptablename())) {
                        displayNameGroupSql.append(" grp" + i).append(".fdisplayname_l" + lang2 + " || '_' ||");
                    }
                    displayNameGroupSql.append("''|| replace (asstAct" + i).append(AssistUtil.isExistsDisplayName(ctx, asstActGroupDetail, lang2) ? ".fdisplayname_l" : ".fname_l").append(lang2 + ",';','\\u003b') ||';'||");
                    numberGroupSql.append("'").append(asstActGroupDetail.getNumber()).append("_!").append(asstActGroupDetail.getName()[lang2]).append(":'|| replace(asstAct" + i).append(asstActGroupDetail.isUselongnumber() ? ".flongnumber" : ".fnumber").append(",'!','.')").append("|| '_!' ||").append(" replace (asstAct" + i).append(".fname_l" + lang2 + ",';','\\u003b') ||';'||");
                }
                longNameGroupSql.append("'' FLONGNAMEGROUP_L" + lang2 + ",");
                displayNameGroupSql.append("'' FDISPLAYNAMEGROUP_L" + lang2 + ",");
                numberGroupSql.append("'' FNUMBERGROUP_L" + lang2 + ",");
            }
            StringBuffer joinSql = new StringBuffer();
            for (i = 0; i < asstActGroupDetailList.size(); ++i) {
                asstActGroupDetail = (AsstActGroupDetail)asstActGroupDetailList.get(i);
                joinSql.append(" left outer join ").append(asstActGroupDetail.getRealtiondataobject()).append(" asstAct" + i).append(" on hg.").append(asstActGroupDetail.getMappingfieldname()).append("= asstAct" + i).append(".fid");
                if (StringUtils.isEmpty((String)asstActGroupDetail.getGrouptablename())) continue;
                joinSql.append(" left outer join ").append(asstActGroupDetail.getGrouptablename()).append(" grp" + i).append(" on grp" + i).append(".fid = asstAct" + i).append(".").append(asstActGroupDetail.getGroupmappingfieldname());
            }
            String assistantHGtmp = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("assistantHGtmp");
            StringBuffer createTempSql = new StringBuffer();
            createTempSql.append(" select hg.fid fid, ");
            createTempSql.append(longNameGroupSql);
            createTempSql.append(displayNameGroupSql);
            createTempSql.append(numberGroupSql);
            createTempSql.append("  hg.fasstaccountid fasstaccountid ");
            createTempSql.append(" into ").append(assistantHGtmp);
            createTempSql.append(" from t_bd_assistanthg hg ");
            createTempSql.append(joinSql);
            createTempSql.append(" where hg.fasstaccountid = '").append(asstaccountid).append("'");
            if (!StringUtils.isEmpty((String)mappingFilderName) && !StringUtils.isEmpty((String)asstacttypeid)) {
                createTempSql.append(" and hg.").append(mappingFilderName).append("= '").append(asstacttypeid).append("'");
            }
            logger.info((Object)("createTempSql : " + createTempSql));
            DbUtil.execute((Context)ctx, (String)createTempSql.toString());
            for (lang = 1; lang <= 3; ++lang) {
                StringBuffer updateLongNameGroupSql = new StringBuffer();
                updateLongNameGroupSql.append(" update t_bd_assistanthg  ");
                updateLongNameGroupSql.append(" set FLONGNAMEGROUP_L" + lang + " = (select FLONGNAMEGROUP_L" + lang + " from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                updateLongNameGroupSql.append(" where exists(select temp.fid from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                logger.info((Object)("updateLongNameGroupSql : " + updateLongNameGroupSql));
                DbUtil.execute((Context)ctx, (String)updateLongNameGroupSql.toString());
            }
            for (lang = 1; lang <= 3; ++lang) {
                StringBuffer updateDisplayNameGroupSql = new StringBuffer();
                updateDisplayNameGroupSql.append(" update t_bd_assistanthg ");
                updateDisplayNameGroupSql.append(" set FDISPLAYNAMEGROUP_L" + lang + " = (select FDISPLAYNAMEGROUP_L" + lang + " from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                updateDisplayNameGroupSql.append(" where exists(select temp.fid from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                logger.info((Object)("updateDisplayNameGroupSql : " + updateDisplayNameGroupSql));
                DbUtil.execute((Context)ctx, (String)updateDisplayNameGroupSql.toString());
            }
            for (lang = 1; lang <= 3; ++lang) {
                StringBuffer updateNumberGroupSql = new StringBuffer();
                updateNumberGroupSql.append(" update t_bd_assistanthg ");
                updateNumberGroupSql.append(" set FNUMBERGROUP_L" + lang + " = (select FNUMBERGROUP_L" + lang + " from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                updateNumberGroupSql.append(" where exists(select temp.fid from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                logger.info((Object)("updateNumberGroupSql : " + updateNumberGroupSql));
                DbUtil.execute((Context)ctx, (String)updateNumberGroupSql.toString());
            }
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTemporaryTableName(assistantHGtmp);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SQLAccessException(e);
        }
    }

    public static void updateAssist_BAK(Context ctx, String pk, BOSObjectType type, String isGeneral) throws BOSException {
        GLDatabaseCashe.setValue(ctx, "database", pk, null);
        String mappingFilderName = AssistUtil.getAssistantHgField(ctx, type, isGeneral);
        if (mappingFilderName == null) {
            GLDatabaseCashe.clearCashe();
            return;
        }
        AssistUtil.updateLongName(ctx, mappingFilderName, pk);
        BOSUuid id = BOSUuid.read((String)pk);
        IObjectValue value = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), (IObjectPK)new ObjectUuidPK(id));
        try {
            AssistUtil.updateHgNumber(ctx, value);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static boolean hasBizRefrence(Context ctx, String pk, BOSObjectType type) throws BOSException {
        if (pk == null) {
            return false;
        }
        String mappingFilderName = AssistUtil.getAssistantHgField(ctx, type, AssistUtil.findGroup(ctx, pk, type));
        if (mappingFilderName == null) {
            return false;
        }
        String bufferSql = "select fid from t_bd_assistanthg where " + mappingFilderName + "=?";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)bufferSql, (Object[])new Object[]{pk});
        IRowSet setAuto = null;
        try {
            AdminOrgUnitInfo parentAdmInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
            String sql = " select are.* from T_GL_AssistRepordEntry are inner join t_bd_asstacttype att on are.FAcctTypeID = att.fid   inner join t_pf_bosobject bb on att.FREALTIONDATAOBJECT = bb.ftablename   where (FAcctFromTo like ? or FAcctFromTo like ? or FAcctFromTo like ?) and bb.fbostype = ?";
            setAuto = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{parentAdmInfo.getNumber() + ":%", ":%" + parentAdmInfo.getNumber(), parentAdmInfo.getNumber(), type.toString()});
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        if (set != null) {
            try {
                String fid;
                boolean hasbusiness = false;
                while (set.next() && !(hasbusiness = AssistUtil.check(ctx, fid = set.getString("fid")))) {
                }
                return hasbusiness || setAuto != null && setAuto.next();
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SQLAccessException(e);
            }
        }
        if (setAuto != null) {
            try {
                return setAuto.next();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void updateBizDate(Context ctx, String pk, String parent, BOSObjectType type) throws BOSException {
        if (parent == null) {
            return;
        }
        GLDatabaseCashe.setValue(ctx, "database", pk, null);
        String mappingFilderName = AssistUtil.getAssistantHgField(ctx, type, AssistUtil.findGroup(ctx, pk, type));
        if (mappingFilderName == null) {
            return;
        }
        String updateSql = "update t_bd_assistanthg set " + mappingFilderName + "=? where " + mappingFilderName + "=? ";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{pk, parent});
        AssistUtil.updateLongName(ctx, mappingFilderName, pk);
        try {
            AdminOrgUnitInfo childAdmInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
            AdminOrgUnitInfo parentAdmInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(parent));
            String updateSqlOther = "update T_GL_AssistRepordEntry set FAcctFromTo=replace(FAcctFromTo,'" + parentAdmInfo.getNumber() + "','" + childAdmInfo.getNumber() + "') \r\n where  FAcctTypeID in (select att.fid from t_bd_asstacttype att inner join t_pf_bosobject bb on att.FREALTIONDATAOBJECT = bb.ftablename  where bb.fbostype = '" + type.toString() + "')  and (FAcctFromTo like '" + parentAdmInfo.getNumber() + ":%' or FAcctFromTo like '%:" + parentAdmInfo.getNumber() + "' or FAcctFromTo like '" + parentAdmInfo.getNumber() + "') ";
            DbUtil.execute((Context)ctx, (String)updateSqlOther);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private static String getAssistantHgField(Context ctx, BOSObjectType type, String groupid) throws BOSException {
        String tableName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type).getTable().getName();
        String selectSql = "select fmappingfieldname from t_bd_asstacttype where  frealtiondataobject=?";
        Object[] param = null;
        if (groupid != null) {
            selectSql = selectSql + " and fglasstacttypegrpid=? ";
            param = new Object[]{tableName, groupid};
        } else {
            param = new Object[]{tableName};
        }
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])param);
        String mappingFilderName = null;
        if (set != null) {
            try {
                if (set.next()) {
                    mappingFilderName = set.getString("fmappingfieldname");
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
        return mappingFilderName;
    }

    private static void updateLongName(Context ctx, String mappingFilderName, String assttypeId) throws BOSException {
        String bufferSql = "select fid from t_bd_assistanthg where " + mappingFilderName + "=?";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)bufferSql, (Object[])new Object[]{assttypeId});
        if (set != null) {
            try {
                if (set.next()) {
                    String asstHgId = set.getString("fid");
                    AssistUtil.replaceNames(ctx, assttypeId, asstHgId, mappingFilderName, "L2");
                    AssistUtil.replaceNames(ctx, assttypeId, asstHgId, mappingFilderName, "L3");
                    String mappingPropertyName = null;
                    if (mappingFilderName.startsWith("F") && mappingFilderName.endsWith("ID")) {
                        mappingPropertyName = mappingFilderName.substring(1);
                        mappingPropertyName = mappingPropertyName.substring(0, mappingFilderName.length() - 3);
                        GLDatabaseCashe.clearAssistCashe(ctx, mappingPropertyName, assttypeId);
                    } else {
                        GLDatabaseCashe.clearCashe(ctx, "assistant");
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    private static void replaceNames(Context ctx, String assttypeId, String asstHgId, String mappingFilderName, String loc) throws BOSException {
        String oldNameValue = AssistUtil.getOldNameValue(ctx, assttypeId, asstHgId, mappingFilderName, loc);
        String newNameValue = AssistUtil.getNewNameValue(ctx, assttypeId, asstHgId, mappingFilderName, loc);
        String dispalyname = "fDisplayNameGroup_" + loc;
        String longname = "flongNameGroup_" + loc;
        String longnumber = "fnumberGroup_" + loc;
        String sqlUpdate = "update t_bd_assistanthg set " + dispalyname + "= replace(" + dispalyname + ",'" + oldNameValue + "','" + newNameValue + "')," + longname + "= replace(" + longname + ",'" + oldNameValue + "','" + newNameValue + "')," + longnumber + "= replace(" + longnumber + ",'" + oldNameValue + "','" + newNameValue + "') where " + mappingFilderName + " ='" + assttypeId + "'";
        DbUtil.execute((Context)ctx, (String)sqlUpdate);
    }

    public static void updateAllAsttAccount(Context ctx, String pk) throws BOSException {
        AssistUtil.updateHg(ctx, pk, null, null);
    }

    public static void updateAllAsttAccount_BAK1(Context ctx, String pk) throws BOSException {
        StringBuffer asstActGroupDetailSql = new StringBuffer();
        asstActGroupDetailSql.append(" select aagd.fseq, aat.fname_l1, aat.fname_l2, aat.fname_l3, aat.fnumber, aat.frealtiondataobject, aat.fmappingfieldname, aat.fgrouptablename, aat.fgroupmappingfieldname ");
        asstActGroupDetailSql.append(" from T_BD_AsstActGroupDetail aagd ");
        asstActGroupDetailSql.append(" left outer join T_BD_AsstActType aat on aat.fid = aagd.FASSTACTTYPEID ");
        asstActGroupDetailSql.append(" where aagd.FASSTACCOUNTID = ? ");
        asstActGroupDetailSql.append(" order by aagd.fseq");
        logger.info((Object)("asstActGroupDetailSql : " + asstActGroupDetailSql));
        IRowSet asstActGroupDetailRowSet = DbUtil.executeQuery((Context)ctx, (String)asstActGroupDetailSql.toString(), (Object[])new Object[]{pk});
        try {
            int lang;
            int i;
            AsstActGroupDetail asstActGroupDetail;
            ArrayList<AsstActGroupDetail> asstActGroupDetailList = new ArrayList<AsstActGroupDetail>();
            while (asstActGroupDetailRowSet != null && asstActGroupDetailRowSet.next()) {
                int seq = asstActGroupDetailRowSet.getInt("fseq");
                String name_l1 = asstActGroupDetailRowSet.getString("fname_l1");
                String name_l2 = asstActGroupDetailRowSet.getString("fname_l2");
                String name_l3 = asstActGroupDetailRowSet.getString("fname_l3");
                String number = asstActGroupDetailRowSet.getString("fnumber");
                String realtiondataobject = asstActGroupDetailRowSet.getString("frealtiondataobject");
                String mappingfieldname = asstActGroupDetailRowSet.getString("fmappingfieldname");
                String grouptablename = asstActGroupDetailRowSet.getString("fgrouptablename");
                String groupmappingfieldname = asstActGroupDetailRowSet.getString("fgroupmappingfieldname");
                boolean uselongnumber = asstActGroupDetailRowSet.getBoolean("fuselongnumber");
                asstActGroupDetail = new AsstActGroupDetail(seq, name_l1, name_l2, name_l3, number, realtiondataobject, mappingfieldname, grouptablename, groupmappingfieldname, uselongnumber);
                asstActGroupDetailList.add(asstActGroupDetail);
            }
            StringBuffer longNameGroupSql = new StringBuffer();
            StringBuffer displayNameGroupSql = new StringBuffer();
            StringBuffer numberGroupSql = new StringBuffer();
            for (int lang2 = 1; lang2 <= 3; ++lang2) {
                for (i = 0; i < asstActGroupDetailList.size(); ++i) {
                    asstActGroupDetail = (AsstActGroupDetail)asstActGroupDetailList.get(i);
                    longNameGroupSql.append("'").append(asstActGroupDetail.getName()[lang2]).append(":'|| replace (asstAct" + i).append(".fname_l" + lang2 + ",';','\\u003b') ||';'||");
                    displayNameGroupSql.append("'").append(asstActGroupDetail.getName()[lang2]).append(":'|| asstAct" + i).append(".fnumber || '_' ||");
                    if (!StringUtils.isEmpty((String)asstActGroupDetail.getGrouptablename())) {
                        displayNameGroupSql.append(" grp" + i).append(".fdisplayname_l" + lang2 + " || '_' ||");
                    }
                    displayNameGroupSql.append("''|| replace (asstAct" + i).append(".fname_l" + lang2 + ",';','\\u003b') ||';'||");
                    numberGroupSql.append("'").append(asstActGroupDetail.getNumber()).append("_!").append(asstActGroupDetail.getName()[lang2]).append(":'|| asstAct" + i).append(".fnumber || '_!' ||").append(" replace (asstAct" + i).append(".fname_l" + lang2 + ",';','\\u003b') ||';'||");
                }
                longNameGroupSql.append("'' FLONGNAMEGROUP_L" + lang2 + ",");
                displayNameGroupSql.append("'' FDISPLAYNAMEGROUP_L" + lang2 + ",");
                numberGroupSql.append("'' FNUMBERGROUP_L" + lang2 + ",");
            }
            StringBuffer joinSql = new StringBuffer();
            for (i = 0; i < asstActGroupDetailList.size(); ++i) {
                asstActGroupDetail = (AsstActGroupDetail)asstActGroupDetailList.get(i);
                joinSql.append(" left outer join ").append(asstActGroupDetail.getRealtiondataobject()).append(" asstAct" + i).append(" on hg.").append(asstActGroupDetail.getMappingfieldname()).append("= asstAct" + i).append(".fid");
                if (StringUtils.isEmpty((String)asstActGroupDetail.getGrouptablename())) continue;
                joinSql.append(" left outer join ").append(asstActGroupDetail.getGrouptablename()).append(" grp" + i).append(" on grp" + i).append(".fid = asstAct" + i).append(".").append(asstActGroupDetail.getGroupmappingfieldname());
            }
            String assistantHGtmp = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("assistantHGtmp");
            StringBuffer createTempSql = new StringBuffer();
            createTempSql.append(" select hg.fid fid, ");
            createTempSql.append(longNameGroupSql);
            createTempSql.append(displayNameGroupSql);
            createTempSql.append(numberGroupSql);
            createTempSql.append("  hg.fasstaccountid fasstaccountid ");
            createTempSql.append(" into ").append(assistantHGtmp);
            createTempSql.append(" from t_bd_assistanthg hg ");
            createTempSql.append(joinSql);
            createTempSql.append(" where hg.fasstaccountid = '").append(pk).append("'");
            logger.info((Object)("createTempSql : " + createTempSql));
            DbUtil.execute((Context)ctx, (String)createTempSql.toString());
            for (lang = 1; lang <= 3; ++lang) {
                StringBuffer updateLongNameGroupSql = new StringBuffer();
                updateLongNameGroupSql.append(" update t_bd_assistanthg  ");
                updateLongNameGroupSql.append(" set FLONGNAMEGROUP_L" + lang + " = (select FLONGNAMEGROUP_L" + lang + " from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                updateLongNameGroupSql.append(" where exists(select temp.fid from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                logger.info((Object)("updateLongNameGroupSql : " + updateLongNameGroupSql));
                DbUtil.execute((Context)ctx, (String)updateLongNameGroupSql.toString());
            }
            for (lang = 1; lang <= 3; ++lang) {
                StringBuffer updateDisplayNameGroupSql = new StringBuffer();
                updateDisplayNameGroupSql.append(" update t_bd_assistanthg ");
                updateDisplayNameGroupSql.append(" set FDISPLAYNAMEGROUP_L" + lang + " = (select FDISPLAYNAMEGROUP_L" + lang + " from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                updateDisplayNameGroupSql.append(" where exists(select temp.fid from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                logger.info((Object)("updateDisplayNameGroupSql : " + updateDisplayNameGroupSql));
                DbUtil.execute((Context)ctx, (String)updateDisplayNameGroupSql.toString());
            }
            for (lang = 1; lang <= 3; ++lang) {
                StringBuffer updateNumberGroupSql = new StringBuffer();
                updateNumberGroupSql.append(" update t_bd_assistanthg ");
                updateNumberGroupSql.append(" set FNUMBERGROUP_L" + lang + " = (select FNUMBERGROUP_L" + lang + " from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                updateNumberGroupSql.append(" where exists(select temp.fid from " + assistantHGtmp + " temp where temp.fid = t_bd_assistanthg.fid) ");
                logger.info((Object)("updateNumberGroupSql : " + updateNumberGroupSql));
                DbUtil.execute((Context)ctx, (String)updateNumberGroupSql.toString());
            }
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTemporaryTableName(assistantHGtmp);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SQLAccessException(e);
        }
    }

    public static void updateAllAsttAccount_BAK(Context ctx, String pk) throws BOSException {
        String sqlSelect = "select Fid From t_bd_assistantHg where fasstaccountid=?";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlSelect, (Object[])new Object[]{pk});
        try {
            while (set.next()) {
                String id = set.getString("fid");
                AssistUtil._modify(ctx, id);
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
    }

    public static void _modify(Context ctx, String id) throws BOSException {
        ConfigurationItem item = Configuration.getInstance().getConfigItem("supportlanguage");
        if (item == null) {
            return;
        }
        Map properties = item.getProperties();
        if (properties == null || properties.size() <= 0) {
            return;
        }
        Iterator it = properties.keySet().iterator();
        String lanKey = null;
        String lanStr = null;
        while (it.hasNext()) {
            lanKey = (String)it.next();
            lanStr = lanKey.substring(0, lanKey.indexOf(35));
            AssistUtil._modify(ctx, id, lanStr);
        }
    }

    public static String getOldNameValue(Context ctx, String assttypeId, String asstHgId, String mappingFilderName, String loc) throws BOSException {
        String typeName = null;
        String longname = "flongNameGroup_" + loc;
        typeName = AssistUtil.getTypeName(ctx, asstHgId, mappingFilderName, loc);
        String sqlSelect = "select " + longname + " from t_bd_assistanthg where fid = ?";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlSelect, (Object[])new Object[]{asstHgId});
        try {
            if (set.next()) {
                String longName = set.getString(longname);
                if (longName.indexOf("'") >= 0) {
                    longName = longName.replaceAll("'", "''");
                }
                if (longName != null && longName.indexOf(";") >= 0 && longName.indexOf(":") >= 0 && typeName != null && longName.indexOf(typeName) != -1) {
                    return longName.substring(longName.indexOf(typeName) + typeName.length() + 1, longName.indexOf(59, longName.indexOf(typeName)) + 1);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        return null;
    }

    public static String getNewNameValue(Context ctx, String assttypeId, String asstHgId, String mappingFilderName, String loc) throws BOSException {
        String typeName = null;
        typeName = AssistUtil.getTypeName(ctx, asstHgId, mappingFilderName, loc);
        String sqlSelect = "select fasstaccountid from t_bd_assistanthg where fid = ?";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlSelect, (Object[])new Object[]{asstHgId});
        try {
            if (set.next()) {
                String asstacccountid = set.getString("fasstaccountid");
                AsstActTypeInfo info = (AsstActTypeInfo)AssistUtil._getDefaultAssitInfo(ctx, asstacccountid, asstHgId, loc);
                String newLongname = info.getString("assGrp");
                if (newLongname.indexOf("'") >= 0) {
                    newLongname = newLongname.replaceAll("'", "''");
                }
                if (newLongname != null && typeName != null) {
                    return newLongname.substring(newLongname.indexOf(typeName) + typeName.length() + 1, newLongname.indexOf(59, newLongname.indexOf(typeName)) + 1);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        return null;
    }

    private static String getTypeName(Context ctx, String asstHgId, String mappingFilderName, String loc) throws BOSException, SQLAccessException {
        String fnameloc = "FName_" + loc;
        String sqlSelect = "select a.fasstaccountid from t_bd_assistanthg a,t_bd_asstaccount b where a.fid=? and fasstaccountid=b.fid ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlSelect, (Object[])new Object[]{asstHgId});
        try {
            if (set != null && set.next()) {
                String accountid = set.getString("fasstaccountid");
                sqlSelect = "SELECT a." + fnameloc + ",FMAPPINGFIELDNAME FROM t_bd_asstacttype a ,t_bd_asstactgroupdetail b  WHERE a.fid=b.fasstacttypeid and b.fasstaccountid =? order by b.fseq ";
                IRowSet set2 = DbUtil.executeQuery((Context)ctx, (String)sqlSelect, (Object[])new Object[]{accountid});
                while (set2 != null && set2.next()) {
                    if (set2.getString("FMAPPINGFIELDNAME") == null || !set2.getString("FMAPPINGFIELDNAME").equalsIgnoreCase(mappingFilderName)) continue;
                    return set2.getString(fnameloc);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        return null;
    }

    public static void _modify(Context ctx, String id, String loc) throws BOSException {
        String dispalyname = "fDisplayNameGroup_" + loc;
        String longname = "flongNameGroup_" + loc;
        String longnumber = "fnumberGroup_" + loc;
        String sqlSelect = "select a.fid,a.fasstaccountid,a." + dispalyname + ",a." + longname + ",a." + longnumber + ",b.fcount from t_bd_assistanthg a,t_bd_asstaccount b where a.fid=? and fasstaccountid=b.fid ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlSelect, (Object[])new Object[]{id});
        if (set == null) {
            return;
        }
        String sqlUpdate = "update t_bd_assistanthg set  " + dispalyname + "=? , " + longnumber + "=?, " + longname + "=? ,fcount=? where fid=? ";
        try {
            if (set.next()) {
                String accountid = set.getString("fasstaccountid");
                String asstGrpid = set.getString("fid");
                String displayname_old = set.getString(dispalyname);
                String longname_old = set.getString(longname);
                String longnumber_old = set.getString(longnumber);
                int count = set.getInt("fcount");
                AsstActTypeInfo info = (AsstActTypeInfo)AssistUtil._getDefaultAssitInfo(ctx, accountid, asstGrpid, loc);
                AssistUtil.limitDisplayNameLength(info);
                String longnumber_new = info.getString("longnumber");
                String displayname_new = info.getString("longName");
                String longname_new = info.getString("assGrp");
                if (!((displayname_new == null || longname_new == null || displayname_old != null && displayname_old.equals(displayname_new) && longname_old != null && longname_old.equals(longname_new)) && longnumber_old != null && longnumber_old.equals(longnumber_new))) {
                    if (ctx.getLocale().toString().equalsIgnoreCase(loc) && (StringUtils.isEmpty((String)displayname_new) || StringUtils.isEmpty((String)longname_new) || StringUtils.isEmpty((String)longnumber_new))) {
                        throw new BOSException("hg name empty! " + asstGrpid + ", " + dispalyname + ":" + displayname_new + ", " + longname + ":" + longname_new + ", " + longnumber + ":" + longnumber_new);
                    }
                    DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{displayname_new, longnumber_new, longname_new, new Integer(count), asstGrpid});
                }
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
    }

    private static void limitDisplayNameLength(AsstActTypeInfo info) {
        String longNameGroup;
        String[] longNameGroupVar;
        String diplayNameGroup;
        String[] diplayNameGroupVar;
        String longNumberGroup = info.getString("longnumber");
        String[] longNumberGroupVar = StringUtils.split((String)longNumberGroup, (int)59);
        if (longNumberGroupVar != null && longNumberGroupVar.length > 2 && longNumberGroup.length() > 300) {
            int len = longNumberGroup.indexOf(59);
            longNumberGroup = longNumberGroup.substring(len + 1);
            info.put("longnumber", longNumberGroup);
            AssistUtil.limitDisplayNameLength(info);
        }
        if ((diplayNameGroupVar = StringUtils.split((String)(diplayNameGroup = info.getString("longName")), (int)59)) != null && diplayNameGroupVar.length > 2 && diplayNameGroup.length() > 400) {
            int len = diplayNameGroup.indexOf(59);
            diplayNameGroup = diplayNameGroup.substring(len + 1);
            info.put("longName", diplayNameGroup);
            AssistUtil.limitDisplayNameLength(info);
        }
        if ((longNameGroupVar = StringUtils.split((String)(longNameGroup = info.getString("assGrp")), (int)59)) != null && longNameGroupVar.length > 2 && longNameGroup.length() > 200) {
            int len = longNameGroup.indexOf(59);
            longNameGroup = longNameGroup.substring(len + 1);
            info.put("assGrp", longNameGroup);
            AssistUtil.limitDisplayNameLength(info);
        }
    }

    public static void limitDisplayNameLength(AssistantHGInfo info) {
        AssistUtil.limitDisplayNameLength(info, l1);
        AssistUtil.limitDisplayNameLength(info, l2);
        AssistUtil.limitDisplayNameLength(info, l3);
    }

    public static void limitDisplayNameLength(AssistantHGInfo info, Locale l) {
        int len;
        String displayName = info.getDisplayNameGroup(l);
        String[] displayNameVar = StringUtils.split((String)displayName, (int)59);
        if (displayNameVar != null && displayName.length() > 400) {
            if (displayNameVar.length > 1) {
                len = displayName.indexOf(59);
                displayName = displayName.substring(len + 1);
                info.setDisplayNameGroup(displayName, l);
                AssistUtil.limitDisplayNameLength(info, l);
            } else {
                displayName = displayName.substring(0, 400);
                info.setDisplayNameGroup(displayName, l);
            }
        }
        if ((displayNameVar = StringUtils.split((String)(displayName = info.getLongNameGroup(l)), (int)59)) != null && displayName.length() > 200) {
            if (displayNameVar.length > 1) {
                len = displayName.indexOf(59);
                displayName = displayName.substring(len + 1);
                info.setLongNameGroup(displayName, l);
                AssistUtil.limitDisplayNameLength(info, l);
            } else {
                displayName = displayName.substring(0, 200);
                info.setLongNameGroup(displayName, l);
            }
        }
        if ((displayNameVar = StringUtils.split((String)(displayName = info.getNumberGroup(l)), (int)59)) != null && displayName.length() > 300) {
            if (displayNameVar.length > 1) {
                len = displayName.indexOf(59);
                displayName = displayName.substring(len + 1);
                info.setNumberGroup(displayName, l);
                AssistUtil.limitDisplayNameLength(info, l);
            } else {
                displayName = displayName.substring(0, 300);
                info.setNumberGroup(displayName, l);
            }
        }
    }

    public static IObjectValue _getDefaultAssitInfo(Context ctx, String accountid, String asstGrpid, String loc) throws BOSException {
        String fnameloc = "FName_" + loc;
        AsstActTypeInfo vo = null;
        vo = new AsstActTypeInfo();
        String getCountSql = "select fcount from t_bd_asstaccount where fid=? ";
        String sql = "SELECT a.fid,a.fnumber,a." + fnameloc + ",a.fmappingfieldname,a.FUseLongNumber,a.frealtiondataobject,a.fgrouptablename,a.fgroupmappingfieldname,a.fismultilevel,a.FIsSelfAsstActaiatem\tFROM t_bd_asstacttype a ,t_bd_asstactgroupdetail b  WHERE a.fid=b.fasstacttypeid and b.fasstaccountid =? order by b.fseq ";
        String[] typeNumberGroup = null;
        String[] typeNameGroup = null;
        String[] dataNumberGroup = null;
        String[] dataNameGroup = null;
        String[] dataLongNameGroup = null;
        int count = 0;
        try {
            IRowSet r = DbUtil.executeQuery((Context)ctx, (String)getCountSql, (Object[])new Object[]{accountid});
            while (r != null && r.next()) {
                count = r.getInt("fcount");
            }
            typeNumberGroup = new String[count];
            typeNameGroup = new String[count];
            dataNumberGroup = new String[count];
            dataNameGroup = new String[count];
            dataLongNameGroup = new String[count];
            StringBuffer typeNumber = new StringBuffer();
            StringBuffer typeName = new StringBuffer();
            StringBuffer dataNumber = new StringBuffer();
            StringBuffer dataName = new StringBuffer();
            StringBuffer dataLongName = new StringBuffer();
            int groupCount = 0;
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accountid});
            while (rowset != null && rowset.next()) {
                String sql3;
                IRowSet rowset3;
                String asstNumber;
                typeNumber = new StringBuffer();
                typeName = new StringBuffer();
                dataNumber = new StringBuffer();
                dataName = new StringBuffer();
                dataLongName = new StringBuffer();
                String fnumber = rowset.getString("fnumber");
                String fname = rowset.getString(fnameloc);
                String fmappingfieldname = rowset.getString("fmappingfieldname");
                String frealtiondataobject = rowset.getString("frealtiondataobject");
                String fgrouptablename = rowset.getString("fgrouptablename");
                int fismultilevel = rowset.getInt("fismultilevel");
                int FIsSelfAsstActaiatem = rowset.getInt("FIsSelfAsstActaiatem");
                boolean useLongNumber = rowset.getBoolean("FUseLongNumber");
                typeNumber.append(fnumber);
                typeName.append(fname);
                if (fismultilevel == 0) {
                    String sql2 = "SELECT " + fmappingfieldname + " FROM t_bd_assistanthg WHERE fid =?";
                    IRowSet rowset2 = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{asstGrpid});
                    String asstName = null;
                    asstNumber = null;
                    if (rowset2 != null && rowset2.next()) {
                        String fid2 = rowset2.getString(fmappingfieldname);
                        String fnametemp = fnameloc;
                        if (fid2 != null && (rowset3 = DbUtil.executeQuery((Context)ctx, (String)(sql3 = "SELECT " + fnameloc + ",fnumber FROM " + frealtiondataobject + " WHERE fid=?"), (Object[])new Object[]{fid2})) != null && rowset3.next()) {
                            asstNumber = rowset3.getString("fnumber");
                            asstName = rowset3.getString(fnameloc);
                            if (!StringUtils.isEmpty((String)asstName)) {
                                asstName = asstName.replaceAll(";", "\\\\u003b");
                            }
                            dataNumber.append(asstNumber);
                            dataName.append(asstName);
                            dataLongName.append(asstName);
                        }
                        fnameloc = fnametemp;
                    }
                } else {
                    String fid2;
                    String fgroupmappingfieldname;
                    if (fgrouptablename == null) {
                        fgrouptablename = frealtiondataobject;
                    }
                    if ((fgroupmappingfieldname = rowset.getString("fgroupmappingfieldname")) == null) {
                        fgroupmappingfieldname = "fparentid";
                    }
                    String sql2 = "SELECT " + fmappingfieldname + " FROM t_bd_assistanthg WHERE fid =?";
                    IRowSet rowset2 = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{asstGrpid});
                    asstNumber = null;
                    String asstName = null;
                    if (rowset2 != null && rowset2.next() && (fid2 = rowset2.getString(fmappingfieldname)) != null) {
                        sql3 = "SELECT " + fnameloc + ", " + fgroupmappingfieldname + "," + (useLongNumber ? "FlongNumber fnumber" : "fnumber") + " FROM " + frealtiondataobject + " WHERE fid=?";
                        logger.debug((Object)(sql3 + " : " + fid2));
                        rowset3 = DbUtil.executeQuery((Context)ctx, (String)sql3, (Object[])new Object[]{fid2});
                        String groupid = null;
                        if (rowset3 != null && rowset3.next()) {
                            asstNumber = rowset3.getString("fnumber");
                            if (useLongNumber && asstNumber != null) {
                                asstNumber = asstNumber.replace('!', '.');
                            }
                            if (!StringUtils.isEmpty((String)(asstName = rowset3.getString(fnameloc)))) {
                                asstName = asstName.replaceAll(";", "\\\\u003b");
                            }
                            dataNumber.append(asstNumber);
                            dataName.append(asstName);
                            groupid = rowset3.getString(fgroupmappingfieldname);
                        }
                        fgroupmappingfieldname = "fparentid";
                        while (groupid != null) {
                            String sql4 = "SELECT " + fnameloc + ", " + fgroupmappingfieldname + " FROM " + fgrouptablename + " WHERE fid=?";
                            IRowSet rowset4 = DbUtil.executeQuery((Context)ctx, (String)sql4, (Object[])new Object[]{groupid});
                            String fparentid = groupid;
                            if (rowset4 != null && rowset4.next()) {
                                asstName = rowset4.getString(fnameloc) == null ? "_" + asstName : rowset4.getString(fnameloc).trim().replaceAll(";", "\\\\u003b") + "_" + asstName;
                                groupid = rowset4.getString(fgroupmappingfieldname);
                                if (!fparentid.equals(groupid)) continue;
                                break;
                            }
                            groupid = null;
                        }
                    }
                    dataLongName.append(asstName);
                }
                typeNumberGroup[groupCount] = typeNumber.toString();
                typeNameGroup[groupCount] = typeName.toString();
                dataNumberGroup[groupCount] = dataNumber.toString();
                dataNameGroup[groupCount] = dataName.toString();
                dataLongNameGroup[groupCount] = dataLongName.toString();
                ++groupCount;
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        vo.put("count", new Integer(count));
        vo.put("typeNumberGroup", typeNumberGroup);
        vo.put("typeNameGroup", typeNameGroup);
        vo.put("dataNumberGroup", dataNumberGroup);
        vo.put("dataNameGroup", dataNameGroup);
        vo.put("dataLongNameGroup", dataLongNameGroup);
        GLDatabaseCashe.setValue(ctx, "assistant", asstGrpid, vo);
        return AssistUtil.doWith(vo);
    }

    private static IObjectValue doWith(AsstActTypeInfo vo) {
        StringBuffer name = new StringBuffer();
        StringBuffer numberGroup = new StringBuffer();
        StringBuffer assGrp = new StringBuffer();
        StringBuffer assGrpNumber = new StringBuffer();
        StringBuffer asstFull = new StringBuffer();
        StringBuffer asstFullNumber = new StringBuffer();
        StringBuffer asstheadnumber = new StringBuffer();
        StringBuffer asstnumber = new StringBuffer();
        StringBuffer asstheadname = new StringBuffer();
        StringBuffer asstname = new StringBuffer();
        StringBuffer asstlevelname = new StringBuffer();
        StringBuffer asstLevelNameNumber = new StringBuffer();
        int count = (Integer)vo.get("count");
        String[] typeNumberGroup = (String[])vo.get("typeNumberGroup");
        String[] typeNameGroup = (String[])vo.get("typeNameGroup");
        String[] dataNumberGroup = (String[])vo.get("dataNumberGroup");
        String[] dataNameGroup = (String[])vo.get("dataNameGroup");
        String[] dataLongNameGroup = (String[])vo.get("dataLongNameGroup");
        for (int i = 0; i < count; ++i) {
            name.append(typeNameGroup[i]).append(":").append(dataNumberGroup[i]).append("_!").append(dataLongNameGroup[i]).append(";");
            numberGroup.append(typeNumberGroup[i]).append("_!").append(typeNameGroup[i]).append(":").append(dataNumberGroup[i]).append("_!").append(dataNameGroup[i]).append(";");
            assGrp.append(typeNameGroup[i]).append(":").append(dataNameGroup[i]).append(";");
            asstheadname.append(typeNameGroup[i]).append(":").append(dataNameGroup[i]).append(";");
            asstnumber.append(dataNumberGroup[i]).append(";");
            assGrpNumber.append(typeNameGroup[i]).append(":").append(dataNumberGroup[i]).append("_").append(dataNameGroup[i]).append(";");
            asstFull.append(typeNameGroup[i]).append(":").append(dataLongNameGroup[i]).append(";");
            asstname.append(dataNameGroup[i]).append(";");
            asstlevelname.append(dataLongNameGroup[i]).append(";");
            asstLevelNameNumber.append(dataNumberGroup[i]).append("_").append(dataLongNameGroup[i]).append(";");
            asstheadnumber.append(typeNameGroup[i]).append(":").append(dataNumberGroup[i]).append(";");
            asstFullNumber.append(typeNameGroup[i]).append(":").append(dataNumberGroup[i]).append("_").append(dataLongNameGroup[i]).append(";");
        }
        AsstActTypeInfo reInfo = new AsstActTypeInfo();
        reInfo.setName(name.toString());
        reInfo.setString("longName", name.toString());
        reInfo.setString("longNumber", numberGroup.toString());
        reInfo.setString("assGrp", assGrp.toString());
        reInfo.setString("assGrpNumber", assGrpNumber.toString());
        reInfo.setString("asstFull", asstFull.toString());
        reInfo.setString("asstFullNumber", asstFullNumber.toString());
        reInfo.setString("asstheadnumber", asstheadnumber.toString());
        reInfo.setString("asstnumber", asstnumber.toString());
        reInfo.setString("asstheadname", asstheadname.toString());
        reInfo.setString("asstname", asstname.toString());
        reInfo.setString("asstlevelname", asstlevelname.toString());
        reInfo.setString("asstLevelNameNumber", asstLevelNameNumber.toString());
        return reInfo;
    }

    private static boolean check(Context ctx, String id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        try {
            sql = new StringBuffer();
            sql.append(" select 1 where  \r\n");
            sql.append(" exists (select 1 from t_gl_initassistbalance where fassistgrpid=?)  \r\n");
            sql.append(" or exists (select 1 from t_gl_voucherassistrecord where fassgrpid=?)  \r\n");
            sql.append(" or exists (select 1 from t_gl_templatevoucherasstrecord where fassgrpid=?)  \r\n");
            sql.append(" or exists (select 1 from t_gl_cashflowrecord where fassgrpid=? and fvoucherid is not null)  \r\n");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id, id, id, id});
            return rowset != null && rowset.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String findGroup(Context ctx, String id, BOSObjectType type) throws BOSException {
        if (!"F90B0133".equals(type.toString())) {
            return null;
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select  fgroupid from t_bd_generalasstacttype where fid=? ");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
            if (rowset != null && rowset.next()) {
                return rowset.getString("fgroupid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static void updateHgNumber(Context ctx, IObjectValue newModel) throws BOSException, EASBizException {
        GLDatabaseCashe.setValue(ctx, "database", newModel.get("id").toString(), null);
        String mappingFieldName = null;
        String typeName_l2 = null;
        String typeName_l3 = null;
        String newNumber = null;
        String hgId = null;
        if (newModel instanceof GeneralAsstActTypeInfo) {
            GeneralAsstActTypeInfo newGeneralInfo = (GeneralAsstActTypeInfo)newModel;
            newNumber = newGeneralInfo.getLongNumber().replace('!', '.');
            mappingFieldName = AssistUtil.getAssistantHgField(ctx, newModel.getBOSType(), newGeneralInfo.getGroup().getId().toString());
        } else {
            newNumber = newModel.getString("number");
            mappingFieldName = AssistUtil.getAssistantHgField(ctx, newModel.getBOSType(), null);
        }
        if (mappingFieldName == null) {
            return;
        }
        String bufferSql = "select fid from t_bd_assistanthg where " + mappingFieldName + "=?";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)bufferSql, (Object[])new Object[]{newModel.get("id").toString()});
        try {
            if (set != null && set.size() > 0 && set.next()) {
                hgId = set.getString("fid");
                if (StringUtils.isEmpty((String)hgId)) {
                    return;
                }
            } else {
                return;
            }
            typeName_l2 = AssistUtil.getTypeName(ctx, hgId, mappingFieldName, "L2");
            typeName_l3 = AssistUtil.getTypeName(ctx, hgId, mappingFieldName, "L3");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (newNumber.indexOf("'") >= 0) {
            newNumber = newNumber.replaceAll("'", "''");
        }
        String newNumber_l2 = typeName_l2 + ":" + newNumber + "_";
        String newNumber_l3 = typeName_l3 + ":" + newNumber + "_";
        String oldNumber_l2 = AssistUtil.getOldNumber(ctx, hgId, typeName_l2, "L2") + "_";
        String oldNumber_l3 = AssistUtil.getOldNumber(ctx, hgId, typeName_l3, "L3") + "_";
        if (oldNumber_l2.indexOf("'") >= 0) {
            oldNumber_l2 = oldNumber_l2.replaceAll("'", "''");
        }
        if (oldNumber_l3.indexOf("'") >= 0) {
            oldNumber_l3 = oldNumber_l3.replaceAll("'", "''");
        }
        String sqlUpdate = "update t_bd_assistanthg set FDisplayNameGroup_l2 = replace(FDisplayNameGroup_l2,'" + oldNumber_l2 + "','" + newNumber_l2 + "'),FDisplayNameGroup_l3 = replace(FDisplayNameGroup_l3,'" + oldNumber_l3 + "','" + newNumber_l3 + "'),FNumberGroup_l2 = replace(FNumberGroup_l2,'" + oldNumber_l2 + "','" + newNumber_l2 + "'),FNumberGroup_l3 = replace(FNumberGroup_l3,'" + oldNumber_l3 + "','" + newNumber_l3 + "') where " + mappingFieldName + " ='" + newModel.getString("id").toString() + "'";
        DbUtil.execute((Context)ctx, (String)sqlUpdate);
    }

    private static String getOldNumber(Context ctx, String asstHgId, String typeName, String loc) throws BOSException {
        String displayname = "FDisplayNameGroup_" + loc;
        String sql = "select " + displayname + " from t_bd_assistanthg where fid=?";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{asstHgId});
        try {
            String name;
            if (row != null && row.size() > 0 && row.next() && !StringUtils.isEmpty((String)(name = row.getString(displayname))) && name.indexOf(typeName + ":") >= 0) {
                int fromIndex = name.indexOf(typeName + ":");
                return name.substring(fromIndex, name.indexOf("_", fromIndex));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return null;
    }

    public static void updateAssistByGroup(Context ctx, GeneralAsstActTypeGroupInfo newModel, GeneralAsstActTypeGroupInfo oldModel) throws BOSException, EASBizException {
        String sqlUpdate;
        String newName_l2 = newModel.getName(LocaleUtils.getLocale((String)"l2"));
        String newName_l3 = newModel.getName(LocaleUtils.getLocale((String)"l3"));
        String oldName_l2 = oldModel.getName(LocaleUtils.getLocale((String)"l2"));
        String oldName_l3 = oldModel.getName(LocaleUtils.getLocale((String)"l3"));
        String newNumber = newModel.getNumber();
        String oldNumber = oldModel.getNumber();
        if (StringUtils.isEmpty((String)oldNumber)) {
            return;
        }
        if (!oldModel.getNumber().equals(newModel.getNumber())) {
            sqlUpdate = "update t_bd_assistanthg set FNumberGroup_l2 = replace(FNumberGroup_l2,'" + oldNumber + "_','" + newNumber + "_'),FNumberGroup_l3 = replace(FNumberGroup_l3,'" + oldNumber + "_','" + newNumber + "_')where FNumberGroup_l2 like ? or FNumberGroup_l3 like ?";
            DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{oldNumber + "_%", oldNumber + "_%"});
            oldNumber = newNumber;
        }
        if (!oldModel.getName().equals(newModel.getName())) {
            sqlUpdate = "update t_bd_assistanthg set FLONGNAMEGROUP_L2 = replace(FLONGNAMEGROUP_L2,'" + oldName_l2 + ":','" + newName_l2 + ":'),FLONGNAMEGROUP_L3 = replace(FLONGNAMEGROUP_L2,'" + oldName_l3 + ":','" + newName_l3 + ":'),FDisplayNameGroup_l2 = replace(FDisplayNameGroup_l2,'" + oldName_l2 + ":','" + newName_l2 + ":'),FDisplayNameGroup_l3 = replace(FDisplayNameGroup_l3,'" + oldName_l3 + ":','" + newName_l3 + ":'),FNumberGroup_l2 = replace(FNumberGroup_l2,'" + oldName_l2 + ":','" + newName_l2 + ":'),FNumberGroup_l3 = replace(FNumberGroup_l3,'" + oldName_l3 + ":','" + newName_l3 + ":')where FNumberGroup_l2 like ? or FNumberGroup_l3 like ?";
            DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{oldNumber + "_%", oldNumber + "_%"});
        }
    }

    private static boolean isExistsDisplayName(Context ctx, AsstActGroupDetail asstActGroupDetail, int lang) throws BOSException {
        Connection cn = null;
        PreparedStatement stmt = null;
        boolean hasDisplayName = false;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            String realtiondataobject = asstActGroupDetail.getRealtiondataobject();
            String sql = "select * from KSQL_USERCOLUMNS where KSQL_COL_NAME =?\tand KSQL_COL_TABNAME='" + realtiondataobject.toUpperCase() + "'";
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, "FDISPLAYNAME_L" + lang);
            ResultSet rs = stmt.executeQuery();
            hasDisplayName = rs == null ? false : rs.next();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return hasDisplayName;
    }

    public static String semicolonConversion(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return "";
        }
        return name.replaceAll(";", "\\\\u003b");
    }
}

