/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.auxacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.HeadDetailException;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountReferenceCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountReferenceFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountReferenceInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeException;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccountReference;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.master.auxacct.app.AbstractAsstAccountControllerBean;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AsstAccountControllerBean
extends AbstractAsstAccountControllerBean {
    private static Logger logger = Logger.getLogger(AsstAccountControllerBean.class);
    private StringBuffer select;
    private StringBuffer where;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AsstAccountInfo asstAccountInfo = (AsstAccountInfo)model;
        ((ObjectBaseInfo)model).setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        if (((AsstAccountInfo)model).getCompany() == null) {
            ((AsstAccountInfo)model).setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        super._checkNameBlank(ctx, (IObjectValue)asstAccountInfo);
        super._checkNameDup(ctx, (IObjectValue)asstAccountInfo);
        super._checkNumberBlank(ctx, (IObjectValue)asstAccountInfo);
        super._checkNumberDup(ctx, (IObjectValue)asstAccountInfo);
        this.checkSelectAsstActType(ctx, (IObjectValue)asstAccountInfo);
        this.checkAsstActTypeDup(ctx, (IObjectValue)asstAccountInfo);
        this.checkAsstActTypeQty(ctx, (IObjectValue)asstAccountInfo);
        return super._addnew(ctx, (IObjectValue)asstAccountInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AsstAccountInfo asstAccountInfo = (AsstAccountInfo)model;
        IObjectPK asstAccountPK = pk;
        AsstAccountInfo oldAsstAccountInfo = this.getAsstAccountInfo(ctx, asstAccountPK);
        boolean isAsstActGpDtChanged = this.checkAsstActGpDtChanged(asstAccountInfo, oldAsstAccountInfo);
        if (isAsstActGpDtChanged) {
            this.checkIsRefByAccount(ctx, asstAccountInfo);
            this.checkIsRefByHg(ctx, asstAccountInfo);
            this.checkIsAsstIsRefed(ctx, asstAccountInfo);
        }
        ((ObjectBaseInfo)model).setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        if (((AsstAccountInfo)model).getCompany() == null) {
            ((AsstAccountInfo)model).setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        super._checkNameBlank(ctx, (IObjectValue)asstAccountInfo);
        super._checkNameDup(ctx, (IObjectValue)asstAccountInfo);
        super._checkNumberBlank(ctx, (IObjectValue)asstAccountInfo);
        super._checkNumberDup(ctx, (IObjectValue)asstAccountInfo);
        this.checkSelectAsstActType(ctx, (IObjectValue)asstAccountInfo);
        this.checkAsstActTypeDup(ctx, (IObjectValue)asstAccountInfo);
        this.checkAsstActTypeQty(ctx, (IObjectValue)asstAccountInfo);
        boolean isSameSeq = this.isSameSeq(ctx, pk, model);
        super._update(ctx, asstAccountPK, (IObjectValue)asstAccountInfo);
        if (!isSameSeq) {
            AssistUtil.updateAllAsttAccount(ctx, pk.toString());
        }
    }

    private boolean checkAsstActGpDtChanged(AsstAccountInfo asstAccountInfo, AsstAccountInfo oldAsstAccountInfo) {
        boolean isAsstActGpDtChanged = false;
        AsstActGroupDetailCollection asstActGroupDetailCollection = asstAccountInfo.getAsstActGpDt();
        AsstActGroupDetailCollection oldAsstActGroupDetailCollection = oldAsstAccountInfo.getAsstActGpDt();
        if (asstActGroupDetailCollection.size() != oldAsstActGroupDetailCollection.size()) {
            isAsstActGpDtChanged = true;
            return isAsstActGpDtChanged;
        }
        for (int i = 0; i < asstActGroupDetailCollection.size(); ++i) {
            AsstActGroupDetailInfo asstActGroupDetailInfo = asstActGroupDetailCollection.get(i);
            boolean isFind = false;
            for (int j = 0; j < oldAsstActGroupDetailCollection.size(); ++j) {
                AsstActGroupDetailInfo oldAsstActGroupDetailInfo = oldAsstActGroupDetailCollection.get(j);
                if (asstActGroupDetailInfo == null || asstActGroupDetailInfo.getAsstActType() == null || asstActGroupDetailInfo.getAsstActType().getId() == null || oldAsstActGroupDetailInfo == null || oldAsstActGroupDetailInfo.getAsstActType() == null || oldAsstActGroupDetailInfo.getAsstActType().getId() == null || !asstActGroupDetailInfo.getAsstActType().getId().equals((Object)oldAsstActGroupDetailInfo.getAsstActType().getId())) continue;
                isFind = true;
                break;
            }
            if (isFind) continue;
            isAsstActGpDtChanged = true;
            return isAsstActGpDtChanged;
        }
        return isAsstActGpDtChanged;
    }

    private boolean isSameSeq(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AsstAccountInfo asstAccountInfo = (AsstAccountInfo)model;
        AsstAccountInfo oldModel = this.getAsstAccountInfo(ctx, pk);
        AsstActGroupDetailCollection oldCol = oldModel.getAsstActGpDt();
        AsstActGroupDetailCollection newCol = asstAccountInfo.getAsstActGpDt();
        for (int i = 0; i < newCol.size(); ++i) {
            AsstActGroupDetailInfo detailInfo = newCol.get(i);
            if (detailInfo.getAsstActType() == null) continue;
            AsstActTypeInfo type = detailInfo.getAsstActType();
            for (int j = 0; j < oldCol.size(); ++j) {
                AsstActGroupDetailInfo oldDetailInfo = oldCol.get(j);
                if (oldDetailInfo.getAsstActType() == null) continue;
                AsstActTypeInfo oldType = oldDetailInfo.getAsstActType();
                if (!type.getId().toString().equals(oldType.getId().toString()) || detailInfo.getSeq() == oldDetailInfo.getSeq()) continue;
                return false;
            }
        }
        return true;
    }

    private void checkHasDeal(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AsstAccountInfo asstAccountInfo = (AsstAccountInfo)model;
        String id = asstAccountInfo.getId().toString();
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            RptRowSet rs = DBUtil.executeQuery((String)"select count(1) from t_bd_accountView where FCAA=?", (SqlParams)new SqlParams().addString(id), (Connection)con);
            rs.next();
            if (rs.getInt(0) > 0) {
                throw new AsstActTypeException(AsstActTypeException.CANNOTEDIT);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected void checkReferenced(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AsstAccountInfo asstAccountInfo = (AsstAccountInfo)model;
        BOSUuid id = BOSUuid.read((String)asstAccountInfo.getId().toString());
        if (BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)id).isFound()) {
            throw new BizReferenceException(BizReferenceException.BIZ_REFENCED);
        }
    }

    @Override
    public Vector _getAsstActTypeByGroup(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Vector<AsstActTypeInfo> vec = null;
        AsstAccountInfo model = new AsstAccountInfo();
        try {
            model = this.getAsstAccountInfo(ctx, pk);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("asstAccount", (Object)model.getId(), CompareType.EQUALS));
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("asstActType.*"));
        evi.getSelector().add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.*"));
        try {
            IAsstActGroupDetail iasstActGroupDt = AsstActGroupDetailFactory.getLocalInstance(ctx);
            AsstActGroupDetailCollection con = iasstActGroupDt.getAsstActGroupDetailCollection(evi);
            vec = new Vector<AsstActTypeInfo>(con.size());
            for (int i = 0; i < con.size(); ++i) {
                if (con.get(i).getAsstActType().getId() == null) continue;
                AsstActTypeInfo info = con.get(i).getAsstActType();
                vec.add(info);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return vec;
    }

    @Override
    protected boolean _compare(Context ctx, IObjectPK pk1, IObjectPK pk2) throws BOSException, EASBizException {
        StringBuffer checkSQL = new StringBuffer();
        checkSQL.append(" select aagdChild.FAsstAccountID from T_BD_AsstActGroupDetail aagdChild where ");
        checkSQL.append(" aagdChild.FAsstAccountID = ? and ");
        checkSQL.append(" aagdChild.FAsstActTypeID in ( ");
        checkSQL.append(" select aagdParent.FAsstActTypeID from T_BD_AsstActGroupDetail aagdParent where aagdParent.FAsstAccountID = ?) ");
        checkSQL.append(" group by aagdChild.FAsstAccountID ");
        checkSQL.append(" having count(*) = (select count(*) from T_BD_AsstActGroupDetail aagdParent where aagdParent.FAsstAccountID = ?) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString(), (Object[])new Object[]{pk2.toString(), pk1.toString(), pk1.toString()});
        try {
            return rowSet != null && rowSet.next();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean _compareBAK(Context ctx, IObjectPK pk1, IObjectPK pk2) throws BOSException, EASBizException {
        Vector srcVec = null;
        Vector destVec = null;
        if (pk1 == null && pk2 == null) {
            return true;
        }
        if (pk1 != null && pk2 == null) {
            return false;
        }
        if (pk1 == null && pk2 != null) {
            return true;
        }
        srcVec = this._getAsstActTypeByGroup(ctx, pk1);
        destVec = this._getAsstActTypeByGroup(ctx, pk2);
        return destVec.containsAll(srcVec);
    }

    private void checkSelectAsstActType(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int asstActTypeCount = 0;
        AsstAccountInfo asstAccountInfo = (AsstAccountInfo)model;
        AsstActGroupDetailCollection detailCollection = asstAccountInfo.getAsstActGpDt();
        for (int i = 0; i < detailCollection.size(); ++i) {
            AsstActGroupDetailInfo detailInfo = detailCollection.get(i);
            if (detailInfo.getAsstActType() != null) continue;
            ++asstActTypeCount;
        }
        if (asstActTypeCount == detailCollection.size()) {
            throw new AsstActTypeException(AsstActTypeException.SELECTASSTACTTYPE);
        }
    }

    private void checkAsstActTypeQty(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        AsstAccountInfo asstAccountInfo = (AsstAccountInfo)model;
        int count = 0;
        AsstActGroupDetailCollection detailCollection = asstAccountInfo.getAsstActGpDt();
        boolean isQty = false;
        MeasureUnitInfo unit = null;
        MeasureUnitGroupInfo unitGroup = null;
        for (int i = 0; i < detailCollection.size(); ++i) {
            AsstActTypeInfo type;
            AsstActGroupDetailInfo detailInfo = detailCollection.get(i);
            if (detailInfo.getAsstActType() == null || !(type = detailInfo.getAsstActType()).isIsQty()) continue;
            isQty = true;
            if (unit == null && unitGroup != null && type.getMeasureUnit() != null && type.getMeasureUnitGroup() == null || unit != null && unitGroup == null && type.getMeasureUnit() == null && type.getMeasureUnitGroup() != null) {
                throw new AsstActTypeException(AsstActTypeException.ASSTQTYNOTSAME, new Object[]{asstAccountInfo.getName()});
            }
            if (unit == null) {
                unit = type.getMeasureUnit();
            } else if (unit != null && type.getMeasureUnit() != null && !unit.getId().toString().equals(type.getMeasureUnit().getId().toString())) {
                throw new AsstActTypeException(AsstActTypeException.ASSTQTYNOTSAME, new Object[]{asstAccountInfo.getName()});
            }
            if (unitGroup == null) {
                unitGroup = type.getMeasureUnitGroup();
            } else if (unitGroup != null && type.getMeasureUnitGroup() != null && !unitGroup.getId().toString().equals(type.getMeasureUnitGroup().getId().toString())) {
                throw new AsstActTypeException(AsstActTypeException.ASSTQTYNOTSAME, new Object[]{asstAccountInfo.getName()});
            }
            ++count;
        }
        asstAccountInfo.setIsQty(isQty);
        asstAccountInfo.setMeasureUnit(unit);
        asstAccountInfo.setMeasureUnitGroup(unitGroup);
    }

    private void checkAsstActTypeDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        AsstAccountInfo asstAccountInfo = (AsstAccountInfo)model;
        int count = 0;
        AsstActGroupDetailCollection detailCollection = asstAccountInfo.getAsstActGpDt();
        Vector<BOSUuid> vec = new Vector<BOSUuid>();
        for (int i = 0; i < detailCollection.size(); ++i) {
            AsstActGroupDetailInfo detailInfo = detailCollection.get(i);
            if (detailInfo.getAsstActType() == null) continue;
            ++count;
            AsstActTypeInfo type = detailInfo.getAsstActType();
            vec.add(type.getId());
        }
        if (count >= 1) {
            StringBuffer sql = new StringBuffer();
            String returnSQL = "";
            sql.append("SELECT ");
            sql.append("A.FID ");
            sql.append(", ");
            sql.append("count(B.FID) ");
            sql.append("from T_BD_AsstAccount A, T_BD_AsstActGroupDetail B where");
            if (asstAccountInfo.getId() != null) {
                sql.append(" A.FID !='" + asstAccountInfo.getId().toString() + "' and \t");
            }
            sql.append(" A.FID = B.FAsstAccountID and A.FID in ");
            sql.append("( ");
            sql.append("select A.FID from ");
            this.buildFrom(count);
            this.buildWhere(count, vec);
            sql.append(this.select.toString());
            sql.append(this.where.toString());
            sql.append(") ");
            sql.append("group by A.FID ");
            JdbcRowSet rs = (JdbcRowSet)DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    String fid = rs.getString("FID");
                    int countSize = rs.getInt(2);
                    if (fid == null || countSize != count) continue;
                    AsstAccountInfo asstInfo = AsstAccountFactory.getLocalInstance(ctx).getAsstAccountInfo("select name,number where id ='" + fid + "'");
                    throw new AsstActTypeException(AsstActTypeException.ASSTACTTYPEDUP, new Object[]{" " + asstInfo.getName() + "(" + asstInfo.getNumber() + ") "});
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void buildFrom(int count) {
        this.select = new StringBuffer();
        this.select.append("T_BD_AsstAccount A ");
        for (int j = 1; j <= count; ++j) {
            this.select.append(", ");
            this.select.append(" T_BD_AsstActGroupDetail ");
            this.select.append("B" + j);
        }
    }

    private void buildWhere(int count, Vector vec) {
        this.where = new StringBuffer();
        this.where.append(" where ");
        for (int i = 1; i <= count; ++i) {
            this.where.append("A.FID ");
            this.where.append(" = ");
            this.where.append("B" + i + ".FAsstAccountID ");
            this.where.append("and ");
            this.where.append("B" + i + ".FAsstActTypeID ");
            this.where.append(" = ");
            this.where.append("'");
            this.where.append(vec.elementAt(i - 1));
            this.where.append("'");
            if (i == count) continue;
            this.where.append("and ");
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String id = pk.toString();
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("GAA.id", (Object)id, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("CAA.id", (Object)id, CompareType.EQUALS));
        filterInfo.setMaskString("#0 or #1");
        if (iAccountView.exists(filterInfo)) {
            throw new AsstActTypeException(AsstActTypeException.DELETEACCOUNTVIEW);
        }
        IAsstAccountReference asstAccountReference = AsstAccountReferenceFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("*");
        coll.add("assignCompany.name");
        view.setSelector(coll);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)id));
        view.setFilter(filter);
        AsstAccountReferenceCollection asstAccountReferenceCollection = asstAccountReference.getAsstAccountReferenceCollection(view);
        if (asstAccountReferenceCollection != null && asstAccountReferenceCollection.size() > 0) {
            AsstAccountReferenceInfo temp = null;
            StringBuffer assignCompanyName = new StringBuffer();
            int count = asstAccountReferenceCollection.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    assignCompanyName.append(", ");
                }
                temp = asstAccountReferenceCollection.get(i);
                assignCompanyName.append(temp.getAssignCompany().getName());
            }
            throw new AsstActTypeException(AsstActTypeException.COMPANY_REFERENCED_CAN_NOT_DELETE, new Object[]{assignCompanyName.toString()});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected boolean _hasDeal(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)id).isFound();
    }

    @Override
    protected IObjectCollection _getAccountByfilter(Context ctx, HashMap filterMap) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT \"ACCOUNTVIEW\".FID AS \"ID\", \"ACCOUNTVIEW\".FNumber AS \"NUMBER\", \"ACCOUNTVIEW\".FName_L2 AS \"NAME\", \"GAA\".FName_L2 AS \"GAA.NAME\", \"CAA\".FName_L2 AS \"CAA.NAME\", \"ACCOUNTVIEW\".FAC AS \"AC\", \"GAA\".FID AS \"GAA.ID\", \"CAA\".FID AS \"CAA.ID\" FROM T_BD_AccountView AS \"ACCOUNTVIEW\" LEFT OUTER JOIN T_ORG_Company AS \"COMPANYID\"ON \"ACCOUNTVIEW\".FCompanyID = \"COMPANYID\".FID LEFT OUTER JOIN T_BD_AsstAccount AS \"GAA\"ON \"ACCOUNTVIEW\".FGAA = \"GAA\".FID INNER JOIN T_BD_AccountTable AS \"ACCOUNTTABLEID\"ON \"ACCOUNTVIEW\".FAccountTableID = \"ACCOUNTTABLEID\".FID LEFT OUTER JOIN T_BD_AccountView AS \"ACCOUNT\"ON \"ACCOUNTVIEW\".FAccountID = \"ACCOUNT\".FID LEFT JOIN T_BD_AsstAccount AS \"CAA\"ON \"ACCOUNTVIEW\".FCAA = \"CAA\".FID");
        sqlBuffer.append(" WHERE ");
        sqlBuffer.append("\"CAA\".FID =? and \"ACCOUNTVIEW\".FCompanyID = ? and \"ACCOUNTVIEW\".FAccountTableID = ? and \"ACCOUNTVIEW\".FIsLeaf = ? and \"ACCOUNTVIEW\".FGLevel< \"ACCOUNTVIEW\".FLevel");
        String sql = sqlBuffer.toString();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{filterMap.get("CAA"), filterMap.get("compamy"), filterMap.get("accountTable"), filterMap.get("isLeaf")});
        AccountViewCollection accountViewColl = new AccountViewCollection();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("ID");
                AccountViewInfo account = new AccountViewInfo();
                account.setId(BOSUuid.read((String)id));
                account.setNumber(rowSet.getString("NUMBER"));
                account.setName(rowSet.getString("NAME"));
                AsstAccountInfo GAAInfo = new AsstAccountInfo();
                String GAAID = rowSet.getString("GAA.ID");
                GAAInfo.setName(rowSet.getString("GAA.NAME"));
                if (GAAID != null && !GAAID.equals("")) {
                    GAAInfo.setId(BOSUuid.read((String)GAAID));
                    account.setGAA(GAAInfo);
                } else {
                    GAAInfo.setId(null);
                    account.setGAA(null);
                }
                AsstAccountInfo CAAInfo = new AsstAccountInfo();
                String CAAID = rowSet.getString("CAA.ID");
                CAAInfo.setName("CAA.NAME");
                if (CAAID != null && !CAAID.equals("")) {
                    CAAInfo.setId(BOSUuid.read((String)CAAID));
                    account.setCAA(CAAInfo);
                } else {
                    CAAInfo.setId(null);
                    account.setCAA(null);
                }
                boolean isAC = rowSet.getBoolean("AC");
                account.setAC(isAC);
                accountViewColl.add(account);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return accountViewColl;
    }

    protected IObjectPK[] getRefDataBaseDPKs(Context ctx, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        Vector vector = this.getAsstActTypeByGroup(ctx, dataBaseDPK);
        Enumeration enums = vector.elements();
        IObjectPK[] pk = new IObjectPK[vector.size()];
        int i = 0;
        while (enums.hasMoreElements()) {
            AsstActTypeInfo info = (AsstActTypeInfo)enums.nextElement();
            pk[i] = new ObjectUuidPK(info.getId());
            ++i;
        }
        return pk;
    }

    @Override
    protected void _checkCAA(Context ctx, IObjectValue accountView) throws BOSException, EASBizException {
        ObjectUuidPK pkParent;
        ObjectUuidPK pkCompany;
        ObjectUuidPK pkUpper;
        IAsstAccount iAsstAccount;
        AccountViewInfo accountViewInfo = (AccountViewInfo)accountView;
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        if (accountViewInfo.getGAA() != null && accountViewInfo.getCAA() == null) {
            throw new AccountException(AccountException.NOT_INCLUDE_UPPER_ASST, new Object[]{accountViewInfo.getNumber(), ""});
        }
        if (accountViewInfo.getGAA() != null && accountViewInfo.getCAA() != null && !(iAsstAccount = AsstAccountFactory.getLocalInstance(ctx)).compare((IObjectPK)(pkUpper = new ObjectUuidPK(accountViewInfo.getGAA().getId())), (IObjectPK)(pkCompany = new ObjectUuidPK(accountViewInfo.getCAA().getId())))) {
            throw new AccountException(AccountException.NOT_INCLUDE_UPPER_ASST, new Object[]{accountViewInfo.getNumber(), ""});
        }
        if (accountViewInfo.getParentAA() != null && accountViewInfo.getCAA() == null) {
            throw new AccountException(AccountException.NOT_INCLUDE_PARENT_ASST, new Object[]{accountViewInfo.getNumber(), ""});
        }
        if (accountViewInfo.getParentAA() != null && accountViewInfo.getCAA() != null && !(iAsstAccount = AsstAccountFactory.getLocalInstance(ctx)).compare((IObjectPK)(pkParent = new ObjectUuidPK(accountViewInfo.getParentAA().getId())), (IObjectPK)(pkCompany = new ObjectUuidPK(accountViewInfo.getCAA().getId())))) {
            throw new AccountException(AccountException.NOT_INCLUDE_PARENT_ASST, new Object[]{accountViewInfo.getNumber(), ""});
        }
        if (accountViewInfo.getId() != null && accountViewInfo.getId().toString().length() > 0) {
            EntityViewInfo eviForChild = new EntityViewInfo();
            FilterInfo filterForChild = new FilterInfo();
            eviForChild.setFilter(filterForChild);
            filterForChild.getFilterItems().add(new FilterItemInfo("parent", (Object)accountViewInfo.getId().toString()));
            filterForChild.getFilterItems().add(new FilterItemInfo("companyID", (Object)accountViewInfo.getCompanyID().getId().toString()));
            AccountViewCollection children = iAccountView.getAccountViewCollection(eviForChild);
            if (children != null) {
                int count = children.size();
                for (int i = 0; i < count; ++i) {
                    AccountViewInfo child = children.get(i);
                    child.getId().toString();
                    if (child.getCAA() == null || accountViewInfo.getCAA() == null) continue;
                    IAsstAccount iAsstAccount2 = AsstAccountFactory.getLocalInstance(ctx);
                    ObjectUuidPK pkChild = new ObjectUuidPK(child.getCAA().getId());
                    ObjectUuidPK pkCompany2 = new ObjectUuidPK(accountViewInfo.getCAA().getId());
                    if (iAsstAccount2.compare((IObjectPK)pkCompany2, (IObjectPK)pkChild)) continue;
                    throw new AccountException(AccountException.CHILD_NOT_INCLUDE_ASST, new Object[]{child.getNumber(), accountViewInfo.getNumber()});
                }
            }
            EntityViewInfo eviForInferior = new EntityViewInfo();
            FilterInfo filterForInferior = new FilterInfo();
            eviForInferior.setFilter(filterForInferior);
            filterForInferior.getFilterItems().add(new FilterItemInfo("upper", (Object)accountViewInfo.getId().toString()));
            filterForInferior.getFilterItems().add(new FilterItemInfo("companyID", (Object)accountViewInfo.getCompanyID().getId().toString()));
            AccountViewCollection inferiors = iAccountView.getAccountViewCollection(eviForInferior);
            if (inferiors != null) {
                int count = inferiors.size();
                for (int i = 0; i < count; ++i) {
                    AccountViewInfo inferior = inferiors.get(i);
                    if (inferior.getCAA() == null && accountViewInfo.getCAA() != null) {
                        throw new AccountException(AccountException.DOWN_NOT_INCLUDE_ASST, new Object[]{inferior.getNumber(), accountViewInfo.getNumber()});
                    }
                    if (inferior.getCAA() == null || accountViewInfo.getCAA() == null) continue;
                    IAsstAccount iAsstAccount3 = AsstAccountFactory.getLocalInstance(ctx);
                    ObjectUuidPK pkInferior = new ObjectUuidPK(inferior.getCAA().getId());
                    ObjectUuidPK pkCompany3 = new ObjectUuidPK(accountViewInfo.getCAA().getId());
                    if (iAsstAccount3.compare((IObjectPK)pkCompany3, (IObjectPK)pkInferior)) continue;
                    throw new AccountException(AccountException.DOWN_NOT_INCLUDE_ASST, new Object[]{inferior.getNumber(), accountViewInfo.getNumber()});
                }
            }
        }
    }

    private void checkIsRefByAccount(Context ctx, AsstAccountInfo asstAccountInfo) throws BOSException, EASBizException {
        if (asstAccountInfo == null || StringUtils.isEmpty((String)asstAccountInfo.getId().toString())) {
            return;
        }
        String sql = "select c.fnumber as cfnumber,a.fnumber as afnumber from t_bd_accountview a inner join T_ORG_Company c on a.FCompanyID=c.fid where fcaa='" + asstAccountInfo.getId().toString() + "'";
        try {
            String companyNumber = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"companyNumber", (Locale)ctx.getLocale());
            String accountNumber = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"accountNumber", (Locale)ctx.getLocale());
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            StringBuffer detail = new StringBuffer();
            if (rowSet == null || rowSet.size() <= 0) {
                return;
            }
            detail.append(companyNumber + "          " + accountNumber + "\n");
            while (rowSet.next()) {
                detail.append(rowSet.getString("cfnumber") + "                   " + rowSet.getString("afnumber") + "\n");
            }
            String detailMsg = detail.toString();
            if (StringUtils.isEmpty((String)detailMsg)) {
                return;
            }
            String headMsg = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"auxIsRefedByAccount", (Locale)ctx.getLocale());
            HeadDetailException headException = new HeadDetailException(headMsg, detailMsg);
            throw headException;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkIsAsstIsRefed(Context ctx, AsstAccountInfo asstAccountInfo) throws BOSException, EASBizException {
        if (asstAccountInfo == null) {
            return;
        }
        SelectorItemCollection seleColl = new SelectorItemCollection();
        seleColl.add(new SelectorItemInfo("id"));
        seleColl.add(new SelectorItemInfo("asstActGpDt.asstActType.glAsstActTypeGrp.shareTactic"));
        asstAccountInfo = AsstAccountFactory.getLocalInstance(ctx).getAsstAccountInfo((IObjectPK)new ObjectUuidPK(asstAccountInfo.getId().toString()), seleColl);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccountInfo.getId().toString()));
        view.setFilter(filter);
        AsstAccountReferenceCollection asstRefColl = AsstAccountReferenceFactory.getLocalInstance(ctx).getAsstAccountReferenceCollection(view);
        if (asstRefColl == null || asstRefColl.size() <= 0) {
            return;
        }
        AsstActGroupDetailCollection asstActGroupColl = asstAccountInfo.getAsstActGpDt();
        if (asstActGroupColl == null || asstActGroupColl.size() <= 0) {
            return;
        }
        for (int i = 0; i < asstActGroupColl.size(); ++i) {
            AsstActGroupDetailInfo asstActGrpDetailInfo = asstActGroupColl.get(i);
            GeneralAsstActTypeGroupInfo group = asstActGrpDetailInfo.getAsstActType().getGlAsstActTypeGrp();
            if (group == null || group.getShareTactic() != ShareTacticEnum.B2 && group.getShareTactic() != ShareTacticEnum.I) continue;
            throw new AsstActTypeException(AsstActTypeException.ASSTHASREFEDBYOTHERORG);
        }
    }

    private void checkIsRefByHg(Context ctx, AsstAccountInfo asstAccountInfo) throws BOSException, EASBizException {
        if (asstAccountInfo == null || StringUtils.isEmpty((String)asstAccountInfo.getId().toString())) {
            return;
        }
        String fnumberGroupString = "FNUMBERGROUP_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toUpperCase();
        String sql = "select " + fnumberGroupString + " from t_bd_assistanthg  where FASSTACCOUNTID ='" + asstAccountInfo.getId().toString() + "'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet == null || rowSet.size() <= 0) {
                return;
            }
            StringBuilder detail = new StringBuilder();
            while (rowSet.next()) {
                detail.append(rowSet.getString(fnumberGroupString) + "\n");
            }
            String detailMsg = detail.toString();
            if (StringUtils.isEmpty((String)detailMsg)) {
                return;
            }
            String headMsg = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"auxIsRefedByHG", (Locale)ctx.getLocale());
            HeadDetailException headException = new HeadDetailException(headMsg, detailMsg);
            throw headException;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

