/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.common.olap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.common.olap.CommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class EASEjbFactory {
    private static Logger logger = Logger.getLogger(EASEjbFactory.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Context getCtx(String uiClass, Context ctx) throws BOSException, EASBizException {
        int configStatus = 0;
        Connection con = null;
        PreparedStatement statement = null;
        String trimUIClass = CommonUtils.trim(uiClass);
        if (trimUIClass == null) {
            return ctx;
        }
        Context newCtx = ctx;
        try {
            String checkSql = "select FDataCenterNumber,FConfigStatus from t_bd_dmltDataCenterConfig dbconfig where dbconfig.FReportID=?";
            con = EJBFactory.getConnection((Context)ctx);
            statement = con.prepareStatement(checkSql);
            statement.setString(1, trimUIClass);
            ResultSet checkSet = statement.executeQuery();
            if (checkSet.next() && checkSet.getString(1) != null && checkSet.getInt(2) == configStatus) {
                String ais = CommonUtils.trim(checkSet.getString(1));
                ByteArrayOutputStream baos = null;
                ByteArrayInputStream bais = null;
                ObjectInputStream objIn = null;
                baos = new ByteArrayOutputStream();
                ObjectOutputStream objOut = new ObjectOutputStream(baos);
                Marshaller ma = new Marshaller((ObjectOutput)objOut);
                newCtx = new Context();
                ctx.marshal(ma);
                byte[] byt = baos.toByteArray();
                bais = new ByteArrayInputStream(byt);
                objIn = new ObjectInputStream(bais);
                Unmarshaller unmar = new Unmarshaller((ObjectInput)objIn);
                newCtx.unmarshal(unmar);
                newCtx.setAIS(ais);
            }
        }
        catch (SQLException er) {
            try {
                logger.error((Object)er);
                throw new BOSException((Throwable)er);
                catch (IOException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        return newCtx;
    }
}

