/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.common;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.ws.common.TextFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class WsCommonXMLUtil {
    private static String xmlParserImpl = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil");

    public static String getBaseUnitNumberByXML(Context ctx, String number) throws Exception {
        try {
            Document doc = WsCommonXMLUtil.getDocumentByFile(WsCommonXMLUtil.getFilePath("baseUnitCode.xml"));
            number = WsCommonXMLUtil.getNumberByXML(doc, "baseUnitCodes//baseUnitCode", number);
        }
        catch (Exception e) {
            throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"READCODEFILEERROR", (Context)ctx) + ":" + e.getMessage());
        }
        return number;
    }

    public static String gePropertyNumberByXML(Context ctx, String number, String filename) throws Exception {
        try {
            Document doc = WsCommonXMLUtil.getDocumentByFile(WsCommonXMLUtil.getFilePath(filename));
            number = WsCommonXMLUtil.getNumberByXML(doc, "Codes//Code", number);
        }
        catch (Exception e) {
            throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"READCODEFILEERROR", (Context)ctx) + ":" + e.getMessage());
        }
        return number;
    }

    private static String getNumberByXML(Document doc, String xmlTag, String number) throws Exception {
        if (null != doc) {
            ArrayList entiesPro = WsCommonXMLUtil.getBillEntries(doc, xmlTag);
            HashMap codeMap = null;
            int count = entiesPro.size();
            for (int i = 0; i < count; ++i) {
                String tonumber;
                codeMap = null;
                codeMap = (HashMap)entiesPro.get(i);
                if (!WsCommonXMLUtil.isFoundNumber(codeMap, number) || null == (tonumber = (String)codeMap.get("to_eas")) || "".equals(tonumber)) continue;
                return tonumber;
            }
        }
        return number;
    }

    private static boolean isFoundNumber(HashMap map, String number) {
        if (null == map || map.size() <= 0) {
            return false;
        }
        String fromNumber = (String)map.get("from_mdm");
        return null != fromNumber && fromNumber.equals(number);
    }

    private static String getFilePath(String fileName) {
        String path = System.getProperty("eas.properties.dir") + File.separator + "code" + File.separator + fileName;
        return path;
    }

    public static String getCUtNumberByXML(String number) throws Exception {
        Document doc = WsCommonXMLUtil.getDocumentByFile(WsCommonXMLUtil.getFilePath("cuCode.xml"));
        number = WsCommonXMLUtil.getNumberByXML(doc, "cuCodes//cuCode", number);
        return number;
    }

    public static Document getDocumentByFile(String file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder db = factory.newDocumentBuilder();
        File files = new File(file);
        Document doc = null;
        if (null != files) {
            doc = db.parse(files);
        }
        return doc;
    }

    public static String getAttributeValue(Document doc, String attributeName) {
        Element rootElement = doc.getDocumentElement();
        if (null != rootElement) {
            return rootElement.getAttribute(attributeName);
        }
        return null;
    }

    public static void validateRootElement(Document doc, String rootTagName) throws Exception {
        Element rootElement = doc.getDocumentElement();
        if (!rootElement.getTagName().equals(rootTagName)) {
            throw new Exception("BillXmlFormat IS ERROR!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            String oldDocBuilderFactory = null;
            DocumentBuilderFactory factory = null;
            try {
                Thread.currentThread().setContextClassLoader(DocumentBuilderFactoryImpl.class.getClassLoader());
                oldDocBuilderFactory = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
                if (!xmlParserImpl.equals(oldDocBuilderFactory)) {
                    System.setProperty("javax.xml.parsers.DocumentBuilderFactory", xmlParserImpl);
                }
                factory = DocumentBuilderFactory.newInstance();
                factory.setExpandEntityReferences(false);
            }
            catch (SecurityException se) {
                logger.error((Object)se);
                se.printStackTrace();
            }
            if (oldDocBuilderFactory != null) {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", oldDocBuilderFactory);
            }
            DocumentBuilderFactory documentBuilderFactory = factory;
            return documentBuilderFactory;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException se) {
                logger.error((Object)se);
                se.printStackTrace();
            }
        }
    }

    public static Document builderDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = WsCommonXMLUtil.getDocumentBuilderFactory();
        factory.setExpandEntityReferences(false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static Document builderDocumentFromFile(String filePath) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = WsCommonXMLUtil.getDocumentBuilderFactory();
        factory.setExpandEntityReferences(false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(filePath);
    }

    public static Document builderDocument(String xmlContent) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory builder = WsCommonXMLUtil.getDocumentBuilderFactory();
        builder.setExpandEntityReferences(false);
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        ByteArrayInputStream input = new ByteArrayInputStream(xmlContent.getBytes("UTF-8"));
        DocumentBuilder parser = builder.newDocumentBuilder();
        return parser.parse(input);
    }

    public static HashMap getBillHead(Document doc, String headName) {
        if (doc == null) {
            return null;
        }
        HashMap<String, String> headMap = null;
        NodeList childs = doc.getElementsByTagName(headName);
        String value = null;
        if (childs != null && childs.getLength() > 0) {
            headMap = new HashMap<String, String>();
            NodeList subChilds = childs.item(0).getChildNodes();
            for (int i = 0; subChilds != null && i < subChilds.getLength(); ++i) {
                Element subElement;
                Node subChild;
                if (subChilds.item(i).getNodeType() != 1 || (subChild = (subElement = (Element)subChilds.item(i)).getFirstChild()) == null || (value = subChild.getNodeValue()) == null) continue;
                headMap.put(subElement.getTagName(), value.trim());
            }
        }
        return headMap;
    }

    public static ArrayList getBillEntries(Document doc, String xpath) throws TransformerException {
        if (doc == null) {
            return null;
        }
        NodeList subChilds = WsCommonXMLUtil.getNodeListFromXpath(doc, xpath);
        ArrayList entries = new ArrayList();
        HashMap<String, String> entryMap = null;
        String value = null;
        for (int i = 0; subChilds != null && i < subChilds.getLength(); ++i) {
            if (subChilds.item(i).getNodeType() != 1) continue;
            entryMap = new HashMap<String, String>();
            Element entryElement = (Element)subChilds.item(i);
            if (entryElement != null) {
                NodeList entryChildList = entryElement.getChildNodes();
                for (int j = 0; entryChildList != null && j < entryChildList.getLength(); ++j) {
                    Node textNode;
                    Node subChild;
                    if (entryChildList.item(j).getNodeType() != 1 || (subChild = entryChildList.item(j)) == null || subChild.getNodeType() != 1 || (textNode = WsCommonXMLUtil.getChildTextNode(subChild)) == null || (value = textNode.getNodeValue()) == null) continue;
                    entryMap.put(subChild.getNodeName(), value.trim());
                }
            }
            entries.add(entryMap);
        }
        return entries;
    }

    public static Node getChildTextNode(Node ele) {
        Document doc;
        DOMImplementation domImpl;
        if (ele != null && (domImpl = (doc = ele.getOwnerDocument()).getImplementation()).hasFeature("Traversal", "2.0")) {
            DocumentTraversal traversal = (DocumentTraversal)((Object)doc);
            int whatToShow = -1;
            TextFilter filter = new TextFilter();
            TreeWalker tree = traversal.createTreeWalker(ele, whatToShow, filter, false);
            return tree.firstChild();
        }
        return null;
    }

    public static NodeList getNodeListFromXpath(Node node, String partern) throws TransformerException {
        String elementTag;
        if (partern != null && partern.lastIndexOf("/") > 0 && (elementTag = partern.substring(partern.lastIndexOf("/") + 1)) != null) {
            if (node.getNodeType() == 1) {
                return ((Element)node).getElementsByTagName(elementTag);
            }
            if (node.getNodeType() == 9) {
                return ((Document)node).getElementsByTagName(elementTag);
            }
        }
        return null;
    }

    public static final synchronized boolean writeXmlFile(String fileName, Document document) throws Exception {
        DOMSource doms = new DOMSource(document);
        File file = new File(fileName);
        StreamResult result = new StreamResult(file);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        Properties properties = transformer.getOutputProperties();
        properties.setProperty("encoding", "UTF-8");
        properties.setProperty("method", "xml");
        properties.setProperty("indent", "yes");
        transformer.setOutputProperties(properties);
        transformer.transform(doms, result);
        return true;
    }

    public static final String domToString(Document document) throws Exception {
        DOMSource doms = new DOMSource(document);
        StringWriter strWriter = new StringWriter();
        StreamResult result = new StreamResult(strWriter);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        Properties properties = transformer.getOutputProperties();
        properties.setProperty("encoding", "UTF-8");
        properties.setProperty("method", "xml");
        properties.setProperty("indent", "yes");
        transformer.setOutputProperties(properties);
        transformer.transform(doms, result);
        return strWriter.toString();
    }

    public static Date convertStrToDate(String strDate, String parttern) throws ParseException {
        if (strDate != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(parttern);
            return dateFormat.parse(strDate);
        }
        return null;
    }

    public static Document buildDocument(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = WsCommonXMLUtil.getDocumentBuilderFactory();
        factory.setExpandEntityReferences(false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(in);
    }

    public static String buildResultXml(String retstatusValue, String number, String Messages) {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, String> errorMessage = new HashMap<String, String>();
        if (null != Messages && !"".equals(Messages)) {
            list.add(number);
            errorMessage.put(number, Messages);
        }
        return WsCommonXMLUtil.buildResultXml(retstatusValue, list, errorMessage);
    }

    public static String buildResultXml(String retstatusValue, ArrayList numberlist, HashMap Messages) {
        String resultXml = "";
        try {
            Document doc = WsCommonXMLUtil.builderDocument();
            Element root = doc.createElement("Result");
            Element retstatus = doc.createElement("retstatus");
            retstatus.appendChild(doc.createTextNode(retstatusValue));
            Element errorMessages = doc.createElement("errorMessages");
            String number = null;
            int count = numberlist.size();
            for (int i = 0; i < count; ++i) {
                number = (String)numberlist.get(i);
                Element errorMessage = doc.createElement("errorMessage");
                errorMessage.setAttribute("number", number);
                Object obj = Messages.get(number);
                String message = "";
                if (null != obj) {
                    message = obj.toString();
                }
                errorMessage.appendChild(doc.createTextNode(message));
                errorMessages.appendChild(errorMessage);
            }
            root.appendChild(retstatus);
            root.appendChild(errorMessages);
            doc.appendChild(root);
            resultXml = WsCommonXMLUtil.domToString(doc);
        }
        catch (Exception e) {
            resultXml = "000";
            logger.error((Object)e);
        }
        return resultXml;
    }

    public static String buildBaseDataXml(Map headmap, List entiesList) throws Exception {
        Document doc = WsCommonXMLUtil.builderDocument();
        Element root = doc.createElement("DataInfo");
        Element dataHead = doc.createElement("DataHead");
        for (Map.Entry et : headmap.entrySet()) {
            String key = et.getKey().toString();
            Object value = et.getValue();
            Element headPropery = doc.createElement(key);
            String textValue = "";
            if (null != value) {
                textValue = value.toString();
            }
            headPropery.appendChild(doc.createTextNode(textValue));
            dataHead.appendChild(headPropery);
        }
        root.appendChild(dataHead);
        if (null != entiesList && entiesList.size() > 0) {
            Element dataEntries = doc.createElement("DataEntries");
            int count = entiesList.size();
            for (int i = 0; i < count; ++i) {
                Element entry = doc.createElement("entry");
                Map map = (Map)entiesList.get(i);
                for (Map.Entry et : map.entrySet()) {
                    String key = et.getKey().toString();
                    Object value = et.getValue();
                    Element entryPropery = doc.createElement(key);
                    String textValue = "";
                    if (null != value) {
                        textValue = value.toString();
                    }
                    entryPropery.appendChild(doc.createTextNode(textValue));
                    entry.appendChild(entryPropery);
                }
                dataEntries.appendChild(entry);
            }
            root.appendChild(dataEntries);
        }
        doc.appendChild(root);
        return WsCommonXMLUtil.domToString(doc);
    }
}

