/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.MaterialGroupDetialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonTag;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.basedata.ws.material.AbstractImportMaterialFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.PropertyContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ImportMaterialFacadeControllerBean
extends AbstractImportMaterialFacadeControllerBean {
    private static final long serialVersionUID = -9217607735093209313L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.material.ImportMaterialFacadeControllerBean");
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";

    @Override
    protected String _importMaterialData(Context ctx, String xmlData) throws BOSException, EASBizException {
        try {
            Document doc = WsCommonXMLUtil.builderDocument(xmlData);
            if (null != doc) {
                WsCommonXMLUtil.validateRootElement(doc, "DataInfo");
                HashMap headPro = WsCommonXMLUtil.getBillHead(doc, "DataHead");
                ArrayList entiesPro = WsCommonXMLUtil.getBillEntries(doc, "DataEntries//entry");
                this.billNumber = (String)headPro.get("number");
                CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo(ctx, (String)headPro.get("CU"));
                if (cuInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTFOUND", (Context)ctx));
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
                String opAttributeName = WsCommonXMLUtil.getAttributeValue(doc, "op");
                String bostype = WsCommonXMLUtil.getAttributeValue(doc, "bostype");
                MaterialInfo materialInfo = new MaterialInfo();
                EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
                Map<String, Object> map = WsCommonImportUtil.getBillHeadProperties(eo);
                this.checkPermission(ctx, cuInfo, opAttributeName);
                if (null != opAttributeName && ("0".equals(opAttributeName) || "1".equals(opAttributeName) || "2".equals(opAttributeName) || "5".equals(opAttributeName))) {
                    materialInfo = (MaterialInfo)WsCommonUtil.getCoreBaseInfo(ctx, eo, this.billNumber, cuInfo.getId().toString());
                    if (null == materialInfo) {
                        throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"BASEDATANOTEXIST", (Context)ctx));
                    }
                    if ("1".equals(opAttributeName)) {
                        materialInfo.setStatus(UsedStatusEnum.APPROVED);
                    } else if ("2".equals(opAttributeName)) {
                        materialInfo.setStatus(UsedStatusEnum.FREEZED);
                    } else if ("5".equals(opAttributeName)) {
                        materialInfo.setStatus(UsedStatusEnum.UNAPPROVE);
                    }
                }
                if (null != opAttributeName && ("3".equals(opAttributeName) || "4".equals(opAttributeName))) {
                    WsCommonUtil.validateNumber(ctx, eo, this.billNumber, cuInfo.getId().toString());
                }
                if ("0".equals(opAttributeName) || "3".equals(opAttributeName) || "4".equals(opAttributeName)) {
                    String[] mustValidateHead = WsCommonTag.getMustValidateProsByMaterialHead();
                    String[] mustValidateEntry = WsCommonTag.getMustValidateProsByMaterialEntry();
                    if (!"0".equals(opAttributeName)) {
                        WsCommonUtil.validateHeadProperty(mustValidateHead, headPro);
                        WsCommonUtil.validateEntiesProperty(mustValidateEntry, entiesPro);
                        this.buildBillEnties(ctx, entiesPro, mustValidateEntry, materialInfo, eo, cuInfo.getId().toString());
                    } else {
                        mustValidateHead = null;
                        mustValidateEntry = null;
                    }
                    WsCommonImportUtil.buildBillHead(ctx, (CoreBaseInfo)materialInfo, map, mustValidateHead, null, headPro, cuInfo.getId().toString());
                }
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                WsCommonUtil.operationBill(ctx, eo, (CoreBaseInfo)materialInfo, opAttributeName, headPro, map, "status");
            }
        }
        catch (Exception e) {
            this.retstatus = "1";
            this.errorMessage = e.getMessage();
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, this.billNumber, this.errorMessage);
    }

    private void buildBillEnties(Context ctx, ArrayList entiesPro, String[] mustValidate, MaterialInfo materialInfo, EntityObjectInfo eo, String cuId) throws Exception {
        Map<String, Object> map = WsCommonImportUtil.getBillEntiesProperties(ctx, "materialGroupDetails", eo);
        MaterialGroupDetialInfo groupDetialinfo = null;
        HashMap entryMap = null;
        if (null != map) {
            int count = entiesPro.size();
            for (int i = 0; i < count; ++i) {
                entryMap = null;
                groupDetialinfo = null;
                entryMap = (HashMap)entiesPro.get(i);
                groupDetialinfo = new MaterialGroupDetialInfo();
                WsCommonImportUtil.buildBill(ctx, map, null, entryMap, mustValidate, (PropertyContainer)groupDetialinfo, cuId);
                materialInfo.getMaterialGroupDetails().add(groupDetialinfo);
            }
        }
    }

    private void checkPermission(Context ctx, CtrlUnitInfo cuInfo, String opAttributeName) throws BOSException, EASBizException {
        String permItemName = "";
        permItemName = "0".equals(opAttributeName) ? "bd_material_update" : "bd_material_addNew";
        APIPermissionCheckUtil.checkPermission(ctx, cuInfo, permItemName);
    }
}

