/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.supplier;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.basedata.ws.supplier.AbstractAssignSupplierFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class AssignSupplierFacadeControllerBean
extends AbstractAssignSupplierFacadeControllerBean {
    private static final long serialVersionUID = -850385501514500087L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.supplier.AssignSupplierFacadeControllerBean");
    private String retstatus = "0";
    private String errorMessage = "";

    @Override
    protected String _assignSupplier(Context ctx, String xmlData) throws BOSException, EASBizException {
        String sourceCuNum = "";
        String dataBaseNumber = "";
        String[] targetCuNum = null;
        try {
            Document doc = WsCommonXMLUtil.builderDocument(xmlData);
            if (null != doc) {
                this.checkPermission(ctx);
                WsCommonXMLUtil.validateRootElement(doc, "AssignData");
                HashMap assignHead = WsCommonXMLUtil.getBillHead(doc, "AssignHead");
                ArrayList assignCU = WsCommonXMLUtil.getBillEntries(doc, "AssignCUS//AssignCU");
                if (null == assignHead || assignHead.size() <= 0 || null == assignCU || assignCU.size() <= 0) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"ASSIGNCUNOTNULL", (Context)ctx));
                }
                sourceCuNum = (String)assignHead.get("sourceCU");
                dataBaseNumber = (String)assignHead.get("dataNumber");
                if (null == (sourceCuNum = WsCommonXMLUtil.getCUtNumberByXML(sourceCuNum)) || "".equals(sourceCuNum)) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTNULL", (Context)ctx));
                }
                if (null == dataBaseNumber || "".equals(dataBaseNumber)) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"NUMBERNOTNULL", (Context)ctx));
                }
                targetCuNum = WsCommonUtil.getTargetCUNumber(assignCU);
                CtrlUnitInfo sourceCU = DataImportUtils.getCtrlUnitInfoFromNumber((Context)ctx, (String)WsCommonXMLUtil.getCUtNumberByXML(sourceCuNum));
                CtrlUnitInfo destCU = null;
                SupplierInfo supplierInfo = DataImportUtils.getSupplierInfoFromNumber((Context)ctx, (String)dataBaseNumber);
                if (sourceCU == null || !sourceCU.isIsCU()) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTEXISTS", (Context)ctx));
                }
                if (supplierInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"SUPPLIERNOTEXISTS", (Context)ctx));
                }
                if (!supplierInfo.getCU().getId().equals((Object)sourceCU.getId())) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTHASBASEINFO", (Context)ctx));
                }
                ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                for (int i = 0; i < targetCuNum.length; ++i) {
                    destCU = DataImportUtils.getCtrlUnitInfoFromNumber((Context)ctx, (String)WsCommonXMLUtil.getCUtNumberByXML(targetCuNum[i]));
                    if (destCU == null || !destCU.isIsCU()) continue;
                    iSupplier.assign((IObjectPK)new ObjectUuidPK(sourceCU.getId()), (IObjectPK)new ObjectUuidPK(supplierInfo.getId()), (IObjectPK)new ObjectUuidPK(destCU.getId()));
                }
            }
        }
        catch (Exception e) {
            this.retstatus = "1";
            this.errorMessage = e.getMessage();
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, dataBaseNumber, this.errorMessage);
    }

    private void checkPermission(Context ctx) throws BOSException, EASBizException {
        String permItemName = "Supplier_Assign";
        CtrlUnitInfo currentCtrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        APIPermissionCheckUtil.checkPermission(ctx, currentCtrlUnit, permItemName);
    }
}

