/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.batch.model.xml;

import com.kingdee.eas.basedata.master.batch.model.xml.IXMLBuilder;
import com.kingdee.eas.basedata.master.batch.model.xml.XmlElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler {
    private XmlElement element = null;
    private StringBuffer currentValue = new StringBuffer();
    private IXMLBuilder builder;

    public XMLParser(IXMLBuilder b) {
        this.builder = b;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.element = new XmlElement(qName);
        this.element.setUri(uri);
        this.element.setLocalName(localName);
        this.element.setAttributes(attributes);
        try {
            this.builder.push(this.element);
        }
        catch (Exception e) {
            SAXException se = new SAXException("current startElement : " + qName + " is error!" + e.getMessage(), e);
            se.setStackTrace(e.getStackTrace());
            throw se;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentValue.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (this.element.getId() != null) {
                if (this.currentValue.toString().trim().length() != 0) {
                    this.element.setValue(this.currentValue.toString().trim());
                    this.builder.push(this.element);
                }
                this.builder.assemble();
            } else if (this.element.getId() == null && this.currentValue.toString().trim().length() == 0) {
                this.builder.assemble();
            }
        }
        catch (Exception e) {
            SAXException se = new SAXException("current endElement : " + qName + " is error!" + e.getMessage(), e);
            se.setStackTrace(e.getStackTrace());
            throw se;
        }
        this.element.clear();
        if (this.currentValue.toString().trim().length() != 0) {
            this.currentValue.delete(0, this.currentValue.length());
        }
    }
}

