/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormCacheService.ORMCacheUtil;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeFactory;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerIntegrateInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.IBizAnalysisCode;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerIntegrateInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierSummary;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierSummaryFactory;
import com.kingdee.eas.basedata.master.cssp.app.AbstractCsManagerControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CsManagerControllerBean
extends AbstractCsManagerControllerBean {
    public static final int MAPTYPE_SUPPLIER = 1;
    public static final int MAPTYPE_CUSTOMER = 2;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.CsManagerControllerBean");

    @Override
    protected IObjectPK _addCustomerCompanyInfo(Context ctx, IObjectValue customerCompanyInfo, boolean isTempSave) throws BOSException, EASBizException {
        ICustomerCompanyInfo iCustomerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        if (isTempSave) {
            return iCustomerCompanyInfo.save((CoreBaseInfo)((ObjectBaseInfo)customerCompanyInfo));
        }
        return iCustomerCompanyInfo.submit((CoreBaseInfo)((ObjectBaseInfo)customerCompanyInfo));
    }

    @Override
    protected IObjectPK _addCustomerSaleInfo(Context ctx, IObjectValue customerSaleInfo, boolean isTempSave) throws BOSException, EASBizException {
        ICustomerSaleInfo iCustomerSaleInfo = CustomerSaleInfoFactory.getLocalInstance(ctx);
        if (isTempSave) {
            return iCustomerSaleInfo.save((CoreBaseInfo)((ObjectBaseInfo)customerSaleInfo));
        }
        return iCustomerSaleInfo.submit((CoreBaseInfo)((CustomerSaleInfoInfo)customerSaleInfo));
    }

    @Override
    protected IObjectPK _addnewCustomer(Context ctx, IObjectPK pk, IObjectValue model, boolean isTempSave) throws BOSException, EASBizException {
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        if (isTempSave) {
            iCustomer.save(pk, (CoreBaseInfo)model);
        } else {
            iCustomer.submit(pk, (CoreBaseInfo)model);
        }
        return pk;
    }

    @Override
    protected IObjectPK _addnewCustomer(Context ctx, IObjectValue model, boolean isTempSave) throws BOSException, EASBizException {
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        if (isTempSave) {
            return iCustomer.save((CoreBaseInfo)model);
        }
        return iCustomer.submit((CoreBaseInfo)model);
    }

    @Override
    protected IObjectPK _addnewSupplier(Context ctx, IObjectPK pk, IObjectValue model, boolean isTempSave) throws BOSException, EASBizException {
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        if (isTempSave) {
            iSupplier.save(pk, (CoreBaseInfo)model);
        } else {
            iSupplier.submit(pk, (CoreBaseInfo)model);
        }
        return pk;
    }

    @Override
    protected IObjectPK _addnewSupplier(Context ctx, IObjectValue model, boolean isTempSave) throws BOSException, EASBizException {
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        if (isTempSave) {
            return iSupplier.save((CoreBaseInfo)model);
        }
        return iSupplier.submit((CoreBaseInfo)model);
    }

    @Override
    protected IObjectPK _addSupplierCompanyInfo(Context ctx, IObjectValue supplierCompanyInfo, boolean isTempSave) throws BOSException, EASBizException {
        ISupplierCompanyInfo iSupplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        if (isTempSave) {
            return iSupplierCompanyInfo.save((CoreBaseInfo)((ObjectBaseInfo)supplierCompanyInfo));
        }
        return iSupplierCompanyInfo.submit((CoreBaseInfo)((ObjectBaseInfo)supplierCompanyInfo));
    }

    @Override
    protected void _deleteCustomer(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        iCustomer.delete(pk);
    }

    @Override
    protected void _deleteCustomerCompanyInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICustomerCompanyInfo iCustomerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        iCustomerCompanyInfo.delete(pk);
    }

    @Override
    protected void _deleteCustomerCompanyInfo(Context ctx, String csBaseNumber, String companyOrgNumber) throws BOSException, EASBizException {
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        CustomerCompanyInfoInfo vo = iCustomer.getCustomerCompanyInfo(csBaseNumber, companyOrgNumber);
        if (vo == null) {
            throw new CustomerSupplierException(CustomerSupplierException.CUSTOMERCOMPANYINFO_NOT_EXIST, new Object[]{csBaseNumber, companyOrgNumber});
        }
        ICustomerCompanyInfo iCustomerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        iCustomerCompanyInfo.delete((IObjectPK)new ObjectUuidPK(vo.getId()));
    }

    @Override
    protected void _deleteCustomerSaleInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICustomerSaleInfo iCustomerSaleInfo = CustomerSaleInfoFactory.getLocalInstance(ctx);
        iCustomerSaleInfo.delete(pk);
    }

    @Override
    protected void _deleteCustomerSaleInfo(Context ctx, String csBaseNumber, String saleOrgNumber) throws BOSException, EASBizException {
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        CustomerSaleInfoInfo vo = iCustomer.getCustomerSaleInfo(csBaseNumber, saleOrgNumber);
        if (vo == null) {
            throw new CustomerSupplierException(CustomerSupplierException.CUSTOMERSALEINFO_NOT_EXIST, new Object[]{csBaseNumber, saleOrgNumber});
        }
        ICustomerSaleInfo iCustomerSaleInfo = CustomerSaleInfoFactory.getLocalInstance(ctx);
        iCustomerSaleInfo.delete((IObjectPK)new ObjectUuidPK(vo.getId()));
    }

    @Override
    protected void _deleteSupplier(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        iSupplier.delete(pk);
    }

    @Override
    protected void _deleteSupplierCompanyInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ISupplierCompanyInfo iSupplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        iSupplierCompanyInfo.delete(pk);
    }

    @Override
    protected void _deleteSupplierCompanyInfo(Context ctx, String csBaseNumber, String companyOrgNumber) throws BOSException, EASBizException {
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        SupplierCompanyInfoInfo vo = iSupplier.getCompanyInfo(csBaseNumber, companyOrgNumber);
        if (vo == null) {
            throw new CustomerSupplierException(CustomerSupplierException.SUPPLIERCOMPANYINFO_NOT_EXIST, new Object[]{csBaseNumber, companyOrgNumber});
        }
        ISupplierCompanyInfo iSupplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        iSupplierCompanyInfo.delete((IObjectPK)new ObjectUuidPK(vo.getId()));
    }

    @Override
    protected IObjectCollection _getCustomersByCompany(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        ICustomerCompanyInfo iCustomerCompany = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyPK.toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        CustomerCompanyInfoCollection vos = iCustomerCompany.getCustomerCompanyInfoCollection(evi);
        CustomerCollection customerCollection = new CustomerCollection();
        int c = vos.size();
        for (int i = 0; i < c; ++i) {
            customerCollection.add(vos.get(i).getCustomer());
        }
        return customerCollection;
    }

    @Override
    protected IObjectCollection _getSuppliersByCompany(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        ISupplierCompanyInfo iSupplierCompany = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyPK.toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        SupplierCompanyInfoCollection vos = iSupplierCompany.getSupplierCompanyInfoCollection(evi);
        SupplierCollection supplierCollection = new SupplierCollection();
        int c = vos.size();
        for (int i = 0; i < c; ++i) {
            supplierCollection.add(vos.get(i).getSupplier());
        }
        return supplierCollection;
    }

    @Override
    protected void _updateCustomer(Context ctx, IObjectPK pk, IObjectValue model, boolean isTempSave) throws BOSException, EASBizException {
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        if (isTempSave) {
            iCustomer.save((CoreBaseInfo)model);
        } else {
            iCustomer.submit((CoreBaseInfo)model);
        }
    }

    @Override
    protected void _updateCustomerCompanyInfo(Context ctx, IObjectValue customerCompanyInfo, boolean isTempSave) throws BOSException, EASBizException {
        ICustomerCompanyInfo iCustomerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        if (isTempSave) {
            iCustomerCompanyInfo.save((CoreBaseInfo)((ObjectBaseInfo)customerCompanyInfo));
        } else {
            iCustomerCompanyInfo.submit((CoreBaseInfo)((ObjectBaseInfo)customerCompanyInfo));
        }
    }

    @Override
    protected void _updateCustomerSaleInfo(Context ctx, IObjectValue customerSaleInfo, boolean isTempSave) throws BOSException, EASBizException {
        ICustomerSaleInfo iCustomerSaleInfo = CustomerSaleInfoFactory.getLocalInstance(ctx);
        if (isTempSave) {
            iCustomerSaleInfo.save((CoreBaseInfo)((ObjectBaseInfo)customerSaleInfo));
        } else {
            iCustomerSaleInfo.submit((CoreBaseInfo)((ObjectBaseInfo)customerSaleInfo));
        }
    }

    @Override
    protected void _updateSupplier(Context ctx, IObjectPK pk, IObjectValue model, boolean isTempSave) throws BOSException, EASBizException {
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        if (isTempSave) {
            iSupplier.save((CoreBaseInfo)model);
        } else {
            iSupplier.submit((CoreBaseInfo)model);
        }
    }

    @Override
    protected void _updateSupplierCompanyInfo(Context ctx, IObjectValue supplierCompanyInfo, boolean isTempSave) throws BOSException, EASBizException {
        ISupplierCompanyInfo iSupplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        if (isTempSave) {
            iSupplierCompanyInfo.save((CoreBaseInfo)((ObjectBaseInfo)supplierCompanyInfo));
        } else {
            iSupplierCompanyInfo.submit((CoreBaseInfo)((ObjectBaseInfo)supplierCompanyInfo));
        }
    }

    @Override
    protected IObjectCollection _getSupplierCompany(Context ctx, IObjectPK supplierPK) throws BOSException {
        ISupplierCompanyInfo iSupplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierPK.toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        SupplierCompanyInfoCollection vos = iSupplierCompanyInfo.getSupplierCompanyInfoCollection(evi);
        return vos;
    }

    @Override
    protected IObjectCollection _getCustomerCompany(Context ctx, IObjectPK customerPK) throws BOSException {
        ICustomerCompanyInfo iCustomerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerPK.toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        CustomerCompanyInfoCollection vos = iCustomerCompanyInfo.getCustomerCompanyInfoCollection(evi);
        return vos;
    }

    @Override
    protected IObjectCollection _getCustomerSale(Context ctx, IObjectPK customerPK) throws BOSException {
        ICustomerSaleInfo iCustomerSaleInfo = CustomerSaleInfoFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerPK.toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        CustomerSaleInfoCollection vos = iCustomerSaleInfo.getCustomerSaleInfoCollection(evi);
        return vos;
    }

    @Override
    protected void _mapCSBaseToBizAnalysisCode(Context ctx, IObjectPK pk, IObjectPK bizAnalysisCodePk, int mapType) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        PreparedStatement stmt = null;
        Connection cn = null;
        int index = 1;
        IBizAnalysisCode iBizAnalysisCode = BizAnalysisCodeFactory.getLocalInstance(ctx);
        BizAnalysisCodeInfo bizAnalysisCodeVO = null;
        SupplierInfo supplierVO = null;
        CustomerInfo customerVO = null;
        if (mapType == 2) {
            ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
            try {
                customerVO = iCustomer.getCustomerInfo(pk);
            }
            catch (ObjectNotFoundException oe) {
                oe.printStackTrace();
                return;
            }
            strSQL.append("update T_BD_Customer set FBizAnalysisCodeID = ? Where FID =?");
        } else if (mapType == 1) {
            ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
            supplierVO = iSupplier.getSupplierInfo(pk);
            strSQL.append("update T_BD_Supplier set FBizAnalysisCodeID = ? Where FID =?");
        }
        bizAnalysisCodeVO = iBizAnalysisCode.getBizAnalysisCodeInfo(bizAnalysisCodePk);
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(strSQL.toString());
            stmt.setString(index++, bizAnalysisCodeVO.getId().toString());
            if (mapType == 2) {
                stmt.setString(index++, customerVO.getId().toString());
            }
            if (mapType == 1) {
                stmt.setString(index++, supplierVO.getId().toString());
            }
            stmt.execute();
            ORMCacheUtil.getInstance().removeInfo(ctx, BOSUuid.read((String)pk.toString()).getType(), pk.toString());
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    @Override
    protected void _mapCSBaseToBizAnalysisCode(Context ctx, IObjectPK pk, String bizAnalysisCodeNumber, int mapType) throws BOSException, EASBizException {
        IBizAnalysisCode iBizAnalysisCode = BizAnalysisCodeFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bizAnalysisCodeNumber, CompareType.EQUALS));
        IObjectPK[] pks = iBizAnalysisCode.getPKList(filter, null);
        if (pks == null) {
            throw new CustomerSupplierException(CustomerSupplierException.BIZCODE_NUMBER_NOT_EXIST, new Object[]{bizAnalysisCodeNumber});
        }
        if (pks.length > 1) {
            throw new CustomerSupplierException(CustomerSupplierException.BIZCODE_NOT_UNIQUE_UNDER_NUMBER, new Object[]{bizAnalysisCodeNumber});
        }
        this._mapCSBaseToBizAnalysisCode(ctx, pk, pks[0], mapType);
    }

    @Override
    protected void _unmapCSBaseBizAnalysisCode(Context ctx, IObjectPK pk, int unmapType) throws BOSException, EASBizException {
        ISupplier iSupplier;
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        StringBuffer strSQL = new StringBuffer();
        Object[] parameter = new String[2];
        parameter[0] = null;
        if (iCustomer.exists(pk)) {
            parameter[1] = pk.toString();
            strSQL.append("update T_BD_Customer set FBizAnalysisCodeID = ? Where FID = ?");
        }
        if ((iSupplier = SupplierFactory.getLocalInstance(ctx)).exists(pk)) {
            parameter[1] = pk.toString();
            strSQL.append("update T_BD_Supplier set FBizAnalysisCodeID = ? Where FID = ?");
        }
        this.execute(ctx, strSQL.toString(), parameter);
        ORMCacheUtil.getInstance().removeInfo(ctx, BOSUuid.read((String)pk.toString()).getType(), pk.toString());
    }

    private void execute(Context ctx, String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = super.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] != null) {
                    ps.setObject(i + 1, params[i]);
                    continue;
                }
                ps.setNull(i + 1, 12);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected IObjectCollection _getCustomerCollectionByBizCode(Context ctx, IObjectPK bizAnalysisCodePK) throws BOSException, EASBizException {
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (bizAnalysisCodePK != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizAnalysisCode.id", (Object)bizAnalysisCodePK.toString(), CompareType.EQUALS));
        }
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("industry.name"));
        evi.getSelector().add(new SelectorItemInfo("industry.number"));
        evi.getSelector().add(new SelectorItemInfo("creator.name"));
        evi.getSelector().add(new SelectorItemInfo("creator.number"));
        evi.getSelector().add(new SelectorItemInfo("internalCompany.name"));
        evi.getSelector().add(new SelectorItemInfo("internalCompany.number"));
        return iCustomer.getCustomerCollection(evi);
    }

    @Override
    protected IObjectCollection _getCustomerCollectionByBizCode(Context ctx, String bizAnalysisCodeNumber) throws BOSException, EASBizException {
        IBizAnalysisCode iBizAnalysisCode = BizAnalysisCodeFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bizAnalysisCodeNumber, CompareType.EQUALS));
        IObjectPK[] pks = iBizAnalysisCode.getPKList(filter, null);
        if (pks == null) {
            return null;
        }
        if (pks.length > 1) {
            throw new CustomerSupplierException(CustomerSupplierException.BIZCODE_NOT_UNIQUE_UNDER_NUMBER, new Object[]{bizAnalysisCodeNumber});
        }
        return this._getCustomerCollectionByBizCode(ctx, pks[0]);
    }

    @Override
    protected IObjectCollection _getSupplierCollectionByBizCode(Context ctx, String bizAnalysisCodeNumber) throws BOSException, EASBizException {
        IBizAnalysisCode iBizAnalysisCode = BizAnalysisCodeFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bizAnalysisCodeNumber, CompareType.EQUALS));
        IObjectPK[] pks = iBizAnalysisCode.getPKList(filter, null);
        if (pks == null) {
            return null;
        }
        if (pks.length > 1) {
            throw new CustomerSupplierException(CustomerSupplierException.BIZCODE_NOT_UNIQUE_UNDER_NUMBER, new Object[]{bizAnalysisCodeNumber});
        }
        return this._getSupplierCollectionByBizCode(ctx, pks[0]);
    }

    @Override
    protected IObjectCollection _getSupplierCollectionByBizCode(Context ctx, IObjectPK bizAnalysisCodePK) throws BOSException, EASBizException {
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (bizAnalysisCodePK != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizAnalysisCode.id", (Object)bizAnalysisCodePK.toString(), CompareType.EQUALS));
        }
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("industry.name"));
        evi.getSelector().add(new SelectorItemInfo("industry.number"));
        evi.getSelector().add(new SelectorItemInfo("creator.name"));
        evi.getSelector().add(new SelectorItemInfo("creator.number"));
        evi.getSelector().add(new SelectorItemInfo("internalCompany.name"));
        evi.getSelector().add(new SelectorItemInfo("internalCompany.number"));
        return iSupplier.getSupplierCollection(evi);
    }

    protected void _updateCustomerIntegrateInfo(Context ctx, IObjectValue objVO, boolean isTemplate) throws BOSException, EASBizException {
        ICustomerIntegrateInfo iCustomerIntegrateInfo = CustomerIntegrateInfoFactory.getLocalInstance(ctx);
        if (isTemplate) {
            iCustomerIntegrateInfo.save((CoreBaseInfo)((ObjectBaseInfo)objVO));
        } else {
            iCustomerIntegrateInfo.submit((CoreBaseInfo)((ObjectBaseInfo)objVO));
        }
    }

    protected void _updateSupplierSummary(Context ctx, IObjectValue objVO, boolean isTemplate) throws BOSException, EASBizException {
        ISupplierSummary iSupplierSummary = SupplierSummaryFactory.getLocalInstance(ctx);
        if (isTemplate) {
            iSupplierSummary.save((CoreBaseInfo)((ObjectBaseInfo)objVO));
        } else {
            iSupplierSummary.submit((CoreBaseInfo)((ObjectBaseInfo)objVO));
        }
    }
}

