/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.master.cssp.app.AbstractCustomerCompanyInfoControllerBean;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomerCompanyInfoControllerBean
extends AbstractCustomerCompanyInfoControllerBean {
    protected void checkIntegrity(Context ctx, CustomerCompanyInfoInfo model) throws BOSException, EASBizException {
        model.verify(ctx);
        if (model.getCU() == null) {
            model.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (model.getCustomer() == null) {
            throw new CustomerSupplierException(CustomerSupplierException.CUSTOMER_COMPANY_INFO_REF_NULL_CSBASE);
        }
        if (model.getCompanyOrgUnit() == null) {
            throw new CustomerSupplierException(CustomerSupplierException.CUSTOMERCOMPANY_COMORGUNIT);
        }
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        if (model.getSettlementCurrency() == null) {
            CustomerInfo customerInfo = iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(model.getCustomer().getId()));
            throw new CustomerSupplierException(CustomerSupplierException.CUSTOMER_CURRENCY, new String[]{customerInfo.getNumber()});
        }
    }

    protected void checkDuplicate(Context ctx, CustomerCompanyInfoInfo model) throws BOSException, EASBizException {
        if (model.getCustomer().isIsMultiCopy()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)model.getCustomer().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)model.getCompanyOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        IObjectPK[] pks = this.getPKList(ctx, filter, null);
        if (pks.length > 0) {
            throw new CustomerSupplierException(CustomerSupplierException.CUSTOMER_COMPANYINFO_DEUPLICATED, new Object[]{model.getCustomer().getName(), model.getCompanyOrgUnit().getName(), ""});
        }
    }

    protected void addnewCheck(Context ctx, CustomerCompanyInfoInfo model) throws BOSException, EASBizException {
        if (model.getCustomer().getUsedStatus().equals((Object)UsedStatusEnum.FREEZED)) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
        }
        if (model.getCustomer().getId() != null) {
            this.checkIntegrity(ctx, model);
            this.checkDuplicate(ctx, model);
            this.checkNoBlankInBankAccount(ctx, model);
        }
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ((CustomerCompanyInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (CustomerCompanyInfoInfo)model);
        CustomerCompanyInfoInfo info = this.getCustomerCompanyInfoInfo(ctx, pk, this.getSelector());
        model.put("logRecord", (Object)(((CustomerCompanyInfoInfo)model).getCustomer().getName() + "  " + info.getCompanyOrgUnit().getName()));
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((CustomerCompanyInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (CustomerCompanyInfoInfo)model);
        IObjectPK pk = super._submit(ctx, model);
        CustomerCompanyInfoInfo info = this.getCustomerCompanyInfoInfo(ctx, pk, this.getSelector());
        model.put("logRecord", (Object)(((CustomerCompanyInfoInfo)model).getCustomer().getName() + "  " + info.getCompanyOrgUnit().getName()));
        return pk;
    }

    @Override
    protected void _updateCheck(Context ctx, IObjectPK pk, IObjectValue value) throws BOSException, EASBizException {
        CustomerCompanyInfoInfo model = (CustomerCompanyInfoInfo)value;
        if (model.getCustomer().getUsedStatus().equals((Object)UsedStatusEnum.FREEZED)) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
        }
        CustomerCompanyBankCollection bankColl = model.getCustomerBank();
        CustomerCompanyBankInfo bank = null;
        String bankAccount = null;
        Pattern p = Pattern.compile("\\s");
        Matcher match = null;
        for (int i = 0; i < bankColl.size(); ++i) {
            bank = bankColl.get(i);
            bankAccount = bank.getBankAccount() == null ? "" : bank.getBankAccount();
            match = p.matcher(bankAccount);
            if (!match.find()) continue;
            throw new CustomerSupplierException(CustomerSupplierException.NOSPACEINBANKACCOUNT, new Object[]{bankAccount});
        }
        BizCheckResult rs = BizCheckerUtil.hasDeal4Update((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new CustomerSupplierException(CustomerSupplierException.CANNOT_MODIFY_HASDEAL);
            }
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_MODIFY_HASDEAL);
        }
        if (model.getCustomer().getUsedStatus().equals((Object)UsedStatusEnum.FREEZED)) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
        }
        this.checkIntegrity(ctx, model);
        CustomerCompanyInfoInfo old = this.getCustomerCompanyInfoInfo(ctx, pk);
        if (!old.getCustomer().getId().toString().equals(model.getCustomer().getId().toString()) || !old.getCompanyOrgUnit().getId().toString().equals(model.getCompanyOrgUnit().getId().toString())) {
            this.checkDuplicate(ctx, model);
        }
    }

    protected void checkNoBlankInBankAccount(Context ctx, CustomerCompanyInfoInfo model) throws BOSException, EASBizException {
        CustomerCompanyBankInfo bank = null;
        String account = "";
        String regex = "\\s";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = null;
        if (model.getCustomerBank() != null && model.getCustomerBank().size() > 0) {
            for (int i = 0; i < model.getCustomerBank().size(); ++i) {
                bank = model.getCustomerBank().get(i);
                account = bank.getBankAccount();
                matcher = pattern.matcher(account);
                if (!matcher.find()) continue;
                throw new CustomerSupplierException(CustomerSupplierException.NOSPACEINBANKACCOUNT, new Object[]{account});
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new CustomerSupplierException(CustomerSupplierException.CANNOT_DELETE_HASDEAL);
            }
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CustomerCompanyInfoInfo info = (CustomerCompanyInfoInfo)model;
        info.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        ICustomerCompanyInfo iCustomerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        CustomerCompanyInfoInfo oldInfo = iCustomerCompanyInfo.getCustomerCompanyInfoInfo(pk, this.getSelectors());
        info.setCreateTime(oldInfo.getCreateTime());
        if (info.getCompanyOrgUnit() != null && info.getCompanyOrgUnit().getCU() != null) {
            info.setCU(info.getCompanyOrgUnit().getCU());
        }
        this._updateCheck(ctx, pk, (IObjectValue)info);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.number"));
        return sic;
    }

    protected void changeCustomerCompanyStatus(Context ctx, IObjectPK customerPK, boolean isFreezed) throws EASBizException, BOSException {
        ICustomerCompanyInfo iCustomerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        CustomerCompanyInfoInfo customerCompanyInfoInfo = iCustomerCompanyInfo.getCustomerCompanyInfoInfo(customerPK);
        if (customerCompanyInfoInfo == null) {
            return;
        }
        customerCompanyInfoInfo.setIsFreezeIssueInvoice(isFreezed);
        if (isFreezed) {
            customerCompanyInfoInfo.setFreezeOrgUnit(ContextUtil.getCurrentFIUnit((Context)ctx).castToFullOrgUnitInfo());
        } else {
            customerCompanyInfoInfo.setFreezeOrgUnit(null);
        }
        iCustomerCompanyInfo.update(customerPK, (CoreBaseInfo)customerCompanyInfoInfo);
    }

    protected void checkFreezed(Context ctx, IObjectPK customerPK, boolean isForceFreezed) throws BOSException, EASBizException {
        if (!isForceFreezed) {
            // empty if block
        }
    }

    protected void checkUnFreezed(Context ctx, IObjectPK customerPK, boolean isForceUnFreeze) throws BOSException, EASBizException {
        ICustomerCompanyInfo iCustomerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        CustomerCompanyInfoInfo customerCompanyInfoInfo = iCustomerCompanyInfo.getCustomerCompanyInfoInfo(customerPK, this.getSelector());
        if (customerCompanyInfoInfo == null) {
            return;
        }
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        CustomerInfo customerInfo = iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(customerCompanyInfoInfo.getCustomer().getId()));
        if (customerInfo.getUsedStatus().getValue() == 2) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UNFREE_BASEINFOIAFREEZED);
        }
        if (!isForceUnFreeze && customerInfo.getUsedStatus().getValue() == 1 && !customerCompanyInfoInfo.getFreezeOrgUnit().equalsPK((IObjectValue)customerCompanyInfoInfo.getCU())) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UNFREEZED_FREEZEDBYOTHERORG);
        }
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK pk, boolean isForceFreezed) throws BOSException, EASBizException {
        this.checkFreezed(ctx, pk, isForceFreezed);
        this.changeCustomerCompanyStatus(ctx, pk, true);
    }

    @Override
    protected void _unFreezed(Context ctx, IObjectPK pk, boolean isForceUnFreezed) throws BOSException, EASBizException {
        this.checkUnFreezed(ctx, pk, isForceUnFreezed);
        this.changeCustomerCompanyStatus(ctx, pk, false);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selectorItems = new SelectorItemCollection();
        selectorItems.add(new SelectorItemInfo("*"));
        selectorItems.add(new SelectorItemInfo("companyOrgUnit.id"));
        selectorItems.add(new SelectorItemInfo("companyOrgUnit.number"));
        selectorItems.add(new SelectorItemInfo("companyOrgUnit.name"));
        selectorItems.add(new SelectorItemInfo("freezeOrgUnit.id"));
        selectorItems.add(new SelectorItemInfo("freezeOrgUnit.number"));
        selectorItems.add(new SelectorItemInfo("freezeOrgUnit.name"));
        selectorItems.add(new SelectorItemInfo("customer.id"));
        selectorItems.add(new SelectorItemInfo("customer.number"));
        selectorItems.add(new SelectorItemInfo("customer.name"));
        selectorItems.add(new SelectorItemInfo("CU.id"));
        selectorItems.add(new SelectorItemInfo("CU.number"));
        selectorItems.add(new SelectorItemInfo("CU.name"));
        return selectorItems;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CustomerCompanyInfoInfo info = this.getCustomerCompanyInfoInfo(ctx, pk, this.getSelector());
        return info.getCustomer().getName() + "  " + info.getCompanyOrgUnit().getName();
    }

    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.changeStatus(ctx, new Object[]{pk}, UsingStatusEnum.FREEZED);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeStatus(ctx, pks, UsingStatusEnum.FREEZED);
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeStatus(ctx, pks, UsingStatusEnum.USING);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.changeStatus(ctx, new Object[]{pk}, UsingStatusEnum.USING);
    }

    private void changeStatus(Context ctx, Object[] pks, UsingStatusEnum status) throws BOSException, EASBizException {
        String resName;
        String logItem;
        if (pks == null) {
            return;
        }
        String oql = " select id,customer.number,companyOrgUnit.name,cu,UsingStatus where id in " + CSSPUtils.getIdsSql(pks);
        CustomerCompanyInfoCollection collection = this.getCustomerCompanyInfoCollection(ctx, oql);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            CustomerCompanyInfoInfo info = collection.get(i);
            list.add(info.getCustomer() == null ? "" : info.getCustomer().getNumber());
            if (info.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) continue;
            throw new CustomerSupplierException(CustomerSupplierException.UPDATE_OTHER_CU, new Object[]{info.getCustomer().getNumber() + " - " + info.getCompanyOrgUnit().getName()});
        }
        if (UsingStatusEnum.USING.equals((Object)status)) {
            logItem = "bd_cssp_customer_company_cancelCancel";
            resName = "CustomerCompanyCancelCancel";
        } else {
            logItem = "bd_cssp_customer_company_cancel";
            resName = "CustomerCompanyCancel";
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"changeStatus", (BOSObjectType)new CustomerCompanyInfoInfo().getBOSType(), null, (String)Arrays.toString((Object[])list.toArray()), (String)logItem, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)resName, (Locale)ctx.getOriginLocale()));
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" update T_BD_CustomerCompanyInfo ");
        sb.appendSql(" set FUsingStatus = ").appendSql(String.valueOf(status.getValue()));
        sb.appendSql(" ,flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=getdate() where fid in ").appendSql(CSSPUtils.getIdsSql(pks));
        sb.execute(ctx);
        ORMValueCacheService.getInstance().discardType(ctx, BOSObjectType.create((String)"7751B8D7"));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    protected void _freezed(Context ctx, CustomerCompanyInfoInfo info) throws BOSException, EASBizException {
        this.changeFreeze(ctx, new Object[]{info.getId()}, 1);
    }

    protected void _freezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeFreeze(ctx, pks, 1);
    }

    protected void _unFreezed(Context ctx, CustomerCompanyInfoInfo info) throws BOSException, EASBizException {
        this.changeFreeze(ctx, new Object[]{info.getId()}, 0);
    }

    protected void _unFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeFreeze(ctx, pks, 0);
    }

    private void changeFreeze(Context ctx, Object[] pks, int isFreeze) throws BOSException, EASBizException {
        if (pks == null) {
            return;
        }
        String oql = " select id,customer.number,companyOrgUnit.name,cu,UsingStatus where id in " + CSSPUtils.getIdsSql(pks);
        CustomerCompanyInfoCollection collection = this.getCustomerCompanyInfoCollection(ctx, oql);
        for (int i = 0; i < collection.size(); ++i) {
            CustomerCompanyInfoInfo info = collection.get(i);
            if (info.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) continue;
            throw new CustomerSupplierException(CustomerSupplierException.UPDATE_OTHER_CU, new Object[]{info.getCustomer().getNumber() + " - " + info.getCompanyOrgUnit().getName()});
        }
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" update T_BD_CustomerCompanyInfo ");
        sb.appendSql(" set FIsTicketFreezed = ").appendSql(String.valueOf(isFreeze));
        sb.appendSql(" where fid in ").appendSql(CSSPUtils.getIdsSql(pks));
        sb.execute(ctx);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            return super.submit(ctx, model);
        }
        try {
            IObjectPK retValue = this._submit4Import(ctx, model);
            return retValue;
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }

    public IObjectPK _submit4Import(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        ((CustomerCompanyInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (CustomerCompanyInfoInfo)model);
        if (model.getId() == null) {
            return this._addnew(ctx, (IObjectValue)model);
        }
        ObjectUuidPK pk = new ObjectUuidPK(model.getId());
        this._update(ctx, (IObjectPK)pk, (IObjectValue)model);
        return pk;
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        ((CustomerCompanyInfoInfo)model).setCreateTime(null);
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            return super.addnew(ctx, model);
        }
        try {
            return this._addnew(ctx, (IObjectValue)model);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            super.update(ctx, pk, model);
            return;
        }
        try {
            this._update(ctx, pk, (IObjectValue)model);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }
}

