/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.batch.app.GeneralBatchUpdateStrategy;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaler;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CustomerSalerInfoBatchUpdateStrategy
extends GeneralBatchUpdateStrategy {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.CustomerSalerInfoBatchUpdateStrategy");
    private static final String CSSP_RESOURCE = "com.kingdee.eas.basedata.master.cssp.CSSPResource";

    @Override
    protected void validateBizLogic(Context ctx, IObjectPK pk, Map params) throws BOSException, EASBizException {
    }

    @Override
    protected void validateBizLogic(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
        Integer org = (Integer)params.get("orgtype");
        String unitId = null;
        if (params.get("orgvalue") != null) {
            unitId = params.get("orgvalue").toString();
        }
        if (org != null) {
            switch (org) {
                case 2: {
                    if (unitId == null) break;
                    this.validateSale(ctx, pks, unitId, params);
                }
            }
        }
    }

    private void validateSale(Context ctx, Object[] pks, String unitId, Map params) throws BOSException, EASBizException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        HashMap<Object, CustomerSupplierException> exceptionMap = new HashMap<Object, CustomerSupplierException>();
        StringBuffer sqlParams = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            this.validateSale(ctx, (IObjectPK)new ObjectUuidPK(pks[i].toString()), unitId, params, exceptionMap);
            if (i > 0) {
                sqlParams.append(",");
            }
            sqlParams.append("'");
            sqlParams.append(pks[i].toString());
            sqlParams.append("'");
        }
        ResultSet saleOrgNotFitSet = null;
        ResultSet statusNotFitSet = null;
        ResultSet customerSet = null;
        Connection con = null;
        Statement statement = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            statement = con.createStatement();
            int customerCount = 0;
            int customerInfoCount = 0;
            int count = 0;
            ArrayList<String> customerList = new ArrayList<String>();
            ArrayList<String> saleInfoList = new ArrayList<String>();
            ArrayList currentIdList = new ArrayList();
            StringBuffer hasCustomerIdBuffer = new StringBuffer();
            hasCustomerIdBuffer.append(" select customer.fid, saleInfo.fid").append(" from T_BD_Customer customer").append(" inner join T_BD_CustomerSaleInfo saleInfo on customer.fid = saleInfo.FCustomerId").append(" where customer.fid in(").append(sqlParams.toString()).append(")").append(" and saleInfo.FSaleOrgId = '").append(unitId).append("'");
            saleOrgNotFitSet = statement.executeQuery(hasCustomerIdBuffer.toString());
            while (saleOrgNotFitSet.next()) {
                customerList.add(customerCount++, saleOrgNotFitSet.getString(1));
                saleInfoList.add(customerInfoCount++, saleOrgNotFitSet.getString(2));
            }
            CustomerSupplierException hasDealException = new CustomerSupplierException(CustomerSupplierException.CANNOT_MODIFY_HASDEAL);
            for (int i = 0; i < customerList.size(); ++i) {
                BizCheckResult rs = BizCheckerUtil.hasDeal4Update((Context)ctx, (BOSUuid)BOSUuid.read((String)saleInfoList.get(i).toString()));
                if (rs.isFound()) {
                    exceptionMap.put(customerList.get(i), hasDealException);
                    continue;
                }
                currentIdList.add(count++, customerList.get(i));
            }
            StringBuffer statusBuffer = new StringBuffer();
            sqlParams.delete(0, sqlParams.length());
            int c = currentIdList.size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(currentIdList.get(i).toString());
                sqlParams.append("'");
            }
            if (sqlParams.length() > 0) {
                statusBuffer.append(" select fid ").append(" from T_BD_Customer").append(" where fid in(").append(sqlParams.toString()).append(")").append(" and FUsedStatus =  2");
                statusNotFitSet = statement.executeQuery(statusBuffer.toString());
                CustomerSupplierException freezedException = new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
                while (statusNotFitSet.next()) {
                    exceptionMap.put(statusNotFitSet.getString(1), freezedException);
                }
                for (int i = 0; i < currentIdList.size(); ++i) {
                    if (exceptionMap.containsKey(currentIdList.get(i).toString())) continue;
                    this.uptIdList.add(saleInfoList.get(i).toString());
                }
            }
            sqlParams.delete(0, sqlParams.length());
            c = exceptionMap.keySet().toArray().length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(exceptionMap.keySet().toArray()[i].toString());
                sqlParams.append("'");
            }
            if (sqlParams.length() > 0) {
                StringBuffer customerBuffer = new StringBuffer();
                customerBuffer.append(" select FNumber ").append(" from ").append(" T_BD_Customer ").append(" where fid in(").append(sqlParams.toString()).append(")");
                customerSet = statement.executeQuery(customerBuffer.toString());
                count = 0;
                while (customerSet.next()) {
                    CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{customerSet.getString(1)});
                    this.log.addException(exception.getMessage(), (Exception)exceptionMap.get(exceptionMap.keySet().toArray()[count++]));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(saleOrgNotFitSet);
                SQLUtils.cleanup(statusNotFitSet);
                SQLUtils.cleanup(customerSet);
                SQLUtils.cleanup((Statement)statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)saleOrgNotFitSet);
        SQLUtils.cleanup((ResultSet)statusNotFitSet);
        SQLUtils.cleanup(customerSet);
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    private void validateSale(Context ctx, IObjectPK pk, String unitId, Map params, Map exceptionMap) throws BOSException {
        if (this.properties == null || this.properties.length == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)pk.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)unitId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        ICustomerSaleInfo ie = CustomerSaleInfoFactory.getLocalInstance(ctx);
        this.putSaleSelectors(view.getSelector());
        CustomerSaleInfoCollection ls = ie.getCustomerSaleInfoCollection(view);
        if (ls != null && ls.size() != 0) {
            CustomerSaleInfoInfo info = ls.get(0);
            String pn = null;
            if (this.values != null && this.values instanceof Map) {
                int size = this.properties.length;
                for (int i = 0; i < size; ++i) {
                    pn = this.properties[i].toString();
                    info.put(pn, ((Map)this.values).get(pn));
                }
            }
            try {
                ie.updateCheck((IObjectPK)new ObjectStringPK(info.getId().toString()), (IObjectValue)info);
                this.uptIdList.add(info.getId().toString());
            }
            catch (Exception ex) {
                exceptionMap.put(pk.toString(), ex);
            }
        } else {
            CustomerInfo customerInfo = null;
            try {
                customerInfo = CustomerFactory.getLocalInstance(ctx).getCustomerInfo(pk);
                throw new CustomerSupplierException(CustomerSupplierException.SALEORG_NOTDEAL_CUSTOMER, new String[]{customerInfo.getNumber()});
            }
            catch (Exception e) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.CUSTOMER_BATCH_FAILD, new String[]{customerInfo.getNumber()});
                this.log.addException(exception.getMessage(), e);
            }
        }
    }

    private void putSaleSelectors(SelectorItemCollection selectors) {
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("customer.id"));
        selectors.add(new SelectorItemInfo("customer.number"));
        selectors.add(new SelectorItemInfo("customer.usedStatus"));
        selectors.add(new SelectorItemInfo("saleOrgUnit.id"));
        selectors.add(new SelectorItemInfo("cu.id"));
        selectors.add(new SelectorItemInfo("effectedStatus"));
        selectors.add(new SelectorItemInfo("taxRate"));
    }

    @Override
    protected void executeUpdate(Context ctx) throws BOSException {
        if (this.uptIdList == null || this.uptIdList.size() == 0 || this.values == null || !(this.values instanceof Map)) {
            return;
        }
        HashSet<String> needModifyCustomerSaleInfoIds = new HashSet<String>();
        needModifyCustomerSaleInfoIds.addAll(this.uptIdList);
        HashSet<String> personInfoIds = new HashSet<String>();
        if (((Map)this.values).get("person") == null) {
            return;
        }
        personInfoIds.addAll((List)((Map)this.values).get("person"));
        if (personInfoIds == null && personInfoIds.size() < 1) {
            return;
        }
        Boolean salerPersonInfoOverwriteFlag = (Boolean)((Map)this.values).get("salerPersonInfoOverwrite");
        PersonCollection personCollection = this.getPersonInfo(ctx, personInfoIds);
        CustomerSaleInfoCollection needModifyCustomerSaleInfoCollection = this.getCustomerSaleInfo(ctx, needModifyCustomerSaleInfoIds);
        String methodDescription = ResourceBase.getString((String)CSSP_RESOURCE, (String)"customerSalerInfoModifyMsg001", (Locale)ctx.getOriginLocale());
        String instanceDetailStrCovert = "";
        StringBuilder instanceDetailStr = null;
        try {
            instanceDetailStr = this.buildInstanceDetailStr(ctx, personCollection, needModifyCustomerSaleInfoIds, needModifyCustomerSaleInfoCollection, salerPersonInfoOverwriteFlag);
        }
        catch (Exception e) {
            logger.error((Object)"\u6279\u91cf\u4fee\u6539\u5ba2\u6237\u9500\u552e\u5458\u8bb0\u5f55\u4e0a\u673a\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
        }
        instanceDetailStrCovert = instanceDetailStr.length() > 1200 ? instanceDetailStr.substring(0, 1200) : instanceDetailStr.toString();
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"CustomerSalerInfoBatchUpdateStrategy#executeUpdate", (BOSObjectType)new BOSObjectType("B879AD9D"), null, (String)instanceDetailStrCovert, (String)"bd_cssp_customerSalerInfo_modify", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)methodDescription);
        try {
            ICustomerSaler iCustomerSaler = CustomerSalerFactory.getLocalInstance(ctx);
            if (salerPersonInfoOverwriteFlag.booleanValue()) {
                this.deleteSalerInfo(needModifyCustomerSaleInfoIds, iCustomerSaler);
                this.addSalerInfo(needModifyCustomerSaleInfoCollection, personCollection, iCustomerSaler);
            } else {
                this.addSalerInfo(needModifyCustomerSaleInfoCollection, personCollection, iCustomerSaler);
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private StringBuilder buildInstanceDetailStr(Context ctx, PersonCollection personCollection, Set<String> needModifyCustomerSaleInfoIds, CustomerSaleInfoCollection needModifyCustomerSaleInfoCollection, Boolean salerPersonInfoOverwriteFlag) throws BOSException {
        StringBuilder oql = new StringBuilder("where customersale.id in(");
        for (String needModifyCustomerSaleInfoId : needModifyCustomerSaleInfoIds) {
            oql.append("'");
            oql.append(needModifyCustomerSaleInfoId);
            oql.append("'");
            oql.append(",");
        }
        oql.deleteCharAt(oql.length() - 1);
        oql.append(")");
        HashSet<String> oldPersonIds = new HashSet<String>();
        CustomerSalerCollection oldCustomerSalerCollection = CustomerSalerFactory.getLocalInstance(ctx).getCustomerSalerCollection(oql.toString());
        HashMap oldCustomerSalerMap = new HashMap();
        if (oldCustomerSalerCollection != null && oldCustomerSalerCollection.size() > 0) {
            for (int i = 0; i < oldCustomerSalerCollection.size(); ++i) {
                List<CustomerSalerInfo> list;
                CustomerSalerInfo oldCustomerSalerInfo = oldCustomerSalerCollection.get(i);
                oldPersonIds.add(oldCustomerSalerInfo.getPerson().getId().toString());
                String oldCustomerSaleInfoId = oldCustomerSalerInfo.getCustomerSale().getId().toString();
                if (oldCustomerSalerMap.get(oldCustomerSaleInfoId) != null) {
                    list = (List)oldCustomerSalerMap.get(oldCustomerSaleInfoId);
                    list.add(oldCustomerSalerInfo);
                    oldCustomerSalerMap.put(oldCustomerSaleInfoId, list);
                    continue;
                }
                list = new ArrayList();
                list.add(oldCustomerSalerInfo);
                oldCustomerSalerMap.put(oldCustomerSaleInfoId, list);
            }
        }
        Map<String, PersonInfo> oldPersonInfoMap = this.getPersonInfoMap(ctx, oldPersonIds);
        HashSet<String> customerBasicInfoIds = new HashSet<String>(needModifyCustomerSaleInfoCollection.size());
        HashSet<String> saleOrgUnitIds = new HashSet<String>(needModifyCustomerSaleInfoCollection.size());
        for (int i = 0; i < needModifyCustomerSaleInfoCollection.size(); ++i) {
            CustomerSaleInfoInfo needModifyCustomerSaleInfo = needModifyCustomerSaleInfoCollection.get(i);
            customerBasicInfoIds.add(needModifyCustomerSaleInfo.getCustomer().getId().toString());
            saleOrgUnitIds.add(needModifyCustomerSaleInfo.getSaleOrgUnit().getId().toString());
        }
        Map<String, CustomerInfo> customerInfoMap = this.getCustomerBasicInfo(ctx, customerBasicInfoIds);
        Map<String, SaleOrgUnitInfo> saleOrgUnitInfoMap = this.getSaleOrgUnitInfo(ctx, saleOrgUnitIds);
        StringBuilder instanceDetailStr = new StringBuilder();
        for (int i = 0; i < needModifyCustomerSaleInfoCollection.size(); ++i) {
            SaleOrgUnitInfo saleOrgUnitInfo;
            CustomerSaleInfoInfo needModifyCustomerSaleInfoInfo = needModifyCustomerSaleInfoCollection.get(i);
            CustomerInfo customerInfo = customerInfoMap.get(needModifyCustomerSaleInfoInfo.getCustomer().getId().toString());
            if (customerInfo == null) {
                customerInfo = new CustomerInfo();
            }
            if ((saleOrgUnitInfo = saleOrgUnitInfoMap.get(needModifyCustomerSaleInfoInfo.getSaleOrgUnit().getId().toString())) == null) {
                saleOrgUnitInfo = new SaleOrgUnitInfo();
            }
            instanceDetailStr.append(ResourceBase.getString((String)CSSP_RESOURCE, (String)"customerSalerInfoModifyMsg002", (Locale)ctx.getOriginLocale()));
            instanceDetailStr.append(customerInfo.getName());
            instanceDetailStr.append("(");
            instanceDetailStr.append(customerInfo.getNumber());
            instanceDetailStr.append(")");
            instanceDetailStr.append(",");
            instanceDetailStr.append(ResourceBase.getString((String)CSSP_RESOURCE, (String)"customerSalerInfoModifyMsg003", (Locale)ctx.getOriginLocale()));
            instanceDetailStr.append(saleOrgUnitInfo.getName());
            instanceDetailStr.append("(");
            instanceDetailStr.append(saleOrgUnitInfo.getNumber());
            instanceDetailStr.append(")");
            instanceDetailStr.append(ResourceBase.getString((String)CSSP_RESOURCE, (String)"customerSalerInfoModifyMsg004", (Locale)ctx.getOriginLocale()));
            List oldCustomerSalerInfos = (List)oldCustomerSalerMap.get(needModifyCustomerSaleInfoInfo.getId().toString());
            PersonCollection afterPersonCollection = new PersonCollection();
            afterPersonCollection.addCollection(personCollection);
            if (oldCustomerSalerInfos != null && oldCustomerSalerInfos.size() > 0) {
                for (int j = 0; j < oldCustomerSalerInfos.size(); ++j) {
                    CustomerSalerInfo customerSalerInfo = (CustomerSalerInfo)oldCustomerSalerInfos.get(j);
                    PersonInfo personInfo = oldPersonInfoMap.get(customerSalerInfo.getPerson().getId().toString());
                    if (personInfo == null) {
                        personInfo = new PersonInfo();
                    }
                    if (!salerPersonInfoOverwriteFlag.booleanValue()) {
                        afterPersonCollection.add(personInfo);
                    }
                    instanceDetailStr.append(personInfo.getName());
                    instanceDetailStr.append("(");
                    instanceDetailStr.append(personInfo.getNumber());
                    instanceDetailStr.append(")");
                    instanceDetailStr.append(",");
                }
            } else {
                instanceDetailStr.append(ResourceBase.getString((String)CSSP_RESOURCE, (String)"customerSalerInfoModifyMsg005", (Locale)ctx.getOriginLocale()));
                instanceDetailStr.append(",");
            }
            instanceDetailStr.append(ResourceBase.getString((String)CSSP_RESOURCE, (String)"customerSalerInfoModifyMsg006", (Locale)ctx.getOriginLocale()));
            for (int k = 0; k < afterPersonCollection.size(); ++k) {
                PersonInfo personInfo = afterPersonCollection.get(k);
                if (personInfo == null) {
                    personInfo = new PersonInfo();
                }
                instanceDetailStr.append(personInfo.getName());
                instanceDetailStr.append("(");
                instanceDetailStr.append(personInfo.getNumber());
                instanceDetailStr.append(")");
                instanceDetailStr.append(",");
            }
            instanceDetailStr.append("\n");
        }
        return instanceDetailStr;
    }

    private Map<String, PersonInfo> getPersonInfoMap(Context ctx, Set<String> oldPersonIds) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", oldPersonIds, CompareType.INCLUDE));
        entityViewInfo.setSelector(selector);
        entityViewInfo.setFilter(filter);
        PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(entityViewInfo);
        HashMap<String, PersonInfo> oldPersonInfoMap = new HashMap<String, PersonInfo>();
        for (int i = 0; i < personCollection.size(); ++i) {
            PersonInfo personInfo = personCollection.get(i);
            oldPersonInfoMap.put(personInfo.getId().toString(), personInfo);
        }
        return oldPersonInfoMap;
    }

    private Map<String, SaleOrgUnitInfo> getSaleOrgUnitInfo(Context ctx, Set<String> saleOrgUnitIds) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", saleOrgUnitIds, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("name");
        ev.getSelector().add("number");
        SaleOrgUnitCollection saleOrgUnitCollection = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitCollection(ev);
        HashMap<String, SaleOrgUnitInfo> saleOrgUnitInfoMap = new HashMap<String, SaleOrgUnitInfo>();
        if (saleOrgUnitCollection != null && saleOrgUnitCollection.size() > 0) {
            for (int i = 0; i < saleOrgUnitCollection.size(); ++i) {
                SaleOrgUnitInfo saleOrgUnitInfo = saleOrgUnitCollection.get(i);
                saleOrgUnitInfoMap.put(saleOrgUnitInfo.getId().toString(), saleOrgUnitInfo);
            }
        }
        return saleOrgUnitInfoMap;
    }

    private Map<String, CustomerInfo> getCustomerBasicInfo(Context ctx, Set<String> customerBasicInfoIds) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", customerBasicInfoIds, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("name");
        ev.getSelector().add("number");
        CustomerCollection customerCollection = CustomerFactory.getLocalInstance(ctx).getCustomerCollection(ev);
        HashMap<String, CustomerInfo> customerInfoMap = new HashMap<String, CustomerInfo>();
        if (customerCollection != null && customerCollection.size() > 0) {
            for (int i = 0; i < customerCollection.size(); ++i) {
                CustomerInfo customerInfo = customerCollection.get(i);
                customerInfoMap.put(customerInfo.getId().toString(), customerInfo);
            }
        }
        return customerInfoMap;
    }

    private void addSalerInfo(CustomerSaleInfoCollection needModifyCustomerSaleInfoCollection, PersonCollection personCollection, ICustomerSaler iCustomerSaler) throws BOSException, EASBizException {
        CoreBaseCollection collection = new CoreBaseCollection();
        for (int i = 0; i < needModifyCustomerSaleInfoCollection.size(); ++i) {
            for (int j = 0; j < personCollection.size(); ++j) {
                CustomerSalerInfo customerSalerInfo = new CustomerSalerInfo();
                customerSalerInfo.setCustomerSale(needModifyCustomerSaleInfoCollection.get(i));
                customerSalerInfo.setPerson(personCollection.get(j));
                collection.add((CoreBaseInfo)customerSalerInfo);
            }
        }
        if (collection.size() <= 1000) {
            iCustomerSaler.addnew(collection);
        } else {
            ArrayList<CoreBaseInfo> coreBaseInfoList = new ArrayList<CoreBaseInfo>();
            for (int i = 0; i < collection.size(); ++i) {
                coreBaseInfoList.add(collection.get(i));
            }
            this.batchAddSalerInfo(coreBaseInfoList, 1000, iCustomerSaler);
        }
    }

    private CustomerSaleInfoCollection getCustomerSaleInfo(Context ctx, Set<String> needModifyCustomerSaleInfoIds) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("customer.id"));
        selector.add(new SelectorItemInfo("saleOrgUnit.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", needModifyCustomerSaleInfoIds, CompareType.INCLUDE));
        entityViewInfo.setSelector(selector);
        entityViewInfo.setFilter(filter);
        CustomerSaleInfoCollection needModifyCustomerSaleInfoCollection = CustomerSaleInfoFactory.getLocalInstance(ctx).getCustomerSaleInfoCollection(entityViewInfo);
        return needModifyCustomerSaleInfoCollection;
    }

    private PersonCollection getPersonInfo(Context ctx, Set<String> personInfoIds) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", personInfoIds, CompareType.INCLUDE));
        entityViewInfo.setSelector(selector);
        entityViewInfo.setFilter(filter);
        PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(entityViewInfo);
        return personCollection;
    }

    private void deleteSalerInfo(Set<String> needModifyCustomerSaleInfoIds, ICustomerSaler iCustomerSaler) throws BOSException, EASBizException {
        if (needModifyCustomerSaleInfoIds.size() <= 1000) {
            this.excuteDeleteSalerInfo(new ArrayList<String>(needModifyCustomerSaleInfoIds), iCustomerSaler);
        } else {
            ArrayList<String> recordList = new ArrayList<String>(needModifyCustomerSaleInfoIds);
            this.batchDeleteSalerInfo(recordList, 1000, iCustomerSaler);
        }
    }

    private void excuteDeleteSalerInfo(List<String> needModifyCustomerSaleInfoIds, ICustomerSaler iCustomerSaler) throws BOSException, EASBizException {
        StringBuilder oql = new StringBuilder("where customersale.id in (");
        for (String customerSaleInfoId : needModifyCustomerSaleInfoIds) {
            oql.append("'");
            oql.append(customerSaleInfoId);
            oql.append("'");
            oql.append(",");
        }
        oql.deleteCharAt(oql.length() - 1);
        oql.append(")");
        iCustomerSaler.delete(oql.toString());
    }

    private void batchDeleteSalerInfo(List<String> recordList, int maxValue, ICustomerSaler iCustomerSaler) throws BOSException, EASBizException {
        ArrayList<String> perList = new ArrayList<String>();
        int size = recordList.size();
        int total = size / maxValue;
        if (size % maxValue != 0) {
            ++total;
        }
        for (int i = 0; i < total; ++i) {
            if (i == total - 1) {
                maxValue = size - i * maxValue;
            }
            for (int j = 0; j < maxValue; ++j) {
                perList.add(recordList.get(j));
            }
            this.excuteDeleteSalerInfo(perList, iCustomerSaler);
            recordList.removeAll(perList);
            perList.clear();
        }
    }

    private void batchAddSalerInfo(List<CoreBaseInfo> recordList, int maxValue, ICustomerSaler iCustomerSaler) throws BOSException, EASBizException {
        ArrayList<CoreBaseInfo> perList = new ArrayList<CoreBaseInfo>();
        int size = recordList.size();
        int total = size / maxValue;
        if (size % maxValue != 0) {
            ++total;
        }
        for (int i = 0; i < total; ++i) {
            if (i == total - 1) {
                maxValue = size - i * maxValue;
            }
            for (int j = 0; j < maxValue; ++j) {
                perList.add(recordList.get(j));
            }
            CoreBaseCollection collection = new CoreBaseCollection();
            for (CoreBaseInfo coreBaseInfo : perList) {
                collection.add(coreBaseInfo);
            }
            iCustomerSaler.addnew(collection);
            recordList.removeAll(perList);
            collection.clear();
            perList.clear();
        }
    }
}

