/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionEntryCollection;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionEntryInfo;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionInfo;
import com.kingdee.eas.basedata.master.cssp.app.IAutoAssignSolutionExecuteHandler;
import com.kingdee.eas.basedata.master.cssp.util.AutoAssignSolutionUtil;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class MaterialAutoAssignSolutionExecuteHandler
implements IAutoAssignSolutionExecuteHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.MaterialAutoAssignSolutionExecuteHandler");
    private static final ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.basedata.master.cssp.CSSPAutoAssignResource");

    @Override
    public void execAutoAssignSolution(Context ctx, AutoAssignSolutionInfo autoAssignSolutionInfo) throws BOSException, EASBizException {
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        AutoAssignSolutionEntryCollection solutionEntries = autoAssignSolutionInfo.getEntries();
        if (solutionEntries == null || solutionEntries.size() < 1) {
            logger.error((Object)("\u6839\u636e\u65b9\u6848id:" + autoAssignSolutionInfo.getId().toString() + "  \u83b7\u53d6\u5230\u7684\u5206\u5f55\u4e3a\u7a7a!"));
            return;
        }
        for (int i = 0; i < solutionEntries.size(); ++i) {
            AutoAssignSolutionEntryInfo assignSolutionEntryInfo = solutionEntries.get(i);
            String[] targetCUs = null;
            CtrlUnitInfo sourceCtrlUnitInfo = iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(assignSolutionEntryInfo.getSourceCU().getId()));
            if (assignSolutionEntryInfo.isIsAssignAllCU()) {
                CtrlUnitCollection allLevelCtrlUnits = AutoAssignSolutionUtil.queryAllLevelCtrlUnits(ctx, new BOSObjectType("4409E7F0"), sourceCtrlUnitInfo, iCtrlUnit);
                if (allLevelCtrlUnits != null && allLevelCtrlUnits.size() > 0) {
                    targetCUs = new String[allLevelCtrlUnits.size()];
                    for (int k = 0; k < allLevelCtrlUnits.size(); ++k) {
                        targetCUs[k] = allLevelCtrlUnits.get(k).getId().toString();
                    }
                }
            } else {
                targetCUs = new String[assignSolutionEntryInfo.getTargetCU().size()];
                for (int j = 0; j < assignSolutionEntryInfo.getTargetCU().size(); ++j) {
                    targetCUs[j] = assignSolutionEntryInfo.getTargetCU().get(j).getCtrlUnit().getId().toString();
                }
            }
            if (targetCUs == null || targetCUs.length < 1) {
                logger.error((Object)("\u65b9\u6848id:" + autoAssignSolutionInfo.getId().toString() + "  ,\u83b7\u53d6\u5230\u7684\u76ee\u6807\u7ec4\u7ec7\u4e3a\u7a7a!"));
                return;
            }
            List<String> diddata = this.getDiddata(ctx, iMaterial, iQuerySolution, assignSolutionEntryInfo, sourceCtrlUnitInfo, targetCUs);
            if (diddata.size() < 1) {
                return;
            }
            StringBuilder instanceDetailStr = this.buildInstanceDetailStr(ctx, autoAssignSolutionInfo, diddata, sourceCtrlUnitInfo, targetCUs, iCtrlUnit, iMaterial);
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"MaterialAutoAssignSolutionExecuteHandler(execAutoAssignSolution)", (BOSObjectType)autoAssignSolutionInfo.getBOSType(), null, (String)instanceDetailStr.toString(), (String)"MaterialAutoAssign_Excute", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)resHelper.getString("AutoAssignMsg024"));
            this.doAssign(iMaterial, assignSolutionEntryInfo, sourceCtrlUnitInfo, targetCUs, diddata);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
    }

    private StringBuilder buildInstanceDetailStr(Context ctx, AutoAssignSolutionInfo autoAssignSolutionInfo, List<String> diddata, CtrlUnitInfo sourceCtrlUnitInfo, String[] targetCUs, ICtrlUnit iCtrlUnit, IMaterial iMaterial) throws BOSException {
        StringBuilder instanceDetailStr = new StringBuilder();
        instanceDetailStr.append(resHelper.getString("AutoAssignMsg009") + autoAssignSolutionInfo.getName() + "(" + autoAssignSolutionInfo.getNumber() + ")");
        instanceDetailStr.append(";");
        instanceDetailStr.append(resHelper.getString("AutoAssignMsg010") + sourceCtrlUnitInfo.getName() + "(" + sourceCtrlUnitInfo.getNumber() + ");");
        CtrlUnitCollection targetCollection = this.getTargetCUInfo(iCtrlUnit, targetCUs);
        instanceDetailStr.append(resHelper.getString("AutoAssignMsg011"));
        if (targetCollection != null && targetCollection.size() > 0) {
            for (int i = 0; i < targetCollection.size(); ++i) {
                CtrlUnitInfo targetCU = targetCollection.get(i);
                instanceDetailStr.append(targetCU.getName() + "(" + targetCU.getNumber() + ")");
                if (i == targetCollection.size() - 1) break;
                instanceDetailStr.append(",");
            }
        }
        instanceDetailStr.append(";");
        instanceDetailStr.append(resHelper.getString("AutoAssignMsg012"));
        MaterialCollection materialCollection = this.getMaterialInfo(iMaterial, diddata);
        if (materialCollection != null && materialCollection.size() > 0) {
            for (int i = 0; i < materialCollection.size(); ++i) {
                MaterialInfo materialInfo = materialCollection.get(i);
                instanceDetailStr.append(materialInfo.getName() + "(" + materialInfo.getNumber() + ")");
                if (i == materialCollection.size() - 1) break;
                instanceDetailStr.append(",");
            }
        }
        return instanceDetailStr;
    }

    private MaterialCollection getMaterialInfo(IMaterial iMaterial, List<String> diddata) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(diddata), CompareType.INCLUDE));
        view.setFilter(filter);
        MaterialCollection materialCollection = iMaterial.getMaterialCollection(view);
        return materialCollection;
    }

    private CtrlUnitCollection getTargetCUInfo(ICtrlUnit iCtrlUnit, String[] targetCUs) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        HashSet<String> tarCUSet = new HashSet<String>(Arrays.asList(targetCUs));
        filter.getFilterItems().add(new FilterItemInfo("id", tarCUSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CtrlUnitCollection ctrlUnitCollection = iCtrlUnit.getCtrlUnitCollection(view);
        return ctrlUnitCollection;
    }

    private void doAssign(IMaterial iMaterial, AutoAssignSolutionEntryInfo assignSolutionEntryInfo, CtrlUnitInfo sourceCU, String[] cuiddata, List<String> diddata) throws BOSException, EASBizException {
        if (assignSolutionEntryInfo.isIsAssignAssistData()) {
            iMaterial.batchAssign2(sourceCU.getId().toString(), diddata.toArray(new String[diddata.size()]), cuiddata, null);
        } else {
            iMaterial.batchAssign(sourceCU.getId().toString(), diddata.toArray(new String[diddata.size()]), cuiddata);
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<String> getDiddata(Context ctx, IMaterial iMaterial, IQuerySolution iQuerySolution, AutoAssignSolutionEntryInfo assignSolutionEntryInfo, CtrlUnitInfo sourceCU, String[] targetCUs) throws BOSException, EASBizException {
        sqlBuilder = this.buildFilterSql(ctx, sourceCU, targetCUs);
        diddata = new ArrayList<String>();
        if (!StringUtil.isEmpty(assignSolutionEntryInfo.getAssignFilterRule()) && !"null".equalsIgnoreCase(assignSolutionEntryInfo.getAssignFilterRule())) {
            querySolutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(assignSolutionEntryInfo.getAssignFilterRule()));
            if (querySolutionInfo != null && !StringUtil.isEmpty(querySolutionInfo.getEntityViewInfo())) {
                view = new EntityViewInfo();
                querySolutionInfoFilter = AutoAssignSolutionUtil.getInnerFilterInfo(querySolutionInfo);
                oql = " id in (" + sqlBuilder.toString() + ")";
                filterInfo = null;
                try {
                    filterInfo = new FilterInfo(oql);
                }
                catch (ParserException e) {
                    e.printStackTrace();
                }
                querySolutionInfoFilter.mergeFilter(filterInfo, "and");
                view.setFilter(querySolutionInfoFilter);
                materialCollection = iMaterial.getCollection(view);
                if (materialCollection != null && materialCollection.size() > 0) {
                    for (i = 0; i < materialCollection.size(); ++i) {
                        diddata.add(materialCollection.get(i).getId().toString());
                    }
                }
            }
        } else {
            try {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
                if (rowSet == null) ** GOTO lbl35
                while (rowSet.next()) {
                    diddata.add(rowSet.getString("id"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
lbl35:
        // 4 sources

        if (diddata.size() < 1) {
            MaterialAutoAssignSolutionExecuteHandler.logger.info((Object)"---\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u53ef\u5206\u914d\u7684\u7269\u6599\u57fa\u672c\u8d44\u6599\u6570\u636e---");
            return diddata;
        }
        return diddata;
    }

    private StringBuilder buildFilterSql(Context ctx, CtrlUnitInfo sourceCU, String[] targetCtrlUnits) throws BOSException, EASBizException {
        Set visibleOrgIDs = AutoAssignSolutionUtil.getVisibleOrgIDs(ctx, new BOSObjectType("4409E7F0"), (IObjectPK)new ObjectUuidPK(sourceCU.getId().toString()));
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select top 60000 v.id from (");
        sqlBuilder.append("select material.fid id from t_bd_material material ");
        sqlBuilder.append("left outer join t_bd_materialgroup materialgroup ");
        sqlBuilder.append("on material.fmaterialgroupid = materialgroup.fid ");
        sqlBuilder.append("left outer join t_bd_measureunit as baseunit ");
        sqlBuilder.append("on material.fbaseunit = baseunit.fid ");
        sqlBuilder.append("inner join t_pm_user creator ");
        sqlBuilder.append("on material.fcreatorid = creator.fid ");
        sqlBuilder.append("inner join t_org_ctrlunit cu ");
        sqlBuilder.append("on material.fcontrolunitid = cu.fid ");
        sqlBuilder.append("where ");
        sqlBuilder.append("material.fstatus = 1 ");
        sqlBuilder.append("and materialgroup.fdeletedstatus = 1 ");
        if (visibleOrgIDs != null && visibleOrgIDs.size() > 0) {
            sqlBuilder.append("and (cu.fid = '");
            sqlBuilder.append(sourceCU.getId().toString());
            sqlBuilder.append("'");
            sqlBuilder.append(" or ");
            sqlBuilder.append("cu.fid IN (");
            int step = 0;
            for (Object visibleOrgID : visibleOrgIDs) {
                sqlBuilder.append("'");
                sqlBuilder.append(visibleOrgID);
                sqlBuilder.append("'");
                if (step == visibleOrgIDs.size() - 1) break;
                sqlBuilder.append(",");
                ++step;
            }
            sqlBuilder.append(") ");
            sqlBuilder.append(") ");
        } else {
            sqlBuilder.append("and cu.fid = '");
            sqlBuilder.append(sourceCU.getId().toString());
            sqlBuilder.append("'");
        }
        sqlBuilder.append(") v ");
        sqlBuilder.append("where not exists ");
        sqlBuilder.append("( ");
        sqlBuilder.append("select fdatabasedid from t_bd_databasedassign assign where assign.fdatabasedid = v.id ");
        sqlBuilder.append("and assign.fassigncuid in (");
        for (int i = 0; i < targetCtrlUnits.length; ++i) {
            sqlBuilder.append("'");
            sqlBuilder.append(targetCtrlUnits[i]);
            sqlBuilder.append("'");
            if (i == targetCtrlUnits.length - 1) break;
            sqlBuilder.append(",");
        }
        sqlBuilder.append(") ");
        sqlBuilder.append("group by fdatabasedid having count(fassigncuid) >= " + targetCtrlUnits.length);
        sqlBuilder.append(")");
        return sqlBuilder;
    }
}

