/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierAssitDataEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SrmSupplierFacadeControllerBeanImpl {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.SrmSupplierFacadeControllerBeanImpl");
    private static final String SRM_SUPPLIER_RESOURCE = "com.kingdee.eas.basedata.master.cssp.SrmSupplierResource";
    private static final String CODE = "code";
    private static final String MSG = "msg";
    private static final String SUCCESS_CODE = "000";
    private static final String NOT_EXIST_CODE = "001";
    private static final String SUPPLIER_CODE = "supplierCode";
    private static final String FAILED_CODE = "002";
    private static final String CURRENT_UNIT_CODE = "currentUnitCode";

    public String assign(Context ctx, Map param) throws Exception {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        ResourceBundleHelper resHelper = new ResourceBundleHelper(SRM_SUPPLIER_RESOURCE);
        if (this.checkParam(param, resultMap, resHelper)) {
            logger.error((Object)("--SrmSupplierFacadeControllerBean._assign---END,resultMap is :" + resultMap));
            return JSON.toJSONString(resultMap);
        }
        String currentUnitCode = param.get(CURRENT_UNIT_CODE).toString();
        FullOrgUnitInfo fullOrgUnitInfo = this.getFullOrgUnitInfoByCode(ctx, currentUnitCode);
        if (fullOrgUnitInfo == null) {
            resultMap.put(CODE, FAILED_CODE);
            resultMap.put(MSG, resHelper.getString("msg004") + currentUnitCode + ")");
            logger.error((Object)("--SrmSupplierFacadeControllerBean._assign---END,resultMap is :" + resultMap));
            return JSON.toJSONString(resultMap);
        }
        CtrlUnitInfo targetUnitInfo = fullOrgUnitInfo.getCU();
        SupplierInfo supplierInfo = this.findSupplierByCode(ctx, param);
        if (supplierInfo == null) {
            resultMap.put(CODE, NOT_EXIST_CODE);
            resultMap.put(MSG, resHelper.getString("msg005") + param.get(SUPPLIER_CODE) + ")");
            logger.error((Object)("--SrmSupplierFacadeControllerBean._assign---END,resultMap is :" + resultMap));
            return JSON.toJSONString(resultMap);
        }
        if (supplierInfo.getCU().getId().toString().equals(targetUnitInfo.getId().toString())) {
            this.dealSupplierWithStatus(ctx, supplierInfo);
            this.dealSupplierAssistWithStatus(ctx, supplierInfo, targetUnitInfo);
            resultMap.put(CODE, SUCCESS_CODE);
            resultMap.put(MSG, "success");
            logger.error((Object)("--SrmSupplierFacadeControllerBean._assign---END,resultMap is :" + resultMap));
            return JSON.toJSONString(resultMap);
        }
        boolean isAssignFlag = this.unitSuborRelationship(ctx, supplierInfo, targetUnitInfo);
        if (isAssignFlag) {
            this.dealSupplierWithStatus(ctx, supplierInfo);
            this.assignSupplierInfo(ctx, supplierInfo, targetUnitInfo, currentUnitCode, resultMap, resHelper);
            if (resultMap.isEmpty()) {
                resultMap.put(CODE, SUCCESS_CODE);
                resultMap.put(MSG, "success");
            }
            logger.error((Object)("--SrmSupplierFacadeControllerBean._assign---END,resultMap is :" + resultMap));
            return JSON.toJSONString(resultMap);
        }
        if (UsedStatusEnum.UNAPPROVE.getValue() == supplierInfo.getUsedStatus().getValue()) {
            resultMap.put(CODE, FAILED_CODE);
            resultMap.put(MSG, SrmSupplierFacadeControllerBeanImpl.convertStr(resHelper.getString("msg011"), supplierInfo.getNumber()));
            return JSON.toJSONString(resultMap);
        }
        Map assitDataMap = this.getSourceAssistData(ctx, supplierInfo);
        this.upgradeSupplierInfo(ctx, supplierInfo, targetUnitInfo, currentUnitCode, resultMap, resHelper);
        this.copySourceAssistData(ctx, assitDataMap, currentUnitCode, targetUnitInfo);
        if (resultMap.isEmpty()) {
            resultMap.put(CODE, SUCCESS_CODE);
            resultMap.put(MSG, "success");
        }
        logger.error((Object)("--SrmSupplierFacadeControllerBean._assign---END,resultMap is :" + resultMap));
        return JSON.toJSONString(resultMap);
    }

    private void copySourceAssistData(Context ctx, Map assitDataMap, String currentUnitCode, CtrlUnitInfo targetUnitInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo = this.getCompanyOrgUnitInfoByCode(ctx, currentUnitCode);
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = this.getPurchaseOrgUnitInfoByCode(ctx, currentUnitCode);
        if (assitDataMap.get("COMPANY") != null && companyOrgUnitInfo != null) {
            SupplierCompanyInfoInfo companyInfo = (SupplierCompanyInfoInfo)assitDataMap.get("COMPANY");
            this.addSupplierCompanyInfo(ctx, targetUnitInfo, companyOrgUnitInfo, companyInfo);
        }
        if (assitDataMap.get("PURCHASE") != null && purchaseOrgUnitInfo != null) {
            SupplierPurchaseInfoInfo purchaseInfo = (SupplierPurchaseInfoInfo)assitDataMap.get("PURCHASE");
            this.addSupplierPurchaseInfo(ctx, targetUnitInfo, purchaseOrgUnitInfo, purchaseInfo);
        }
    }

    private void addSupplierPurchaseInfo(Context ctx, CtrlUnitInfo targetUnitInfo, PurchaseOrgUnitInfo purchaseOrgUnit, SupplierPurchaseInfoInfo purchaseInfo) throws BOSException, EASBizException {
        purchaseInfo.setId(null);
        purchaseInfo.setPurchaseOrgUnit(purchaseOrgUnit);
        purchaseInfo.setCU(targetUnitInfo);
        if (purchaseInfo.getSupplierLinkMan() != null && purchaseInfo.getSupplierLinkMan().size() > 0) {
            for (int i = 0; i < purchaseInfo.getSupplierLinkMan().size(); ++i) {
                SupplierLinkManInfo linkManInfo = purchaseInfo.getSupplierLinkMan().get(i);
                linkManInfo.setId(null);
                linkManInfo.setSupplierPurchase(null);
                purchaseInfo.getSupplierLinkMan().set(i, linkManInfo);
            }
        }
        ISupplierPurchaseInfo iSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
        iSupplierPurchaseInfo.addnew((CoreBaseInfo)purchaseInfo);
    }

    private void addSupplierCompanyInfo(Context ctx, CtrlUnitInfo targetUnitInfo, CompanyOrgUnitInfo companyOrgUnitInfo, SupplierCompanyInfoInfo companyInfo) throws BOSException, EASBizException {
        companyInfo.setId(null);
        companyInfo.setCompanyOrgUnit(companyOrgUnitInfo);
        companyInfo.setCU(targetUnitInfo);
        if (companyInfo.getSupplierBank() != null && companyInfo.getSupplierBank().size() > 0) {
            for (int i = 0; i < companyInfo.getSupplierBank().size(); ++i) {
                SupplierCompanyBankInfo companyBankInfo = companyInfo.getSupplierBank().get(i);
                companyBankInfo.setId(null);
                companyBankInfo.setSupplierCompanyInfo(null);
                companyInfo.getSupplierBank().set(i, companyBankInfo);
            }
        }
        SupplierCompanyInfoFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)companyInfo);
    }

    private void upgradeSupplierInfo(Context ctx, SupplierInfo supplierInfo, CtrlUnitInfo targetUnitInfo, String currentUnitCode, Map resultMap, ResourceBundleHelper resHelper) throws BOSException, EASBizException {
        ObjectUuidPK supplierId = new ObjectUuidPK(supplierInfo.getId());
        ObjectUuidPK superCUPk = new ObjectUuidPK(targetUnitInfo.getId());
        if (!this.checkAssignAndUpgrateBefore(ctx, targetUnitInfo, supplierId, resHelper, resultMap, false)) {
            ICSSPGroup icsspGroup = CSSPGroupFactory.getLocalInstance(ctx);
            HashSet needUpgrateCsspGroupIds = new HashSet();
            this.getGroupInfoID(supplierInfo.getBrowseGroup().getId().toString(), icsspGroup, targetUnitInfo, needUpgrateCsspGroupIds);
            if (needUpgrateCsspGroupIds != null && !needUpgrateCsspGroupIds.isEmpty()) {
                for (Object groupInfoId : needUpgrateCsspGroupIds) {
                    icsspGroup.upgrade((IObjectPK)new ObjectUuidPK(groupInfoId.toString()), null, (IObjectPK)superCUPk);
                }
            }
        }
        SupplierFactory.getLocalInstance(ctx).upgrade((IObjectPK)supplierId, (IObjectPK)new ObjectUuidPK(supplierInfo.getCU().getId()), (IObjectPK)superCUPk);
    }

    private Map getSourceAssistData(Context ctx, SupplierInfo supplierInfo) throws BOSException, EASBizException {
        HashMap<String, SupplierCompanyInfoInfo> assitDataMap = new HashMap<String, SupplierCompanyInfoInfo>(2);
        CompanyOrgUnitInfo companyOrgUnitInfo = this.getCompanyOrgUnitInfoById(ctx, supplierInfo.getCU().getId().toString());
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = this.getPurchaseOrgUnitInfoById(ctx, supplierInfo.getCU().getId().toString());
        if (companyOrgUnitInfo != null) {
            assitDataMap.put("COMPANY", this.getCompanyInfoBySupInfoAndComInfo(ctx, supplierInfo, companyOrgUnitInfo));
        }
        if (purchaseOrgUnitInfo != null) {
            assitDataMap.put("PURCHASE", (SupplierCompanyInfoInfo)this.getPurchaseInfoBySupInfoAndPurInfo(ctx, supplierInfo, purchaseOrgUnitInfo));
        }
        return assitDataMap;
    }

    private void assignSupplierInfo(Context ctx, SupplierInfo supplierInfo, CtrlUnitInfo targetUnitInfo, String currentUnitCode, Map resultMap, ResourceBundleHelper resHelper) throws Exception {
        if (this.canUseCurrentSupplierData(ctx, targetUnitInfo, supplierInfo)) {
            this.assignCompanyInfo(ctx, currentUnitCode, supplierInfo);
            this.assignPurchaseInfo(ctx, currentUnitCode, supplierInfo, resultMap, resHelper);
        } else {
            ObjectUuidPK sourceCuId = new ObjectUuidPK(supplierInfo.getCU().getId());
            ObjectUuidPK supplierId = new ObjectUuidPK(supplierInfo.getId());
            ObjectUuidPK assignCUPK = new ObjectUuidPK(targetUnitInfo.getId());
            if (!this.checkAssignAndUpgrateBefore(ctx, targetUnitInfo, supplierId, resHelper, resultMap, true)) {
                return;
            }
            ctx.put((Object)"srmAssign", (Object)"srmAssign");
            SupplierFactory.getLocalInstance(ctx).assign((IObjectPK)sourceCuId, (IObjectPK)supplierId, (IObjectPK)assignCUPK);
            this.assignCompanyInfo(ctx, currentUnitCode, supplierInfo);
            this.assignPurchaseInfo(ctx, currentUnitCode, supplierInfo, resultMap, resHelper);
        }
    }

    private StringBuilder checkGroupVisiable(Context ctx, String cuLongNumber, String[] dataBaseIds, ResourceBundleHelper resHelper) {
        Set keys;
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        String tableName = "t_bd_supplier";
        String groupName = "t_bd_csspGroup";
        sql.append(" select a.fnumber,b.fname_l2,b.fid,c.flongNumber from " + tableName + "  a");
        sql.append(" inner join " + groupName + " b on a.FBrowseGroupID = b.fid");
        sql.append(" inner join t_org_ctrlunit c on b.fcontrolunitid = c.fid");
        sql.append(" where  charindex(c.flongnumber,'" + cuLongNumber + "')<=0 and a.fid in (");
        for (int j = 0; j < dataBaseIds.length; ++j) {
            sql.append("'" + dataBaseIds[j] + "'");
            if (j == dataBaseIds.length - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        try {
            ISQLExecutor srs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
            IRowSet rs = srs.executeSQL();
            while (rs.next()) {
                String number = rs.getString(1);
                String groupname = rs.getString(2);
                String id = rs.getString(3);
                String longNUmber = rs.getString(4);
                map.put(id, number + "@@@" + groupname + "@@@" + longNUmber);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        StringBuilder errorDetail = new StringBuilder();
        if (!map.isEmpty() && (keys = map.keySet()) != null) {
            for (Object key : keys) {
                String value = map.get(key).toString();
                String[] str = value.split("@@@");
                String assignFail = resHelper.getString("msg010");
                MessageFormat mf = new MessageFormat(assignFail);
                errorDetail.append(mf.format(new String[]{"[" + str[0] + "]", "[" + str[1] + "]"}) + "\n");
            }
        }
        return errorDetail;
    }

    private boolean checkAssignAndUpgrateBefore(Context ctx, CtrlUnitInfo targetUnitInfo, ObjectUuidPK supplierId, ResourceBundleHelper resHelper, Map resultMap, boolean isAssign) throws BOSException {
        StringBuilder stringBuilder = this.checkGroupVisiable(ctx, targetUnitInfo.getLongNumber(), new String[]{supplierId.toString()}, resHelper);
        if (stringBuilder != null && stringBuilder.length() > 0) {
            if (isAssign) {
                resultMap.put(CODE, FAILED_CODE);
                resultMap.put(MSG, stringBuilder.toString());
            }
            return false;
        }
        return true;
    }

    private void assignCompanyInfo(Context ctx, String currentUnitCode, SupplierInfo supplierInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo targetCompanyOrgUnit = this.getCompanyOrgUnitInfoByCode(ctx, currentUnitCode);
        CompanyOrgUnitInfo sourceCompanyOrgUnit = this.getCompanyOrgUnitInfoById(ctx, supplierInfo.getCU().getId().toString());
        if (targetCompanyOrgUnit == null) {
            logger.error((Object)("\u6839\u636e\u7f16\u7801\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u7ec4\u7ec7(" + currentUnitCode + ")"));
        } else if (sourceCompanyOrgUnit == null || this.getCompanyInfoBySupInfoAndComInfo(ctx, supplierInfo, sourceCompanyOrgUnit) == null) {
            logger.error((Object)("\u6839\u636e\u4f9b\u5e94\u5546\u7f16\u7801\u5728EAS\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u8d44\u6599\u4fe1\u606f(" + supplierInfo.getNumber() + ")"));
        } else if (this.getCompanyInfoBySupInfoAndComInfo(ctx, supplierInfo, targetCompanyOrgUnit) == null) {
            SupplierCompanyInfoInfo sourceCompanyInfo = this.getCompanyInfoBySupInfoAndComInfo(ctx, supplierInfo, sourceCompanyOrgUnit);
            if (UsingStatusEnum.FREEZED.getValue() == sourceCompanyInfo.getUsingStatus().getValue()) {
                ObjectUuidPK companyInfoPk = new ObjectUuidPK(sourceCompanyInfo.getId());
                SupplierCompanyInfoFactory.getLocalInstance(ctx).cancelCancel((IObjectPK)companyInfoPk);
            }
            String cuid = sourceCompanyOrgUnit.getCU().getId().toString();
            String[] diddata = new String[]{supplierInfo.getId().toString()};
            String[] cuiddata = new String[]{targetCompanyOrgUnit.getId().toString()};
            HashSet<SupplierAssitDataEnum> assitData = new HashSet<SupplierAssitDataEnum>(1);
            assitData.add(SupplierAssitDataEnum.COMPANY);
            SupplierFactory.getLocalInstance(ctx).batchAssignAssist(cuid, diddata, cuiddata, assitData);
        }
    }

    private SupplierCompanyInfoInfo getCompanyInfoBySupInfoAndComInfo(Context ctx, SupplierInfo supplierInfo, CompanyOrgUnitInfo sourceCompanyOrgUnit) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)sourceCompanyOrgUnit.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("supplierBank.*");
        SupplierCompanyInfoCollection companyInfoCollection = SupplierCompanyInfoFactory.getLocalInstance(ctx).getSupplierCompanyInfoCollection(view);
        if (companyInfoCollection != null && companyInfoCollection.size() > 0) {
            return companyInfoCollection.get(0);
        }
        return null;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoById(Context ctx, String id) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("name");
        ev.getSelector().add("number");
        ev.getSelector().add("longnumber");
        ev.getSelector().add("cu");
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(ev);
        if (companyOrgUnitCollection != null && companyOrgUnitCollection.size() > 0) {
            return companyOrgUnitCollection.get(0);
        }
        return null;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByCode(Context ctx, String currentUnitCode) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currentUnitCode, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("name");
        ev.getSelector().add("number");
        ev.getSelector().add("longnumber");
        ev.getSelector().add("cu");
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(ev);
        if (companyOrgUnitCollection != null && companyOrgUnitCollection.size() > 0) {
            return companyOrgUnitCollection.get(0);
        }
        return null;
    }

    private void assignPurchaseInfo(Context ctx, String currentUnitCode, SupplierInfo supplierInfo, Map resultMap, ResourceBundleHelper resHelper) throws BOSException, EASBizException {
        PurchaseOrgUnitInfo targetPurchaseOrgUnit = this.getPurchaseOrgUnitInfoByCode(ctx, currentUnitCode);
        PurchaseOrgUnitInfo sourcePurchaseOrgUnit = this.getPurchaseOrgUnitInfoById(ctx, supplierInfo.getCU().getId().toString());
        if (targetPurchaseOrgUnit == null) {
            resultMap.put(CODE, FAILED_CODE);
            resultMap.put(MSG, resHelper.getString("msg007") + currentUnitCode + ")");
        } else if (sourcePurchaseOrgUnit == null || this.getPurchaseInfoBySupInfoAndPurInfo(ctx, supplierInfo, sourcePurchaseOrgUnit) == null) {
            resultMap.put(CODE, FAILED_CODE);
            resultMap.put(MSG, resHelper.getString("msg008") + supplierInfo.getNumber() + ")");
        } else if (this.getPurchaseInfoBySupInfoAndPurInfo(ctx, supplierInfo, targetPurchaseOrgUnit) == null) {
            SupplierPurchaseInfoInfo sourcePurchaseInfo = this.getPurchaseInfoBySupInfoAndPurInfo(ctx, supplierInfo, sourcePurchaseOrgUnit);
            if (UsingStatusEnum.FREEZED.getValue() == sourcePurchaseInfo.getUsingStatus().getValue()) {
                ObjectUuidPK purchaseInfoPk = new ObjectUuidPK(sourcePurchaseInfo.getId());
                SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx).cancelCancel((IObjectPK[])new ObjectUuidPK[]{purchaseInfoPk});
            }
            String cuid = sourcePurchaseOrgUnit.getCU().getId().toString();
            String[] diddata = new String[]{supplierInfo.getId().toString()};
            String[] cuiddata = new String[]{targetPurchaseOrgUnit.getId().toString()};
            HashSet<SupplierAssitDataEnum> assitData = new HashSet<SupplierAssitDataEnum>(1);
            assitData.add(SupplierAssitDataEnum.PURCHASE);
            SupplierFactory.getLocalInstance(ctx).batchAssignAssist(cuid, diddata, cuiddata, assitData);
        }
    }

    private SupplierPurchaseInfoInfo getPurchaseInfoBySupInfoAndPurInfo(Context ctx, SupplierInfo supplierInfo, PurchaseOrgUnitInfo purchaseOrgUnit) throws BOSException, EASBizException {
        ObjectUuidPK suppllierPk = new ObjectUuidPK(supplierInfo.getId());
        ObjectUuidPK purchaseOrgPk = new ObjectUuidPK(purchaseOrgUnit.getId());
        ISupplierPurchaseInfo iSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
        SupplierPurchaseInfoInfo purChaseInfo = iSupplierPurchaseInfo.getPurChaseInfo((IObjectPK)suppllierPk, (IObjectPK)purchaseOrgPk);
        return purChaseInfo;
    }

    private PurchaseOrgUnitInfo getPurchaseOrgUnitInfoById(Context ctx, String id) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("name");
        ev.getSelector().add("number");
        ev.getSelector().add("longnumber");
        ev.getSelector().add("cu");
        PurchaseOrgUnitCollection orgUnitCollection = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitCollection(ev);
        if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
            return orgUnitCollection.get(0);
        }
        return null;
    }

    private PurchaseOrgUnitInfo getPurchaseOrgUnitInfoByCode(Context ctx, String currentUnitCode) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currentUnitCode, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("name");
        ev.getSelector().add("number");
        ev.getSelector().add("longnumber");
        ev.getSelector().add("cu");
        PurchaseOrgUnitCollection orgUnitCollection = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitCollection(ev);
        if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
            return orgUnitCollection.get(0);
        }
        return null;
    }

    private boolean canUseCurrentSupplierData(Context ctx, CtrlUnitInfo targetUnitInfo, SupplierInfo supplierInfo) throws BOSException, SQLException {
        String sql = "SELECT FID FROM T_BD_DATABASEDASSIGN WHERE FDATABASEDID = ? AND FASSIGNCUID = ? AND FBOSOBJECTTYPE = ?";
        String supplierId = supplierInfo.getId().toString();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{supplierId, targetUnitInfo.getId().toString(), "37C67DFC"});
        return rowSet != null && rowSet.next() && rowSet.getString("FID") != null;
    }

    private boolean unitSuborRelationship(Context ctx, SupplierInfo supplierInfo, CtrlUnitInfo targetUnitInfo) throws Exception {
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo supCUInfo = this.getCtrlUnitInfoById(ctx, supplierInfo.getCU().getId().toString());
        CtrlUnitCollection allChildrenCollection = iCtrlUnit.getCtrlUnitCollection("select id,name,number where longnumber like '" + targetUnitInfo.getLongNumber() + "!%'");
        if (allChildrenCollection != null && allChildrenCollection.size() > 0) {
            for (int i = 0; i < allChildrenCollection.size(); ++i) {
                if (!supCUInfo.getNumber().equals(allChildrenCollection.get(i).getNumber())) continue;
                return false;
            }
        }
        return true;
    }

    private CtrlUnitInfo getCtrlUnitInfoById(Context ctx, String id) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("name");
        ev.getSelector().add("number");
        ev.getSelector().add("longnumber");
        ev.getSelector().add("cu");
        CtrlUnitCollection ctrlUnitCollection = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(ev);
        if (ctrlUnitCollection != null && ctrlUnitCollection.size() > 0) {
            return ctrlUnitCollection.get(0);
        }
        return null;
    }

    private void dealSupplierAssistWithStatus(Context ctx, SupplierInfo supplierInfo, CtrlUnitInfo targetUnitInfo) throws BOSException, EASBizException {
        this.dealSupplierCompanyDataWithStatus(ctx, supplierInfo, targetUnitInfo);
        this.dealSupplierPurchaseDataWithStatus(ctx, supplierInfo, targetUnitInfo);
    }

    private void dealSupplierPurchaseDataWithStatus(Context ctx, SupplierInfo supplierInfo, CtrlUnitInfo targetUnitInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)targetUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add("*");
        ISupplierPurchaseInfo instance = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
        SupplierPurchaseInfoCollection supplierPurchaseInfoCollection = instance.getSupplierPurchaseInfoCollection(view);
        if (supplierPurchaseInfoCollection != null && supplierPurchaseInfoCollection.size() > 0) {
            SupplierPurchaseInfoInfo supplierPurchaseInfo = supplierPurchaseInfoCollection.get(0);
            if (UsingStatusEnum.FREEZED.getValue() == supplierPurchaseInfo.getUsingStatus().getValue()) {
                ObjectUuidPK purchaseInfoPk = new ObjectUuidPK(supplierPurchaseInfo.getId());
                instance.cancelCancel((IObjectPK[])new ObjectUuidPK[]{purchaseInfoPk});
            }
        }
    }

    private void dealSupplierCompanyDataWithStatus(Context ctx, SupplierInfo supplierInfo, CtrlUnitInfo targetUnitInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)targetUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add("*");
        ISupplierCompanyInfo instance = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        SupplierCompanyInfoCollection companyInfoCollection = instance.getSupplierCompanyInfoCollection(view);
        if (companyInfoCollection != null && companyInfoCollection.size() > 0) {
            SupplierCompanyInfoInfo supplierCompanyInfo = companyInfoCollection.get(0);
            if (UsingStatusEnum.FREEZED.getValue() == supplierCompanyInfo.getUsingStatus().getValue()) {
                ObjectUuidPK companyInfoPk = new ObjectUuidPK(supplierCompanyInfo.getId());
                instance.cancelCancel((IObjectPK)companyInfoPk);
            }
        }
    }

    private void dealSupplierWithStatus(Context ctx, SupplierInfo supplierInfo) throws BOSException, EASBizException {
        ObjectUuidPK supplierPk = new ObjectUuidPK(supplierInfo.getId());
        if (UsedStatusEnum.UNAPPROVE.getValue() == supplierInfo.getUsedStatus().getValue()) {
            SupplierFactory.getLocalInstance(ctx).approve(new IObjectPK[]{supplierPk});
        }
        if (UsedStatusEnum.FREEZED.getValue() == supplierInfo.getUsedStatus().getValue()) {
            SupplierFactory.getLocalInstance(ctx).unFreezed((IObjectPK)supplierPk, true);
        }
    }

    private SupplierInfo findSupplierByCode(Context ctx, Map param) throws BOSException {
        String supplierCode = param.get(SUPPLIER_CODE).toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)supplierCode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)3, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)2, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("cu.*");
        view.getSelector().add("browseGroup.*");
        SupplierCollection supplierCollection = SupplierFactory.getLocalInstance(ctx).getSupplierCollection(view);
        if (supplierCollection != null && supplierCollection.size() > 0) {
            return supplierCollection.get(0);
        }
        return null;
    }

    private FullOrgUnitInfo getFullOrgUnitInfoByCode(Context ctx, String currentUnitCode) throws BOSException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currentUnitCode, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("name");
        ev.getSelector().add("number");
        ev.getSelector().add("longnumber");
        ev.getSelector().add("cu.*");
        FullOrgUnitCollection fullOrgUnitCollection = iFullOrgUnit.getFullOrgUnitCollection(ev);
        if (fullOrgUnitCollection != null && fullOrgUnitCollection.size() > 0) {
            return fullOrgUnitCollection.get(0);
        }
        return null;
    }

    private boolean checkParam(Map param, Map resultMap, ResourceBundleHelper resHelper) {
        if (param == null || param.size() < 1) {
            resultMap.put(MSG, resHelper.getString("msg001"));
            resultMap.put(CODE, FAILED_CODE);
            return true;
        }
        if (param.get(SUPPLIER_CODE) == null) {
            resultMap.put(MSG, resHelper.getString("msg002"));
        }
        if (param.get(CURRENT_UNIT_CODE) == null) {
            resultMap.put(MSG, resHelper.getString("msg003"));
        }
        if (resultMap.containsKey(MSG)) {
            resultMap.put(CODE, FAILED_CODE);
            return true;
        }
        return false;
    }

    public DataBaseInfo getGroupInfo(String csspGroupId, ICSSPGroup icsspGroup, CtrlUnitInfo targetUnitInfo) throws BOSException, EASBizException {
        String longNumber = targetUnitInfo.getLongNumber();
        StringBuffer oql = new StringBuffer();
        oql.append("select id,name,number,parent.name,parent.number,parent.CU.id,level,isLeaf,longNumber,CU.id,CU.name,CU.longNumber");
        oql.append(" where deletedStatus=1 ");
        oql.append(" and CU.longNumber like '");
        oql.append(longNumber + "!%' and id ='" + csspGroupId + "'");
        DataBaseInfo dataBaseInfo = icsspGroup.getDataBaseInfo(oql.toString());
        return dataBaseInfo;
    }

    public void getGroupInfoID(String csspGroupId, ICSSPGroup icsspGroup, CtrlUnitInfo targetUnitInfo, Set needUpgrateCsspGroupIds) {
        try {
            CSSPGroupInfo csspInfo = (CSSPGroupInfo)this.getGroupInfo(csspGroupId, icsspGroup, targetUnitInfo);
            if (csspInfo.getParent() != null) {
                this.getGroupInfoID(csspInfo.getParent().getId().toString(), icsspGroup, targetUnitInfo, needUpgrateCsspGroupIds);
            }
            needUpgrateCsspGroupIds.add(csspInfo.getId().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String convertStr(String mutiResourceStr, String ... param) {
        MessageFormat mf = new MessageFormat(mutiResourceStr);
        String[] arrStr = null;
        if (param != null && param.length > 0) {
            arrStr = new String[param.length];
            for (int i = 0; i < param.length; ++i) {
                arrStr[i] = "[" + param[i] + "]";
            }
            String formatStr = mf.format(arrStr);
            return formatStr;
        }
        return "";
    }
}

