/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.framework.app.Assign2ImpBase;
import com.kingdee.eas.basedata.framework.app.ParallelSqlExecutor;
import com.kingdee.eas.basedata.master.cssp.SupplierAssitDataEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class SupplierAssign2Imp
extends Assign2ImpBase {
    private static Logger logger = Logger.getLogger(SupplierAssign2Imp.class);
    private static final String Supplier_KACLASSTYPE_ID = "7ac99937-00fb-3000-e000-0002c0a81345B999CA39";

    public int batchAssign2Part(Context ctx, String srcOrgId, Set tarOrgIds, String tblBD, Set assistData, int insertBDOneTime) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        PreparedStatement pStmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            String viewBD = "(select top " + insertBDOneTime + " fid from " + tblBD + ")";
            String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
            StringBuilder inSql = new StringBuilder(100);
            for (int i = 0; i < tarOrgIds.size(); ++i) {
                inSql.append(",'").append("?");
            }
            inSql.replace(0, 1, "");
            String tblCompanyExist = this.getCompanyInfoExistTbl(ctx, tblBD, inSql.toString(), tarOrgIds);
            String tblPurchaseExist = this.getPurchaseInfoExistTbl(ctx, tblBD, inSql.toString(), tarOrgIds);
            String orgSql = "select Fid,FisCompanyOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FControlUnitId from t_org_baseunit where fid in (" + inSql + ")";
            pStmt = cn.prepareStatement(orgSql);
            int n = 0;
            for (Object oTarOrgId : tarOrgIds) {
                pStmt.setString(++n, oTarOrgId.toString());
            }
            ResultSet rs = pStmt.executeQuery();
            if (this.isParallel()) {
                ExecutorService pool = Executors.newFixedThreadPool(6);
                ParallelSqlExecutor pe = new ParallelSqlExecutor(pool);
                while (rs.next()) {
                    int fIsCompanyOrgUnit = rs.getInt("FisCompanyOrgUnit");
                    int fIsPurchaseOrgUnit = rs.getInt("FIsPurchaseOrgUnit");
                    String destCuId = rs.getString("FControlUnitId");
                    String destOuId = rs.getString("FID");
                    if ((assistData == null || assistData.contains((Object)SupplierAssitDataEnum.COMPANY)) && fIsCompanyOrgUnit == 1) {
                        pe.getSqlList().add(this.getSQL4AssignCompany(ctx, userId, destCuId, destOuId, srcOrgId, viewBD));
                        pe.getSqlList().add(this.getSql4AssignCompanyBank(ctx, tblCompanyExist, destOuId, srcOrgId, viewBD));
                    }
                    if ((assistData == null || assistData.contains((Object)SupplierAssitDataEnum.PURCHASE)) && fIsPurchaseOrgUnit == 1) {
                        pe.getSqlList().add(this.getSQL4AssignPurchase(ctx, userId, destCuId, destOuId, srcOrgId, viewBD));
                        pe.getSqlList().add(this.getSql4AssignLinkman(ctx, tblPurchaseExist, destOuId, srcOrgId, viewBD));
                    }
                    pe.executeUpdate(ctx);
                }
                pool.shutdown();
                if (pe.getErrorList().size() > 0) {
                    logger.error((Object)(pe.getErrorList().size() + " error occur!"));
                    logger.error((Object)((Exception)pe.getErrorList().get(0)));
                    throw new BOSException((Throwable)((Exception)pe.getErrorList().get(0)));
                }
            } else {
                while (rs.next()) {
                    int fIsCompanyOrgUnit = rs.getInt("FisCompanyOrgUnit");
                    int fIsPurchaseOrgUnit = rs.getInt("FIsPurchaseOrgUnit");
                    String destOuId = rs.getString("FID");
                    String destCuId = rs.getString("FControlUnitId");
                    Statement stmt2 = cn.createStatement();
                    if ((assistData == null || assistData.contains((Object)SupplierAssitDataEnum.COMPANY)) && fIsCompanyOrgUnit == 1) {
                        stmt2.addBatch(this.getSQL4AssignCompany(ctx, userId, destCuId, destOuId, srcOrgId, viewBD));
                        stmt2.addBatch(this.getSql4AssignCompanyBank(ctx, tblCompanyExist, destOuId, srcOrgId, viewBD));
                    }
                    if ((assistData == null || assistData.contains((Object)SupplierAssitDataEnum.PURCHASE)) && fIsPurchaseOrgUnit == 1) {
                        stmt2.addBatch(this.getSQL4AssignPurchase(ctx, userId, destCuId, destOuId, srcOrgId, viewBD));
                        stmt2.addBatch(this.getSql4AssignLinkman(ctx, tblPurchaseExist, destOuId, srcOrgId, viewBD));
                    }
                    stmt2.executeBatch();
                }
            }
            this.deleteTop(ctx, tblBD, insertBDOneTime);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                SQLUtils.cleanup(pStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        SQLUtils.cleanup((Statement)pStmt, (Connection)cn);
        return 0;
    }

    protected String getSQL4AssignCompany(Context ctx, String cuUserId, String destCuid, String destCompanyId, String srcCompanyId, String viewBD) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(200);
        sql.append("insert into t_bd_Suppliercompanyinfo ");
        sql.append(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FComOrgID,FSettlementTypeID,FSettlementCurrencyID,FSettlementAccount,FPaymentTypeID,FAccountClassID,FIsFreezePayment,FEffectedStatus,FFreezeOrgUnitID,FSupplierID,FContactPerson,FContactPersonPost,FPhone,FMobile,FFax,FPostalcode,FEMail)  ");
        sql.append(" select newbosid('F26C0EC7') FID , '" + cuUserId + "' FCreatorID, now() FCreateTime, '" + cuUserId + "' FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuid + "'  FControlUnitID,   '" + destCompanyId + "' FComOrgID,FSettlementTypeID,FSettlementCurrencyID,FSettlementAccount,FPaymentTypeID," + this.getKAClassSql(ctx, destCompanyId) + " FAccountClassID,FIsFreezePayment,2 FEffectedStatus,null FFreezeOrgUnitID,FSupplierID,FContactPerson,FContactPersonPost,FPhone,FMobile,FFax,FPostalcode,FEMail");
        sql.append(" from t_bd_Suppliercompanyinfo mc  where 1=1 ");
        sql.append(" and mc.FSupplierID in ").append(viewBD);
        sql.append(" and mc.FComOrgID='" + srcCompanyId + "'  ");
        sql.append(" and not exists (select 1 from t_bd_Suppliercompanyinfo mc2 where mc2.FComOrgID='");
        sql.append(destCompanyId).append("'");
        sql.append(" and mc.FSupplierID=mc2.FSupplierID)");
        return sql.toString();
    }

    protected String getSQL4AssignPurchase(Context ctx, String cuUserId, String destCuid, String destOugUnitId, String srcOrgUnitId, String viewBD) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_BD_Supplierpurchaseinfo ");
        sql.append(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FPurchaseOrgID,FIsFreezeOrder,FAdvanceDay,FEffectedStatus,FBillingOrgUnitID,FDeliverOrgUnitID,FFreezeOrgUnitID,FSupplierID,FType,FDay,FMonth,FCashDiscountID,FGrade,FDefaultPurchaserID,FInitialDay,FMonthOrDay,FAddXMonthOrDay,FWhenXDay\t,FIsPurCollaboration,FIsAutoAudit,FIsConfirmPartial,FIsDeliverPlanCollaboration,FIsStoreDirect,FConfirmNum,FResponseTime,FNoticeAdvance )  ");
        sql.append(" select newbosid('9920F4D3') FID , '" + cuUserId + "' FCreatorID, now() FCreateTime, '" + cuUserId + "' FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuid + "'  FControlUnitID,   '" + destOugUnitId + "' FPurchaseOrgID,FIsFreezeOrder,FAdvanceDay,FEffectedStatus,FBillingOrgUnitID,FDeliverOrgUnitID,null FFreezeOrgUnitID,FSupplierID,FType,FDay,FMonth,FCashDiscountID,FGrade,FDefaultPurchaserID,FInitialDay,FMonthOrDay,FAddXMonthOrDay,FWhenXDay,FIsPurCollaboration,FIsAutoAudit,FIsConfirmPartial,FIsDeliverPlanCollaboration,FIsStoreDirect,FConfirmNum,FResponseTime,FNoticeAdvance");
        sql.append(" from T_BD_Supplierpurchaseinfo mc  where 1=1 ");
        sql.append(" and mc.FSupplierID in ").append(viewBD);
        sql.append(" and mc.FPurchaseOrgID='" + srcOrgUnitId + "'  ");
        sql.append(" and not exists (select 1 from T_BD_Supplierpurchaseinfo mc2 where mc2.FPurchaseOrgID='");
        sql.append(destOugUnitId).append("'");
        sql.append(" and mc.FSupplierID=mc2.FSupplierID)");
        return sql.toString();
    }

    protected String getSql4AssignCompanyBank(Context ctx, String tblCompanyExist, String destOuId, String srcOrgId, String viewBD) {
        StringBuffer sql = new StringBuffer(100);
        sql.append("insert into t_bd_Suppliercompanybank ");
        sql.append(" (FID,FBank,FBankAccount,FBankAddress,FSupplierCompanyInfoID)  ");
        sql.append(" select newbosid('E62C04BD') FID , b.FBank,b.FBankAccount,b.FBankAddress,  s2.fid  FSupplierCompanyInfoID from t_bd_Suppliercompanybank b, t_bd_Suppliercompanyinfo s1  , t_bd_Suppliercompanyinfo s2  ");
        sql.append(" where b.FSupplierCompanyInfoID=s1.fid and s2.FSupplierID=s1.FSupplierID");
        sql.append(" and s1.FComOrgID='").append(srcOrgId).append("'");
        sql.append(" and s1.FSupplierID in ").append(viewBD);
        sql.append(" and s2.fcomorgid = '" + destOuId + "'");
        sql.append(" and not exists (select 1 from ").append(tblCompanyExist).append(" t where s2.fid=t.fid)");
        return sql.toString();
    }

    protected String getSql4AssignLinkman(Context ctx, String tblPurchaseExist, String destOuId, String srcOrgId, String viewBD) {
        StringBuffer sql = new StringBuffer(100);
        sql.append("insert into t_bd_Supplierlinkman ");
        sql.append(" (FID,FPersonID,FContactPerson,FContactPersonPost,FPhone,FFax,FMobile,FPostalcode,FEMail,FAddress, FSupplierPurchaseID)  ");
        sql.append(" select newbosid('3FD16964') FID , b.FPersonID,b.FContactPerson, b.FContactPersonPost,b.FPhone,b.FFax,b.FMobile,b.FPostalcode,b.FEmail,b.FAddress, s2.fid  FSupplierPurchaseID from t_bd_Supplierlinkman b, T_BD_Supplierpurchaseinfo s1  , T_BD_Supplierpurchaseinfo s2  ");
        sql.append(" where b.FSupplierPurchaseID=s1.fid and s2.FSupplierID=s1.FSupplierID");
        sql.append(" and s1.FPurchaseOrgID='").append(srcOrgId).append("'");
        sql.append(" and s1.FSupplierID in ").append(viewBD);
        sql.append(" and s2.FPurchaseOrgID = '" + destOuId + "'");
        sql.append(" and not exists (select 1 from ").append(tblPurchaseExist).append(" t where s2.fid=t.fid)");
        return sql.toString();
    }

    private String getKAClassSql(Context ctx, String destCompanyId) {
        String localeSuffix = ctx.getLocale().toString();
        StringBuffer kaSql = new StringBuffer();
        kaSql.append("\n ISNULL(").append("\n ISNULL(").append("\n (select TOP 1 KAClass.FID FID from T_BD_KAClassfication  as  KAClass").append("\n\t\tINNER JOIN T_BD_KAClassficationType AS KAClassType ON KAClassType.FID =  KAClass.FTypeLink ").append("\n\t\tINNER JOIN T_ORG_Company AS Company ON Company.FID =  KAClass.FCurrencyCompany ").append("\n\twhere  KAClass.FCurrencyCompany ='" + destCompanyId + "'").append("\n\t\tand KAClassType.FObjectTypeID='7ac99937-00fb-3000-e000-0002c0a81345B999CA39'").append("\n\t\tand KAClass.FAccountTableID=Company.FAccountTableID").append("\n\t\tand KAClass.FNumber=(select top 1 Fnumber from T_BD_KAClassfication where T_BD_KAClassfication.FID=mc.faccountclassid))").append("\n , ").append("\n (select TOP 1 KAClass.FID FID from T_BD_KAClassfication  as  KAClass").append("\n\t\tINNER JOIN T_BD_KAClassficationType AS KAClassType ON KAClassType.FID =  KAClass.FTypeLink ").append("\n\t\tINNER JOIN T_ORG_Company AS Company ON Company.FID =  KAClass.FCurrencyCompany ").append("\n\twhere  KAClass.FCurrencyCompany ='" + destCompanyId + "'").append("\n\t\tand KAClassType.FObjectTypeID='7ac99937-00fb-3000-e000-0002c0a81345B999CA39'").append("\n\t\tand KAClass.FAccountTableID=Company.FAccountTableID").append("\n\t\tand KAClass.FName_" + localeSuffix + "=(select top 1 FName_" + localeSuffix + " from T_BD_KAClassfication where T_BD_KAClassfication.FID=mc.faccountclassid))").append("\n  ), ").append("\n  (select TOP 1 KAClass.FID FID from T_BD_KAClassfication  as  KAClass").append("\n\t\tINNER JOIN T_BD_KAClassficationType AS KAClassType ON KAClassType.FID =  KAClass.FTypeLink ").append("\n\t\tINNER JOIN T_ORG_Company AS Company ON Company.FID =  KAClass.FCurrencyCompany ").append("\n\twhere  KAClass.FCurrencyCompany ='" + destCompanyId + "'").append("\n\t\tand KAClassType.FObjectTypeID='7ac99937-00fb-3000-e000-0002c0a81345B999CA39'").append("\n\t\tand KAClass.FAccountTableID=Company.FAccountTableID").append("\n \torder by KAClass.FLastUpdateTime desc )").append("\n )");
        return kaSql.toString();
    }

    protected String getCompanyInfoExistTbl(Context ctx, String tblBD, String destOrgSubSql, Set tarOrgIds) throws BOSException, EASBizException {
        String tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("CustomerCompanyInfo");
        this.createIdTable(ctx, tbl);
        Connection cn = null;
        PreparedStatement pStmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            StringBuilder sql = new StringBuilder(100);
            sql.append("insert into ").append(tbl);
            sql.append(" select fid from t_bd_suppliercompanyinfo ");
            sql.append("where FSupplierID in (select fid from ").append(tblBD).append(")");
            sql.append(" and FComOrgID in (").append(destOrgSubSql).append(")");
            pStmt = cn.prepareStatement(sql.toString());
            int n = 0;
            for (Object oTarOrgId : tarOrgIds) {
                pStmt.setString(++n, oTarOrgId.toString());
            }
            pStmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pStmt, (Connection)cn);
        return tbl;
    }

    protected String getPurchaseInfoExistTbl(Context ctx, String tblBD, String destOrgSubSql, Set tarOrgIds) throws BOSException, EASBizException {
        String tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("CustomerSaleInfo");
        this.createIdTable(ctx, tbl);
        Connection cn = null;
        PreparedStatement pStmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            StringBuilder sql = new StringBuilder(100);
            sql.append("insert into ").append(tbl);
            sql.append(" select fid from t_bd_supplierpurchaseinfo ");
            sql.append("where FSupplierID in (select fid from ").append(tblBD).append(")");
            sql.append(" and FPurchaseOrgID in (").append(destOrgSubSql).append(")");
            pStmt = cn.prepareStatement(sql.toString());
            int n = 0;
            for (Object oTarOrgId : tarOrgIds) {
                pStmt.setString(++n, oTarOrgId.toString());
            }
            pStmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pStmt, (Connection)cn);
        return tbl;
    }

    boolean isParallel() {
        return false;
    }
}

