/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.master.cssp.app.AbstractSupplierCompanyInfoControllerBean;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SupplierCompanyInfoControllerBean
extends AbstractSupplierCompanyInfoControllerBean {
    protected void checkIntegrity(Context ctx, SupplierCompanyInfoInfo model) throws BOSException, EASBizException {
        model.verify(ctx);
        if (model.getCU() == null) {
            model.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (model.getSupplier() == null) {
            throw new CustomerSupplierException(CustomerSupplierException.SUPPLIER_COMPANY_INFO_REF_NULL_CSBASE);
        }
        if (model.getCompanyOrgUnit() == null) {
            throw new CustomerSupplierException(CustomerSupplierException.SUPPLIER_COMPANY_INFO_REF_NULL_COMPANY_ORG);
        }
        if (model.getSettlementCurrency() == null) {
            ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
            SupplierInfo supplierInfo = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(model.getSupplier().getId()));
            throw new CustomerSupplierException(CustomerSupplierException.CUSTOMER_CURRENCY, new String[]{supplierInfo.getNumber()});
        }
    }

    protected void checkDuplicate(Context ctx, SupplierCompanyInfoInfo model) throws BOSException, EASBizException {
        if (model.getSupplier().isIsMultiCopy()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)model.getSupplier().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)model.getCompanyOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        IObjectPK[] pks = this.getPKList(ctx, filter, null);
        if (pks.length > 0) {
            throw new CustomerSupplierException(CustomerSupplierException.SUPPLIER_COMPANYINFO_DEUPLICATED, new Object[]{model.getSupplier().getName(), model.getCompanyOrgUnit().getName(), ""});
        }
    }

    protected void addnewCheck(Context ctx, SupplierCompanyInfoInfo model) throws BOSException, EASBizException {
        if (model.getSupplier().getId() != null) {
            this.checkIntegrity(ctx, model);
            this.checkDuplicate(ctx, model);
            this.checkNoBlankInBankAccount(ctx, model);
        }
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ((SupplierCompanyInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (SupplierCompanyInfoInfo)model);
        super._submit(ctx, pk, model);
        SupplierCompanyInfoInfo info = this.getSupplierCompanyInfoInfo(ctx, pk, this.getSelector());
        model.put("logRecord", (Object)(((SupplierCompanyInfoInfo)model).getSupplier().getName() + "  " + info.getCompanyOrgUnit().getName()));
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((SupplierCompanyInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (SupplierCompanyInfoInfo)model);
        IObjectPK pk = super._submit(ctx, model);
        SupplierCompanyInfoInfo info = this.getSupplierCompanyInfoInfo(ctx, pk, this.getSelector());
        model.put("logRecord", (Object)(((SupplierCompanyInfoInfo)model).getSupplier().getName() + "  " + info.getCompanyOrgUnit().getName()));
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SupplierCompanyInfoInfo info = (SupplierCompanyInfoInfo)model;
        info.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        ISupplierCompanyInfo iSupplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        SupplierCompanyInfoInfo oldInfo = iSupplierCompanyInfo.getSupplierCompanyInfoInfo(pk, this.getSelectors());
        info.setCreateTime(oldInfo.getCreateTime());
        if (info.getCompanyOrgUnit() != null && info.getCompanyOrgUnit().getCU() != null) {
            info.setCU(info.getCompanyOrgUnit().getCU());
        }
        this.updateCheck(ctx, pk, info);
        super._update(ctx, pk, model);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.number"));
        return sic;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SupplierCompanyInfoInfo info = this.getSupplierCompanyInfoInfo(ctx, pk);
        CtrlUnitInfo curCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (!curCU.getId().toString().equals(info.getCU().getId().toString())) {
            throw new MaterialBaseException(MaterialBaseException.CANNOT_DELETE_OTHERCUASSIST);
        }
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new CustomerSupplierException(CustomerSupplierException.CANNOT_DELETE_HASDEAL);
            }
        }
        super._delete(ctx, pk);
    }

    protected void checkFreezed(Context ctx, IObjectPK supplierPK, boolean isForceFreezed) throws BOSException, EASBizException {
        if (!isForceFreezed) {
            // empty if block
        }
    }

    protected void checkUnFreezed(Context ctx, IObjectPK supplierPK, boolean isForceUnFreeze) throws BOSException, EASBizException {
        ISupplierCompanyInfo iSupplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        SupplierCompanyInfoInfo supplierCompanyInfoInfo = iSupplierCompanyInfo.getSupplierCompanyInfoInfo(supplierPK, this.getSelector());
        if (supplierCompanyInfoInfo == null) {
            return;
        }
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        SupplierInfo supplierInfo = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierCompanyInfoInfo.getSupplier().getId()));
        if (supplierInfo.getUsedStatus().getValue() == 2) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UNFREE_BASEINFOIAFREEZED);
        }
        if (!isForceUnFreeze && supplierInfo.getUsedStatus().getValue() == 1 && !supplierCompanyInfoInfo.getFreezeOrgUnit().equalsPK((IObjectValue)supplierCompanyInfoInfo.getCU())) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UNFREEZED_FREEZEDBYOTHERORG);
        }
    }

    protected void changeSupplierCompanyStatus(Context ctx, IObjectPK supplierPK, boolean isFreezed) throws EASBizException, BOSException {
        ISupplierCompanyInfo iSupplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        SupplierCompanyInfoInfo supplierCompanyInfoInfo = iSupplierCompanyInfo.getSupplierCompanyInfoInfo(supplierPK);
        if (supplierCompanyInfoInfo == null) {
            return;
        }
        supplierCompanyInfoInfo.setIsFreezePayment(isFreezed);
        if (isFreezed) {
            supplierCompanyInfoInfo.setFreezeOrgUnit(ContextUtil.getCurrentFIUnit((Context)ctx).castToFullOrgUnitInfo());
        } else {
            supplierCompanyInfoInfo.setFreezeOrgUnit(null);
        }
        iSupplierCompanyInfo.update(supplierPK, (CoreBaseInfo)supplierCompanyInfoInfo);
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK pk, boolean isForceFreezed) throws BOSException, EASBizException {
        this.checkFreezed(ctx, pk, isForceFreezed);
        this.changeSupplierCompanyStatus(ctx, pk, true);
    }

    @Override
    protected void _unFreezed(Context ctx, IObjectPK pk, boolean isForceUnFreeze) throws BOSException, EASBizException {
        this.checkUnFreezed(ctx, pk, isForceUnFreeze);
        this.changeSupplierCompanyStatus(ctx, pk, false);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selectorItems = new SelectorItemCollection();
        selectorItems.add(new SelectorItemInfo("*"));
        selectorItems.add(new SelectorItemInfo("supplier.id"));
        selectorItems.add(new SelectorItemInfo("supplier.name"));
        selectorItems.add(new SelectorItemInfo("supplier.number"));
        selectorItems.add(new SelectorItemInfo("freezeOrgUnit.id"));
        selectorItems.add(new SelectorItemInfo("freezeOrgUnit.number"));
        selectorItems.add(new SelectorItemInfo("freezeOrgUnit.name"));
        selectorItems.add(new SelectorItemInfo("companyOrgUnit.id"));
        selectorItems.add(new SelectorItemInfo("companyOrgUnit.number"));
        selectorItems.add(new SelectorItemInfo("companyOrgUnit.name"));
        selectorItems.add(new SelectorItemInfo("CU.id"));
        selectorItems.add(new SelectorItemInfo("CU.number"));
        selectorItems.add(new SelectorItemInfo("CU.name"));
        return selectorItems;
    }

    @Override
    protected void _updateCheck(Context ctx, IObjectPK pk, IObjectValue value) throws BOSException, EASBizException {
        SupplierCompanyInfoInfo model = (SupplierCompanyInfoInfo)value;
        SupplierCompanyBankCollection bankColl = model.getSupplierBank();
        SupplierCompanyBankInfo bank = null;
        String bankAccount = null;
        Pattern p = Pattern.compile("\\s");
        Matcher match = null;
        for (int i = 0; i < bankColl.size(); ++i) {
            bank = bankColl.get(i);
            bankAccount = bank.getBankAccount() == null ? "" : bank.getBankAccount();
            match = p.matcher(bankAccount);
            if (!match.find()) continue;
            throw new CustomerSupplierException(CustomerSupplierException.NOSPACEINBANKACCOUNT, new Object[]{bankAccount});
        }
        BizCheckResult rs = BizCheckerUtil.hasDeal4Update((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new CustomerSupplierException(CustomerSupplierException.CANNOT_MODIFY_HASDEAL);
            }
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_MODIFY_HASDEAL);
        }
        if (model.getSupplier().getUsedStatus().equals((Object)UsedStatusEnum.FREEZED)) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISFREEZED);
        }
        this.checkIntegrity(ctx, model);
        SupplierCompanyInfoInfo old = this.getSupplierCompanyInfoInfo(ctx, pk);
        if (!old.getSupplier().getId().toString().equals(model.getSupplier().getId().toString()) || !old.getCompanyOrgUnit().getId().toString().equals(model.getCompanyOrgUnit().getId().toString())) {
            this.checkDuplicate(ctx, model);
        }
    }

    protected void checkNoBlankInBankAccount(Context ctx, SupplierCompanyInfoInfo model) throws BOSException, EASBizException {
        SupplierCompanyBankInfo bank = null;
        String account = "";
        String regex = "\\s";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = null;
        if (model.getSupplierBank() != null && model.getSupplierBank().size() > 0) {
            for (int i = 0; i < model.getSupplierBank().size(); ++i) {
                bank = model.getSupplierBank().get(i);
                account = bank.getBankAccount();
                matcher = pattern.matcher(account);
                if (!matcher.find()) continue;
                throw new CustomerSupplierException(CustomerSupplierException.NOSPACEINBANKACCOUNT, new Object[]{account});
            }
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SupplierCompanyInfoInfo info = this.getSupplierCompanyInfoInfo(ctx, pk, this.getSelector());
        return info.getSupplier().getName() + "  " + info.getCompanyOrgUnit().getName();
    }

    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((SupplierCompanyInfoInfo)model).setCreateTime(null);
        return super._addnew(ctx, model);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.changeStatus(ctx, new Object[]{((SupplierCompanyInfoInfo)model).getId()}, UsingStatusEnum.FREEZED);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeStatus(ctx, pks, UsingStatusEnum.FREEZED);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.changeStatus(ctx, new Object[]{((SupplierCompanyInfoInfo)model).getId()}, UsingStatusEnum.USING);
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeStatus(ctx, pks, UsingStatusEnum.USING);
    }

    private void changeStatus(Context ctx, Object[] pks, UsingStatusEnum status) throws BOSException, EASBizException {
        String resName;
        String logItem;
        if (pks == null) {
            return;
        }
        String oql = " select id,supplier.number,companyOrgUnit.name,cu,usedStatus where id in " + CSSPUtils.getIdsSql(pks);
        SupplierCompanyInfoCollection collection = this.getSupplierCompanyInfoCollection(ctx, oql);
        ArrayList<String> list = new ArrayList<String>();
        int c = collection.size();
        for (int i = 0; i < c; ++i) {
            SupplierCompanyInfoInfo info = collection.get(i);
            list.add(info.getSupplier() == null ? "" : info.getSupplier().getNumber());
            if (info.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) continue;
            throw new CustomerSupplierException(CustomerSupplierException.UPDATE_OTHER_CU, new Object[]{info.getSupplier().getNumber() + " - " + info.getCompanyOrgUnit().getName()});
        }
        if (UsingStatusEnum.USING.equals((Object)status)) {
            logItem = "bd_cssp_supplier_company_cancelCancel";
            resName = "SupplierCompanyCancelCancel";
        } else {
            logItem = "bd_cssp_supplier_company_cancel";
            resName = "SupplierCompanyCancel";
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"changeStatus", (BOSObjectType)new SupplierCompanyInfoInfo().getBOSType(), null, (String)Arrays.toString((Object[])list.toArray()), (String)logItem, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)resName, (Locale)ctx.getOriginLocale()));
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" update T_BD_SupplierCompanyInfo ");
        sb.appendSql(" set FUsingStatus = ").appendSql(String.valueOf(status.getValue()));
        sb.appendSql(" ,flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=getdate() where fid in ").appendSql(CSSPUtils.getIdsSql(pks));
        sb.execute(ctx);
        ORMValueCacheService.getInstance().discardType(ctx, this.getBOSType());
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    protected void _freezed(Context ctx, SupplierCompanyInfoInfo info) throws BOSException, EASBizException {
        this.changeFreeze(ctx, new Object[]{info.getId()}, 1);
    }

    protected void _freezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeFreeze(ctx, pks, 1);
    }

    protected void _unFreezed(Context ctx, SupplierCompanyInfoInfo info) throws BOSException, EASBizException {
        this.changeFreeze(ctx, new Object[]{info.getId()}, 0);
    }

    protected void _unFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.changeFreeze(ctx, pks, 0);
    }

    private void changeFreeze(Context ctx, Object[] pks, int isFreeze) throws BOSException, EASBizException {
        if (pks == null) {
            return;
        }
        String oql = " select id,supplier.number,companyOrgUnit.name,cu,usedStatus where id in " + CSSPUtils.getIdsSql(pks);
        SupplierCompanyInfoCollection collection = this.getSupplierCompanyInfoCollection(ctx, oql);
        int c = collection.size();
        for (int i = 0; i < c; ++i) {
            SupplierCompanyInfoInfo info = collection.get(i);
            if (info.getCU().getId().equals((Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId())) continue;
            throw new CustomerSupplierException(CustomerSupplierException.UPDATE_OTHER_CU, new Object[]{info.getSupplier().getNumber() + " - " + info.getCompanyOrgUnit().getName()});
        }
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" update T_BD_SupplierCompanyInfo ");
        sb.appendSql(" set FIsFreezePayment = ").appendSql(String.valueOf(isFreeze));
        sb.appendSql(" where fid in ").appendSql(CSSPUtils.getIdsSql(pks));
        sb.execute(ctx);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pks) throws BOSException, EASBizException {
        Object[] ipks = new IObjectPK[]{pks};
        this.changeStatus(ctx, ipks, UsingStatusEnum.FREEZED);
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK pks) throws BOSException, EASBizException {
        Object[] ipks = new IObjectPK[]{pks};
        this.changeStatus(ctx, ipks, UsingStatusEnum.USING);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            return super.submit(ctx, model);
        }
        try {
            IObjectPK retValue = this._submit4Import(ctx, model);
            return retValue;
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }

    public IObjectPK _submit4Import(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        ((SupplierCompanyInfoInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        this.addnewCheck(ctx, (SupplierCompanyInfoInfo)model);
        if (model.getId() == null) {
            return this._addnew(ctx, (IObjectValue)model);
        }
        ObjectUuidPK pk = new ObjectUuidPK(model.getId());
        this._update(ctx, (IObjectPK)pk, (IObjectValue)model);
        return pk;
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        ((SupplierCompanyInfoInfo)model).setCreateTime(null);
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            return super.addnew(ctx, model);
        }
        try {
            return this._addnew(ctx, (IObjectValue)model);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            super.update(ctx, pk, model);
            return;
        }
        try {
            this._update(ctx, pk, (IObjectValue)model);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }
}

