/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.AbstractMulDataTransmission;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.assistant.TaxDataInfo;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.master.cssp.CSParameterCollection;
import com.kingdee.eas.basedata.master.cssp.CSParameterFactory;
import com.kingdee.eas.basedata.master.cssp.CSParameterInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICSParameter;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.InternalCSSPType;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TreeSet;

public class SupplierDataImport
extends AbstractMulDataTransmission {
    String[] INTEGER_FIELDS = new String[]{"FVersion"};
    String[] INTEGER_OBJS = new String[]{"version"};
    String[] STRING_FIELDS = new String[]{"FBarCode", "FMnemonicCode", "FForeignName", "FShortName", "FTaxRegisterNo", "FBizRegisterNo", "FBusiLicence", "FBusiExequatur", "FGSPAuthentication", "FAddress", "FArtificialPerson", ""};
    String[] STRING_OBJS = new String[]{"barCode", "mnemonicCode", "foreignName", "simpleName", "taxRegisterNo", "bizRegisterNo", "busiLicence", "busiExequatur", "GSPAuthentication", "address", "artificialPerson"};
    String[] BOOLEAN_FIELDS = new String[]{"FIsInternalCompany", "FIsCarrier", "FIsOuter"};
    String[] BOOLEAN_OBJS = new String[]{"isInternalCompany", "isCarrier", "isOuter"};
    String[] BIGDECIMAL_FIELDS = new String[]{"FTaxRate"};
    String[] BIGDECIMAL_OBJ = new String[]{"taxRate"};
    private SupplierInfo oldSupplierInfo = null;
    boolean isHasPreData = false;
    private CSParameterInfo currentCSParameterInfo;
    private static final String[] mainFields = new String[]{"FNumber", "FName_L1", "FName_L2", "FName_L3", "FShortName", "FForeignName", "FMnemonicCode", "FBizRegisterNo", "FTaxRegisterNo"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SupplierFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    private String supplierCustomerNameCheck(String fieldName, String fieldValue, TreeSet dupTreeSet, Context ctx) throws BOSException, EASBizException, Exception {
        StringBuffer sb = new StringBuffer();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("CU.name"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, (Object)fieldValue, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(selector);
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        CustomerCollection customerColl = iCustomer.getCustomerCollection(view);
        if (customerColl != null && customerColl.size() > 0) {
            dupTreeSet.add("SAME_CUSTOMER_NAME");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"SAME_CUSTOMER_NAME", (Locale)ctx.getOriginLocale()));
            sb.append("\uff08");
            for (int i = 0; i < customerColl.size(); ++i) {
                CustomerInfo customerInfo = customerColl.get(i);
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"NUMBER", (Locale)ctx.getOriginLocale()));
                sb.append(customerInfo.getNumber());
                sb.append("\uff0c");
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"HASEXIST", (Locale)ctx.getOriginLocale()));
                sb.append(customerInfo.getCU().getName());
                if (i >= customerColl.size() - 1) continue;
                sb.append("\uff1b");
            }
            sb.append("\uff09");
        }
        return sb.toString();
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ISupplier iSupplier = (ISupplier)this.getController(ctx);
        try {
            CtrlUnitInfo cu;
            CSParameterInfo param;
            if (coreBaseInfo.getId() == null) {
                boolean isAutoNumber = this.isAutoNumber((SupplierInfo)coreBaseInfo, ctx);
                boolean isImportByRule = DataImportUtils.getImportParam(ctx);
                coreBaseInfo.put("isImportByRule", (Object)isImportByRule);
                if (isAutoNumber && isImportByRule) {
                    ((SupplierInfo)coreBaseInfo).setNumber(this.createNewNumber((SupplierInfo)coreBaseInfo, ctx));
                }
            }
            coreBaseInfo.put("isImport", (Object)true);
            if (coreBaseInfo != null && !((SupplierInfo)coreBaseInfo).isIsInternalCompany()) {
                ((SupplierInfo)coreBaseInfo).setIsInternalCompany(false);
            }
            if ((param = this.getCSParamInfo(ctx, (cu = ContextUtil.getCurrentCtrlUnit((Context)ctx)).getId().toString())).isSupplierDontSave()) {
                String nameMessage = "";
                TreeSet<String> dupTreeSet = new TreeSet<String>();
                ArrayList<String> csParameterArrayList = new ArrayList<String>();
                if (param.isSupplierName()) {
                    csParameterArrayList.add("name");
                }
                if (param.isSupplierSimpleName()) {
                    csParameterArrayList.add("simpleName");
                }
                if (param.isSupplierForeignName()) {
                    csParameterArrayList.add("foreignName");
                }
                if (param.isSupplierMnemonicCode()) {
                    csParameterArrayList.add("mnemonicCode");
                }
                if (param.isSupplierBizRegisterNo()) {
                    csParameterArrayList.add("bizRegisterNo");
                }
                if (param.isSupplierTaxRegisterNo()) {
                    csParameterArrayList.add("taxRegisterNo");
                }
                if (param.isSupplierCustomerName()) {
                    csParameterArrayList.add("customerName");
                }
                for (String fieldName : csParameterArrayList) {
                    String fieldValue = (String)coreBaseInfo.get(fieldName);
                    if ("customerName".equals(fieldName)) {
                        fieldName = "name";
                        fieldValue = (String)coreBaseInfo.get(fieldName);
                        nameMessage = this.supplierCustomerNameCheck(fieldName, fieldValue, dupTreeSet, ctx);
                        continue;
                    }
                    if (StringUtils.isEmpty((String)fieldValue)) continue;
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo(fieldName, (Object)fieldValue));
                    filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(3), CompareType.NOTEQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)((String)coreBaseInfo.get("number")), CompareType.NOTEQUALS));
                    if (param.isSupplierCUUnique()) {
                        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)cu.getId().toString(), CompareType.EQUALS));
                    }
                    if (!iSupplier.exists(filter)) continue;
                    dupTreeSet.add(fieldName);
                }
                if (param.isSupplierDontSave() && !dupTreeSet.isEmpty()) {
                    String dupMsg = "";
                    for (String items : dupTreeSet) {
                        String element = "";
                        element = "SAME_CUSTOMER_NAME".equals(items) ? nameMessage : ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)items, (Locale)ctx.getOriginLocale());
                        dupMsg = dupMsg + element + ",";
                    }
                    dupMsg = dupMsg.substring(0, dupMsg.lastIndexOf(44));
                    dupMsg = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"supplier", (Locale)ctx.getOriginLocale()) + dupMsg;
                    dupTreeSet.clear();
                    throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{dupMsg});
                }
            }
            coreBaseInfo.put("isImport", (Object)"true");
            iSupplier.submit(coreBaseInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private CSParameterInfo getCSParamInfo(Context ctx, String cuid) throws BOSException, EASBizException {
        if (this.currentCSParameterInfo != null) {
            return this.currentCSParameterInfo;
        }
        ICSParameter iCSParameter = CSParameterFactory.getLocalInstance(ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)cuid, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        CSParameterCollection collection = iCSParameter.getCSParameterCollection(entityViewInfo);
        this.currentCSParameterInfo = collection != null && collection.size() > 0 ? collection.get(0) : CSParameterInfo.getSupplierDefaultParam();
        return this.currentCSParameterInfo;
    }

    private boolean isAddView(CoreBaseInfo customerInfo, Context ctx) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)customerInfo);
        if (this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0) {
            return iCodingRuleManager.isAddView((IObjectValue)customerInfo, strCompanyID, this.getBindingProperty());
        }
        return iCodingRuleManager.isAddView((IObjectValue)customerInfo, strCompanyID);
    }

    private String createNewNumber(SupplierInfo supplierInfo, Context ctx) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)supplierInfo);
        if (this.isAddView((CoreBaseInfo)supplierInfo, ctx)) {
            if (this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0) {
                return iCodingRuleManager.getNumber((IObjectValue)supplierInfo, strCompanyID, this.getBindingProperty());
            }
            return iCodingRuleManager.getNumber((IObjectValue)supplierInfo, strCompanyID);
        }
        if (this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0) {
            return iCodingRuleManager.getNumber((IObjectValue)supplierInfo, strCompanyID, this.getBindingProperty());
        }
        return iCodingRuleManager.getNumber((IObjectValue)supplierInfo, strCompanyID);
    }

    private boolean isAutoNumber(SupplierInfo supplierInfo, Context ctx) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)supplierInfo);
        return this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0 ? iCodingRuleManager.isExist((IObjectValue)supplierInfo, strCompanyID, this.getBindingProperty()) : iCodingRuleManager.isExist((IObjectValue)supplierInfo, strCompanyID);
    }

    private String getBindingProperty() {
        return null;
    }

    public CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws TaskExternalException, EASBizException, BOSException {
        int i;
        SupplierInfo supplierInfo = new SupplierInfo();
        SupplierInfo oldInfo = null;
        String importDataModel = DataImportUtils.getImportDataModel(ctx);
        supplierInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        supplierInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        String numberdata = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        String str = null;
        if (numberdata != null && numberdata.length() > 0 && (str = numberdata.toString()) != null && str.trim().length() > 0) {
            supplierInfo.setNumber(str);
            if (super.isSltImportUpdate()) {
                try {
                    ISupplier iSupplier = (ISupplier)this.getController(ctx);
                    SupplierCollection supplierCollection = iSupplier.getSupplierCollection("select *,supplierGroupDetails.* where number ='" + str + "'");
                    if (supplierCollection != null && supplierCollection.size() > 0) {
                        oldInfo = supplierCollection.get(0);
                        supplierInfo = (SupplierInfo)oldInfo.clone();
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        }
        DataImportUtils.setStringData(hsData, this.STRING_FIELDS, (CoreBaseInfo)supplierInfo, this.STRING_OBJS);
        DataImportUtils.setBooleanData(hsData, this.BOOLEAN_FIELDS, (CoreBaseInfo)supplierInfo, this.BOOLEAN_OBJS);
        DataImportUtils.setIntegerData(hsData, this.INTEGER_FIELDS, (CoreBaseInfo)supplierInfo, this.INTEGER_OBJS);
        Object data = null;
        String value = null;
        String[] multiStr = new String[]{"L1", "L2", "L3"};
        String fnameStr = DataImportTools.getDataString((Hashtable)hsData, (String)("FName_" + DataImportTools.getLoc((Context)ctx)));
        int c = multiStr.length;
        for (i = 0; i < c; ++i) {
            data = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"FName_").append((String)multiStr[i]).toString())).data;
            if (data != null && !StringUtils.isEmpty((String)data.toString())) {
                supplierInfo.setName(data.toString(), new Locale(multiStr[i]));
                continue;
            }
            supplierInfo.setName(fnameStr, new Locale(multiStr[i]));
        }
        data = ((DataToken)hsData.get((Object)"FUsedStatus")).data;
        if (data != null) {
            value = data.toString();
            UsedStatusEnum cs = DataImportUtils.getCustomerStatusValue(value);
            supplierInfo.setUsedStatus(cs);
            Object obj = hsData.get("FFreezeOrgUnit");
            if (UsedStatusEnum.FREEZED.equals((Object)cs) && (obj == null || obj.toString().trim().length() <= 0)) {
                CustomerSupplierException exception = new CustomerSupplierException(CustomerSupplierException.FREEZED_ORG_NULL);
                throw new TaskExternalException(exception.getMessage(), (Throwable)((Object)exception));
            }
        }
        for (i = 0; i < this.BIGDECIMAL_FIELDS.length; ++i) {
            try {
                BigDecimal bigDecimalValue;
                Object o = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (bigDecimalValue = new BigDecimal(o.toString())) == null) continue;
                supplierInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], bigDecimalValue);
                continue;
            }
            catch (NumberFormatException nex) {
                nex.printStackTrace();
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i] + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "FormmaterError", ctx));
            }
        }
        try {
            if (hsData.get("FBizAnalysisCodeID") != null) {
                BizAnalysisCodeInfo info;
                data = ((DataToken)hsData.get((Object)"FBizAnalysisCodeID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getBizAnalysisCodeInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setBizAnalysisCode(info);
                }
            }
            if (hsData.get("FParentID") != null) {
                SupplierInfo info;
                ISupplier iSupplier;
                SupplierCollection collection;
                data = ((DataToken)hsData.get((Object)"FParentID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if (str != null && str.trim().length() > 0 && (collection = (iSupplier = (ISupplier)this.getController(ctx)).getSupplierCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    supplierInfo.setParent(info);
                }
            }
            if (hsData.get("FInternalSupplierType") != null) {
                InternalCSSPType type;
                data = ((DataToken)hsData.get((Object)"FInternalSupplierType")).data;
                if ((data == null || "".equals(data)) && supplierInfo.isIsInternalCompany()) {
                    CustomerSupplierException e = new CustomerSupplierException(CustomerSupplierException.INTERNALCUSTTYPENULL);
                    throw new TaskExternalException(e.getMessage(), (Throwable)((Object)e));
                }
                if (data != null) {
                    str = data.toString();
                }
                if ((type = DataImportUtils.getInternalCSSPType(str)) != null) {
                    supplierInfo.setInternalSupplierType(type);
                }
            }
            if (hsData.get("FInternalCompanyID") != null) {
                CompanyOrgUnitInfo info;
                data = ((DataToken)hsData.get((Object)"FInternalCompanyID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, str)) != null && info.get("isbizunit") != null) {
                    Boolean isbizunit = new Boolean(info.get("isbizunit").toString());
                    if (isbizunit.booleanValue()) {
                        supplierInfo.setInternalCompany(info);
                    } else {
                        throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "CompanyShoudBeEntity", ctx));
                    }
                }
            }
            if (hsData.get("FInternalProfitCenter") != null) {
                ProfitCenterOrgUnitInfo info;
                data = ((DataToken)hsData.get((Object)"FInternalProfitCenter")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getProfitCenter(ctx, str)) != null) {
                    supplierInfo.setInternalProfitCenter(info);
                }
            }
            if (hsData.get("FTaxDataID") != null) {
                TaxDataInfo info;
                data = ((DataToken)hsData.get((Object)"FTaxDataID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getTaxDataInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setTaxData(info);
                }
            }
            if (hsData.get("FIndustryID") != null) {
                IndustryInfo info;
                data = ((DataToken)hsData.get((Object)"FIndustryID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getIndustryInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setIndustry(info);
                }
            }
            if (hsData.get("FCountryID") != null) {
                CountryInfo info;
                data = ((DataToken)hsData.get((Object)"FCountryID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getCountryInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setCountry(info);
                }
            }
            if (hsData.get("FProvinceID") != null) {
                ProvinceInfo info;
                data = ((DataToken)hsData.get((Object)"FProvinceID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getProvinceInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setProvince(info);
                }
            }
            if (hsData.get("FCityID") != null) {
                CityInfo info;
                data = ((DataToken)hsData.get((Object)"FCityID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getCityInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setCity(info);
                }
            }
            if (hsData.get("FRegionID") != null) {
                RegionInfo info;
                data = ((DataToken)hsData.get((Object)"FRegionID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getRegionInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setRegion(info);
                }
            }
            if (hsData.get("FFreezeOrgUnit") != null) {
                FullOrgUnitInfo info;
                data = ((DataToken)hsData.get((Object)"FFreezeOrgUnit")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getFullOrgUnitInfoFromNumber(ctx, str)) != null) {
                    supplierInfo.setFreezeOrgUnit(info);
                }
            }
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        if (importDataModel.equals("0")) {
            if (oldInfo != null && oldInfo.getUsedStatus() == UsedStatusEnum.APPROVED) {
                SupplierInfo oldSupplier = null;
                SupplierInfo newSupplier = null;
                if (supplierInfo != null) {
                    oldSupplier = (SupplierInfo)oldInfo.clone();
                    newSupplier = (SupplierInfo)supplierInfo.clone();
                    oldSupplier.getSupplierGroupDetails().clear();
                    newSupplier.getSupplierGroupDetails().clear();
                    if (!ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)oldSupplier, (AbstractObjectValue)newSupplier)) {
                        throw new TaskExternalException(supplierInfo.getName() + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "ApproveInvalid", ctx));
                    }
                }
            }
        } else if (importDataModel.equals("1")) {
            supplierInfo.setUsedStatus(UsedStatusEnum.UNAPPROVE);
        } else if (importDataModel.equals("2")) {
            // empty if block
        }
        return supplierInfo;
    }

    protected void createEntry(CoreBaseInfo head, Hashtable hsData, Context ctx) throws Exception {
        int pos;
        SupplierInfo supplierInfo = (SupplierInfo)head;
        Object data = null;
        Object browseGroupInfo = null;
        CSSPGroupStandardInfo groupStandardInfo = null;
        SupplierGroupDetailInfo detailInfo = new SupplierGroupDetailInfo();
        data = ((DataToken)hsData.get((Object)"FSupplierGroupStandardID")).data;
        if (data == null || data.toString().length() == 0) {
            throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "standardNotExist", ctx));
        }
        String str = data.toString();
        groupStandardInfo = DataImportUtils.getGroupStandardInfoByNumber(ctx, str, "supplier");
        if (groupStandardInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "standardNotExist", ctx));
        }
        detailInfo.setSupplierGroupStandard(groupStandardInfo);
        data = ((DataToken)hsData.get((Object)"FSupplierGroupID")).data;
        if (data == null || data.toString().length() == 0) {
            throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "groupNotExist", ctx));
        }
        str = data.toString();
        CSSPGroupInfo groupInfo = DataImportUtils.getGroupInfoByNumber(ctx, str, ((DataToken)hsData.get((Object)"FSupplierGroupStandardID")).data.toString(), "supplier");
        if (groupInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "groupNotExist", ctx));
        }
        detailInfo.setSupplierGroup(groupInfo);
        if (groupStandardInfo.getIsBasic() == StandardTypeEnum.basicStandard) {
            supplierInfo.setBrowseGroup(groupInfo);
        }
        if ((pos = this.isInCollection(detailInfo, supplierInfo.getSupplierGroupDetails())) < 0) {
            supplierInfo.getSupplierGroupDetails().add(detailInfo);
        } else {
            supplierInfo.getSupplierGroupDetails().set(pos, detailInfo);
        }
    }

    private int isInCollection(SupplierGroupDetailInfo info, SupplierGroupDetailCollection collection) {
        if (collection == null) {
            return -1;
        }
        for (int i = 0; i < collection.size(); ++i) {
            SupplierGroupDetailInfo tempInfo = collection.get(i);
            if (!tempInfo.getSupplierGroupStandard().getId().equals((Object)info.getSupplierGroupStandard().getId())) continue;
            return i;
        }
        return -1;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String mutilName = "FName_" + ContextUtils.getLocaleFromEnv().toString().toUpperCase();
            result.put("FNumber", DataImportUtils.transformValue(rs.getString("number")));
            result.put(mutilName, DataImportUtils.transformValue(rs.getString("name")));
            result.put("FMnemonicCode", DataImportUtils.transformValue(rs.getString("mnemonicCode")));
            result.put("FForeignName", DataImportUtils.transformValue(rs.getString("foreignName")));
            result.put("FBizAnalysisCodeID", DataImportUtils.transformValue(rs.getString("bizAnalysisCode.number")));
            result.put("FBarCode", DataImportUtils.transformValue(rs.getString("barCode")));
            result.put("FShortName", DataImportUtils.transformValue(rs.getString("simpleName")));
            result.put("FParentID", DataImportUtils.transformValue(rs.getString("parent.number")));
            result.put("FIsInternalCompany", DataImportUtils.transformValue(rs.getString("isInternalCompany")));
            result.put("FInternalCompanyID", DataImportUtils.transformValue(rs.getString("companyOrgUnit.number")));
            result.put("FInternalSupplierType", (Object)DataImportUtils.getInternalCSSPType(DataImportUtils.transformValue(rs.getString("internalSupplierType")).toString()));
            result.put("FInternalProfitCenter_number", DataImportUtils.transformValue(rs.getString("internalProfitCenter.number")));
            result.put("FTaxDataID", DataImportUtils.transformValue(rs.getString("taxData.number")));
            result.put("FTaxRegisterNo", DataImportUtils.transformValue(rs.getString("taxRegisterNo")));
            result.put("FBizRegisterNo", DataImportUtils.transformValue(rs.getString("bizRegisterNo")));
            result.put("FBusiLicence", DataImportUtils.transformValue(rs.getString("busiLicence")));
            result.put("FBusiExequatur", DataImportUtils.transformValue(rs.getString("busiExequatur")));
            result.put("FGSPAuthentication", DataImportUtils.transformValue(rs.getString("GSPAuthentication")));
            result.put("FIndustryID", DataImportUtils.transformValue(rs.getString("industry.number")));
            result.put("FAddress", DataImportUtils.transformValue(rs.getString("address")));
            result.put("FCountryID", DataImportUtils.transformValue(rs.getString("country.number")));
            result.put("FProvinceID", DataImportUtils.transformValue(rs.getString("province.number")));
            result.put("FCityID", DataImportUtils.transformValue(rs.getString("city.number")));
            result.put("FRegionID", DataImportUtils.transformValue(rs.getString("region.number")));
            result.put("FArtificialPerson", DataImportUtils.transformValue(rs.getString("artificialPerson")));
            result.put("FVersion", DataImportUtils.transformValue(rs.getString("version")));
            result.put("FUsedStatus", (Object)DataImportUtils.getCustomerStatusValue(DataImportUtils.transformValue(rs.getString("usedStatus")).toString()));
            result.put("FFreezeOrgUnit", DataImportUtils.transformValue(rs.getString("fullOrgUnit.number")));
            result.put("FSupplierGroupStandardID", DataImportUtils.transformValue(rs.getString("csspGroupStandard.number")));
            result.put("FSupplierGroupID", DataImportUtils.transformValue(rs.getString("browseGroup.number")));
            result.put("FCreatorNumber", DataImportUtils.transformValue(rs.getString("creator.number")));
            result.put("FCreateTime", DataImportUtils.getDateStrByLocale(ctx, rs.getDate("createTime")));
            this.putTable(result, "FTaxRate", rs.getString("taxRate"));
            result.put("FIsCarrier", DataImportUtils.transformValue(rs.getString("isCarrier")));
            if ("0".equals(DataImportUtils.transformValue(rs.getString("isOuter")))) {
                result.put("FIsOuter", "false");
            } else {
                result.put("FIsOuter", "true");
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iSupplier.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.cssp.app.SupplierExportSupplierBaseQuery";
    }

    protected String[] getMainFields() {
        if (super.isSltImportUpdate()) {
            return new String[]{"FNumber"};
        }
        return mainFields;
    }
}

