/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.BizDealResult;
import com.kingdee.eas.basedata.framework.app.AbstractBizDealAfterAssignImpl;
import com.kingdee.eas.basedata.framework.app.BizDealsDBUtil;
import com.kingdee.eas.basedata.framework.app.IBizDealAfterAssign;
import com.kingdee.eas.basedata.master.material.MaterialAssitDataEnum;
import com.kingdee.eas.basedata.master.material.MaterialCompanyData;
import com.kingdee.eas.basedata.master.material.UnAssign2CheckResult;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import java.util.List;
import org.apache.log4j.Logger;

public class BizDealUtil {
    private static Logger logger = Logger.getLogger(BizDealUtil.class);

    public static BizDealResult afterAssignDeal(Context ctx, String bosType, FullOrgUnitInfo targetOrgUnit, String[] diddata) throws BOSException, EASBizException {
        String[] deals = null;
        try {
            deals = BizDealsDBUtil.getDeals(ctx, bosType.toString(), IBizDealAfterAssign.class);
        }
        catch (EASDBException e) {
            throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)e);
        }
        if (deals == null || deals.length == 0) {
            return BizDealResult.HAVENODEALS;
        }
        for (int i = 0; i < deals.length; ++i) {
            BizDealResult dealResult = BizDealResult.SUCCESS;
            try {
                Class<?> dealClass = Class.forName(deals[i]);
                AbstractBizDealAfterAssignImpl deal = (AbstractBizDealAfterAssignImpl)dealClass.newInstance();
                if (deal == null) continue;
                dealResult = deal.doDealAfterAssign(ctx, bosType, targetOrgUnit, diddata);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return BizDealResult.SUCCESS;
    }

    public static BizDealResult afterAssignDeal(Context ctx, String bosType, FullOrgUnitInfo targetOrgUnit, String tableName) throws BOSException, EASBizException {
        String[] deals = null;
        try {
            deals = BizDealsDBUtil.getDeals(ctx, bosType.toString(), IBizDealAfterAssign.class);
        }
        catch (EASDBException e) {
            throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)e);
        }
        if (deals == null || deals.length == 0) {
            return BizDealResult.HAVENODEALS;
        }
        for (int i = 0; i < deals.length; ++i) {
            BizDealResult dealResult = BizDealResult.SUCCESS;
            try {
                Class<?> dealClass = Class.forName(deals[i]);
                AbstractBizDealAfterAssignImpl bizInstance = (AbstractBizDealAfterAssignImpl)dealClass.newInstance();
                String table = BizDealsDBUtil.getBizTempTable(ctx, deals[i], tableName);
                bizInstance.doDealAfterAssign(ctx, bosType, targetOrgUnit, table);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return BizDealResult.SUCCESS;
    }

    public static BizDealResult afterUnAssignDeal(Context ctx, String bosType, String dataTypeTableName, String[] orgIds, String tableName) throws BOSException, EASBizException {
        String[] deals = null;
        try {
            deals = BizDealsDBUtil.getDeals(ctx, bosType.toString(), IBizDealAfterAssign.class);
        }
        catch (EASDBException e) {
            throw new EASBizException(BizHasDealException.SQL_ERR, (Throwable)e);
        }
        if (deals == null || deals.length == 0) {
            return BizDealResult.HAVENODEALS;
        }
        for (int i = 0; i < deals.length; ++i) {
            BizDealResult dealResult = BizDealResult.SUCCESS;
            try {
                Class<?> dealClass = Class.forName(deals[i]);
                AbstractBizDealAfterAssignImpl bizInstance = (AbstractBizDealAfterAssignImpl)dealClass.newInstance();
                String table = BizDealsDBUtil.getBizTempTable(ctx, deals[i], tableName);
                bizInstance.doDealAfterUnassign(ctx, bosType, dataTypeTableName, orgIds, table);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return BizDealResult.SUCCESS;
    }

    public static BizDealResult afterUnAssignDeal(Context ctx, BOSObjectType bosType, MaterialCompanyData dataType, MaterialAssitDataEnum matAssiEnum, String[] orgIds, String[] dataIds, boolean hasDataCantUnAssign, List<UnAssign2CheckResult> checkResultList) throws BOSException, EASBizException {
        String[] deals = null;
        try {
            deals = BizDealsDBUtil.getDeals(ctx, bosType.toString(), IBizDealAfterAssign.class);
        }
        catch (EASDBException e) {
            throw new EASBizException(BizHasDealException.SQL_ERR, (Throwable)e);
        }
        if (deals == null || deals.length == 0) {
            return BizDealResult.HAVENODEALS;
        }
        for (int i = 0; i < deals.length; ++i) {
            BizDealResult dealResult = BizDealResult.SUCCESS;
            try {
                Class<?> dealClass = Class.forName(deals[i]);
                AbstractBizDealAfterAssignImpl bizInstance = (AbstractBizDealAfterAssignImpl)dealClass.newInstance();
                bizInstance.doDealAfterUnassign(ctx, bosType, dataType, matAssiEnum, orgIds, dataIds, hasDataCantUnAssign, checkResultList);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return BizDealResult.SUCCESS;
    }

    public static BizDealResult afterUnAssignDeal(Context ctx, BOSObjectType bosType, MaterialCompanyData dataType, MaterialAssitDataEnum matAssiEnum, String[] orgIds, String dataIdsql, String[] notInDataIds, boolean hasDataCantUnAssign, List<UnAssign2CheckResult> checkResultList, String tableName) throws BOSException, EASBizException {
        String[] deals = null;
        try {
            deals = BizDealsDBUtil.getDeals(ctx, bosType.toString(), IBizDealAfterAssign.class);
        }
        catch (EASDBException e) {
            throw new EASBizException(BizHasDealException.SQL_ERR, (Throwable)e);
        }
        if (deals == null || deals.length == 0) {
            return BizDealResult.HAVENODEALS;
        }
        for (int i = 0; i < deals.length; ++i) {
            BizDealResult dealResult = BizDealResult.SUCCESS;
            try {
                Class<?> dealClass = Class.forName(deals[i]);
                AbstractBizDealAfterAssignImpl bizInstance = (AbstractBizDealAfterAssignImpl)dealClass.newInstance();
                String table = BizDealsDBUtil.getBizTempTable(ctx, deals[i], tableName);
                bizInstance.doDealAfterUnassign(ctx, bosType, dataType, matAssiEnum, orgIds, dataIdsql, notInDataIds, hasDataCantUnAssign, checkResultList, table);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return BizDealResult.SUCCESS;
    }
}

