/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.util.db.SQLUtils;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BizDealsDBUtil {
    private static Logger logger = Logger.getLogger(BizDealsDBUtil.class);

    public static String[] getDeals(Context ctx, String bosType, Class inf) throws EASDBException {
        Vector<String> vec = new Vector<String>();
        Object[] deals = null;
        String sql = "select fdeal from T_BD_bizDeals where FBosType= ? and FInterface= ?";
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        try {
            conn = BizDealsDBUtil.getConnection(ctx);
            stat = conn.prepareStatement(sql);
            stat.setString(1, bosType);
            stat.setString(2, inf.getName());
            rs = stat.executeQuery();
            while (rs.next()) {
                vec.addElement(rs.getString(1));
                deals = new String[vec.size()];
                vec.copyInto(deals);
            }
        }
        catch (SQLException e2) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e2);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stat, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stat, (Connection)conn);
        return deals;
    }

    protected static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    public static String getBizTempTable(Context ctx, String symbol, String originalTable) throws EASDBException {
        String tempTable = "VT" + originalTable.substring(originalTable.length() >> 1) + BizDealsDBUtil.createRandomCharData(3);
        StringBuffer createTablesql = new StringBuffer("select * into ").append(tempTable).append(" from ").append(originalTable);
        StringBuffer createIndex = new StringBuffer("create index ").append("VI").append(originalTable.substring(originalTable.length() >> 1)).append(BizDealsDBUtil.createRandomCharData(3)).append(" on ").append(tempTable).append(" ( fid )");
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        try {
            conn = BizDealsDBUtil.getConnection(ctx);
            stat = conn.prepareStatement(createTablesql.toString());
            logger.error((Object)("  ttttttttttt  symbol " + symbol + " " + createTablesql));
            stat.execute();
            stat = conn.prepareStatement(createIndex.toString());
            logger.error((Object)("  iiiiiiiiiii  " + createIndex));
            stat.execute();
        }
        catch (SQLException e2) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e2);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stat, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stat, (Connection)conn);
        return tempTable;
    }

    private static String createRandomCharData(int length) {
        StringBuilder sb = new StringBuilder();
        SecureRandom randdata = new SecureRandom();
        int data = 0;
        block5: for (int i = 0; i < length; ++i) {
            int index = randdata.nextInt(3);
            switch (index) {
                case 0: {
                    data = randdata.nextInt(10);
                    sb.append(data);
                    continue block5;
                }
                case 1: {
                    data = randdata.nextInt(26) + 65;
                    sb.append((char)data);
                    continue block5;
                }
                case 2: {
                    data = randdata.nextInt(26) + 97;
                    sb.append((char)data);
                }
            }
        }
        String result = sb.toString();
        return result;
    }

    public static String getBizTempTable(Context ctx, String deal, String dataTypeTableName, String wheresql) throws EASDBException {
        String tempTable = "VT" + BizDealsDBUtil.createRandomCharData(4) + BizDealsDBUtil.createRandomCharData(2);
        StringBuffer createTablesql = new StringBuffer("select * into ").append(tempTable).append(" from ").append(dataTypeTableName).append(" ").append(wheresql);
        StringBuffer createIndex = new StringBuffer("create index ").append("VI").append(tempTable).append(" on ").append(tempTable).append(" ( fid )");
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        try {
            conn = BizDealsDBUtil.getConnection(ctx);
            stat = conn.prepareStatement(createTablesql.toString());
            logger.error((Object)("  ttttttttttt  symbol " + deal + " " + createTablesql));
            stat.execute();
            stat = conn.prepareStatement(createIndex.toString());
            logger.error((Object)("  iiiiiiiiiii  " + createIndex));
            stat.execute();
        }
        catch (SQLException e2) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e2);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stat, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stat, (Connection)conn);
        return tempTable;
    }
}

