/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.app.ServerControlStrategy;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import org.apache.log4j.Logger;

public abstract class DServerControlStrategy
extends ServerControlStrategy {
    private static final Logger logger = CoreUIObject.getLogger(DServerControlStrategy.class);

    @Override
    public String getControlType() {
        return "D";
    }

    @Override
    public void checkCanAdd(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType) throws Exception {
        this.checkAddPolicy(ctx, ctrlUnitPK, objectType);
    }

    @Override
    public void checkCanUpdate(Context ctx, DataBaseInfo dataBaseDInfo, IObjectPK ctrlUnitPK) throws Exception {
        DataBaseDInfo dataBaseDInfo2 = (DataBaseDInfo)dataBaseDInfo;
        if (!dataBaseDInfo2.getCU().getId().toString().equals(ctrlUnitPK.toString())) {
            this.checkUpdatePolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType());
        }
    }

    public void checkCanDelete(Context ctx, DataBaseDInfo dataBaseDInfo, IObjectPK ctrlUnitPK) throws Exception {
        DataBaseDInfo dataBaseDInfo2 = dataBaseDInfo;
        if (!dataBaseDInfo2.getCU().getId().toString().equals(ctrlUnitPK.toString())) {
            this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType());
        }
    }

    protected void checkAddPolicy(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateAddnewable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
    }

    protected void checkUpdatePolicy(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateEditable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    protected void checkDelPolicy(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateDeletable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
    }
}

