/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.myeas.IPersonalParam;
import com.kingdee.eas.base.myeas.PersonalParamFactory;
import com.kingdee.eas.base.myeas.PersonalParamInfo;
import com.kingdee.eas.base.myeas.util.PersonalParamHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BDUtil {
    private static final Logger logger = Logger.getLogger(BDUtil.class);
    public static final String Property_name = EASResource.getString((String)"com.kingdee.eas.basedata.framework.FRAMEWORKAutoGenerateResource", (String)"13_BDUtil");
    public static final String STRING_B = ")";
    public static final String STRING_A = "(";
    public static final String ORTTYPE_NAME = EASResource.getString((String)"com.kingdee.eas.basedata.framework.FRAMEWORKAutoGenerateResource", (String)"14_BDUtil");
    public static final String ORG_TYPE = "OrgType";
    public static final String ENTITY_NAME = EASResource.getString((String)"com.kingdee.eas.basedata.framework.FRAMEWORKAutoGenerateResource", (String)"15_BDUtil");

    public static String getEntity(Context ctx, String refEntityName, String orgType) {
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectCollection entities = loader.getEntityCollection();
        StringBuffer sb = new StringBuffer(1024);
        int ic = entities.size();
        for (int i = 0; i < ic; ++i) {
            EntityObjectInfo entity = entities.get(i);
            String entityOrgType = entity.getExtendedProperty(ORG_TYPE);
            if (orgType != null && !orgType.equals(entityOrgType)) continue;
            PropertyCollection properties = entity.getPropertiesRuntime();
            int cj = properties.size();
            for (int j = 0; j < cj; ++j) {
                LinkPropertyInfo linkprop;
                RelationshipInfo relate;
                EntityObjectInfo supplierObject;
                PropertyInfo prop = properties.get(j);
                if (!(prop instanceof LinkPropertyInfo) || (supplierObject = (relate = (linkprop = (LinkPropertyInfo)prop).getRelationship()).getSupplierObject()) == null || !supplierObject.getFullName().equals(refEntityName)) continue;
                sb.append("\n");
                sb.append(ENTITY_NAME);
                sb.append(entity.getAlias());
                sb.append(STRING_A);
                sb.append(entity.getFullName());
                sb.append(STRING_B);
                String ORGTYPE = ORTTYPE_NAME;
                sb.append(ORGTYPE);
                sb.append(entityOrgType);
                sb.append(Property_name);
                sb.append(prop.getAlias());
                sb.append(STRING_A);
                sb.append(prop.getName());
                sb.append(STRING_B);
            }
        }
        return sb.toString();
    }

    public static String getTableName(Context ctx, String bosType) throws BOSException, EASBizException {
        EntityObjectInfo entityInfo = null;
        entityInfo = ctx != null ? MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bosType)) : MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(BOSObjectType.create((String)bosType));
        return entityInfo.getTable().getName();
    }

    public static void ignoreFilterItems(String regexs, FilterInfo filterInfo) {
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            return;
        }
        regexs = regexs.toUpperCase();
        String[] arrayRegexs = regexs.split(",");
        for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
            FilterItemInfo curItem = filterInfo.getFilterItems().get(i);
            String curProperty = curItem.getPropertyName().toUpperCase();
            boolean isMatch = false;
            for (int j = 0; j < arrayRegexs.length; ++j) {
                Pattern p = Pattern.compile(arrayRegexs[j]);
                boolean b = p.matcher(curProperty).matches();
                if (!b) continue;
                isMatch = true;
                break;
            }
            if (!isMatch || filterInfo.getMaskString() == null) continue;
            String mask = filterInfo.getMaskString();
            mask = mask.toLowerCase().trim();
            mask = mask.replaceAll("#" + i, "");
            mask = mask.replaceAll("\\( *\\)", "");
            mask = mask.replaceAll("^ *and", "");
            mask = mask.replaceAll("\\( *and", STRING_A);
            mask = mask.replaceAll("and *$", "");
            mask = mask.replaceAll("and *\\)", STRING_B);
            for (int k = filterInfo.getFilterItems().size() - 1; k > i; --k) {
                mask = mask.replaceFirst("#" + k, "*" + (k - 1));
            }
            mask = mask.replaceAll("\\*", "#");
            filterInfo.setMaskString(mask);
            filterInfo.getFilterItems().removeObject(i);
            --i;
        }
    }

    public static void replaceFilterItem(FilterInfo filterInfo, String oldPros, String newPros) {
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            return;
        }
        String[] arrayOldPros = oldPros.split(",");
        String[] arrayNewPros = newPros.split(",");
        for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
            FilterItemInfo curItem = filterInfo.getFilterItems().get(i);
            String curProperty = curItem.getPropertyName().trim();
            for (int j = 0; j < arrayOldPros.length; ++j) {
                if (!curProperty.equalsIgnoreCase(arrayOldPros[j])) continue;
                curItem.setPropertyName(arrayNewPros[j]);
            }
        }
    }

    public static String getMatchString(String value) {
        String matchType = BDUtil.getUserMatchType(null);
        String curMatchStr = "";
        curMatchStr = "0".equals(matchType) ? "%" + value + "%" : ("2".equals(matchType) ? "%" + value : ("1".equals(matchType) ? value + "%" : "%" + value + "%"));
        return curMatchStr;
    }

    public static String getUserMatchType(IObjectPK userId) {
        String tmpType = "";
        try {
            tmpType = PersonalParamHelper.getPersonalParam((String)"f7MatchType", (IObjectPK)userId);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (tmpType == null) {
            tmpType = "";
        }
        return tmpType;
    }

    public static void memoIsAssignAsst(boolean flag) throws BOSException, EASBizException {
        String paramName = "isAssignAsst";
        String sFlag = "false";
        if (flag) {
            sFlag = "true";
        }
        IPersonalParam pp = PersonalParamFactory.getRemoteInstance();
        PersonalParamInfo ppInfo = null;
        CoreBaseCollection pps = pp.getCollection("where paramname='" + paramName + "'");
        if (pps.size() > 0) {
            ppInfo = (PersonalParamInfo)pps.get(0);
        } else {
            ppInfo = new PersonalParamInfo();
            ppInfo.setParamName(paramName);
        }
        ppInfo.setParamValue(sFlag);
        pp.submit((CoreBaseInfo)ppInfo);
    }

    public static String isAssignAsstLastTime() throws BOSException {
        String paramName = "isAssignAsst";
        IPersonalParam pp = PersonalParamFactory.getRemoteInstance();
        PersonalParamInfo ppInfo = null;
        CoreBaseCollection pps = pp.getCollection("where paramname='" + paramName + "'");
        if (pps.size() > 0) {
            ppInfo = (PersonalParamInfo)pps.get(0);
            return ppInfo.getParamValue();
        }
        return null;
    }

    public static String format(String pettern, Object[] param) {
        MessageFormat mf = new MessageFormat(pettern);
        return mf.format(param);
    }

    public static String getResource(String resClassName, String resName, Object[] param) {
        return BDUtil.getResource(resClassName, resName, param, null);
    }

    public static String getResource(String resClassName, String resName, Object[] param, Locale locale) {
        String pettern = null;
        pettern = locale == null ? EASResource.getString((String)resClassName, (String)resName) : ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale);
        return BDUtil.format(pettern, param);
    }

    public static String createIdTable(Context ctx) throws Exception {
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE SysTable");
        createTableSql.append("\t(");
        createTableSql.append("fid        varchar(44)");
        createTableSql.append(STRING_B);
        String tbl = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
        return tbl;
    }

    public static String generateIdTable(Context ctx, Object[] dataArray, boolean closeCn) throws Exception {
        String tbl = BDUtil.createIdTable(ctx);
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            for (int i = 0; i < dataArray.length; ++i) {
                stmt.addBatch("insert into " + tbl + " values ('" + dataArray[i].toString() + "')");
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
        }
        finally {
            if (closeCn) {
                SQLUtils.cleanup((Statement)stmt, (Connection)cn);
            }
        }
        return tbl;
    }

    public static String generateIdTable(Context ctx, Object[] dataArray) throws Exception {
        return BDUtil.generateIdTable(ctx, dataArray, false);
    }
}

