/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CUParentChangedHandlerUtil {
    private static final String LONGNUMBER = "longNumber";
    private static final String FILTERFIELD_CUNUMBER = "CU.number";
    private static HashMap needHandleMap = null;

    public static void adjustData(Context ctx, OrgStructureInfo changedCU, OrgStructureInfo oldParentCU, OrgStructureInfo newParentCU) throws EASBizException, BOSException {
        assert (changedCU != null);
        assert (oldParentCU != null);
        assert (newParentCU != null);
        if (changedCU == null || oldParentCU == null || newParentCU == null) {
            return;
        }
        String oldLongNumber = oldParentCU.getLongNumber();
        String newLongNumber = newParentCU.getLongNumber();
        if (newLongNumber.startsWith(oldLongNumber)) {
            return;
        }
        if (needHandleMap == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectCollection eoColl = loader.getEntityCollection();
            int eoCollSize = eoColl.size();
            EntityObjectCollection allS4TreeColl = new EntityObjectCollection();
            for (int i = 0; i < eoCollSize; ++i) {
                EntityObjectInfo tmpInfo = eoColl.get(i);
                if (!CUParentChangedHandlerUtil.isS4TreeEntityObjectInfo(tmpInfo)) continue;
                allS4TreeColl.add(tmpInfo);
            }
            needHandleMap = CUParentChangedHandlerUtil.getEntityInfos(allS4TreeColl);
        }
        if (needHandleMap.size() <= 0) {
            return;
        }
        String[] oldCUs = oldParentCU.getLongNumber().split("!");
        String[] newCUs = newParentCU.getLongNumber().split("!");
        HashSet<String> removedCUs = new HashSet<String>();
        for (int i = 0; i < oldCUs.length; ++i) {
            String tmp = oldCUs[i];
            removedCUs.add(tmp);
            for (int j = 0; j < newCUs.length; ++j) {
                if (oldCUs[i] == null || !oldCUs[i].equals(newCUs[j])) continue;
                removedCUs.remove(tmp);
            }
        }
        if (removedCUs.size() <= 0) {
            return;
        }
        String tableName = null;
        BOSObjectType bosType = null;
        Iterator handleIt = needHandleMap.keySet().iterator();
        while (handleIt.hasNext()) {
            tableName = handleIt.next().toString();
            bosType = (BOSObjectType)needHandleMap.get(tableName);
            CUParentChangedHandlerUtil.handleOneTable(ctx, changedCU, oldParentCU, newParentCU, tableName, bosType, removedCUs);
        }
    }

    private static FilterInfo getCUFilter(Set removedCUNumbers) {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo(FILTERFIELD_CUNUMBER, (Object)removedCUNumbers, CompareType.INCLUDE));
        return fi;
    }

    private static StringBuffer getLongNumberFilterStr(IObjectCollection objColl) {
        StringBuffer sb = new StringBuffer();
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue value = objColl.getObject(i);
            if (i == 0) {
                sb.append(" (FLongNumber like '").append(value.get(LONGNUMBER)).append("%' ) ");
                continue;
            }
            sb.append(" or (FLongNumber like '").append(value.get(LONGNUMBER)).append("%' ) ");
        }
        return sb;
    }

    private static boolean isS4TreeEntityObjectInfo(EntityObjectInfo tmpInfo) throws BOSException {
        String controlType = tmpInfo.getExtendedProperty("controlType");
        if (controlType != null && controlType.equalsIgnoreCase("S4")) {
            String tmp = tmpInfo.getBusinessImplName();
            try {
                Class<?> c = Class.forName(tmp);
                Object o = c.newInstance();
                if (o instanceof TreeBase) {
                    return true;
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return false;
    }

    private static HashMap getEntityInfos(EntityObjectCollection coll) {
        HashMap<String, BOSObjectType> map = new HashMap<String, BOSObjectType>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            EntityObjectInfo tmp = coll.get(i);
            String tableName = tmp.getTable().getName();
            map.put(tableName, tmp.getType());
        }
        return map;
    }

    private static void handleOneTable(Context ctx, OrgStructureInfo changedCU, OrgStructureInfo oldParentCU, OrgStructureInfo newParentCU, String tableName, BOSObjectType bosType, Set removedCUs) throws EASBizException, BOSException {
        IDynamicObject idyn = DynamicObjectFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evInfo = new EntityViewInfo();
        evInfo.setFilter(CUParentChangedHandlerUtil.getCUFilter(removedCUs));
        evInfo.getSelector().add(new SelectorItemInfo(LONGNUMBER));
        IObjectCollection objColl = idyn.getCollection(bosType, evInfo);
        if (objColl == null || objColl.size() <= 0) {
            return;
        }
        int size = objColl.size();
        StringBuffer filterStr = CUParentChangedHandlerUtil.getLongNumberFilterStr(objColl);
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tableName).append(" set FParentID = null,FLongNumber=FNumber,FLevel=1 where ").append("(FControlUnitID in (select fid from T_Org_CtrlUnit where FLongNumber like '").append(changedCU.getLongNumber()).append("%'))").append(" and (").append(filterStr).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

